/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.data;

import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsServersStatus;
import hec.serversuite.data.LocalServerInfo;
import hec.serversuite.data.ServerInfo;
import hec.serversuite.data.ServerStatusCheck;
import java.util.Objects;

public final class LocalAuthenticationSource
extends CwmsAuthenticationSource {
    public static final String LOOKUP_PATH = "cwms/login/local";
    private static final LocalAuthenticationSource INSTANCE = new LocalAuthenticationSource();

    private LocalAuthenticationSource() {
        super("Local", "No network connection to CWMS");
    }

    public static LocalAuthenticationSource getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isUsernamePasswordSupported() {
        return false;
    }

    @Override
    public boolean isCacSupported() {
        return false;
    }

    @Override
    public String getUsernamePlaceholder() {
        return LocalServerInfo.getInstance().getDisplayName();
    }

    @Override
    public String getLookup() {
        return LOOKUP_PATH;
    }

    @Override
    public ServerInfo getServerInfo() {
        return LocalServerInfo.getInstance();
    }

    @Override
    public ServerStatusCheck getServerStatusCheck() {
        return s -> new CwmsServersStatus(CwmsServersStatus.CwmsServersOnline.ALL_ONLINE, "");
    }

    @Override
    public String getHtmlDisplay() {
        return "<html>" + this.getDisplayName() + "</html>";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hash(this.getDisplayName());
    }
}

