/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.data;

public class ServerInfo
implements Cloneable {
    private String _displayName;
    private String _toolTip;
    private String _host;
    private String _port;
    private String _serverName;
    private String _extraColumn1;

    public ServerInfo clone() throws CloneNotSupportedException {
        ServerInfo serverInfo = (ServerInfo)super.clone();
        serverInfo._displayName = this._displayName;
        serverInfo._host = this._host;
        serverInfo._port = this._port;
        serverInfo._serverName = this._serverName;
        serverInfo._extraColumn1 = this._extraColumn1;
        return serverInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._displayName == null ? 0 : this._displayName.hashCode());
        result = 31 * result + (this._host == null ? 0 : this._host.hashCode());
        result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
        result = 31 * result + (this._serverName == null ? 0 : this._serverName.hashCode());
        result = 31 * result + (this._extraColumn1 == null ? 0 : this._extraColumn1.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerInfo other = (ServerInfo)obj;
        if (this._displayName == null ? other._displayName != null : !this._displayName.equals(other._displayName)) {
            return false;
        }
        if (this._host == null ? other._host != null : !this._host.equals(other._host)) {
            return false;
        }
        if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
            return false;
        }
        if (this._serverName == null ? other._serverName != null : !this._serverName.equals(other._serverName)) {
            return false;
        }
        return !(this._extraColumn1 == null ? other._extraColumn1 != null : !this._extraColumn1.equals(other._extraColumn1));
    }

    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append("//");
        sb.append(this._host);
        if (this._port != null && !this._port.isEmpty()) {
            sb.append(":");
            sb.append(this._port);
        }
        return sb.toString();
    }

    public String getTooltip() {
        if (this._toolTip == null) {
            if (this._port == null) {
                return this._host;
            }
            return "Host:" + this._host + " Port:" + this._port;
        }
        return this._toolTip;
    }

    public void setTooltip(String toolTip) {
        this._toolTip = toolTip;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public Integer getPort() {
        if (this._port == null || this._port.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(this._port);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setPort(String port) {
        this._port = port;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public String getExtraColumn1() {
        return this._extraColumn1;
    }

    public void setExtraColumn1(String extraColumn1) {
        this._extraColumn1 = extraColumn1;
    }

    public String toString() {
        String name = this.getDisplayName();
        if (name == null || name.isEmpty()) {
            return this._host + ":" + this._port;
        }
        return name;
    }

    public String toSerializeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDisplayName());
        sb.append(this.getUrl());
        return sb.toString();
    }
}

