/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.impl;

import hec.serversuite.impl.ClientCheckInService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.rmi.csinterface.ClientCheckInServer;

public class ClientCheckInServiceImpl
implements ClientCheckInService {
    private static final Logger LOGGER = Logger.getLogger(ClientCheckInServiceImpl.class.getName());
    private final ClientCheckInServer _checkInServer;
    private ScheduledExecutorService _singleThreadScheduledExecutor;
    private ScheduledFuture<?> _scheduledClientCheckIn;

    public ClientCheckInServiceImpl(ClientCheckInServer checkInServer) {
        this._checkInServer = checkInServer;
    }

    @Override
    public synchronized void startCheckInService(String userId) throws IllegalStateException {
        if (this._checkInServer == null) {
            throw new IllegalStateException("Login server cannot be null.");
        }
        if (this._singleThreadScheduledExecutor == null) {
            this._singleThreadScheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        }
        if (this._scheduledClientCheckIn != null) {
            this._scheduledClientCheckIn.cancel(true);
        }
        Runnable command = () -> this.setClientAlive(userId);
        long initialDelay = 0L;
        long period = Integer.getInteger("loginserver.heartbeat.intervalminutes", 2).intValue();
        TimeUnit unit = TimeUnit.MINUTES;
        this._scheduledClientCheckIn = this._singleThreadScheduledExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    protected boolean setClientAlive(String userId) {
        try {
            this._checkInServer.setClientAlive(userId);
            return true;
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Error notifying server that client is still alive.", t);
            return false;
        }
    }

    @Override
    public synchronized void stopCheckInService() {
        if (this._singleThreadScheduledExecutor != null) {
            this._singleThreadScheduledExecutor.shutdown();
        }
    }
}

