/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.impl;

import hec.lang.LoginException;
import hec.serversuite.CwmsLoginDialogService;
import hec.serversuite.LoginHandler;
import hec.serversuite.ServerSuite;
import hec.serversuite.ServerSuiteBuilder;
import hec.serversuite.ServerSuiteFactory;
import hec.serversuite.ServerSuiteListener;
import hec.serversuite.ServerSuiteStatus;
import hec.serversuite.ServerSuiteUtil;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.LocalAuthenticationSource;
import hec.serversuite.data.ServerLoginState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.services.annotations.ServiceProvider;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

@ServiceProvider(path="hec/login/ServerSuiteFactory", position=1, service=ServerSuiteFactory.class)
public class ServerSuiteFactoryImpl
implements ServerSuiteFactory {
    private static final Logger LOGGER = Logger.getLogger(ServerSuiteFactoryImpl.class.getName());
    private final List<ServerSuiteListener> _listeners = new ArrayList<ServerSuiteListener>();
    private final Map<CwmsAuthenticationSource, ServerSuite> _serverSuiteMap = new HashMap<CwmsAuthenticationSource, ServerSuite>();
    private ServerSuite _activeServerSuite;

    public ServerSuiteFactoryImpl() {
        Logger.getLogger(ServerSuiteFactoryImpl.class.getName()).log(Level.FINEST, "Default constructor used for ServiceProvider API");
    }

    @Override
    public ServerSuite getActiveServerSuite() {
        return this._activeServerSuite;
    }

    @Override
    public void reset() {
        if (this._activeServerSuite != null && this._activeServerSuite.getServer() != null) {
            this._serverSuiteMap.remove(this._activeServerSuite.getServer());
        }
        this._activeServerSuite = null;
    }

    @Override
    public boolean isLoggedIn(CwmsAuthenticationSource cwmsAuthenticationSource) {
        ServerSuite serverSuite = this.getInstance(cwmsAuthenticationSource);
        return serverSuite != null && serverSuite.getState() == ServerLoginState.LOGGED_IN;
    }

    private ServerSuite getOrCreateServerSuite(CwmsAuthenticationSource cwmsAuthenticationSource) throws LoginException {
        ServerSuite serverSuite = this._serverSuiteMap.get(cwmsAuthenticationSource);
        if (serverSuite == null) {
            serverSuite = ((ServerSuiteBuilder)Lookups.forPath((String)cwmsAuthenticationSource.getLookup()).lookup(ServerSuiteBuilder.class)).build(cwmsAuthenticationSource);
        }
        return serverSuite;
    }

    @Override
    public ServerSuite getInstance(CwmsAuthenticationSource cwmsAuthenticationSource) {
        ServerSuite serverSuite = null;
        if (cwmsAuthenticationSource != null) {
            serverSuite = this._serverSuiteMap.get(cwmsAuthenticationSource);
        }
        return serverSuite;
    }

    @Override
    public ServerSuite login(String appName, CwmsAuthenticationSource cwmsAuthenticationSource, boolean useLocal, boolean localOnCancel, boolean showLoginDialog) throws LoginException {
        return this.login(appName, cwmsAuthenticationSource, useLocal, localOnCancel, showLoginDialog, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSuite login(String appName, CwmsAuthenticationSource cwmsAuthenticationSource, boolean useLocal, boolean localOnCancel, boolean showLoginDialog, String userName, char[] password) throws LoginException {
        ServerSuite previousSuite = this._activeServerSuite;
        try {
            ServerSuite retval;
            if (showLoginDialog) {
                retval = this.authenticateWithDialog(appName, cwmsAuthenticationSource, useLocal, localOnCancel);
            } else if (cwmsAuthenticationSource != null) {
                this._activeServerSuite = retval = this.logIntoAuthenticationSourceHeadless(appName, cwmsAuthenticationSource, userName, password);
                this._serverSuiteMap.put(cwmsAuthenticationSource, retval);
                LOGGER.log(Level.FINE, "Client application logged successfully in without prompting a login dialog.");
            } else {
                throw new LoginException("Authentication attempt headless was unsuccessful, no login dialog was prompted and local login is not supported");
            }
            ServerSuite serverSuite = retval;
            return serverSuite;
        }
        finally {
            if (this._activeServerSuite != null && previousSuite != null && this._activeServerSuite != previousSuite) {
                ServerSuiteStatus serverStatus = new ServerSuiteStatus(this._activeServerSuite, previousSuite.getState(), this._activeServerSuite.getState());
                this.notifyStatusChanged(serverStatus);
            }
        }
    }

    private ServerSuite authenticateWithDialog(String appName, CwmsAuthenticationSource cwmsAuthenticationSource, boolean useLocal, boolean localOnCancel) {
        CwmsLoginDialogService cwmsLoginDialogService = (CwmsLoginDialogService)Lookup.getDefault().lookup(CwmsLoginDialogService.class);
        if (cwmsLoginDialogService != null) {
            cwmsLoginDialogService.authenticateWithDialog(appName, cwmsAuthenticationSource, useLocal, new MyLoginHandler(appName, localOnCancel));
        }
        return this._activeServerSuite;
    }

    private ServerSuite logIntoAuthenticationSourceHeadless(String appName, CwmsAuthenticationSource cwmsAuthenticationSource, String userName, char[] password) throws LoginException {
        ServerSuite serverSuite = this.getOrCreateServerSuite(cwmsAuthenticationSource);
        char[] user = Optional.ofNullable(userName).map(String::toCharArray).orElse(null);
        serverSuite.login(user, password, appName);
        return serverSuite;
    }

    @Override
    public void addListener(ServerSuiteListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(ServerSuiteListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public final void notifyStatusChanged(ServerSuiteStatus serverStatus) {
        if (serverStatus != null) {
            for (ServerSuiteListener listener : this._listeners) {
                listener.serverStateChanged(serverStatus);
            }
        }
    }

    @Override
    public synchronized ServerSuite loginSecondary(String appName, CwmsAuthenticationSource cwmsAuthenticationSource) throws LoginException {
        ServerSuite retval;
        if (cwmsAuthenticationSource.isUsernamePasswordSupported()) {
            retval = this.authenticateWithDialog(appName, cwmsAuthenticationSource, false, false);
            if (retval == null) {
                throw new LoginException("Could not login to server: " + cwmsAuthenticationSource + " using the CWMS login dialog");
            }
        } else {
            ServerSuite serverSuite = this.getOrCreateServerSuite(cwmsAuthenticationSource);
            serverSuite.login(appName);
            retval = serverSuite;
        }
        if (retval.getState() == ServerLoginState.LOGGED_IN) {
            this._serverSuiteMap.put(cwmsAuthenticationSource, retval);
        }
        return retval;
    }

    private class MyLoginHandler
    implements LoginHandler {
        private final String _appName;
        private final boolean _localOnCancel;

        public MyLoginHandler(String appName, boolean localOnCancel) {
            this._appName = appName;
            this._localOnCancel = localOnCancel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void login(CwmsAuthenticationSource selectedAuthenticationSource, String username, char[] password) throws LoginException {
            boolean previous = ServerSuiteUtil.getDisplayExceptions();
            try {
                ServerSuiteUtil.setDisplayExceptions(false);
                ServerSuite selectedServerSuite = ServerSuiteFactoryImpl.this.getOrCreateServerSuite(selectedAuthenticationSource);
                char[] name = username == null || username.isEmpty() ? null : username.toCharArray();
                char[] pass = password == null || password.length == 0 ? null : password;
                selectedServerSuite.login(name, pass, this._appName);
                ServerSuiteFactoryImpl.this._activeServerSuite = selectedServerSuite;
                ServerSuiteFactoryImpl.this._serverSuiteMap.put(selectedAuthenticationSource, selectedServerSuite);
            }
            finally {
                ServerSuiteUtil.setDisplayExceptions(previous);
            }
        }

        @Override
        public void cancel() {
            if (this._localOnCancel) {
                if (ServerSuiteFactoryImpl.this._activeServerSuite == null || ServerSuiteFactoryImpl.this._activeServerSuite.getState() == ServerLoginState.FAILED) {
                    try {
                        ServerSuiteFactoryImpl.this._activeServerSuite = ServerSuiteFactoryImpl.this.getOrCreateServerSuite(LocalAuthenticationSource.getInstance());
                        ServerSuiteFactoryImpl.this._activeServerSuite.setLoginState(ServerLoginState.LOCAL);
                        LOGGER.log(Level.FINE, "Canceled login dialog and previous server suite authentication failed. Server Suite is now set to local local.");
                    }
                    catch (LoginException e) {
                        LOGGER.log(Level.SEVERE, "Unable to login as local login state through canceling the login dialog", e);
                    }
                } else {
                    LOGGER.log(Level.FINE, "Canceled login dialog, previous server suite remains active");
                }
            } else {
                LOGGER.log(Level.FINE, "Canceled login dialog, previous server suite remains active");
            }
        }
    }
}

