/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.impl;

import hec.security.UserProfile;
import hec.serversuite.logging.LoginInfo;
import hec.serversuite.logging.LogoutInfo;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.TimeZone;
import rma.services.ServiceLookup;

public final class UserProfileLogger {
    private final UserProfile _userProfile;

    public UserProfileLogger(UserProfile userProfile) {
        this._userProfile = userProfile;
    }

    public void logLogin(String loginServerUrl, String officeId, String dbiServerUrl) {
        String lastLogin = this._userProfile.getLastLoginTime().map(this::convertToDisplay).orElse("None");
        LoginInfo loginInfo = new LoginInfo(this._userProfile.getUserName(), loginServerUrl, officeId, dbiServerUrl, lastLogin);
        loginInfo.logIt();
    }

    private String convertToDisplay(ZonedDateTime dateTime) {
        return dateTime.withZoneSameInstant(this.getDisplayTimeZone()).toString();
    }

    public void logLogout(ZonedDateTime currentDatabaseTime, String loginServerUrl, String dbiUrl) {
        LogoutInfo logoutInfo;
        Optional lastLoginTimeOpt = this._userProfile.getLastLoginTime();
        if (lastLoginTimeOpt.isPresent()) {
            ZonedDateTime lastLoginTime = (ZonedDateTime)lastLoginTimeOpt.get();
            String durationStr = this.buildLoggedInDurationString(lastLoginTime, currentDatabaseTime);
            String localTime = this.convertToDisplay(lastLoginTime);
            String lastLoginText = localTime + durationStr;
            logoutInfo = new LogoutInfo(this._userProfile.getUserName(), loginServerUrl, dbiUrl, lastLoginText);
        } else {
            logoutInfo = new LogoutInfo(this._userProfile.getUserName(), "N/A", "N/A", "N/A");
        }
        logoutInfo.logIt();
    }

    private ZoneId getDisplayTimeZone() {
        TimeZone timeZone = ServiceLookup.getTimeZoneDisplayService().getTimeZone();
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        return timeZone.toZoneId();
    }

    private String buildLoggedInDurationString(ZonedDateTime lastLoginTime, ZonedDateTime dbTime) {
        long days = ChronoUnit.DAYS.between(lastLoginTime, dbTime);
        long hours = ChronoUnit.HOURS.between(lastLoginTime, dbTime.minusDays(days));
        long minutes = ChronoUnit.MINUTES.between(lastLoginTime, dbTime.minusDays(days).minusHours(hours));
        long seconds = ChronoUnit.SECONDS.between(lastLoginTime, dbTime.minusDays(days).minusHours(hours).minusMinutes(minutes));
        return String.format(" (%dd %02d:%02d:%02d)", days, hours, minutes, seconds);
    }
}

