/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.logging;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class LoginInfo {
    private static final Logger LOGGER = Logger.getLogger(LoginInfo.class.getName());
    private final String _userName;
    private final String _server;
    private final String _officeId;
    private final String _database;
    private final String _lastLogin;
    private boolean _timerCanceled = false;

    public static Logger getLogger() {
        return LOGGER;
    }

    public LoginInfo(String userName, String server, String officeId, String database, String lastLogin) {
        this._userName = userName;
        this._server = server;
        this._officeId = officeId;
        this._database = database;
        this._lastLogin = lastLogin;
    }

    public void logIt() {
        Object[] info = new Object[]{this, this._userName, this._server, this._database, this._lastLogin, this._officeId};
        LOGGER.log(Level.INFO, "LOGGED IN: User: {1} Server: {2} Database: {3} Last Login: {4} Office ID: {5}", info);
    }

    public void showDialog(final Component parent, final String title, final Runnable doLater) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoginInfo.this._timerCanceled = false;
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                JLabel label = new JLabel("User:");
                Font labelFont = label.getFont();
                Font boldFont = new Font(labelFont.getName(), 1, labelFont.getSize());
                label.setFont(boldFont);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel(LoginInfo.this._userName);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel("Server:");
                label.setFont(boldFont);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel(LoginInfo.this._server);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel("Database:");
                label.setFont(boldFont);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel(LoginInfo.this._database);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 2;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel("Last Login:");
                label.setFont(boldFont);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 3;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel(LoginInfo.this._lastLogin);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 3;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                JOptionPane pane = new JOptionPane(panel, 1);
                final JDialog dialog = pane.createDialog(parent, title);
                if (doLater != null) {
                    dialog.addComponentListener(new ComponentListener(){

                        @Override
                        public void componentHidden(ComponentEvent arg0) {
                            doLater.run();
                        }

                        @Override
                        public void componentMoved(ComponentEvent arg0) {
                        }

                        @Override
                        public void componentResized(ComponentEvent arg0) {
                        }

                        @Override
                        public void componentShown(ComponentEvent arg0) {
                        }
                    });
                }
                dialog.setModal(false);
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                pane.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        LoginInfo.this._timerCanceled = true;
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
                Timer timer = new Timer(5000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        if (!LoginInfo.this._timerCanceled) {
                            dialog.setVisible(false);
                        }
                        if (arg0.getSource() instanceof Timer) {
                            ((Timer)arg0.getSource()).stop();
                        }
                    }
                });
                timer.start();
            }
        });
    }

    public String getUserName() {
        return this._userName;
    }

    public String getServer() {
        return this._server;
    }

    public String getDatabase() {
        return this._database;
    }

    public String getLastLogin() {
        return this._lastLogin;
    }

    public String getOfficeId() {
        return this._officeId;
    }
}

