/*
 * Decompiled with CFR 0.152.
 */
package hec.serversuite.logging;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class LogoutInfo {
    private static final Logger LOGGER = Logger.getLogger(LogoutInfo.class.getName());
    private String _userName;
    private String _server;
    private String _database;
    private String _loggedInSince;
    private boolean _timerCanceled = false;

    public static Logger getLogger() {
        return LOGGER;
    }

    public LogoutInfo(String userName, String server, String database, String loggedInSince) {
        this._userName = userName;
        this._server = server;
        this._database = database;
        this._loggedInSince = loggedInSince;
    }

    public void logIt() {
        Object[] info = new Object[]{this, this._userName, this._server, this._database, this._loggedInSince};
        LOGGER.log(Level.INFO, "LOGGED OUT: User: {1} Server: {2} Database: {3} Logged In Since: {4}", info);
    }

    public void showDialog(Component parent, String title) {
        this.showDialog(parent, title, null);
    }

    public void showDialog(final Component parent, final String title, final Runnable doLater) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object dlgTitle = "Logout";
                if (title != null && !title.toLowerCase().contains("logout")) {
                    dlgTitle = title + " " + (String)dlgTitle;
                }
                LogoutInfo.this._timerCanceled = false;
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                JLabel label = new JLabel("User:");
                Font labelFont = label.getFont();
                Font boldFont = new Font(labelFont.getName(), 1, labelFont.getSize());
                label.setFont(boldFont);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel(LogoutInfo.this._userName);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel("Server:");
                label.setFont(boldFont);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel(LogoutInfo.this._server);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel("Database:");
                label.setFont(boldFont);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel(LogoutInfo.this._database);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 2;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel("Logged In Since:");
                label.setFont(boldFont);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 3;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                label = new JLabel(LogoutInfo.this._loggedInSince);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 3;
                gbc.ipadx = 15;
                gbc.ipady = 5;
                gbc.anchor = 17;
                panel.add((Component)label, gbc);
                JOptionPane pane = new JOptionPane(panel, 1);
                final JDialog dialog = pane.createDialog(parent, (String)dlgTitle);
                if (doLater != null) {
                    dialog.addComponentListener(new ComponentListener(){

                        @Override
                        public void componentHidden(ComponentEvent arg0) {
                            doLater.run();
                        }

                        @Override
                        public void componentMoved(ComponentEvent arg0) {
                        }

                        @Override
                        public void componentResized(ComponentEvent arg0) {
                        }

                        @Override
                        public void componentShown(ComponentEvent arg0) {
                        }
                    });
                }
                dialog.setModal(false);
                dialog.setVisible(true);
                pane.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        LogoutInfo.this._timerCanceled = true;
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }
                });
                Timer timer = new Timer(5000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        if (!LogoutInfo.this._timerCanceled) {
                            dialog.setVisible(false);
                        }
                        if (arg0.getSource() instanceof Timer) {
                            ((Timer)arg0.getSource()).stop();
                        }
                    }
                });
                timer.start();
            }
        });
    }
}

