/*
 * Decompiled with CFR 0.152.
 */
package hec.plugins.dssvue.collections;

import hec.dssgui.ListSelection;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.DataReferenceSet;
import hec.heclib.dss.DssDataManager;
import hec.heclib.util.HecTime;
import hec.heclib.util.stringContainer;
import hec.hecmath.HecMath;
import hec.hecmath.TimeSeriesMath;
import hec.io.DataContainer;
import hec.io.PairedDataContainer;
import hec.io.TimeSeriesContainer;
import hec.plugins.dssvue.collections.OverwritableTextField;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;

public class CollectionsPlugin {
    protected ListSelection listSelection;
    protected String _versionID = "1.5, May 2012";
    private static ListSelection _listSelection;
    protected int _numberRecords = 0;

    public static void main(Object[] args) {
        if (args.length > 0 && args[0] instanceof ListSelection) {
            _listSelection = (ListSelection)args[0];
        }
        final ListSelection listSelection = (ListSelection)args[0];
        listSelection.setCustomMenu("Collections");
        JMenu collectionMenu = listSelection.getCustomMenu();
        JMenuItem menu = new JMenuItem("New Collection from Period Of Record");
        collectionMenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.newFromPor(listSelection);
            }
        });
        menu = new JMenuItem("New Collection from POR Peaks");
        collectionMenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.newFromPeaks(listSelection);
            }
        });
        menu = new JMenuItem("Period Of Record from Collection");
        collectionMenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.porFromCollection(listSelection);
            }
        });
        menu = new JMenuItem("New Collection Using Numeric F Part");
        collectionMenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.newUsingFpart(listSelection);
            }
        });
        menu = new JMenuItem("New Collection Using Selection");
        collectionMenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.newUsingSelection(listSelection, false);
            }
        });
        menu = new JMenuItem("New Collection Using F Part Mask");
        collectionMenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.newUsingMask(listSelection);
            }
        });
        menu = new JMenuItem("New Collection Using Katherines method");
        collectionMenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.newUsingSelection(listSelection, true);
            }
        });
        JMenu jmenu = new JMenu("Duplicate");
        collectionMenu.add(jmenu);
        menu = new JMenuItem("Using New Sequence Number");
        jmenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.duplicate(listSelection, 0);
            }
        });
        menu = new JMenuItem("Adding to Sequence Number");
        jmenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.duplicate(listSelection, 1);
            }
        });
        menu = new JMenuItem("New F part (same sequence)");
        jmenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.duplicate(listSelection, 2);
            }
        });
        jmenu = new JMenu("Resequence");
        collectionMenu.add(jmenu);
        menu = new JMenuItem("Using New Sequence Number");
        jmenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.resequence(listSelection, 0);
            }
        });
        menu = new JMenuItem("Adding to Sequence Number");
        jmenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.resequence(listSelection, 1);
            }
        });
        menu = new JMenuItem("Rename F Part");
        collectionMenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.resequence(listSelection, 2);
            }
        });
        jmenu = new JMenu("Change Date/Times");
        collectionMenu.add(jmenu);
        menu = new JMenuItem("Copy");
        jmenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.changeDateTimes(listSelection, 0);
            }
        });
        menu = new JMenuItem("Shift");
        jmenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.changeDateTimes(listSelection, 1);
            }
        });
        menu = new JMenuItem("Min/Max of Collection");
        collectionMenu.add(menu);
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CollectionsPlugin plugin = new CollectionsPlugin();
                plugin.minMaxCollection(listSelection);
            }
        });
    }

    protected boolean checkBasics(ListSelection listSelection) {
        char major;
        System.out.println("CollectionsPlugin, version " + this._versionID);
        String filename = listSelection.getDSSFilename();
        if (filename == null || filename.length() == 0) {
            JOptionPane.showMessageDialog((Component)listSelection, "Please select a DSS File", "No File Selected", 2);
            return false;
        }
        DssDataManager dataManager = listSelection.getDataManager();
        if (!dataManager.writeAccess()) {
            JOptionPane.showMessageDialog((Component)listSelection, "No write access to file.", "Unable to Write", 2);
            return false;
        }
        Vector paths = listSelection.getSelectedPaths();
        if (paths.size() == 0) {
            JOptionPane.showMessageDialog((Component)listSelection, "No Records Selected.", "Error", 2);
            return false;
        }
        this._numberRecords = dataManager.numberRecords();
        stringContainer ver = new stringContainer();
        int[] numb = new int[1];
        dataManager.zinqir("VERS", ver, numb);
        if (ver.string.startsWith("6") && (major = ver.string.charAt(2)) < 'R') {
            String mess = "Incorrect heclib library version\nYou need 6-RA or later and you have " + ver.string;
            JOptionPane.showMessageDialog((Component)listSelection, mess, "Error", 0);
            return false;
        }
        return true;
    }

    protected void newFromPor(ListSelection listSelection) {
        int startingSequence;
        if (!this.checkBasics(listSelection)) {
            return;
        }
        List[] list = listSelection.getSelectedDataContainers();
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == null) continue;
            JOptionPane.showMessageDialog((Component)listSelection, "Only Valid for time series data", "Error", 2);
            return;
        }
        String s = JOptionPane.showInputDialog((Component)listSelection, "Enter starting date (and time) for each sequence\n(Year will be ignored)", "Starting date of sequence", 3);
        if (s == null) {
            return;
        }
        HecTime start = new HecTime();
        start.set(s);
        if (!start.isDateDefined()) {
            JOptionPane.showMessageDialog((Component)listSelection, "Invalid date", "Error", 2);
            return;
        }
        if (!start.isTimeDefined()) {
            start.setTime("0001");
        }
        System.out.println("Start = " + start.toString());
        s = JOptionPane.showInputDialog((Component)listSelection, "Enter ending date for each sequence\n(Year will be ignored)", "Ending date of sequence", 3);
        if (s == null) {
            return;
        }
        HecTime end = new HecTime();
        end.set(s);
        if (!end.isDateDefined()) {
            JOptionPane.showMessageDialog((Component)listSelection, "Invalid date", "Error", 2);
            return;
        }
        if (!end.isTimeDefined()) {
            end.setTime("2400");
        }
        if (start.greaterThan(end)) {
            int yr = end.year();
            int day = end.day();
            int month = end.month();
            end.setYearMonthDay(++yr, month, day, 1440);
        }
        System.out.println("End = " + start.toString());
        s = JOptionPane.showInputDialog((Component)listSelection, "Enter starting sequence number,\nor leave blank to use year as sequence", "Starting sequence number", 3);
        if (s == null || s.length() == 0) {
            startingSequence = -1;
        } else {
            try {
                startingSequence = Integer.parseInt(s);
            }
            catch (Exception e) {
                startingSequence = -1;
            }
            if (startingSequence < 0) {
                JOptionPane.showMessageDialog((Component)listSelection, "Invalid number", "Error", 2);
                return;
            }
        }
        TimeSeriesContainer c = (TimeSeriesContainer)list[0].get(0);
        int intl = c.interval > 60 ? 1440 : 60;
        HecTime htime = new HecTime();
        htime.setYearMonthDay(3000, start.month(), start.day(), start.minutesSinceMidnight());
        s = JOptionPane.showInputDialog((Component)listSelection, "Enter complete date for\n(first data point) collection", htime.toString(104));
        if (s == null) {
            return;
        }
        HecTime collectionDate = new HecTime();
        collectionDate.set(s);
        if (!collectionDate.isDateDefined()) {
            JOptionPane.showMessageDialog((Component)listSelection, "Invalid date", "Error", 2);
            return;
        }
        System.out.println("collectionDate = " + collectionDate.toString());
        int count = 0;
        for (int i = 0; i < list[0].size(); ++i) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)list[0].get(i);
            count += this.computePorCollection(listSelection, tsc, start, end, collectionDate, startingSequence);
        }
        if (count == 0) {
            JOptionPane.showMessageDialog((Component)listSelection, "No collections produced", "Error", 2);
            return;
        }
        this.refreshCatalog();
        JOptionPane.showMessageDialog((Component)listSelection, count + " collection data sets saved", "Collections from Period of Record", 1);
    }

    protected int computePorCollection(ListSelection listSelection, TimeSeriesContainer origTsc, HecTime start, HecTime end, HecTime collectionDate, int startingSequence) {
        Vector<TimeSeriesContainer> containers = new Vector<TimeSeriesContainer>();
        TimeSeriesContainer tsc = new TimeSeriesContainer();
        origTsc.clone(tsc);
        tsc.values = null;
        tsc.times = null;
        tsc.quality = null;
        tsc.numberValues = 0;
        HecTime origStart = new HecTime();
        origStart.set(origTsc.times[0], origTsc.timeGranularitySeconds, origTsc.julianBaseDate);
        HecTime origEnd = new HecTime();
        origEnd.set(origTsc.times[origTsc.times.length - 1], origTsc.timeGranularitySeconds, origTsc.julianBaseDate);
        int lenPeriod = end.value() - start.value();
        if (lenPeriod < 0) {
            lenPeriod += 512640;
        }
        int yr = origStart.year();
        int day = start.day();
        int month = start.month();
        HecTime hecTime = new HecTime();
        hecTime.setYearMonthDay(yr, month, day, 1440);
        if (hecTime.lessThan(origStart)) {
            hecTime.setYearMonthDay(++yr, month, day, 1440);
        }
        hecTime.subtractMinutes(1339);
        if (hecTime.lessThan(origStart)) {
            hecTime.set(origStart);
        }
        while (true) {
            int startValue = hecTime.value();
            int startPos = -1;
            for (int i = 0; i < origTsc.times.length; ++i) {
                if (origTsc.times[i] < startValue) continue;
                startPos = i;
                break;
            }
            if (startPos == -1) break;
            int endValue = startValue + lenPeriod;
            int endPos = -1;
            for (int i = startPos; i < origTsc.times.length; ++i) {
                if (origTsc.times[i] < endValue) continue;
                endPos = i;
                break;
            }
            if (endPos == -1) break;
            TimeSeriesContainer tscn = new TimeSeriesContainer();
            tsc.clone(tscn);
            tscn.numberValues = endPos - startPos + 1;
            tscn.times = new int[tscn.numberValues];
            tscn.values = new double[tscn.numberValues];
            if (origTsc.quality != null) {
                tscn.quality = new int[tscn.numberValues];
            }
            for (int i = 0; i < tscn.numberValues; ++i) {
                tscn.times[i] = origTsc.times[startPos];
                tscn.values[i] = origTsc.values[startPos];
                if (origTsc.quality != null) {
                    tscn.quality[i] = origTsc.quality[startPos];
                }
                ++startPos;
            }
            DSSPathname path = new DSSPathname(tscn.fullName);
            if (startingSequence > -1) {
                path.setCollectionSequence(startingSequence++);
            } else {
                HecTime htime = new HecTime();
                htime.set(tscn.times[0], tscn.timeGranularitySeconds, tscn.julianBaseDate);
                path.setCollectionSequence(htime.year());
            }
            tscn.fullName = path.pathname();
            int diff = collectionDate.value() - tscn.times[0];
            int i = 0;
            while (i < tscn.times.length) {
                int n = i++;
                tscn.times[n] = tscn.times[n] + diff;
            }
            tscn.startTime = tscn.times[0];
            tscn.endTime = tscn.times[tscn.numberValues - 1];
            containers.add(tscn);
            yr = hecTime.year();
            day = hecTime.day();
            month = hecTime.month();
            hecTime.setYearMonthDay(++yr, month, day);
        }
        listSelection.saveData(containers);
        this.refreshCatalog();
        return containers.size();
    }

    protected void minMaxCollection(ListSelection listSelection) {
        PairedDataContainer pdc;
        if (!this.checkBasics(listSelection)) {
            return;
        }
        List[] list = listSelection.getSelectedDataContainers();
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == null) continue;
            JOptionPane.showMessageDialog((Component)listSelection, "Only Valid for time series data", "Error", 2);
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)listSelection, "Include times of min/max in recoreds?", "Include times", 0);
        Vector<Vector> vectors = new Vector<Vector>();
        boolean error = this.separateIntoCollections(list[0], vectors);
        if (error) {
            JOptionPane.showMessageDialog((Component)listSelection, "Data sets can only be collections", "Error", 2);
            return;
        }
        Vector<PairedDataContainer> pdContainers = new Vector<PairedDataContainer>();
        for (int i = 0; i < vectors.size(); ++i) {
            int k;
            int inumber;
            String seq;
            DSSPathname path;
            TimeSeriesContainer tsc;
            int j;
            Vector containers = vectors.get(i);
            pdc = new PairedDataContainer();
            pdc.numberOrdinates = containers.size();
            pdc.xOrdinates = new double[pdc.numberOrdinates];
            if (opt == 0) {
                pdc.numberCurves = 2;
                pdc.yOrdinates = new double[2][pdc.numberOrdinates];
                pdc.labelsUsed = true;
                pdc.labels = new String[2];
                pdc.labels[0] = "Time - minutes";
                pdc.labels[1] = "Max Value";
            } else {
                pdc.numberCurves = 1;
                pdc.yOrdinates = new double[1][pdc.numberOrdinates];
                pdc.labelsUsed = false;
            }
            for (j = 0; j < containers.size(); ++j) {
                tsc = (TimeSeriesContainer)containers.get(j);
                path = new DSSPathname(tsc.fullName);
                seq = path.getCollectionSequence();
                try {
                    inumber = Integer.parseInt(seq);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog((Component)listSelection, "Invalid sequence number: " + seq, "Error", 2);
                    return;
                }
                if (j == 0) {
                    DSSPathname pdPath = new DSSPathname();
                    pdPath.setAPart(path.aPart());
                    pdPath.setBPart(path.bPart());
                    pdPath.setCPart("Sequence - Max " + path.cPart());
                    pdPath.setDPart(path.dPart().substring(2));
                    pdPath.setEPart(path.ePart());
                    pdPath.setFPart(path.fPart().substring(9));
                    pdc.fullName = pdPath.pathname();
                    pdc.xunits = "Sequence number";
                    pdc.yunits = tsc.units;
                    pdContainers.add(pdc);
                }
                pdc.xOrdinates[j] = inumber;
                double max = -9999999.0;
                int posMax = 0;
                for (k = 0; k < tsc.values.length; ++k) {
                    if (!(tsc.values[k] > max)) continue;
                    max = tsc.values[k];
                    posMax = k;
                }
                if (opt == 0) {
                    pdc.yOrdinates[0][j] = tsc.times[posMax];
                    pdc.yOrdinates[1][j] = max;
                    continue;
                }
                pdc.yOrdinates[0][j] = max;
            }
            pdc = new PairedDataContainer();
            pdc.numberOrdinates = containers.size();
            pdc.xOrdinates = new double[pdc.numberOrdinates];
            if (opt == 0) {
                pdc.numberCurves = 2;
                pdc.yOrdinates = new double[2][pdc.numberOrdinates];
                pdc.labelsUsed = true;
                pdc.labels = new String[2];
                pdc.labels[0] = "Time - minutes";
                pdc.labels[1] = "Min Value";
            } else {
                pdc.numberCurves = 1;
                pdc.yOrdinates = new double[1][pdc.numberOrdinates];
                pdc.labelsUsed = false;
            }
            for (j = 0; j < containers.size(); ++j) {
                tsc = (TimeSeriesContainer)containers.get(j);
                path = new DSSPathname(tsc.fullName);
                seq = path.getCollectionSequence();
                try {
                    inumber = Integer.parseInt(seq);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog((Component)listSelection, "Invalid sequence number: " + seq, "Error", 2);
                    return;
                }
                if (j == 0) {
                    DSSPathname pdPath = new DSSPathname();
                    pdPath.setAPart(path.aPart());
                    pdPath.setBPart(path.bPart());
                    pdPath.setCPart("Sequence - Min " + path.cPart());
                    pdPath.setDPart(path.dPart().substring(2));
                    pdPath.setEPart(path.ePart());
                    pdPath.setFPart(path.fPart().substring(9));
                    pdc.fullName = pdPath.pathname();
                    pdc.xunits = "Sequence number";
                    pdc.yunits = tsc.units;
                    pdContainers.add(pdc);
                }
                pdc.xOrdinates[j] = inumber;
                double min = 9.99999999E8;
                int posMin = 0;
                for (k = 0; k < tsc.values.length; ++k) {
                    if (!(tsc.values[k] < min)) continue;
                    min = tsc.values[k];
                    posMin = k;
                }
                if (opt == 0) {
                    pdc.yOrdinates[0][j] = tsc.times[posMin];
                    pdc.yOrdinates[1][j] = min;
                    continue;
                }
                pdc.yOrdinates[0][j] = min;
            }
        }
        listSelection.saveData(pdContainers);
        this.refreshCatalog();
        if (pdContainers.size() > 4) {
            JOptionPane.showMessageDialog((Component)listSelection, pdContainers.size() + "Paired Data Records Saved", "Data Saved", 1);
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("Paired Data Records Saved:");
            for (int k = 0; k < pdContainers.size(); ++k) {
                pdc = (PairedDataContainer)pdContainers.get(k);
                sb.append("\n");
                sb.append(pdc.fullName);
            }
            JOptionPane.showMessageDialog((Component)listSelection, sb.toString(), "Data Saved", 1);
        }
    }

    protected void newFromPeaks(ListSelection listSelection) {
        int startingSequence;
        int daysAfter;
        int daysBefore;
        if (!this.checkBasics(listSelection)) {
            return;
        }
        List[] list = listSelection.getSelectedDataContainers();
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == null) continue;
            JOptionPane.showMessageDialog((Component)listSelection, "Only Valid for time series data", "Error", 2);
            return;
        }
        String s = JOptionPane.showInputDialog((Component)listSelection, "Enter the number of days before the peak to start the collection", "Generate Collection from Peaks", 3);
        if (s == null) {
            return;
        }
        try {
            daysBefore = Integer.parseInt(s);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)listSelection, "Invalid number", "Error", 2);
            return;
        }
        s = JOptionPane.showInputDialog((Component)listSelection, "Enter the number of days after the peak to end the collection", "Generate Collection from Peaks", 3);
        if (s == null) {
            return;
        }
        try {
            daysAfter = Integer.parseInt(s);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)listSelection, "Invalid number", "Error", 2);
            return;
        }
        s = JOptionPane.showInputDialog((Component)listSelection, "Enter starting sequence number,\nor leave blank to use year as sequence", "Starting sequence number", 3);
        if (s == null || s.length() == 0) {
            startingSequence = -1;
        } else {
            try {
                startingSequence = Integer.parseInt(s);
            }
            catch (Exception e) {
                startingSequence = -1;
            }
            if (startingSequence < 0) {
                JOptionPane.showMessageDialog((Component)listSelection, "Invalid number", "Error", 2);
                return;
            }
        }
        TimeSeriesContainer c = (TimeSeriesContainer)list[0].get(0);
        s = c.interval > 60 ? JOptionPane.showInputDialog((Component)listSelection, "Enter complete date for\n(first data point) collection", "01JAN3000, 2400") : JOptionPane.showInputDialog((Component)listSelection, "Enter complete date for\n(first data point) collection", "01JAN3000, 0100");
        if (s == null) {
            return;
        }
        HecTime collectionDate = new HecTime();
        collectionDate.set(s);
        if (!collectionDate.isDateDefined()) {
            JOptionPane.showMessageDialog((Component)listSelection, "Invalid date", "Error", 2);
            return;
        }
        System.out.println("collectionDate = " + collectionDate.toString());
        int count = 0;
        for (int i = 0; i < list[0].size(); ++i) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)list[0].get(i);
            count += this.computePeakCollection(listSelection, tsc, daysBefore, daysAfter, collectionDate, startingSequence);
        }
        if (count == 0) {
            JOptionPane.showMessageDialog((Component)listSelection, "No collections produced", "Error", 2);
            return;
        }
        this.refreshCatalog();
        JOptionPane.showMessageDialog((Component)listSelection, count + " collection data sets saved", "Collections from Period of Record", 1);
    }

    protected int computePeakCollection(ListSelection listSelection, TimeSeriesContainer origTsc, int daysBefore, int daysAfter, HecTime collectionDate, int startingSequence) {
        int[] peakTimes;
        TimeSeriesMath math = new TimeSeriesMath();
        try {
            math.setData((DataContainer)origTsc);
            HecMath result = math.transformTimeSeries("1YEAR", "0MINUTES", "MAX", true);
            TimeSeriesContainer dc = (TimeSeriesContainer)result.getData();
            peakTimes = Arrays.copyOf(dc.times, dc.times.length);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)listSelection, "Error determining annual maximums: \n" + e.toString(), "Error", 2);
            return -1;
        }
        Vector<TimeSeriesContainer> containers = new Vector<TimeSeriesContainer>();
        TimeSeriesContainer tsc = new TimeSeriesContainer();
        origTsc.clone(tsc);
        tsc.values = null;
        tsc.times = null;
        tsc.quality = null;
        tsc.numberValues = 0;
        HecTime origStart = new HecTime();
        origStart.set(origTsc.times[0], origTsc.timeGranularitySeconds, origTsc.julianBaseDate);
        HecTime origEnd = new HecTime();
        origEnd.set(origTsc.times[origTsc.times.length - 1], origTsc.timeGranularitySeconds, origTsc.julianBaseDate);
        int count = 0;
        do {
            int startValue = peakTimes[count] - daysBefore * 1440;
            int startPos = -1;
            for (int i = 0; i < origTsc.times.length; ++i) {
                if (origTsc.times[i] < startValue) continue;
                startPos = i;
                break;
            }
            if (startPos == -1) break;
            int endValue = peakTimes[count] + daysAfter * 1440;
            int endPos = -1;
            for (int i = startPos; i < origTsc.times.length; ++i) {
                if (origTsc.times[i] < endValue) continue;
                endPos = i;
                break;
            }
            if (endPos == -1) break;
            TimeSeriesContainer tscn = new TimeSeriesContainer();
            tsc.clone(tscn);
            tscn.numberValues = endPos - startPos + 1;
            tscn.times = new int[tscn.numberValues];
            tscn.values = new double[tscn.numberValues];
            if (origTsc.quality != null) {
                tscn.quality = new int[tscn.numberValues];
            }
            for (int i = 0; i < tscn.numberValues; ++i) {
                tscn.times[i] = origTsc.times[startPos];
                tscn.values[i] = origTsc.values[startPos];
                if (origTsc.quality != null) {
                    tscn.quality[i] = origTsc.quality[startPos];
                }
                ++startPos;
            }
            DSSPathname path = new DSSPathname(tscn.fullName);
            if (startingSequence > -1) {
                path.setCollectionSequence(startingSequence++);
            } else {
                HecTime htime = new HecTime();
                htime.set(peakTimes[count], origTsc.timeGranularitySeconds, origTsc.julianBaseDate);
                path.setCollectionSequence(htime.year());
            }
            tscn.fullName = path.pathname();
            int diff = collectionDate.value() - tscn.times[0];
            int i = 0;
            while (i < tscn.times.length) {
                int n = i++;
                tscn.times[n] = tscn.times[n] + diff;
            }
            tscn.startTime = tscn.times[0];
            tscn.endTime = tscn.times[tscn.numberValues - 1];
            containers.add(tscn);
        } while (++count < peakTimes.length);
        listSelection.saveData(containers);
        this.refreshCatalog();
        return containers.size();
    }

    protected void porFromCollection(ListSelection listSelection) {
        int startingSequence;
        if (!this.checkBasics(listSelection)) {
            return;
        }
        List[] list = listSelection.getSelectedDataContainers();
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == null) continue;
            JOptionPane.showMessageDialog((Component)listSelection, "Only Valid for time series data collections", "Error", 2);
            return;
        }
        Vector<Vector> vectors = new Vector<Vector>();
        boolean error = this.separateIntoCollections(list[0], vectors);
        if (error) {
            JOptionPane.showMessageDialog((Component)listSelection, "Data sets can only be collections", "Error", 2);
            return;
        }
        String s = JOptionPane.showInputDialog((Component)listSelection, "Enter starting year number,\nor leave blank to use sequence for year", "Starting sequence number", 3);
        if (s == null || s.length() == 0) {
            startingSequence = -1;
        } else {
            try {
                startingSequence = Integer.parseInt(s);
            }
            catch (Exception e) {
                startingSequence = -1;
            }
            if (s.length() != 4) {
                startingSequence = -1;
            }
            if (startingSequence < 0) {
                JOptionPane.showMessageDialog((Component)listSelection, "Invalid year (must be 4 digits)", "Error", 2);
                return;
            }
        }
        for (int i = 0; i < vectors.size(); ++i) {
            Vector containers = vectors.get(i);
            int year = startingSequence;
            for (int j = 0; j < containers.size(); ++j) {
                int iyr;
                TimeSeriesContainer tsc = (TimeSeriesContainer)containers.get(j);
                DSSPathname path = new DSSPathname(tsc.fullName);
                if (year == -1) {
                    s = path.getCollectionSequence();
                    try {
                        iyr = Integer.parseInt(s);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog((Component)listSelection, "Invalid year sequence: " + s, "Error", 2);
                        return;
                    }
                } else {
                    iyr = year++;
                }
                HecTime hecTime = new HecTime();
                hecTime.set(tsc.times[0], tsc.timeGranularitySeconds, tsc.julianBaseDate);
                HecTime newTime = new HecTime();
                newTime.set(tsc.times[0], tsc.timeGranularitySeconds, tsc.julianBaseDate);
                newTime.setYearMonthDay(iyr, hecTime.month(), hecTime.day());
                int diff = newTime.value() - hecTime.value();
                int k = 0;
                while (k < tsc.times.length) {
                    int n = k++;
                    tsc.times[n] = tsc.times[n] + diff;
                }
                tsc.startTime = tsc.times[0];
                tsc.endTime = tsc.times[tsc.times.length - 1];
                int n = path.fPart().indexOf("|");
                String f = path.fPart().substring(n + 1);
                path.setCollectionSequence(null);
                path.setFPart(f);
                tsc.fullName = path.pathname();
            }
            listSelection.saveData(containers);
        }
        this.refreshCatalog();
        JOptionPane.showMessageDialog((Component)listSelection, vectors.size() + " data sets saved", "Period of Record from Collections", 1);
    }

    protected boolean separateIntoCollections(List containers, Vector<Vector> vectors) {
        Vector<DSSPathname> paths = new Vector<DSSPathname>();
        for (int i = 0; i < containers.size(); ++i) {
            Object obj = containers.get(i);
            if (obj instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)obj;
                if (!DSSPathname.isaCollectionPath((String)tsc.fullName)) {
                    return true;
                }
                boolean added = false;
                for (int j = 0; j < paths.size(); ++j) {
                    DSSPathname p = (DSSPathname)paths.get(j);
                    if (!DSSPathname.isSameCollection((String)tsc.fullName, (String)p.pathname())) continue;
                    Vector v = vectors.get(j);
                    v.add(tsc);
                    added = true;
                    break;
                }
                if (added) continue;
                DSSPathname p = new DSSPathname(tsc.fullName);
                paths.add(p);
                Vector<TimeSeriesContainer> v = new Vector<TimeSeriesContainer>();
                v.add(tsc);
                vectors.add(v);
                continue;
            }
            return true;
        }
        return false;
    }

    protected boolean separatePathsIntoCollections(Vector pathnames, Vector<Vector> vectors) {
        Vector<DSSPathname> paths = new Vector<DSSPathname>();
        for (int i = 0; i < pathnames.size(); ++i) {
            String path = pathnames.get(i).toString();
            if (!DSSPathname.isaCollectionPath((String)path)) {
                return true;
            }
            boolean added = false;
            for (int j = 0; j < paths.size(); ++j) {
                DSSPathname p = (DSSPathname)paths.get(j);
                if (!DSSPathname.isSameCollection((String)path, (String)p.pathname())) continue;
                Vector v = vectors.get(j);
                v.add(path);
                added = true;
                break;
            }
            if (added) continue;
            DSSPathname p = new DSSPathname(path);
            paths.add(p);
            Vector<String> v = new Vector<String>();
            v.add(path);
            vectors.add(v);
        }
        return false;
    }

    protected void newUsingFpart(ListSelection listSelection) {
        if (!this.checkBasics(listSelection)) {
            return;
        }
        Vector<String> paths = this.getSelectedPathnameList(listSelection);
        Vector<String> newPathnames = new Vector<String>(paths.size());
        String filename = listSelection.getDSSFilename();
        for (int i = 0; i < paths.size(); ++i) {
            int collectionNumber;
            DSSPathname path = new DSSPathname(paths.get(i).toString());
            try {
                String fPart = path.fPart();
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < fPart.length(); ++j) {
                    char c = fPart.charAt(j);
                    if (!Character.isDigit(c)) continue;
                    sb.append(c);
                }
                collectionNumber = Integer.parseInt(sb.toString());
            }
            catch (Exception e) {
                collectionNumber = -1;
            }
            if (collectionNumber < 0) {
                JOptionPane.showMessageDialog((Component)listSelection, "Invalid F part supplied for " + path.pathname() + "\nF part must be a integer number >= 0", "Error", 2);
                return;
            }
            DecimalFormat df = new DecimalFormat("000000");
            String numb = df.format(collectionNumber);
            path.setFPart("C:" + numb + "|");
            newPathnames.add(path.pathname());
        }
        this.rename(listSelection, paths, newPathnames);
    }

    protected int rename(ListSelection listSelection, Vector<String> fromPaths, Vector<String> toPaths) {
        DssDataManager dm = listSelection.getDataManager();
        int count = dm.renameRecords(fromPaths, toPaths);
        if (count == 0) {
            JOptionPane.showMessageDialog((Component)listSelection, "No Records to process", "Error", 2);
        } else if (count < 0) {
            JOptionPane.showMessageDialog((Component)listSelection, "Error in renaming process", "Error", 2);
        } else {
            this.refreshCatalog();
            JOptionPane.showMessageDialog((Component)listSelection, count + " records processed", "Complete", 1);
        }
        return count;
    }

    protected Vector<String> getSelectedPathnameList(ListSelection listSelection) {
        Vector<String> paths = new Vector<String>();
        DataReferenceSet selected = listSelection.getSelectedPathnames();
        for (int i = 0; i < selected.size(); ++i) {
            DataReference dr = selected.get(i);
            Vector pl = dr.getPathnameList();
            paths.addAll(pl);
        }
        return paths;
    }

    protected void newUsingMask(ListSelection listSelection) {
        int opt;
        if (!this.checkBasics(listSelection)) {
            return;
        }
        List[] list = listSelection.getSelectedDataContainers();
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == null) continue;
            JOptionPane.showMessageDialog((Component)listSelection, "Only Valid for time series data", "Error", 2);
            return;
        }
        if (list[0].size() == 0) {
            JOptionPane.showMessageDialog((Component)listSelection, "No Valid time series data", "Error", 2);
            return;
        }
        String[] mess = new String[]{"Enter Mask over existing F Part:", "  S - Skip Character", "  N - Character is part of Sequence number", "  F - Character is part of F part following sequence", "      (Characters are case independent)"};
        String mask = "";
        TimeSeriesContainer tc = (TimeSeriesContainer)list[0].get(0);
        do {
            DSSPathname path;
            MaskDialog maskDialog;
            if ((mask = (maskDialog = new MaskDialog((Frame)listSelection, "Enter Mask", mess, (path = new DSSPathname(tc.fullName)).fPart())).getMask()) == null) {
                return;
            }
            mask = mask.toUpperCase();
            String fPart = this.parseMask(path.fPart(), mask);
            path.setFPart(fPart);
            opt = JOptionPane.showConfirmDialog((Component)listSelection, "Pathnames will be converted to the following stype\n" + path.pathname() + "\nUse this mask?", "Collection Mask", 1);
            if (opt != 2) continue;
            return;
        } while (opt != 0);
        tc = (TimeSeriesContainer)list[0].get(0);
        int intl = tc.interval > 60 ? 1440 : 60;
        HecTime htime = new HecTime();
        htime.set(tc.startTime, tc.timeGranularitySeconds, tc.julianBaseDate);
        String s = JOptionPane.showInputDialog((Component)listSelection, "Enter complete date for\n(first data point) collection", htime.toString(104));
        if (s == null) {
            return;
        }
        HecTime collectionDate = new HecTime();
        collectionDate.set(s);
        if (!collectionDate.isDateDefined()) {
            JOptionPane.showMessageDialog((Component)listSelection, "Invalid date", "Error", 2);
            return;
        }
        System.out.println("collectionDate = " + collectionDate.toString());
        int collectionStart = collectionDate.value();
        Vector<TimeSeriesContainer> vtsc = new Vector<TimeSeriesContainer>();
        for (int i = 0; i < list[0].size(); ++i) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)list[0].get(i);
            for (int j = 0; j < tsc.times.length; ++j) {
                tsc.times[j] = collectionStart - tsc.startTime + tsc.times[j];
            }
            DSSPathname path = new DSSPathname(tsc.fullName);
            String fPart = this.parseMask(path.fPart(), mask);
            path.setFPart(fPart);
            tsc.fullName = path.pathname();
            vtsc.add(tsc);
        }
        listSelection.saveData(vtsc);
        this.refreshCatalog();
        JOptionPane.showMessageDialog((Component)listSelection, vtsc.size() + " collection data sets created.", "Collections ", 1);
    }

    protected String parseMask(String fPart, String mask) {
        int min = fPart.length();
        if (mask.length() < min) {
            min = mask.length();
        }
        StringBuffer coll = new StringBuffer();
        StringBuffer newf = new StringBuffer();
        for (int j = 0; j < min; ++j) {
            if (mask.charAt(j) == 'N') {
                coll.append(fPart.charAt(j));
                continue;
            }
            if (mask.charAt(j) != 'F') continue;
            newf.append(fPart.charAt(j));
        }
        for (int i = 0; i < coll.length(); ++i) {
            if (coll.charAt(i) != ' ') continue;
            coll.setCharAt(i, '0');
        }
        if (coll.length() < 6) {
            int diff = 6 - coll.length();
            for (int i = 0; i < diff; ++i) {
                coll.insert(0, '0');
            }
        }
        String result = "C:" + coll.toString() + "|" + newf.toString();
        return result;
    }

    protected void newUsingSelection(ListSelection listSelection, boolean katherinesMethod) {
        if (!this.checkBasics(listSelection)) {
            return;
        }
        List[] list = listSelection.getSelectedDataContainers();
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == null) continue;
            JOptionPane.showMessageDialog((Component)listSelection, "Only Valid for time series data", "Error", 2);
            return;
        }
        TimeSeriesContainer tc = (TimeSeriesContainer)list[0].get(0);
        int intl = tc.interval > 60 ? 1440 : 60;
        HecTime htime = new HecTime();
        htime.set(tc.startTime, tc.timeGranularitySeconds, tc.julianBaseDate);
        String s = JOptionPane.showInputDialog((Component)listSelection, "Enter complete date for\n(first data point) collection", htime.toString(104));
        if (s == null) {
            return;
        }
        HecTime collectionDate = new HecTime();
        collectionDate.set(s);
        if (!collectionDate.isDateDefined()) {
            JOptionPane.showMessageDialog((Component)listSelection, "Invalid date", "Error", 2);
            return;
        }
        System.out.println("collectionDate = " + collectionDate.toString());
        int collectionStart = collectionDate.value();
        Vector<TimeSeriesContainer> vtsc = new Vector<TimeSeriesContainer>();
        for (int i = 0; i < list[0].size(); ++i) {
            int collectionNumber;
            TimeSeriesContainer tsc = (TimeSeriesContainer)list[0].get(i);
            for (int j = 0; j < tsc.times.length; ++j) {
                tsc.times[j] = collectionStart - tsc.startTime + tsc.times[j];
            }
            DSSPathname path = new DSSPathname(tsc.fullName);
            String fPart = path.fPart();
            int len = fPart.length();
            int idx = fPart.lastIndexOf("-");
            if (katherinesMethod) {
                if (idx > 0) {
                    len = idx;
                }
            } else {
                idx = 0;
            }
            try {
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < len; ++j) {
                    char c = fPart.charAt(j);
                    if (!Character.isDigit(c)) continue;
                    sb.append(c);
                }
                collectionNumber = Integer.parseInt(sb.toString());
            }
            catch (Exception e) {
                collectionNumber = -1;
            }
            if (collectionNumber < 0) {
                JOptionPane.showMessageDialog((Component)listSelection, "Invalid F part supplied for " + path.pathname() + "\nF part must be a integer number >= 0", "Error", 2);
                return;
            }
            DecimalFormat df = new DecimalFormat("000000");
            String numb = df.format(collectionNumber);
            if (idx > 0) {
                path.setFPart("C:" + numb + "|" + fPart.substring(idx + 1));
            } else {
                path.setFPart("C:" + numb + "|");
            }
            tsc.fullName = path.pathname();
            vtsc.add(tsc);
        }
        listSelection.saveData(vtsc);
        this.refreshCatalog();
        JOptionPane.showMessageDialog((Component)listSelection, vtsc.size() + " collection data sets saved", "Collections ", 1);
    }

    protected void duplicate(ListSelection listSelection, int action) {
        if (!this.checkBasics(listSelection)) {
            return;
        }
        List[] list = listSelection.getSelectedDataContainers();
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == null) continue;
            JOptionPane.showMessageDialog((Component)listSelection, "Only Valid for time series data", "Error", 2);
            return;
        }
        Vector<Vector> vectors = new Vector<Vector>();
        boolean error = this.separateIntoCollections(list[0], vectors);
        if (error) {
            JOptionPane.showMessageDialog((Component)listSelection, "Data sets can only be collections", "Error", 2);
            return;
        }
        String message = action == 0 ? "Enter new sequence number" : (action == 1 ? "Enter number to add to each sequence" : "Enter new F part");
        String s = JOptionPane.showInputDialog((Component)listSelection, message, "Collections", 3);
        if (s == null) {
            return;
        }
        int number = 0;
        if (action < 2) {
            try {
                number = Integer.parseInt(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)listSelection, "Invalid number entered: " + s, "Error", 2);
                return;
            }
        }
        for (int i = 0; i < vectors.size(); ++i) {
            Vector containers = vectors.get(i);
            for (int j = 0; j < containers.size(); ++j) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)containers.get(j);
                DSSPathname path = new DSSPathname(tsc.fullName);
                int inumber = number;
                if (action == 0) {
                    path.setCollectionSequence(inumber++);
                } else if (action == 1) {
                    String seq = path.getCollectionSequence();
                    try {
                        inumber = Integer.parseInt(seq);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog((Component)listSelection, "Invalid sequence number: " + seq, "Error", 2);
                        return;
                    }
                    path.setCollectionSequence(inumber += number);
                } else {
                    path.setFPart(s);
                }
                tsc.fullName = path.pathname();
            }
            listSelection.saveData(containers);
        }
        this.refreshCatalog();
        JOptionPane.showMessageDialog((Component)listSelection, vectors.size() + " collections saved", "Collections", 1);
    }

    protected void resequence(ListSelection listSelection, int action) {
        Vector<Vector> vectors;
        if (!this.checkBasics(listSelection)) {
            return;
        }
        Vector<String> paths = this.getSelectedPathnameList(listSelection);
        boolean error = this.separatePathsIntoCollections(paths, vectors = new Vector<Vector>());
        if (error) {
            JOptionPane.showMessageDialog((Component)listSelection, "Data sets can only be collections", "Error", 2);
            return;
        }
        String message = action == 0 ? "Enter new sequence number" : (action == 1 ? "Enter number to add to each sequence" : "Enter new F part");
        String s = JOptionPane.showInputDialog((Component)listSelection, message, "Collections", 3);
        if (s == null) {
            return;
        }
        int number = 0;
        if (action < 2) {
            try {
                number = Integer.parseInt(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)listSelection, "Invalid number entered: " + s, "Error", 2);
                return;
            }
        }
        String dssFilename = listSelection.getDssFilename();
        DataReferenceSet oldNames = new DataReferenceSet();
        Vector<String> newNames = new Vector<String>();
        for (int i = 0; i < vectors.size(); ++i) {
            Vector pathnames = vectors.get(i);
            int inumber = number;
            for (int j = 0; j < pathnames.size(); ++j) {
                String name = pathnames.get(j).toString();
                DSSPathname path = new DSSPathname(name);
                if (action == 0) {
                    path.setCollectionSequence(inumber++);
                } else if (action == 1) {
                    String seq = path.getCollectionSequence();
                    try {
                        inumber = Integer.parseInt(seq);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog((Component)listSelection, "Invalid sequence number: " + seq, "Error", 2);
                        return;
                    }
                    path.setCollectionSequence(inumber += number);
                } else {
                    path.setFPart(s);
                }
                DataReference dr = new DataReference(name, dssFilename);
                oldNames.add((Object)dr);
                newNames.add(path.pathname());
            }
        }
        this.rename(listSelection, (Vector<String>)oldNames, newNames);
    }

    protected void changeDateTimes(ListSelection listSelection, int action) {
        if (!this.checkBasics(listSelection)) {
            return;
        }
        List[] list = listSelection.getSelectedDataContainers();
        for (int i = 1; i < list.length; ++i) {
            if (list[i] == null) continue;
            JOptionPane.showMessageDialog((Component)listSelection, "Only Valid for time series data", "Error", 2);
            return;
        }
        Vector<Vector> vectors = new Vector<Vector>();
        boolean error = this.separateIntoCollections(list[0], vectors);
        if (error) {
            JOptionPane.showMessageDialog((Component)listSelection, "Data sets can only be collections", "Error", 2);
            return;
        }
        String message = action == 0 ? "Enter new date and time to copy to\ne.g.,  01FEB2500, 2400" : "Enter new date and time to shift to\ne.g.,  01FEB2500, 2400\n(Warning - old dates will no longer exist)";
        String s = JOptionPane.showInputDialog((Component)listSelection, message, "Collections", 3);
        if (s == null || s.length() == 0) {
            return;
        }
        HecTime htime = new HecTime();
        htime.set(s);
        if (!htime.isDefined()) {
            JOptionPane.showMessageDialog((Component)listSelection, "Invalid date/time entered: " + s, "Error", 2);
            return;
        }
        for (int i = 0; i < vectors.size(); ++i) {
            Vector containers = vectors.get(i);
            Vector<TimeSeriesContainer> contarinersToDelete = new Vector<TimeSeriesContainer>();
            for (int j = 0; j < containers.size(); ++j) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)containers.get(j);
                TimeSeriesContainer tscClone = new TimeSeriesContainer();
                tsc.clone(tscClone);
                int diff = htime.value() - tsc.times[0];
                for (int k = 0; k < tsc.times.length; ++k) {
                    int n = k;
                    tsc.times[n] = tsc.times[n] + diff;
                    tscClone.values[k] = -3.4028234663852886E38;
                }
                tsc.startTime = tsc.times[0];
                tsc.endTime = tsc.times[tsc.times.length - 1];
                contarinersToDelete.add(tscClone);
            }
            if (action == 1) {
                listSelection.saveData(contarinersToDelete);
            }
            listSelection.saveData(containers);
        }
        this.refreshCatalog();
        JOptionPane.showMessageDialog((Component)listSelection, vectors.size() + " collections saved", "Collections", 1);
    }

    protected void refreshCatalog() {
        boolean needsFix = true;
        int numberRecords = _listSelection.getDataManager().numberRecords();
        if (numberRecords != this._numberRecords) {
            needsFix = false;
        }
        if (needsFix) {
            double dver2;
            String ver = ListSelection._versionNumber;
            try {
                dver2 = Double.parseDouble(ver.substring(0, 3));
                if (dver2 > 2.1) {
                    needsFix = false;
                }
            }
            catch (Exception dver2) {
                // empty catch block
            }
            if (needsFix) {
                try {
                    dver2 = Double.parseDouble(ver.substring(4, 6));
                    if (dver2 > 45.0) {
                        needsFix = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (needsFix) {
            _listSelection.getDataManager().getPathnameList(true);
        }
        _listSelection.refreshCatalog();
        _listSelection.updateMenuItems(true);
    }

    public class MaskDialog
    extends JDialog {
        OverwritableTextField _mask;
        boolean _canceled;

        MaskDialog(Frame parent, String title, String[] message, String fPart) {
            super(parent, title, true);
            this._canceled = true;
            this.build(message);
            this._mask.setText(fPart);
            this.setVisible(true);
        }

        public String getMask() {
            if (this._canceled) {
                return null;
            }
            return this._mask.getText();
        }

        protected void build(String[] message) {
            this.getContentPane().setLayout(new GridBagLayout());
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)8, (int)10, (int)5, (int)5);
            this.getContentPane().add((Component)panel, gbc);
            int icount = 0;
            for (int i = 0; i < message.length; ++i) {
                JLabel label = new JLabel(message[i]);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = icount++;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
                panel.add((Component)label, gbc);
            }
            this._mask = new OverwritableTextField();
            this._mask.setColumns(32);
            this._mask.setFont(new Font("Courier", 0, 12));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = icount;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)15, (int)2, (int)0, (int)0);
            panel.add((Component)this._mask, gbc);
            ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 16;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)10, (int)10, (int)5, (int)5);
            this.getContentPane().add((Component)cmdPanel, gbc);
            cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

                public void buttonCmdActionPerformed(ActionEvent e) {
                    switch (e.getID()) {
                        case 8: {
                            MaskDialog.this._canceled = false;
                            MaskDialog.this.setVisible(false);
                            break;
                        }
                        case 4: {
                            MaskDialog.this._canceled = true;
                            MaskDialog.this.setVisible(false);
                        }
                    }
                }
            });
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this.setSize(380, 220);
                Rectangle bounds = this.getParent().getBounds();
                Rectangle abounds = this.getBounds();
                if (bounds.width > 0) {
                    this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
                }
            }
            super.setVisible(visible);
        }
    }
}

