/*
 * Decompiled with CFR 0.152.
 */
package hec.res.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecG2dDialog;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.event.PlotTypeChangedEvent;
import hec.event.PlotTypeListener;
import hec.geometry.Scale;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.PlotType;
import hec.gfx2d.Viewport;
import hec.heclib.dss.DataReference;
import hec.heclib.dss.Group;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.model.ModelVariable;
import hec.res.client.PlotDialog$ModelVariableDataReference;
import hec.res.client.SelectPlotVariablesJDialog;
import hec.watershed.res.model.Element;
import hec.watershed.res.model.PlottableObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mil.army.usace.hec.rmi.client.OpenPlotTypeDialog;
import mil.army.usace.hec.rmi.csinterface.BaseDSSManager;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSData;
import mil.army.usace.hec.rmi.gfx2d.SimpleDSSDataFactory;
import rma.util.RMAIO;

public abstract class PlotDialog
extends HecG2dDialog {
    protected Vector _resRuns;
    private JMenu _plotMenu;
    protected Vector _tsDataVec;
    private EventListenerList _listenerList = new EventListenerList();

    public PlotDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
    }

    public PlotDialog(Frame frame, String string, boolean bl, Group group) {
        super(frame, string, bl, group);
    }

    public PlotDialog(Frame serializable, String string, boolean n, Vector vector, Vector vector2, String string2) {
        super((Frame)serializable, string, n != 0);
        this.setRuns(vector2);
        this.setTimeWindow(string2);
        new Vector();
        serializable = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            string = vector.get(n);
            if (!(string instanceof PlottableObject)) continue;
            string = (PlottableObject)string;
            ((Vector)serializable).addAll(string.getDefaultModelVariables());
        }
        Collections.sort(serializable);
        this.setPlotObjects(vector);
        G2dGlyph g2dGlyph = new Vector();
        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
            g2dGlyph.addAll(this.getG2dObjects((ModelVariable)((Vector)serializable).get(i)));
        }
        DataTypeFactory.getFactory().reset();
        this._gfxPanel.buildComponents(g2dGlyph, DataTypeFactory.getFactory().getLineProperties(g2dGlyph));
        for (int i = 0; i < this._gfxPanel.getViewportVector().size(); ++i) {
            Viewport viewport = (Viewport)this._gfxPanel.getViewportVector().get(i);
            for (int j = 0; j < viewport.getGlyphVector().size(); ++j) {
                g2dGlyph = (G2dGlyph)viewport.getGlyphVector().get(j);
                serializable = g2dGlyph.getScale();
                if (!((g2dGlyph = g2dGlyph.getG2dObject()) instanceof SimpleDSSData) || (g2dGlyph = ((SimpleDSSData)g2dGlyph).getModelVariable()) == null) continue;
                serializable.getModelVariables().add(g2dGlyph);
            }
        }
    }

    public void makeMenus() {
        JMenu jMenu;
        int n;
        super.makeMenus();
        this.jConfigurePlotLayout.setVisible(false);
        this._plotMenu = new JMenu("Plot");
        this._plotMenu.setMnemonic('P');
        Serializable serializable = new JMenuItem("Select Variables ...", 83);
        ((AbstractButton)serializable).addActionListener((ActionListener)((Object)this));
        this._plotMenu.add((JMenuItem)serializable);
        this._plotMenu.addSeparator();
        serializable = new JMenuItem("Open Plot Type ...", 79);
        ((AbstractButton)serializable).addActionListener((ActionListener)((Object)this));
        this._plotMenu.add((JMenuItem)serializable);
        serializable = new JMenuItem("Save Plot Type ...", 80);
        ((AbstractButton)serializable).addActionListener((ActionListener)((Object)this));
        this._plotMenu.add((JMenuItem)serializable);
        serializable = new Vector();
        for (n = this.jmb.getMenuCount() - 1; n >= 0 && !(jMenu = this.jmb.getMenu(n)).getText().equals("Edit"); --n) {
            this.jmb.remove(jMenu);
            ((Vector)serializable).add(jMenu);
        }
        this.jmb.add(this._plotMenu);
        for (n = 0; n < ((Vector)serializable).size(); ++n) {
            this.jmb.add((JMenu)((Vector)serializable).get(n));
        }
    }

    public void setRuns(Vector vector) {
        this._resRuns = vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = (JMenuItem)actionEvent.getSource();
        if ("Select Variables ...".equals(object = ((AbstractButton)object).getText())) {
            this.selectModelVariables();
            return;
        }
        if ("Save Plot Type ...".equals(object)) {
            this.savePlotType();
            return;
        }
        if ("Open Plot Type ...".equals(object)) {
            this.openPlotType();
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public void setPlotObjects(Vector vector) {
        if (vector == null || vector.size() == 0) {
            this._plotMenu.setVisible(false);
        } else {
            this._plotMenu.setVisible(true);
        }
        this._plotObjs = vector;
    }

    void selectModelVariables() {
        if (this._plotObjs == null) {
            return;
        }
        SelectPlotVariablesJDialog selectPlotVariablesJDialog = new SelectPlotVariablesJDialog((Frame)((Object)this));
        selectPlotVariablesJDialog.setAvailablePlotObjects(this._plotObjs);
        selectPlotVariablesJDialog.setSelectedViewports(this._gfxPanel.getViewportVector());
        selectPlotVariablesJDialog.setVisible(true);
    }

    void openPlotType() {
        OpenPlotTypeDialog openPlotTypeDialog = new OpenPlotTypeDialog((Frame)((Object)this), true, 0);
        openPlotTypeDialog.setTitle("Open Plot Type ...");
        openPlotTypeDialog.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
        openPlotTypeDialog.setElementTypes(this.getElementTypes());
        Object object = ClientApp.app().getAppType();
        openPlotTypeDialog.setSubDirectory((String)object);
        object = new Vector<String>();
        ((Vector)object).add("*.plotType");
        openPlotTypeDialog.setFileFilters((List)object);
        openPlotTypeDialog.setShowFileExtensions(false);
        openPlotTypeDialog.setVisible(true);
        if (openPlotTypeDialog.isCanceled()) {
            return;
        }
        if ((openPlotTypeDialog = openPlotTypeDialog.getIdentifier()) == null) {
            return;
        }
        if (!openPlotTypeDialog.getPath().endsWith(".plotType")) {
            OpenPlotTypeDialog openPlotTypeDialog2 = openPlotTypeDialog;
            openPlotTypeDialog2.setPath(openPlotTypeDialog2.getPath() + ".plotType");
        }
        this.openPlotType((Identifier)openPlotTypeDialog);
    }

    public void openPlotType(Identifier identifier) {
        Identifier identifier2 = this.getOpenIdentifier(identifier, null, false);
        if (identifier2 == null) {
            return;
        }
        HecFile hecFile = identifier2.getFile();
        if (hecFile == null) {
            return;
        }
        hecFile = new PlotType();
        try {
            if (!hecFile.readFile(identifier2) || hecFile.getPanelProperties() == null) {
                System.out.println("openPlotType: failed to read " + identifier.getPath() + " correctly");
                return;
            }
            this.configurePlot((PlotType)hecFile);
        }
        catch (Exception exception) {
            System.out.println("openPlotType: error reading " + identifier.getPath() + " Error " + String.valueOf(exception));
            exception.printStackTrace();
        }
    }

    public boolean openPlotType(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            return false;
        }
        PlotType plotType = new PlotType();
        try {
            if (!plotType.readFile(bufferedReader) || plotType.getPanelProperties() == null) {
                System.out.println("openPlotType: failed to read plot type correctly");
                return false;
            }
            this.configurePlot(plotType);
        }
        catch (Exception exception) {
            System.out.println("openPlotType: error reading plot type Error " + String.valueOf(exception));
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    void configurePlot(PlotType object) {
        this._gfxPanel.configurePanel(object.getPanelProperties());
        object = object.getPlotVariables();
        this.configurePlotVariables((Vector)object);
        PlotDialog plotDialog = this;
        plotDialog.updateUnitSystem((Container)plotDialog._gfxPanel);
        this._gfxPanel.revalidate();
        this.repaint();
    }

    void configurePlotVariables(Vector vector) {
        DataTypeFactory.getFactory().reset();
        for (int i = 0; i < vector.size(); ++i) {
            Scale scale;
            Viewport viewport;
            Object object = (ModelVariable)vector.get(i);
            if (this._resRuns == null) {
                this.noRunsSelectedMessage("Res");
                break;
            }
            int n = this._resRuns.size();
            System.out.println("getTSDataList: plotting " + n + " runs");
            if (n <= 0) {
                this.noRunsSelectedMessage("Res");
                break;
            }
            Vector vector2 = this.getG2dObjects((ModelVariable)object);
            int n2 = object.getViewportIndex();
            if (n2 < 0 || n2 >= this._gfxPanel.getViewportVector().size() || (viewport = (Viewport)this._gfxPanel.getViewportVector().get(n2)) == null) continue;
            if (object.getScaleIndex() != -1) {
                scale = (Scale)viewport.getScaleVector().get(object.getScaleIndex());
                if (scale != null) {
                    scale.getModelVariables().add(object);
                }
            } else {
                scale = null;
            }
            if (vector2.size() == 0) continue;
            object = DataTypeFactory.getFactory().getLineProperties((List)vector2, this.getParamFromModelVariable((ModelVariable)object));
            for (int j = 0; j < vector2.size(); ++j) {
                if (scale != null) {
                    viewport.addG2dObject((G2dObject)vector2.get(j), (G2dLineProperties)object.get(j), scale);
                    continue;
                }
                viewport.addG2dObject((G2dObject)vector2.get(j), (G2dLineProperties)object.get(j));
            }
        }
        this._gfxPanel.getLegendPanel().refreshLegendItems();
    }

    public String getParamFromModelVariable(ModelVariable modelVariable) {
        if (modelVariable.getParamId() == -1) {
            return modelVariable.getNameQualifier();
        }
        Object object = Parameter.getParamString((int)modelVariable.getParamId());
        if (modelVariable.getNameQualifier() != null) {
            object = (String)object + "-" + modelVariable.getNameQualifier();
        }
        return object;
    }

    void savePlotType() {
        if (this._plotObjs == null) {
            return;
        }
        OpenPlotTypeDialog openPlotTypeDialog = new OpenPlotTypeDialog((Frame)((Object)this), true, 1);
        openPlotTypeDialog.setTitle("Save Plot Type ...");
        openPlotTypeDialog.setFileManager((RmiFileManager)ClientApp.app().getFileManager().getRemote());
        Object object = ClientApp.app().getAppType();
        openPlotTypeDialog.setSubDirectory((String)object);
        openPlotTypeDialog.setElementTypes(this.getElementTypes());
        object = new Vector<String>();
        ((Vector)object).add("*.plottype");
        openPlotTypeDialog.setFileFilters((List)object);
        openPlotTypeDialog.setVisible(true);
        if (openPlotTypeDialog.isCanceled()) {
            return;
        }
        if ((openPlotTypeDialog = openPlotTypeDialog.getIdentifier()) == null) {
            return;
        }
        this.savePlotType((Identifier)openPlotTypeDialog);
    }

    private void savePlotType(Identifier identifier) {
        Viewport viewport;
        int n = 0;
        Vector vector = new Vector();
        for (int i = 0; i < this._gfxPanel.getViewportVector().size(); ++i) {
            viewport = (Viewport)this._gfxPanel.getViewportVector().get(i);
            for (int j = 0; j < viewport.getScaleVector().size(); ++j) {
                Scale scale = (Scale)viewport.getScaleVector().get(j);
                scale.getAxis(1);
                Vector vector2 = scale.getModelVariables();
                if (vector2 == null || vector2.size() <= 0) continue;
                for (int k = 0; k < vector2.size(); ++k) {
                    scale = (ModelVariable)vector2.get(k);
                    scale.setViewportIndex(i);
                    n |= Element.getObjectTypeId((ModelVariable)scale);
                }
                vector.addAll(vector2);
            }
        }
        String string = RMAIO.getFileFromPath((String)identifier.getPath());
        String string2 = RMAIO.getDirectoryFromPath((String)identifier.getPath());
        string = String.valueOf(n).concat("-").concat(string);
        identifier.setPath(string2 + "/" + string);
        Identifier identifier2 = this.getOpenIdentifier(identifier, ".plotType", true);
        if (identifier2 == null) {
            return;
        }
        Object object = identifier2.getFile();
        if (object == null) {
            return;
        }
        if ((object = object.getBufferedWriter()) == null) {
            return;
        }
        object = this._gfxPanel.getProperties();
        viewport = new PlotType();
        viewport.setName(identifier.getName());
        viewport.setPlotVariables(vector);
        viewport.setPanelProperties((G2dPanelProp)object);
        try {
            viewport.writeFile(identifier2);
        }
        catch (Exception exception) {
            System.out.println("Error writing PlotType " + exception.getMessage());
        }
        this.firePlotTypesChanged(0);
    }

    Vector getG2dObjects(ModelVariable modelVariable) {
        Object object;
        Vector vector = new Vector();
        if (modelVariable == null) {
            return vector;
        }
        if (this._plotObjs == null) {
            return vector;
        }
        for (int i = 0; i < this._plotObjs.size(); ++i) {
            object = this._plotObjs.get(i);
            if (!(object instanceof PlottableObject) || (object = (PlottableObject)object) == null) continue;
            object.getTSRecords(modelVariable, vector, this._resRuns);
        }
        Vector<TSDataSet> vector2 = new Vector<TSDataSet>();
        int n = 0;
        if (ClientApp.app() != null) {
            ClientApp.app();
            if (ClientApp.Workspace() != null) {
                ClientApp.app();
                n = ClientApp.Workspace().getWatershedTimeZone().getRawOffset() / 3600000;
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            object = (TSRecordProxy)vector.get(i);
            if (object == null) continue;
            Vector vector3 = this.getTSDataList(modelVariable);
            for (int j = 0; j < vector3.size(); ++j) {
                Object object2 = (TSDataSet)vector3.get(j);
                if ((object2 = object2.getTSRecord(object.getName(), object.getVariableId())) == null) continue;
                String string = object2.getDSSFilename();
                object2 = object2.getDSSPathname();
                System.out.println("getG2dObject: file=" + string + "\n path=" + (String)object2);
                object2 = new PlotDialog$ModelVariableDataReference(this, (String)object2, string, modelVariable);
                object2.setGmtOffset(n);
                vector2.add((TSDataSet)object2);
            }
        }
        return this.getDssList(vector2, this._timewindow);
    }

    public void setTSDataList(Vector vector) {
        this._tsDataVec = vector;
    }

    public G2dPanel getG2dPanel() {
        return this._gfxPanel;
    }

    public void addPlotTypeListener(PlotTypeListener plotTypeListener) {
        this._listenerList.add(PlotTypeListener.class, plotTypeListener);
    }

    public void removePlotTypeListener(PlotTypeListener plotTypeListener) {
        this._listenerList.remove(PlotTypeListener.class, plotTypeListener);
    }

    protected void firePlotTypesChanged(int n) {
        PlotTypeChangedEvent plotTypeChangedEvent = null;
        EventListener[] eventListenerArray = this._listenerList.getListeners(PlotTypeListener.class);
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            if (plotTypeChangedEvent == null) {
                plotTypeChangedEvent = new PlotTypeChangedEvent((Object)this, n);
            }
            ((PlotTypeListener)eventListenerArray[i]).plotTypesChanged(plotTypeChangedEvent);
        }
    }

    protected abstract Vector getTSDataList(ModelVariable var1);

    private void noRunsSelectedMessage(String string) {
        ClientApp.app();
        JOptionPane.showMessageDialog((Component)ClientApp.frame(), "No Runs Selected or no selected Runs contain " + string + " models", "No Runs Found", 1);
    }

    public Vector getDssList(Vector vector, String string) {
        Vector<DSSManager> vector2 = new Vector<DSSManager>();
        if (vector == null) {
            return vector2;
        }
        DSSManager dSSManager = null;
        try {
            ClientApp.app();
            dSSManager = (DSSManager)ClientApp.Workspace().getData().getDSSFileManager().getRemote();
        }
        catch (Exception exception) {
            System.out.println("getDssList: failed to get dssfilemanager " + String.valueOf(exception));
        }
        if (dSSManager == null) {
            return vector2;
        }
        SimpleDSSDataFactory simpleDSSDataFactory = new SimpleDSSDataFactory((BaseDSSManager)dSSManager);
        for (int i = 0; i < vector.size(); ++i) {
            DataReference dataReference;
            block8: {
                dataReference = (DataReference)vector.get(i);
                System.out.println("ref.getFilename = " + dataReference.getFilename() + " ref.getPath = " + dataReference.getPath());
                try {
                    dSSManager = simpleDSSDataFactory.newSimpleDSSData(dataReference.getFilename(), dataReference.getPath(), string);
                    if (!(dataReference instanceof PlotDialog$ModelVariableDataReference)) break block8;
                    ModelVariable modelVariable = ((PlotDialog$ModelVariableDataReference)dataReference).getModelVariable();
                    dSSManager.setModelVariable(modelVariable);
                    if (dSSManager.getYParameterId() != -1 || modelVariable == null || modelVariable.getParamId() == -1) break block8;
                    dSSManager.setYParameterId(modelVariable.getParamId());
                }
                catch (Exception exception) {
                    System.out.println("getDssList: error getting data for " + dataReference.getFilename() + ":" + dataReference.getPath());
                    continue;
                }
            }
            if (dSSManager == null || dSSManager.size() <= 0) {
                System.out.println("failed to get data for " + dataReference.getFilename() + ":" + dataReference.getPath());
                continue;
            }
            dSSManager.setGmtOffset(dataReference.getGmtOffset());
            vector2.addElement(dSSManager);
        }
        return vector2;
    }

    private int[] getElementTypes() {
        if (this._plotObjs == null) {
            return new int[0];
        }
        Vector vector = new Vector(this._plotObjs.size());
        for (int i = 0; i < this._plotObjs.size(); ++i) {
            Object object = this._plotObjs.get(i);
            if (!(object instanceof Element) || vector.contains(object = new Integer(((Element)object).getElementTypeId()))) continue;
            vector.add(object);
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }
}

