/*
 * Decompiled with CFR 0.152.
 */
package hec.res.client;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.gui.NameDialog;
import hec.lang.NamedType;
import hec.map.LocalPt;
import hec.map.MapGlyph;
import hec.map.MapLabelItem;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.WorldLine;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.streamAlignment.StreamAlignmentGlyph;
import hec.model.StreamElement;
import hec.model.StreamPolyLine;
import hec.model.StreamSegment;
import hec.res.client.ResDrawingAttributeSet;
import hec.res.client.ResNetworkDPDiversionData;
import hec.res.client.ResNetworkDPJunctionData;
import hec.res.client.ResNetworkDPReachData;
import hec.res.client.ResNetworkDPReservoirData;
import hec.res.client.ResNetworkGlyph$NewJunctionContainer;
import hec.watershed.res.model.DiversionElement;
import hec.watershed.res.model.Element;
import hec.watershed.res.model.JunctionElement;
import hec.watershed.res.model.ReachElement;
import hec.watershed.res.model.ResAlt;
import hec.watershed.res.model.ResNetwork;
import hec.watershed.res.model.ResNode;
import hec.watershed.res.model.ReservoirDamElement;
import hec.watershed.res.model.ReservoirElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import rma.swing.RmaImage;
import rma.swing.text.DssPathnamePartDocument;

public class ResNetworkGlyph
extends MapGlyph
implements ActionListener {
    ResNetwork _sysmap = null;
    ResNetworkDPJunctionData _junctionData = ResNetworkDPJunctionData.a();
    ResNetworkDPReachData _reachData = ResNetworkDPReachData.a();
    ResNetworkDPReservoirData _reservoirData = ResNetworkDPReservoirData.a();
    ResNetworkDPDiversionData _diversionData = ResNetworkDPDiversionData.a();
    Vector<MapGlyph.Selection> _selectionVector = new Vector();
    ResAlt _resAlt = null;
    transient int _glyphLevel = 0;
    static Image _impactImage = null;
    static Image _reachImage = null;
    static Image _tsImage = null;
    ResDrawingAttributeSet _rssDas = null;
    protected MapGlyph _parentGlyph;

    public ResNetworkGlyph(MapPanel mapPanel, ResNetwork resNetwork) {
        super(mapPanel, (MapObjectInterface)resNetwork);
        if (!resNetwork.setLocked(3)) {
            JOptionPane.showMessageDialog((Component)mapPanel, "Unable to display RSS System Schematic.\nCurrently being edited.");
            return;
        }
        this._sysmap = resNetwork;
        if (_impactImage == null) {
            _impactImage = RmaImage.loadURLImage((String)"Images/fia3.gif");
        }
        if (_reachImage == null) {
            _reachImage = RmaImage.loadURLImage((String)"Images/fia3.gif");
        }
        if (_tsImage == null) {
            _tsImage = RmaImage.loadURLImage((String)"Images/modelup.gif");
        }
        ClientApp.app();
        mapPanel = ModeDrawingAttributeSet.getModeAttributeSet((String)ClientApp.frame().getCurrentMode().toString());
        if (mapPanel == null) {
            return;
        }
        this._rssDas = (ResDrawingAttributeSet)mapPanel.getModelAttributeSet("ResPRM");
    }

    public void abort() {
        if (this._sysmap != null) {
            this._sysmap.setLocked(1);
        }
    }

    public void close() {
        this.abort();
    }

    public NamedType findObject(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return null;
        }
        localPt = this._mapPanel.scale().lp2wp(localPt);
        return this.findObject((WorldPt)localPt);
    }

    public NamedType findObject(WorldPt worldPt) {
        if (this._sysmap == null || worldPt == null) {
            return null;
        }
        double d = this._mapPanel.scale().x2e(5) - this._mapPanel.scale().x2e(0);
        JunctionElement junctionElement = null;
        if (this._rssDas.isAttributeShown("Junctions")) {
            junctionElement = this._sysmap.findJunction(worldPt, d);
        }
        if (junctionElement == null) {
            if (this._rssDas.isAttributeShown("Reaches")) {
                junctionElement = this.findReach(worldPt, d);
            }
        }
        if (junctionElement == null) {
            if (this._rssDas.isAttributeShown("Reservoirs")) {
                junctionElement = this.findReservoir(worldPt);
            }
        }
        if (junctionElement == null) {
            if (this._rssDas.isAttributeShown("Diversions")) {
                junctionElement = this.findDiversion(worldPt, d);
            }
        }
        return junctionElement;
    }

    public boolean objectPopupMenu(LocalPt localPt, int n) {
        NamedType[] namedTypeArray = this.findObject(localPt);
        if (namedTypeArray != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)namedTypeArray, false);
            if (!this._selectionVector.contains(selection)) {
                this.clearSelection();
                this._selectionVector.addElement(selection);
            }
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            ClientApp.app();
            selection = ClientApp.frame();
            selection = selection.getCurrentMode();
            if (this._selectionVector.size() == 1) {
                return selection.objectPopupMenu((NamedType)namedTypeArray, localPt);
            }
            namedTypeArray = this.getSelections();
            return selection.objectPopupMenu(namedTypeArray, localPt);
        }
        return false;
    }

    public NamedType objectSelect(LocalPt localPt, int n) {
        if ((localPt = this.findObject(localPt)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)localPt, false);
            boolean bl = this._selectionVector.contains(selection);
            if (!bl) {
                this._selectionVector.addElement(selection);
                this._mapPanel.paintMap();
            } else if (bl && ResNetworkGlyph.isShiftDown((int)n) && (n & 4) == 0) {
                this._selectionVector.remove(selection);
                this._mapPanel.paintMap();
            }
        } else {
            this.clearSelection();
        }
        return localPt;
    }

    public boolean objectDoubleClick(LocalPt localPt, int n) {
        NamedType namedType = this.findObject(localPt);
        if (namedType != null) {
            this._selectionVector.removeAllElements();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)namedType, false);
            this._selectionVector.addElement(selection);
            this._mapPanel.paintMap();
            ClientApp.app();
            selection = ClientApp.frame();
            selection = selection.getCurrentMode();
            selection.objectDoubleClick(namedType, localPt);
            return true;
        }
        return false;
    }

    public boolean junctionPopupMenu(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return false;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        JunctionElement junctionElement = this._sysmap.findJunction(worldPt, d);
        if (junctionElement != null) {
            this._selectionVector.removeAllElements();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)junctionElement, false);
            this._selectionVector.addElement(selection);
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            ClientApp.app();
            selection = ClientApp.frame();
            selection = selection.getCurrentMode();
            selection.objectPopupMenu((NamedType)junctionElement, localPt);
            return true;
        }
        return false;
    }

    public boolean reachPopupMenu(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return false;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        ReachElement reachElement = this.findReach(worldPt, d);
        if (reachElement != null) {
            this._selectionVector.removeAllElements();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)reachElement, false);
            this._selectionVector.addElement(selection);
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            ClientApp.app();
            selection = ClientApp.frame();
            selection = selection.getCurrentMode();
            selection.objectPopupMenu((NamedType)reachElement, localPt);
            return true;
        }
        return false;
    }

    public boolean reservoirPopupMenu(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return false;
        }
        this._mapPanel.scale().x2e(localPt.x + 5);
        this._mapPanel.scale().x2e(localPt.x);
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        worldPt = this.findReservoir(worldPt);
        if (worldPt != null) {
            this._selectionVector.removeAllElements();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)worldPt, false);
            this._selectionVector.addElement(selection);
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            ClientApp.app();
            selection = ClientApp.frame();
            selection = selection.getCurrentMode();
            selection.objectPopupMenu((NamedType)worldPt, localPt);
            return true;
        }
        return false;
    }

    public boolean diversionPopupMenu(LocalPt localPt) {
        if (this._sysmap == null || localPt == null) {
            return false;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        DiversionElement diversionElement = this.findDiversion(worldPt, d);
        if (diversionElement != null) {
            this._selectionVector.removeAllElements();
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)diversionElement, false);
            this._selectionVector.addElement(selection);
            this._mapPanel.paintMap();
            this._mapPanel.waitforPaintComplete();
            ClientApp.app();
            selection = ClientApp.frame();
            selection = selection.getCurrentMode();
            selection.objectPopupMenu((NamedType)diversionElement, localPt);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) instanceof MenuItem) {
            object = (MenuItem)object;
            ((MenuComponent)object).getName();
        }
    }

    public boolean isShown() {
        if (this._rssDas == null) {
            return false;
        }
        return this._rssDas.isShown();
    }

    public void setShown(boolean bl) {
        if (this._rssDas == null) {
            return;
        }
        this._rssDas.setShown(bl);
    }

    public void setAlternative(ResAlt resAlt) {
        this._resAlt = resAlt;
    }

    public ResAlt getAlternative() {
        return this._resAlt;
    }

    public void clearSelection() {
        this._selectionVector.removeAllElements();
        this._mapPanel.paintMap();
    }

    public void clearSelection(Object object) {
        boolean bl = false;
        for (int i = 0; i < this._selectionVector.size(); ++i) {
            MapGlyph.Selection selection = this._selectionVector.elementAt(i);
            if (selection == null || selection.object != object) continue;
            this._selectionVector.removeElement(selection);
            bl = true;
            break;
        }
        if (bl) {
            this._mapPanel.paintMap();
        }
    }

    public void clearSelection(String string) {
        boolean bl = false;
        for (int i = 0; i < this._selectionVector.size(); ++i) {
            NamedType namedType;
            MapGlyph.Selection selection = this._selectionVector.elementAt(i);
            if (selection == null || !string.equals((namedType = (NamedType)selection.object).getName())) continue;
            this._selectionVector.removeElement(selection);
            bl = true;
            break;
        }
        if (bl) {
            this._mapPanel.paintMap();
        }
    }

    public JunctionElement findJunction(WorldPt worldPt) {
        double d = this._mapPanel.scale().x2e(5) - this._mapPanel.scale().x2e(0);
        return this._sysmap.findJunction(worldPt, d);
    }

    public JunctionElement findJunction(WorldPt worldPt, double d) {
        return this._sysmap.findJunction(worldPt, d);
    }

    public ReservoirElement findReservoir(LocalPt localPt) {
        localPt = this._mapPanel.scale().lp2wp(localPt);
        return this.findReservoir((WorldPt)localPt);
    }

    public ReservoirElement findReservoir(WorldPt worldPt) {
        double d;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph != null && (streamAlignmentGlyph = streamAlignmentGlyph.findReach(worldPt)) != null && (d = streamAlignmentGlyph.getLine().getCoordAtLocation(worldPt)) != Double.NEGATIVE_INFINITY) {
            return this._sysmap.findReservoir(streamAlignmentGlyph.getIndex(), d);
        }
        return this._sysmap.findReservoir(worldPt);
    }

    public ReservoirElement findReservoir(String string) {
        if (string == null) {
            return null;
        }
        return this._sysmap.findReservoir(string);
    }

    public void setSelection(Object object, boolean bl) {
        object = new MapGlyph.Selection((MapGlyph)this, object, bl);
        this._selectionVector.removeAllElements();
        this._selectionVector.addElement((MapGlyph.Selection)object);
        this._mapPanel.paintMap();
    }

    public void addSelection(Object object, boolean bl) {
        if (!this._selectionVector.contains(object = new MapGlyph.Selection((MapGlyph)this, object, bl))) {
            this._selectionVector.addElement((MapGlyph.Selection)object);
        }
        this._mapPanel.paintMap();
    }

    public NamedType[] getSelections() {
        int n = this._selectionVector.size();
        if (n == 0) {
            return new NamedType[0];
        }
        NamedType[] namedTypeArray = new NamedType[this._selectionVector.size()];
        for (int i = 0; i < n; ++i) {
            MapGlyph.Selection selection = this._selectionVector.get(i);
            namedTypeArray[i] = (NamedType)selection.object;
        }
        return namedTypeArray;
    }

    public ReservoirElement selectReservoir(LocalPt localPt, boolean bl, boolean bl2) {
        if (!bl) {
            this._selectionVector.removeAllElements();
        }
        if (this._sysmap == null || localPt == null) {
            return null;
        }
        localPt = this._mapPanel.scale().lp2wp(localPt);
        if ((localPt = this.findReservoir((WorldPt)localPt)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)localPt, bl2);
            if (!this._selectionVector.contains(selection)) {
                this._selectionVector.addElement(selection);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedReservoir(graphics, this._mapPanel.scale(), (ReservoirElement)localPt, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return localPt;
    }

    public ReservoirElement selectReservoir(String string, boolean bl, boolean bl2) {
        if (!bl) {
            this._selectionVector.removeAllElements();
        }
        if (this._sysmap == null || string == null) {
            return null;
        }
        if ((string = this.findReservoir(string)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)string, bl2);
            if (!this._selectionVector.contains(selection)) {
                this._selectionVector.addElement(selection);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedReservoir(graphics, this._mapPanel.scale(), (ReservoirElement)string, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return string;
    }

    public JunctionElement selectJunction(LocalPt localPt, boolean bl, boolean bl2) {
        if (!bl) {
            this._selectionVector.removeAllElements();
        }
        if (this._sysmap == null || localPt == null) {
            return null;
        }
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        localPt = this._mapPanel.scale().lp2wp(localPt);
        if ((localPt = this._sysmap.findJunction((WorldPt)localPt, d)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)localPt, bl2);
            if (!this._selectionVector.contains(selection)) {
                this._selectionVector.addElement(selection);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedJunction(graphics, this._mapPanel.scale(), (JunctionElement)localPt, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return localPt;
    }

    public void createReservoir(Vector object, Vector vector, Vector vector2, Vector vector3) {
        Object object2;
        if (this._sysmap == null || object == null) {
            return;
        }
        if (((Vector)object).size() <= 0) {
            return;
        }
        WorldRegion worldRegion = new WorldRegion();
        object = (LocalPt)((Vector)object).elementAt(0);
        double d = this._mapPanel.scale().x2e(((LocalPt)object).x + 5) - this._mapPanel.scale().x2e(((LocalPt)object).x);
        ReservoirElement reservoirElement = null;
        ClientApp.app();
        object = new NameDialog((Frame)ClientApp.frame(), true);
        int n = this.getNameLengthLimit(1);
        if (n != 0) {
            object2 = new DssPathnamePartDocument();
            object2.setLength(n);
            object.setNameFieldDocument((Document)object2);
        }
        object.setName(this._sysmap.getNextDefaultName(1));
        object.setDescription("");
        object.setTitle("Name New Reservoir");
        object2 = new Vector();
        String[] stringArray = this._sysmap.getReservoirNames();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                ((Vector)object2).add(stringArray[i]);
            }
        }
        object.setExistingNames((List)object2);
        object.setVisible(true);
        if (!object.isCanceled()) {
            String string = object.getName();
            object = object.getDescription();
            reservoirElement = this._sysmap.createReservoir(worldRegion, vector, vector2, d, string, (String)object);
            reservoirElement.setStreamSegmentVector(vector3);
            object = reservoirElement.getDownstreamNode().getLocation();
            object = this._mapPanel.scale().wp2lp((WorldPt)object);
            double d2 = this._mapPanel.scale().x2e(((LocalPt)object).x + 15);
            double d3 = this._mapPanel.scale().y2n(((LocalPt)object).y);
            worldRegion.pts.addElement(new WorldPt(d2, d3));
            d2 = this._mapPanel.scale().x2e(((LocalPt)object).x);
            d3 = this._mapPanel.scale().y2n(((LocalPt)object).y - 20);
            worldRegion.pts.addElement(new WorldPt(d2, d3));
            d2 = this._mapPanel.scale().x2e(((LocalPt)object).x - 15);
            d3 = this._mapPanel.scale().y2n(((LocalPt)object).y);
            worldRegion.pts.addElement(new WorldPt(d2, d3));
            reservoirElement.setRegion(worldRegion);
        }
        this._mapPanel.paintMap();
    }

    public void drawReservoir(Graphics graphics, MapScale mapScale, ReservoirElement reservoirElement) {
        StreamElement streamElement;
        StreamSegment streamSegment;
        Object object;
        int n;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return;
        }
        if (reservoirElement == null) {
            return;
        }
        Object object2 = reservoirElement.getRegion();
        int[] nArray = new int[object2.pts.size()];
        int[] nArray2 = new int[object2.pts.size()];
        for (n = 0; n < object2.pts.size() && (object = (WorldPt)object2.pts.elementAt(n)) != null; ++n) {
            nArray[n] = mapScale.e2x(((WorldPt)object).e);
            nArray2[n] = mapScale.n2y(((WorldPt)object).n);
        }
        object2 = reservoirElement.getDownstreamNode();
        if (object2 != null) {
            object = object2.getLocation();
            nArray[n] = mapScale.e2x(((WorldPt)object).e);
            nArray2[n] = mapScale.n2y(((WorldPt)object).n);
            ++n;
        }
        if (n > 0) {
            graphics.setPaintMode();
            graphics.setColor(this._reservoirData.fillColor);
            graphics.fillPolygon(nArray, nArray2, n);
            graphics.setColor(this._reservoirData.outlineColor);
            graphics.drawPolygon(nArray, nArray2, n);
        }
        object = reservoirElement.getNodeVector();
        reservoirElement.getNodeDirVector();
        int n2 = ((Vector)object).size();
        double d = (double)this._reachData.reachWidth / 1.5;
        Vector vector = reservoirElement.getStreamSegmentVector();
        if (vector != null) {
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                int n3;
                streamSegment = (StreamSegment)vector.elementAt(n);
                if (streamSegment == null || (streamElement = streamAlignmentGlyph.findReach(streamSegment.streamIndex)) == null || (var20_19 = streamSegment.downstreamStation != Double.NEGATIVE_INFINITY ? streamElement.getCoordByStation(streamSegment.downstreamStation) : streamSegment.downstreamCoord) == (var22_20 = streamSegment.upstreamStation != Double.NEGATIVE_INFINITY ? streamElement.getCoordByStation(streamSegment.upstreamStation) : streamSegment.upstreamCoord)) continue;
                object2 = streamElement.getLineSegment(var20_19, var22_20);
                if (nArray.length < object2.pts.size() << 1) {
                    nArray = new int[object2.pts.size() << 1];
                    nArray2 = new int[object2.pts.size() << 1];
                }
                if ((n3 = object2.getLocalRegionArrays(mapScale, nArray, nArray2, d)) <= 0) continue;
                graphics.setPaintMode();
                graphics.setColor(this._reservoirData.fillColor.darker());
                graphics.fillPolygon(nArray, nArray2, n3);
                graphics.setColor(this._reservoirData.outlineColor.darker());
                graphics.drawPolygon(nArray, nArray2, n3);
            }
        } else {
            for (n = 0; n < n2; ++n) {
                int n4;
                object2 = (ResNode)((Vector)object).elementAt(n);
                if (object2 == null || (streamSegment = streamAlignmentGlyph.findReach(object2.getStreamIndex())) == null) continue;
                var20_19 = object2.getStreamCoord();
                var22_20 = Double.NEGATIVE_INFINITY;
                for (n4 = 0; n4 < n2; ++n4) {
                    if (n == n4 || (vector = (ResNode)((Vector)object).elementAt(n4)) == null || vector.getStreamIndex() != object2.getStreamIndex()) continue;
                    var22_20 = vector.getStreamCoord();
                    break;
                }
                if (var22_20 == Double.NEGATIVE_INFINITY) {
                    n4 = reservoirElement.getNodeDir(n);
                    if (n4 == 1) {
                        var22_20 = 0.0;
                    } else {
                        var22_20 = var20_19;
                        var20_19 = 1.0;
                    }
                } else if (var22_20 >= var20_19) continue;
                object2 = streamSegment.getLineSegment(var22_20, var20_19);
                if (nArray.length < object2.pts.size() << 1) {
                    nArray = new int[object2.pts.size() << 1];
                    nArray2 = new int[object2.pts.size() << 1];
                }
                if ((n4 = object2.getLocalRegionArrays(mapScale, nArray, nArray2, d)) <= 0) continue;
                graphics.setPaintMode();
                graphics.setColor(this._reservoirData.fillColor.darker());
                graphics.fillPolygon(nArray, nArray2, n4);
                graphics.setColor(this._reservoirData.outlineColor.darker());
                graphics.drawPolygon(nArray, nArray2, n4);
            }
        }
        WorldPt worldPt = new WorldPt();
        WorldPt worldPt2 = new WorldPt();
        Vector vector2 = reservoirElement.getElementsByClass(ReservoirDamElement.class, null);
        for (n = 0; n < vector2.size(); ++n) {
            streamElement = (Element)vector2.elementAt(n);
            object2 = streamElement.getDownstreamNode();
            if (object2 == null) continue;
            streamSegment = this._mapPanel.scale().wp2lp(object2.getLocation());
            object = streamAlignmentGlyph.findReach(object2.getStreamIndex());
            if (object == null) continue;
            object.getLine().getSlopeAtCoord(object2.getStreamCoord(), worldPt, worldPt2);
            object2 = graphics.getColor();
            graphics.setColor(Color.gray);
            nArray[0] = (int)((double)streamSegment.x - worldPt2.n * d * 2.0 + worldPt2.e * d / 2.0 + 0.5);
            nArray[1] = (int)((double)streamSegment.x - worldPt2.n * d * 2.0 - worldPt2.e * d / 2.0 + 0.5);
            nArray[2] = (int)((double)streamSegment.x + worldPt2.n * d * 2.0 - worldPt2.e * d / 2.0 + 0.5);
            nArray[3] = (int)((double)streamSegment.x + worldPt2.n * d * 2.0 + worldPt2.e * d / 2.0 + 0.5);
            nArray2[0] = (int)((double)streamSegment.y - worldPt2.e * d * 2.0 - worldPt2.n * d / 2.0 + 0.5);
            nArray2[1] = (int)((double)streamSegment.y - worldPt2.e * d * 2.0 + worldPt2.n * d / 2.0 + 0.5);
            nArray2[2] = (int)((double)streamSegment.y + worldPt2.e * d * 2.0 + worldPt2.n * d / 2.0 + 0.5);
            nArray2[3] = (int)((double)streamSegment.y + worldPt2.e * d * 2.0 - worldPt2.n * d / 2.0 + 0.5);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor((Color)object2);
        }
        object = reservoirElement.getReferencePt();
        int n5 = mapScale.e2x(((WorldPt)object).e);
        int n6 = mapScale.n2y(((WorldPt)object).n);
        if (_impactImage == null) {
            graphics.setColor(Color.red);
            graphics.fillOval(n5 - 2, n6 - 2, 4, 4);
            graphics.setColor(Color.blue);
            graphics.drawOval(n5 - 2, n6 - 2, 4, 4);
        }
        this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(reservoirElement.getName(), n5 + 10, n6 + 4, (float)this._glyphLevel + 0.1f, this._reservoirData.nameFont, this._reservoirData.outlineColor, null, graphics));
    }

    public void drawSelectedReservoir(Graphics graphics, MapScale mapScale, ReservoirElement reservoirElement, boolean bl, boolean bl2) {
        int n;
        WorldPt worldPt;
        int n2 = 0;
        Object object = new LocalPt();
        int[] nArray = new int[4000];
        int[] nArray2 = new int[4000];
        for (int i = 0; i < reservoirElement.getRegion().pts.size() && i < 4000; ++i) {
            worldPt = (WorldPt)reservoirElement.getRegion().pts.elementAt(i);
            if (worldPt == null) continue;
            mapScale.wp2lp(worldPt, (LocalPt)object);
            nArray[n2] = ((LocalPt)object).x;
            nArray2[n2] = ((LocalPt)object).y;
            ++n2;
        }
        ResNode resNode = reservoirElement.getDownstreamNode();
        if (resNode != null) {
            worldPt = resNode.getLocation();
            nArray[n2] = mapScale.e2x(worldPt.e);
            nArray2[n2] = mapScale.n2y(worldPt.n);
            ++n2;
        }
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        }
        graphics.setColor(Color.yellow);
        graphics.fillPolygon(nArray, nArray2, n2);
        graphics.setPaintMode();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        }
        graphics.setColor(Color.blue);
        graphics.drawPolygon(nArray, nArray2, n2);
        if (bl2) {
            int[] nArray3 = new int[4];
            object = new int[4];
            for (int i = 0; i < n2; ++i) {
                nArray3[0] = nArray[i] - 3;
                object[0] = nArray2[i];
                nArray3[1] = nArray[i];
                object[1] = nArray2[i] + 3;
                nArray3[2] = nArray[i] + 3;
                object[2] = nArray2[i];
                nArray3[3] = nArray[i];
                object[3] = nArray2[i] - 3;
                graphics.fillPolygon(nArray3, (int[])object, 4);
            }
        }
        ReservoirElement reservoirElement2 = reservoirElement;
        object = reservoirElement2.getNodeVector();
        reservoirElement2.getNodeDirVector();
        ((Vector)object).size();
        double d = (double)this._reachData.reachWidth / 1.5;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        Vector vector = reservoirElement2.getStreamSegmentVector();
        if (vector != null) {
            int n3 = vector.size();
            for (n = 0; n < n3; ++n) {
                int n4;
                double d2;
                double d3;
                StreamElement streamElement;
                resNode = (StreamSegment)vector.elementAt(n);
                if (resNode == null || (streamElement = streamAlignmentGlyph.findReach(resNode.streamIndex)) == null || (d3 = resNode.downstreamStation != Double.NEGATIVE_INFINITY ? streamElement.getCoordByStation(resNode.downstreamStation) : resNode.downstreamCoord) == (d2 = resNode.upstreamStation != Double.NEGATIVE_INFINITY ? streamElement.getCoordByStation(resNode.upstreamStation) : resNode.upstreamCoord)) continue;
                streamElement = streamElement.getLineSegment(d3, d2);
                if (nArray.length < streamElement.pts.size() << 1) {
                    nArray = new int[streamElement.pts.size() << 1];
                    nArray2 = new int[streamElement.pts.size() << 1];
                }
                if ((n4 = streamElement.getLocalRegionArrays(mapScale, nArray, nArray2, d)) <= 0) continue;
                graphics.setColor(Color.yellow);
                graphics.fillPolygon(nArray, nArray2, n4);
                graphics.setColor(this._reservoirData.outlineColor.darker());
                graphics.drawPolygon(nArray, nArray2, n4);
            }
        } else {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                int n5;
                StreamElement streamElement;
                reservoirElement = (ResNode)((Vector)object).elementAt(i);
                if (reservoirElement == null || (streamElement = reservoirElement.getStream()) == null) continue;
                double d4 = reservoirElement.getStreamCoord();
                double d5 = Double.NEGATIVE_INFINITY;
                for (n5 = 0; n5 < ((Vector)object).size(); ++n5) {
                    if (i == n5 || (vector = (ResNode)((Vector)object).elementAt(n5)) == null || vector.getStreamIndex() != reservoirElement.getStreamIndex()) continue;
                    d5 = vector.getStreamCoord();
                    break;
                }
                if (d5 == Double.NEGATIVE_INFINITY) {
                    d5 = 0.0;
                }
                if (d5 >= d4) continue;
                StreamPolyLine streamPolyLine = streamElement.getLineSegment(d5, d4);
                if (nArray.length < streamPolyLine.pts.size() << 1) {
                    nArray = new int[streamPolyLine.pts.size() << 1];
                    nArray2 = new int[streamPolyLine.pts.size() << 1];
                }
                if ((n5 = streamPolyLine.getLocalRegionArrays(mapScale, nArray, nArray2, d)) <= 0) continue;
                graphics.setColor(Color.yellow);
                graphics.fillPolygon(nArray, nArray2, n5);
                graphics.setColor(this._reservoirData.outlineColor.darker());
                graphics.drawPolygon(nArray, nArray2, n5);
            }
        }
        WorldPt worldPt2 = new WorldPt();
        WorldPt worldPt3 = new WorldPt();
        Vector vector2 = reservoirElement2.getElementsByClass(ReservoirDamElement.class, null);
        for (n = 0; n < vector2.size(); ++n) {
            Element element = (Element)vector2.elementAt(n);
            ResNode resNode2 = element.getDownstreamNode();
            if (resNode2 == null) continue;
            LocalPt localPt = this._mapPanel.scale().wp2lp(resNode2.getLocation());
            element = streamAlignmentGlyph.findReach(resNode2.getStreamIndex());
            if (element == null) continue;
            element.getLine().getSlopeAtCoord(resNode2.getStreamCoord(), worldPt2, worldPt3);
            object = graphics.getColor();
            graphics.setColor(Color.yellow);
            nArray[0] = (int)((double)localPt.x - worldPt3.n * d * 2.0 + worldPt3.e * d / 2.0 + 0.5);
            nArray[1] = (int)((double)localPt.x - worldPt3.n * d * 2.0 - worldPt3.e * d / 2.0 + 0.5);
            nArray[2] = (int)((double)localPt.x + worldPt3.n * d * 2.0 - worldPt3.e * d / 2.0 + 0.5);
            nArray[3] = (int)((double)localPt.x + worldPt3.n * d * 2.0 + worldPt3.e * d / 2.0 + 0.5);
            nArray2[0] = (int)((double)localPt.y - worldPt3.e * d * 2.0 - worldPt3.n * d / 2.0 + 0.5);
            nArray2[1] = (int)((double)localPt.y - worldPt3.e * d * 2.0 + worldPt3.n * d / 2.0 + 0.5);
            nArray2[2] = (int)((double)localPt.y + worldPt3.e * d * 2.0 + worldPt3.n * d / 2.0 + 0.5);
            nArray2[3] = (int)((double)localPt.y + worldPt3.e * d * 2.0 - worldPt3.n * d / 2.0 + 0.5);
            graphics.fillPolygon(nArray, nArray2, 4);
            graphics.setColor(Color.blue);
            graphics.drawPolygon(nArray, nArray2, 4);
            graphics.setColor((Color)object);
        }
        if (bl) {
            graphics.setPaintMode();
        }
    }

    public void draw(Graphics graphics, MapScale mapScale) {
        Element element;
        int n;
        if (this._sysmap == null) {
            return;
        }
        this._glyphLevel = this._mapPanel.getGlyphLevel((MapGlyph)this);
        Vector vector = this._sysmap.getElementVector();
        for (n = 0; _paintOk && n < vector.size(); ++n) {
            element = (Element)vector.elementAt(n);
            if (element == null) continue;
            if (element instanceof ReservoirElement) {
                if (!this._rssDas.isAttributeShown("Reservoirs")) continue;
                this.drawReservoir(graphics, mapScale, (ReservoirElement)element);
                continue;
            }
            if (!(element instanceof ReachElement)) continue;
            if (!this._rssDas.isAttributeShown("Reaches")) continue;
            this.drawReach(graphics, mapScale, (ReachElement)element);
        }
        for (n = 0; _paintOk && n < vector.size(); ++n) {
            element = (Element)vector.elementAt(n);
            if (element == null || !(element instanceof JunctionElement)) continue;
            if (!this._rssDas.isAttributeShown("Junctions")) continue;
            this.drawJunction(graphics, mapScale, (JunctionElement)element);
        }
        for (n = 0; _paintOk && n < vector.size(); ++n) {
            element = (Element)vector.elementAt(n);
            if (element == null || !(element instanceof DiversionElement)) continue;
            if (!this._rssDas.isAttributeShown("Diversions")) continue;
            this.drawDiversion(graphics, mapScale, (DiversionElement)element);
        }
        for (n = 0; _paintOk && n < this._selectionVector.size(); ++n) {
            element = this._selectionVector.elementAt(n);
            if (element.object == null) continue;
            if (element.object instanceof ReservoirElement) {
                vector = (ReservoirElement)element.object;
                if (!this._rssDas.isAttributeShown("Reservoirs")) continue;
                this.drawSelectedReservoir(graphics, mapScale, (ReservoirElement)vector, false, element.editing);
                continue;
            }
            if (element.object instanceof ReachElement) {
                if (!this._rssDas.isAttributeShown("Reaches")) continue;
                this.drawSelectedReach(graphics, mapScale, (ReachElement)element.object, false, element.editing);
                continue;
            }
            if (element.object instanceof JunctionElement) {
                if (!this._rssDas.isAttributeShown("Junctions")) continue;
                this.drawSelectedJunction(graphics, mapScale, (JunctionElement)element.object, false, element.editing);
                continue;
            }
            if (!(element.object instanceof DiversionElement)) continue;
            if (!this._rssDas.isAttributeShown("Diversions")) continue;
            this.drawSelectedDiversion(graphics, mapScale, (DiversionElement)element.object, false, element.editing);
        }
    }

    public void drawJunction(Graphics graphics, MapScale mapScale, JunctionElement junctionElement) {
        if (junctionElement == null) {
            return;
        }
        int n = this._junctionData.junctionWidth;
        int n2 = (int)((double)this._junctionData.junctionWidth / 2.0);
        WorldPt worldPt = junctionElement.getReferencePt();
        if (worldPt == null || !worldPt.isValid()) {
            return;
        }
        int n3 = mapScale.e2x(worldPt.e);
        int n4 = mapScale.n2y(worldPt.n);
        if (junctionElement.getLocalFlowVector().size() > 0) {
            int n5 = (int)((double)n2 * 1.5);
            int n6 = n5 << 1;
            graphics.setColor(Color.white);
            int n7 = n6;
            graphics.fillOval(n3 - n5, n4 - n5, n7, n7);
            graphics.setColor(this._junctionData.outlineColor);
            int n8 = n6;
            graphics.drawOval(n3 - n5, n4 - n5, n8, n8);
        }
        graphics.setColor(this._junctionData.fillColor);
        int n9 = n;
        graphics.fillOval(n3 - n2, n4 - n2, n9, n9);
        graphics.setColor(this._junctionData.outlineColor);
        int n10 = n;
        graphics.drawOval(n3 - n2, n4 - n2, n10, n10);
        if (this._junctionData.drawName) {
            this._mapPanel.viewport().addMapLabelItem(new MapLabelItem(junctionElement.getName(), n3, n4, junctionElement.getLabelPosition(), (int)((double)n2 * 1.5 + 3.0), (float)this._glyphLevel + 0.3f, this._junctionData.nameFont, this._junctionData.fillColor, null, graphics));
        }
    }

    public void drawSelectedJunction(Graphics graphics, MapScale mapScale, JunctionElement junctionElement, boolean bl, boolean bl2) {
        if (junctionElement == null) {
            return;
        }
        int n = this._junctionData.junctionWidth;
        int n2 = (int)((double)this._junctionData.junctionWidth / 2.0);
        if ((junctionElement = junctionElement.getReferencePt()) == null || !junctionElement.isValid()) {
            return;
        }
        int n3 = mapScale.e2x(junctionElement.e);
        int n4 = mapScale.n2y(junctionElement.n);
        graphics.setColor(Color.yellow);
        int n5 = n;
        graphics.fillOval(n3 - n2, n4 - n2, n5, n5);
        graphics.setColor(this._junctionData.outlineColor);
        int n6 = n;
        graphics.drawOval(n3 - n2, n4 - n2, n6, n6);
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        }
        if (bl2) {
            graphics.setColor(Color.black);
            graphics.fillRect(n3 - n2 - 5, n4 - n2 - 5, 5, 5);
            graphics.fillRect(n3 - n2 - 5, n4 + n2, 5, 5);
            graphics.fillRect(n3 + n2, n4 - n2 - 5, 5, 5);
            graphics.fillRect(n3 + n2, n4 + n2, 5, 5);
        }
        if (bl) {
            graphics.setPaintMode();
        }
    }

    public ReachElement selectReach(LocalPt localPt, boolean bl, boolean bl2) {
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        System.out.println("selectReach: pt=" + String.valueOf(localPt) + " add=" + bl + " editing=" + bl2);
        if (!bl) {
            this._selectionVector.removeAllElements();
        }
        if (this._sysmap == null || localPt == null) {
            return null;
        }
        localPt = this._mapPanel.scale().lp2wp(localPt);
        if ((localPt = this.findReach((WorldPt)localPt, d)) != null) {
            MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)localPt, bl2);
            if (!this._selectionVector.contains(selection)) {
                this._selectionVector.addElement(selection);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedReach(graphics, this._mapPanel.scale(), (ReachElement)localPt, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return localPt;
    }

    public ReachElement findReach(LocalPt localPt) {
        double d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x);
        localPt = this._mapPanel.scale().lp2wp(localPt);
        return this._sysmap.findReach((WorldPt)localPt, d);
    }

    public ReachElement findReach(WorldPt worldPt) {
        double d = this._mapPanel.scale().x2e(5) - this._mapPanel.scale().x2e(0);
        return this._sysmap.findReach(worldPt, d);
    }

    public ReachElement findReach(WorldPt worldPt, double d) {
        return this._sysmap.findReach(worldPt, d);
    }

    public void drawReach(Graphics graphics, MapScale mapScale, ReachElement reachElement) {
        WorldLine worldLine;
        double d;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return;
        }
        if (reachElement == null) {
            return;
        }
        ResNode resNode = reachElement.getUpstreamNode();
        ResNode resNode2 = reachElement.getDownstreamNode();
        if (resNode == null || resNode2 == null) {
            System.out.println("\nWarning, error in reach " + reachElement.getName() + " connectivity!\n");
            return;
        }
        StreamElement streamElement = null;
        if (streamAlignmentGlyph != null) {
            streamElement = streamAlignmentGlyph.findReach(resNode.getStreamIndex());
        }
        if (streamElement != null) {
            if (resNode.getStreamStation() == resNode2.getStreamStation()) {
                System.out.println("ResNetworkGlyph.drawReach: Warning, reach" + reachElement.getName() + " has zero length!");
                return;
            }
            d = resNode.getStreamCoord();
            double d2 = resNode2.getStreamCoord();
            worldLine = streamElement.getLineSegment(d2, d);
        } else {
            worldLine = new WorldLine();
            worldLine.pts.addElement(resNode.getLocation());
            worldLine.pts.addElement(resNode2.getLocation());
        }
        d = (double)this._reachData.reachWidth / 2.0;
        int[] nArray = new int[worldLine.pts.size() << 1];
        int[] nArray2 = new int[worldLine.pts.size() << 1];
        int n = worldLine.getLocalRegionArrays(mapScale, nArray, nArray2, d);
        if (n > 0) {
            graphics.setPaintMode();
            graphics.setColor(this._reachData.fillColor);
            graphics.fillPolygon(nArray, nArray2, n);
            if (reachElement.isActive(this._resAlt)) {
                graphics.setColor(this._reachData.outlineColor);
            } else {
                graphics.setColor(this._reachData.inactiveOutlineColor);
            }
            graphics.drawPolygon(nArray, nArray2, n);
        }
        graphics.setColor(this._reachData.fillColor);
        WorldPt worldPt = new WorldPt();
        WorldPt worldPt2 = new WorldPt();
        worldLine.getSlopeAtCoord(0.5, worldPt, worldPt2);
        this.drawArrow(graphics, mapScale, worldPt, worldPt2);
        worldPt = resNode.getLocation();
        worldLine = resNode2.getLocation();
        int n2 = mapScale.e2x(worldPt.e);
        int n3 = mapScale.n2y(worldPt.n);
        graphics.setColor(Color.red);
        graphics.fillOval(n2 - 2, n3 - 2, 4, 4);
        graphics.setColor(this._reachData.outlineColor);
        graphics.drawOval(n2 - 2, n3 - 2, 4, 4);
        n2 = mapScale.e2x(worldLine.e);
        n3 = mapScale.n2y(worldLine.n);
        graphics.setColor(Color.red);
        graphics.fillOval(n2 - 2, n3 - 2, 4, 4);
        graphics.setColor(this._reachData.outlineColor);
        graphics.drawOval(n2 - 2, n3 - 2, 4, 4);
        if (this._reachData.drawReachName && streamElement != null) {
            double d3 = (resNode.getStreamCoord() + resNode2.getStreamCoord()) / 2.0;
            graphics.setColor(this._reachData.fillColor);
            Font font = graphics.getFont();
            graphics.setFont(this._reachData.nameFont);
            this.drawConformingString(graphics, mapScale, streamElement.getLine(), reachElement.getName(), d3, (int)d, graphics.getFont(), this._reachData.outlineColor, 1, (float)this._glyphLevel + 0.4f);
            graphics.setFont(font);
        }
    }

    public void drawReachDeprecated(Graphics graphics, MapScale mapScale, ReachElement reachElement) {
        int[] nArray;
        int[] nArray2;
        if (reachElement == null) {
            return;
        }
        WorldLine worldLine = reachElement.getLine();
        int n = worldLine.getLocalRegionArrays(mapScale, nArray2 = new int[worldLine.pts.size() << 1], nArray = new int[worldLine.pts.size() << 1]);
        if (n > 0) {
            graphics.setPaintMode();
            graphics.setColor(new Color(0, 128, 255));
            graphics.fillPolygon(nArray2, nArray, n);
            graphics.setColor(Color.blue);
            graphics.drawPolygon(nArray2, nArray, n);
        }
        WorldPt worldPt = reachElement.getReferencePt();
        int n2 = mapScale.e2x(worldPt.e);
        int n3 = mapScale.n2y(worldPt.n);
        if (_reachImage == null) {
            graphics.setColor(this._reachData.fillColor);
            graphics.fillOval(n2 - 2, n3 - 2, 4, 4);
            graphics.setColor(Color.blue);
            graphics.drawOval(n2 - 2, n3 - 2, 4, 4);
        }
        graphics.setColor(this._reachData.fillColor);
        graphics.drawString(reachElement.getName(), n2 + 10, n3 + 4);
    }

    public void drawSelectedReach(Graphics graphics, MapScale mapScale, ReachElement reachElement, boolean bl, boolean bl2) {
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (reachElement == null) {
            return;
        }
        ResNode resNode = reachElement.getUpstreamNode();
        ResNode resNode2 = reachElement.getDownstreamNode();
        if (resNode == null || resNode2 == null) {
            System.out.println("\nWarning, error in reach " + reachElement.getName() + " connectivity!\n");
            return;
        }
        StreamElement streamElement = null;
        if (streamAlignmentGlyph != null) {
            streamElement = streamAlignmentGlyph.findReach(resNode.getStreamIndex());
        }
        if (streamElement != null) {
            if (resNode.getStreamStation() == resNode2.getStreamStation()) {
                System.out.println("ResNetworkGlyph.drawReach: Warning, reach" + reachElement.getName() + " has zero length!");
                return;
            }
            double d = resNode.getStreamCoord();
            double d2 = resNode2.getStreamCoord();
            streamAlignmentGlyph = streamElement.getLineSegment(d2, d);
        } else {
            streamAlignmentGlyph = new WorldLine();
            streamAlignmentGlyph.pts.addElement(resNode.getLocation());
            streamAlignmentGlyph.pts.addElement(resNode2.getLocation());
        }
        int[] nArray = new int[streamAlignmentGlyph.pts.size() << 1];
        int[] nArray2 = new int[streamAlignmentGlyph.pts.size() << 1];
        int n = streamAlignmentGlyph.getLocalRegionArrays(mapScale, nArray, nArray2);
        graphics.setColor(Color.yellow);
        graphics.fillPolygon(nArray, nArray2, n);
        graphics.setPaintMode();
        if (bl) {
            graphics.setXORMode(new Color(255, 255, 255));
        }
        if (reachElement.isActive()) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(this._reachData.inactiveOutlineColor);
        }
        graphics.drawPolygon(nArray, nArray2, n);
        if (bl2) {
            reachElement = resNode.getLocation();
            WorldPt worldPt = resNode2.getLocation();
            int n2 = mapScale.e2x(reachElement.e);
            int n3 = mapScale.n2y(reachElement.n);
            graphics.setColor(Color.black);
            graphics.fillOval(n2 - 3, n3 - 3, 6, 6);
            graphics.drawOval(n2 - 3, n3 - 3, 6, 6);
            n2 = mapScale.e2x(worldPt.e);
            n3 = mapScale.n2y(worldPt.n);
            graphics.setColor(Color.black);
            graphics.fillOval(n2 - 3, n3 - 3, 6, 6);
            graphics.drawOval(n2 - 3, n3 - 3, 6, 6);
        }
        if (bl) {
            graphics.setPaintMode();
        }
    }

    public void getDeleteNode(ResNode resNode) {
        this._sysmap.deleteNode(resNode);
    }

    public ResNode createReachNode(LocalPt localPt, StreamElement streamElement, ResNode resNode) {
        if (localPt == null) {
            return null;
        }
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return null;
        }
        if ((streamAlignmentGlyph = streamAlignmentGlyph.findReach(localPt, streamElement)) == null) {
            return null;
        }
        if (streamElement != null && streamAlignmentGlyph != streamElement) {
            return null;
        }
        streamElement = this._mapPanel.scale().lp2wp(localPt);
        double d = streamAlignmentGlyph.getLine().getCoordAtLocation((WorldPt)streamElement);
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        if (resNode != null && resNode.getStreamCoord() <= d) {
            return null;
        }
        double d2 = this._mapPanel.scale().x2e(localPt.x + (int)((double)this._junctionData.junctionWidth / 2.0)) - this._mapPanel.scale().x2e(localPt.x);
        localPt = this._sysmap.findJunction((WorldPt)streamElement, d2);
        if (localPt != null) {
            if (resNode == null && (resNode = localPt.getDownstreamNode()) != null) {
                if (resNode.getDownstreamElement() != null) {
                    return null;
                }
                return resNode;
            }
            streamElement = localPt.getReferencePt();
            d = streamAlignmentGlyph.getLine().getCoordAtLocation((WorldPt)streamElement);
        }
        resNode = null;
        if (localPt == null && (resNode = this.findReservoir((WorldPt)streamElement)) != null) {
            return null;
        }
        if (localPt == null && resNode == null && (localPt = this._sysmap.findReach(streamAlignmentGlyph.getIndex(), d)) != null) {
            return null;
        }
        localPt = this._sysmap.createNode(streamAlignmentGlyph.getLocationByCoord(d));
        localPt.setStreamIndex(streamAlignmentGlyph.getIndex());
        localPt.setStreamName(streamAlignmentGlyph.getName());
        localPt.setStreamCoord(d);
        localPt.setStreamStation(streamAlignmentGlyph.getStationByCoord(d));
        return localPt;
    }

    private JunctionElement closestJunction(ResNode resNode, JunctionElement junctionElement, JunctionElement junctionElement2) {
        WorldPt worldPt;
        if (junctionElement2 == null) {
            return junctionElement;
        }
        resNode = resNode.getLocation();
        if (worldPt.distToPoint(junctionElement.getReferencePt()) < resNode.distToPoint(junctionElement2.getReferencePt())) {
            return junctionElement;
        }
        return junctionElement2;
    }

    ResNetworkGlyph$NewJunctionContainer findOrCreateJunctions(ResNode resNode, ResNode resNode2) {
        ResNetworkGlyph$NewJunctionContainer resNetworkGlyph$NewJunctionContainer = new ResNetworkGlyph$NewJunctionContainer();
        LocalPt localPt = this._mapPanel.scale().wp2lp(resNode.getLocation());
        double d = this._mapPanel.scale().x2e(localPt.x + (int)((double)this._junctionData.junctionWidth / 2.0)) - this._mapPanel.scale().x2e(localPt.x);
        localPt = new WorldRect(resNode.getLocation(), d);
        WorldRect worldRect = new WorldRect(resNode2.getLocation(), d);
        Vector vector = this._sysmap.getElementVector();
        for (int i = 0; i < vector.size(); ++i) {
            Element element = (Element)vector.elementAt(i);
            if (element == null || !(element instanceof JunctionElement)) continue;
            if ((element = (JunctionElement)element) != resNetworkGlyph$NewJunctionContainer.c && localPt.contains(element.getReferencePt())) {
                resNetworkGlyph$NewJunctionContainer.a = this.closestJunction(resNode, (JunctionElement)element, resNetworkGlyph$NewJunctionContainer.a);
                element = resNetworkGlyph$NewJunctionContainer.a.getDownstreamNode();
                if (element != null && element.getDownstreamElement() == null) {
                    element.dispose();
                }
                resNetworkGlyph$NewJunctionContainer.a.addNode(resNode, 0);
                continue;
            }
            if (element == resNetworkGlyph$NewJunctionContainer.a || !worldRect.contains(element.getReferencePt())) continue;
            resNetworkGlyph$NewJunctionContainer.c = this.closestJunction(resNode2, (JunctionElement)element, resNetworkGlyph$NewJunctionContainer.c);
            resNetworkGlyph$NewJunctionContainer.c.addNode(resNode2, 1);
            element = resNetworkGlyph$NewJunctionContainer.c.getDownstreamNode();
            if (element == null || element.getStreamIndex() == resNode2.getStreamIndex() || !(element.getStreamCoord() < 0.01)) continue;
            element.setStream(resNode2.getStream());
            element.setStreamIndex(resNode2.getStreamIndex());
            element.setStreamName(resNode2.getStreamName());
            element.setStreamStation(resNode2.getStreamStation());
            element.setStreamCoord(resNode2.getStreamCoord());
        }
        if (resNetworkGlyph$NewJunctionContainer.a == null) {
            resNetworkGlyph$NewJunctionContainer.a = this.createJunctionElement();
            if (resNetworkGlyph$NewJunctionContainer.a == null) {
                resNetworkGlyph$NewJunctionContainer.b = true;
                if (resNetworkGlyph$NewJunctionContainer.c == null) {
                    resNetworkGlyph$NewJunctionContainer.d = true;
                }
                return resNetworkGlyph$NewJunctionContainer;
            }
            resNetworkGlyph$NewJunctionContainer.a.addNode(resNode, 0);
            resNetworkGlyph$NewJunctionContainer.b = true;
        }
        if (resNetworkGlyph$NewJunctionContainer.c == null) {
            resNetworkGlyph$NewJunctionContainer.c = this.createJunctionElement();
            if (resNetworkGlyph$NewJunctionContainer.c == null) {
                resNetworkGlyph$NewJunctionContainer.d = true;
                return resNetworkGlyph$NewJunctionContainer;
            }
            resNetworkGlyph$NewJunctionContainer.c.addNode(resNode2, 1);
            resNetworkGlyph$NewJunctionContainer.d = true;
            ResNode resNode3 = this._sysmap.createNode(resNode2.getLocation());
            resNode3.setStreamIndex(resNode2.getStreamIndex());
            resNode3.setStreamName(resNode2.getStreamName());
            resNode3.setStreamCoord(resNode2.getStreamCoord());
            resNode3.setStreamStation(resNode2.getStreamStation());
            resNetworkGlyph$NewJunctionContainer.c.addNode(resNode3, 0);
        }
        return resNetworkGlyph$NewJunctionContainer;
    }

    JunctionElement createJunctionElement() {
        String string = null;
        Object object = new NameDialog((Frame)((JFrame)AppDaddy.getFrame()), true);
        object.setNameFieldDocument((Document)new DssPathnamePartDocument());
        object.setName(this._sysmap.getNextDefaultName(2));
        object.setDescription("");
        object.setTitle("Name New Junction");
        object.setVisible(true);
        if (!object.isCanceled()) {
            string = object.getName();
            object = object.getDescription();
            if ((string = this._sysmap.newJunctionElement(string)) != null) {
                string.setDescription((String)object);
            }
        }
        return string;
    }

    public void createReach(ResNode resNode, ResNode resNode2, LocalPt object) {
        if (this._sysmap == null || resNode == null || resNode2 == null) {
            return;
        }
        object = this.findOrCreateJunctions(resNode, resNode2);
        if (object.a == null || object.c == null) {
            if (object.b) {
                this._sysmap.deleteNode(resNode);
                if (object.a != null) {
                    this._sysmap.deleteJunction(object.a.getName());
                }
            }
            if (object.d) {
                this._sysmap.deleteNode(resNode2);
                if (object.c != null) {
                    this._sysmap.deleteJunction(object.c.getName());
                }
            }
            return;
        }
        ClientApp.app();
        NameDialog nameDialog = new NameDialog((Frame)ClientApp.frame(), true);
        nameDialog.setName(this._sysmap.getNextDefaultName(0));
        nameDialog.setDescription("");
        nameDialog.setTitle("Name New Reach");
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this._sysmap.getReachNames();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        nameDialog.setExistingNames(vector);
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            if (object.b) {
                this._sysmap.deleteNode(resNode);
                this._sysmap.deleteJunction(object.a.getName());
            }
            if (object.d) {
                this._sysmap.deleteNode(resNode2);
                this._sysmap.deleteJunction(object.c.getName());
            }
            return;
        }
        String string = nameDialog.getName();
        if ((resNode = this._sysmap.createReach(object.a, object.c, resNode, resNode2, string)) == null) {
            return;
        }
        resNode.setDescription(nameDialog.getDescription());
        this._mapPanel.paintMap();
    }

    public ResNode findDownstreamNode(StreamElement streamElement, double d) {
        return this._sysmap.findDownstreamNode(streamElement.getIndex(), d);
    }

    public ResNode findUpstreamNode(StreamElement streamElement, double d) {
        return this._sysmap.findUpstreamNode(streamElement.getIndex(), d);
    }

    public void drawArrow(Graphics graphics, MapScale mapScale, WorldPt worldPt, WorldPt worldPt2) {
        worldPt2 = new WorldPt(worldPt2);
        worldPt2.n = -worldPt2.n;
        int n = mapScale.e2x(worldPt.e);
        int n2 = mapScale.n2y(worldPt.n);
        int n3 = n + (int)(-1.0 * worldPt2.n * 10.0 - worldPt2.e * 20.0 / 2.0);
        int n4 = n2 + (int)(1.0 * worldPt2.e * 10.0 - worldPt2.n * 20.0 / 2.0);
        graphics.drawLine(n3, n4, n += (int)(-1.0 * worldPt2.n * 10.0 + worldPt2.e * 20.0 / 2.0), n2 += (int)(1.0 * worldPt2.e * 10.0 + worldPt2.n * 20.0 / 2.0));
        n = n3 - (int)(-worldPt2.n * 3.0 - worldPt2.e * 5.0);
        n2 = n4 - (int)(worldPt2.e * 3.0 - worldPt2.n * 5.0);
        graphics.drawLine(n3, n4, n, n2);
        n = n3 - (int)(worldPt2.n * 3.0 - worldPt2.e * 5.0);
        n2 = n4 - (int)(-worldPt2.e * 3.0 - worldPt2.n * 5.0);
        graphics.drawLine(n3, n4, n, n2);
    }

    public void drawEndArrow(Graphics graphics, MapScale mapScale, WorldPt worldPt, WorldPt worldPt2, boolean bl, boolean bl2) {
        double d = (double)this._diversionData.diversionWidth * 2.5;
        double d2 = this._diversionData.diversionWidth;
        double cfr_ignored_0 = worldPt2.e;
        double cfr_ignored_1 = worldPt2.n;
        worldPt2 = new WorldPt(worldPt2);
        worldPt2.n = -worldPt2.n;
        int n = mapScale.e2x(worldPt.e);
        int n2 = mapScale.n2y(worldPt.n);
        Polygon polygon = new Polygon();
        if (bl2) {
            graphics.setColor(this._diversionData.conColor);
        } else if (bl) {
            graphics.setColor(Color.yellow);
        }
        int n3 = n + (int)(-worldPt2.n * d2 - worldPt2.e * d);
        int n4 = n2 + (int)(worldPt2.e * d2 - worldPt2.n * d);
        polygon.addPoint(n3, n4);
        polygon.addPoint(n, n2);
        n3 = n + (int)(worldPt2.n * d2 - worldPt2.e * d);
        n4 = n2 + (int)(-worldPt2.e * d2 - worldPt2.n * d);
        polygon.addPoint(n3, n4);
        graphics.fillPolygon(polygon);
        if (bl2 && bl) {
            graphics.setColor(this._diversionData.outlineColor);
        } else if (bl2) {
            graphics.setColor(this._diversionData.outlineColor);
        } else {
            graphics.setColor(this._diversionData.disConColor);
        }
        graphics.drawPolygon(polygon);
    }

    @Deprecated
    public ResNode createReservoirNode(LocalPt localPt, StreamElement streamElement, Vector vector) {
        if (localPt == null) {
            return null;
        }
        streamElement = this.getStreamAlignmentGlyph();
        if (streamElement == null) {
            return null;
        }
        if ((streamElement = streamElement.findReach(localPt, null)) == null) {
            return null;
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ResNode cfr_ignored_0 = (ResNode)vector.elementAt(i);
            }
        }
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        double d = streamElement.getLine().getCoordAtLocation(worldPt);
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        double d2 = this._mapPanel.scale().x2e(localPt.x + (int)((double)this._junctionData.junctionWidth / 2.0)) - this._mapPanel.scale().x2e(localPt.x);
        localPt = this._sysmap.findJunction(worldPt, d2);
        if (localPt != null) {
            if (vector != null && (vector = localPt.getDownstreamNode()) != null) {
                if (vector.getDownstreamElement() != null) {
                    return null;
                }
                return vector;
            }
            worldPt = localPt.getReferencePt();
            d = streamElement.getLine().getCoordAtLocation(worldPt);
        }
        vector = null;
        if (localPt == null && (vector = this.findReservoir(worldPt)) != null) {
            return null;
        }
        if (localPt == null && vector == null && (localPt = this._sysmap.findReach(streamElement.getIndex(), d)) != null) {
            return null;
        }
        localPt = this._sysmap.createNode(streamElement.getLocationByCoord(d));
        localPt.setStreamIndex(streamElement.getIndex());
        localPt.setStreamCoord(d);
        localPt.setStreamStation(streamElement.getStationByCoord(d));
        return localPt;
    }

    public void drawConformingString(Graphics graphics, MapScale mapScale, WorldLine worldLine, String string, double d) {
        int n;
        double d2;
        double d3;
        double d4;
        double d5;
        WorldPt worldPt;
        double d6;
        if (d < 0.0 || d > 1.0) {
            return;
        }
        double d7 = worldLine.getLength();
        Object object = (WorldPt)worldLine.pts.elementAt(0);
        double d8 = mapScale.e2x(object.e + d7) - mapScale.e2x(object.e);
        double d9 = d8 / d7;
        double d10 = 1.0 / d8;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.getAscent();
        fontMetrics.getDescent();
        fontMetrics.getMaxAdvance();
        int n4 = string.length();
        double d11 = (double)(n4 * n2) * d10;
        double d12 = (double)n2 / d9 / 2.0;
        double d13 = (double)n2 * d10 / 2.0;
        double d14 = d12 * 2.0;
        WorldLine worldLine2 = new WorldLine();
        double d15 = d - d11 / 2.0;
        double d16 = d + d11 / 2.0;
        object = new WorldPt();
        WorldPt worldPt2 = new WorldPt();
        worldLine.getSlopeAtCoord(d, object, worldPt2);
        object = new WorldPt(object.e - d14 * 1.0 * worldPt2.n, object.n + d14 * 1.0 * worldPt2.e);
        worldLine2.pts.addElement(object);
        WorldPt worldPt3 = object;
        WorldPt worldPt4 = worldPt2;
        WorldPt worldPt5 = new WorldPt();
        for (d6 = d - d13; d6 >= d15; d6 -= d13) {
            worldPt = worldPt3;
            worldPt3 = worldPt4;
            worldPt3 = new WorldPt(worldPt.e - worldPt3.e * d12, worldPt.n - worldPt3.n * d12);
            d5 = worldLine.getNearestLocation(worldPt3, worldPt5);
            d4 = worldPt3.e - worldPt5.e;
            d3 = worldPt3.n - worldPt5.n;
            worldPt3.init(worldPt5.e + d4 * d14 / d5, worldPt5.n + d3 * d14 / d5);
            worldLine2.pts.insertElementAt(worldPt3, 0);
            d2 = worldLine.getCoordAtLocation(worldPt5);
            worldPt4 = new WorldPt();
            worldLine.getSlopeAtCoord(d2, worldPt5, worldPt4);
        }
        worldPt3 = object;
        worldPt4 = worldPt2;
        for (d6 = d + d13; d6 <= d16; d6 += d13) {
            worldPt = worldPt3;
            worldPt3 = worldPt4;
            worldPt3 = new WorldPt(worldPt.e + worldPt3.e * d12, worldPt.n + worldPt3.n * d12);
            d5 = worldLine.getNearestLocation(worldPt3, worldPt5);
            d4 = worldPt3.e - worldPt5.e;
            d3 = worldPt3.n - worldPt5.n;
            worldPt3.init(worldPt5.e + d4 * d14 / d5, worldPt5.n + d3 * d14 / d5);
            worldLine2.pts.addElement(worldPt3);
            d2 = worldLine.getCoordAtLocation(worldPt5);
            worldPt4 = new WorldPt();
            worldLine.getSlopeAtCoord(d2, worldPt5, worldPt4);
        }
        Color color = this._mapPanel.viewport().getBackground();
        Color color2 = graphics.getColor();
        object = new char[n4 + 1];
        string.getChars(0, n4, (char[])object, 0);
        double cfr_ignored_0 = 1.0 / (double)n4;
        int n5 = 1;
        if (worldLine2.getFirstPt().e > worldLine2.getLastPt().e) {
            n5 = -1;
        }
        worldPt3 = new WorldPt();
        worldPt4 = new WorldPt();
        double d17 = 1.0 / (worldLine2.getLength() * d9);
        d6 = 0.0;
        if (n5 < 0) {
            d6 = 1.0;
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (n = 0; n < n4; ++n) {
            worldLine2.getSlopeAtCoord(d6, worldPt3, worldPt4);
            nArray[n] = mapScale.e2x(worldPt3.e);
            nArray2[n] = mapScale.n2y(worldPt3.n);
            int n6 = fontMetrics.charWidth((char)object[n]) + 1;
            if (Math.abs(worldPt4.n) / Math.abs(worldPt4.e) >= (double)n2 / (double)n6) {
                d6 += (double)(n5 * n3) * d17;
                continue;
            }
            d6 += (double)n5 * (double)n6 / Math.abs(worldPt4.e) * d17;
        }
        d6 = 0.5;
        worldLine2.getSlopeAtCoord(0.5, worldPt3, worldPt4);
        for (n = n4 / 2 - 1; n >= 0; --n) {
            int n7 = fontMetrics.charWidth((char)object[n]) + 1;
            d6 = Math.abs(worldPt4.n) / Math.abs(worldPt4.e) >= (double)n2 / (double)n7 ? (d6 -= (double)(n5 * n3) * d17) : (d6 -= (double)n5 * (double)n7 / Math.abs(worldPt4.e) * d17);
            worldLine2.getSlopeAtCoord(d6, worldPt3, worldPt4);
            nArray[n] = mapScale.e2x(worldPt3.e);
            nArray2[n] = mapScale.n2y(worldPt3.n);
        }
        d6 = 0.5;
        for (n = n4 / 2; n < n4; ++n) {
            worldLine2.getSlopeAtCoord(d6, worldPt3, worldPt4);
            nArray[n] = mapScale.e2x(worldPt3.e);
            nArray2[n] = mapScale.n2y(worldPt3.n);
            int n8 = fontMetrics.charWidth((char)object[n]);
            if (Math.abs(worldPt4.n) / Math.abs(worldPt4.e) >= (double)n2 / (double)n8) {
                d6 += (double)(n5 * n3) * d17;
                continue;
            }
            d6 += (double)n5 * (double)n8 / Math.abs(worldPt4.e) * d17;
        }
        graphics.setColor(color);
        for (n = 0; n < n4; ++n) {
            int n9 = fontMetrics.charWidth((char)object[n]) + 1;
            graphics.fillRect(nArray[n], nArray2[n] - n3, n9, n2);
        }
        graphics.setColor(color2);
        for (n = 0; n < n4; ++n) {
            graphics.drawChars((char[])object, n, 1, nArray[n], nArray2[n]);
        }
    }

    public void setReachData(ResNetworkDPReachData resNetworkDPReachData) {
        this._reachData = resNetworkDPReachData;
    }

    public void setJunctionData(ResNetworkDPJunctionData resNetworkDPJunctionData) {
        this._junctionData = resNetworkDPJunctionData;
    }

    public void setReservoirData(ResNetworkDPReservoirData resNetworkDPReservoirData) {
        this._reservoirData = resNetworkDPReservoirData;
    }

    public void setDiversionData(ResNetworkDPDiversionData resNetworkDPDiversionData) {
        this._diversionData = resNetworkDPDiversionData;
    }

    public ResNetworkDPReachData getReachData() {
        return this._reachData;
    }

    public ResNetworkDPJunctionData getJunctionData() {
        return this._junctionData;
    }

    public ResNetworkDPReservoirData getReservoirData() {
        return this._reservoirData;
    }

    public ResNetworkDPDiversionData getDiversionData() {
        return this._diversionData;
    }

    public JunctionElement moveJunction(JunctionElement junctionElement, WorldPt worldPt, StreamElement streamElement, double d, double d2) {
        if (this._sysmap == null || junctionElement == null) {
            return junctionElement;
        }
        LocalPt localPt = this._mapPanel.scale().wp2lp(worldPt);
        double d3 = this._mapPanel.scale().x2e(localPt.x + 8) - this._mapPanel.scale().x2e(localPt.x);
        if ((worldPt = this._sysmap.findJunction(worldPt, d3)) == null || worldPt == junctionElement) {
            junctionElement.setStreamStation(streamElement, d2);
        } else {
            int n = JOptionPane.showConfirmDialog((Component)ClientApp.frame(), "Connect Junctions " + junctionElement.getName() + " and " + worldPt.getName() + "?", "Connect?", 0, 3);
            if (n == 0) {
                this._selectionVector.removeAllElements();
                MapGlyph.Selection selection = new MapGlyph.Selection((MapGlyph)this, (Object)worldPt, true);
                this._selectionVector.addElement(selection);
                junctionElement.setStreamStation(streamElement, d2);
                worldPt.addJunction(junctionElement);
                worldPt.setStreamStation(streamElement, d2);
                junctionElement = worldPt;
            }
        }
        Vector vector = junctionElement.getConnectedElements();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            streamElement = (Element)vector.elementAt(i);
            if (!(streamElement instanceof ReservoirElement)) continue;
            ((ReservoirElement)streamElement).updateSegments();
        }
        return junctionElement;
    }

    public void createJunction(LocalPt object, StreamElement streamElement) {
        Object object2;
        if (object == null) {
            return;
        }
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return;
        }
        object = this._mapPanel.scale().lp2wp(object);
        double d = streamElement.getStationByLocation((WorldPt)object);
        object = streamElement.getLocationByStation(d);
        streamAlignmentGlyph = this._sysmap.createNode((WorldPt)object);
        streamAlignmentGlyph.setStreamIndex(streamElement.getIndex());
        double d2 = streamElement.getLine().getCoordAtLocation((WorldPt)object);
        streamAlignmentGlyph.setStreamCoord(d2);
        streamAlignmentGlyph.setStreamStation(streamElement.getStationByCoord(d2));
        ClientApp.app();
        object = new NameDialog((Frame)ClientApp.frame(), true);
        int n = this.getNameLengthLimit(2);
        if (n != 0) {
            object2 = new DssPathnamePartDocument();
            object2.setLength(n);
            object.setNameFieldDocument((Document)object2);
        }
        object.setName(this._sysmap.getNextDefaultName(2));
        object.setDescription("");
        object.setTitle("Name New Junction");
        object.setVisible(true);
        if (!object.isCanceled()) {
            object2 = object.getName();
            object = object.getDescription();
            this._sysmap.createJunction(null, (ResNode)streamAlignmentGlyph, 0.0, (String)object2, (String)object);
        }
    }

    public void connectDiversionElement(DiversionElement diversionElement, LocalPt localPt) {
    }

    public void createDiversion(ResNode resNode, ResNode resNode2, Vector vector, int n) {
        Object object;
        if (this._sysmap == null || vector == null) {
            return;
        }
        if (vector.size() <= 0) {
            return;
        }
        new WorldRegion();
        ClientApp.app();
        Object object2 = new NameDialog((Frame)ClientApp.frame(), true);
        int n2 = this.getNameLengthLimit(3);
        if (n2 != 0) {
            object = new DssPathnamePartDocument();
            object.setLength(n2);
            object2.setNameFieldDocument((Document)object);
        }
        object2.setName(this._sysmap.getNextDefaultName(3));
        object2.setDescription("");
        object2.setTitle("Name New Diversion");
        object2.setVisible(true);
        if (!object2.isCanceled()) {
            object = object2.getName();
            object2 = object2.getDescription();
            resNode = this._sysmap.createDiversion(resNode, resNode2, vector, 0.0, (String)object, (String)object2);
            resNode.setInflowType(n);
        }
        this._mapPanel.paintMap();
    }

    public void createDiversion(ResNode resNode, ResNode resNode2, Vector vector, int n, ReservoirElement object) {
        Object object2;
        if (this._sysmap == null || vector == null) {
            return;
        }
        if (vector.size() <= 0) {
            return;
        }
        new WorldRegion();
        ClientApp.app();
        object = new NameDialog((Frame)ClientApp.frame(), true);
        int n2 = this.getNameLengthLimit(3);
        if (n2 != 0) {
            object2 = new DssPathnamePartDocument();
            object2.setLength(n2);
            object.setNameFieldDocument((Document)object2);
        }
        object.setName(this._sysmap.getNextDefaultName(3));
        object.setDescription("");
        object.setTitle("Name New Diversion");
        object.setVisible(true);
        if (!object.isCanceled()) {
            object2 = object.getName();
            object = object.getDescription();
            resNode = this._sysmap.createDiversion(resNode, resNode2, vector, 0.0, (String)object2, (String)object);
            resNode.setInflowType(n);
        }
        this._mapPanel.paintMap();
    }

    public int getNameLengthLimit(int n) {
        return 0;
    }

    public DiversionElement findDiversion(WorldPt worldPt, double d) {
        worldPt = this._sysmap.findDiversion(worldPt, d);
        return worldPt;
    }

    public NamedType getSelectedObject() {
        if (this._selectionVector == null || this._selectionVector.isEmpty()) {
            return null;
        }
        MapGlyph.Selection selection = this._selectionVector.firstElement();
        return (NamedType)selection.object;
    }

    public DiversionElement selectDiversion(LocalPt localPt, boolean bl, boolean bl2) {
        double d;
        if (!bl) {
            this._selectionVector.removeAllElements();
        }
        if (this._sysmap == null || localPt == null) {
            return null;
        }
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        localPt = this.findDiversion(worldPt, d = this._mapPanel.scale().x2e(localPt.x + 5) - this._mapPanel.scale().x2e(localPt.x));
        if (localPt != null) {
            worldPt = new MapGlyph.Selection((MapGlyph)this, (Object)localPt, bl2);
            if (!this._selectionVector.contains(worldPt)) {
                this._selectionVector.addElement((MapGlyph.Selection)worldPt);
            }
            if (bl) {
                Graphics graphics = this._mapPanel.viewport().getGraphics();
                this.drawSelectedDiversion(graphics, this._mapPanel.scale(), (DiversionElement)localPt, false, bl2);
                graphics.dispose();
            } else {
                this._mapPanel.paintMap();
            }
        } else if (!bl) {
            this._mapPanel.paintMap();
        }
        return localPt;
    }

    public void drawSelectedDiversion(Graphics graphics, MapScale mapScale, DiversionElement diversionElement, boolean bl, boolean bl2) {
        if (diversionElement == null) {
            return;
        }
        WorldLine worldLine = diversionElement.getLine();
        Object object = diversionElement.getUpstreamNode();
        ResNode resNode = diversionElement.getDownstreamNode();
        if (object == null) {
            return;
        }
        if (worldLine != null) {
            double worldPt = (double)this._diversionData.diversionWidth / 1.5;
            if (object != null) {
                worldLine.getFirstPt().init(object.getLocation());
            }
            if (resNode != null) {
                worldLine.getLastPt().init(resNode.getLocation());
            }
            object = new int[worldLine.pts.size() << 1];
            int[] nArray = new int[worldLine.pts.size() << 1];
            int n = worldLine.getLocalRegionArrays(mapScale, (int[])object, nArray, worldPt);
            if (bl) {
                graphics.setXORMode(new Color(255, 255, 255));
            } else {
                graphics.setColor(diversionElement.getLineColor());
            }
            if (n > 0) {
                graphics.setColor(Color.yellow);
                graphics.fillPolygon((int[])object, nArray, n);
                graphics.setColor(Color.yellow);
                graphics.drawPolygon((int[])object, nArray, n);
                if (this._diversionData.drawName) {
                    graphics.getFont();
                    this.drawConformingString(graphics, mapScale, diversionElement.getLine(), diversionElement.getName(), 0.5, (int)worldPt, this._diversionData.nameFont, this._diversionData.fillColor, 1, (float)this._glyphLevel + 0.35f);
                }
            }
            object = new int[4];
            nArray = new int[4];
            if (bl2) {
                graphics.setColor(Color.black);
                int n2 = (int)((double)this._diversionData.diversionWidth / 1.5);
                for (n = 0; n < worldLine.pts.size(); ++n) {
                    diversionElement = (WorldPt)worldLine.pts.elementAt(n);
                    diversionElement = this._mapPanel.scale().wp2lp((WorldPt)diversionElement);
                    object[0] = (ResNode)(diversionElement.x - n2);
                    nArray[0] = diversionElement.y;
                    object[1] = (ResNode)diversionElement.x;
                    nArray[1] = diversionElement.y + n2;
                    object[2] = (ResNode)(diversionElement.x + n2);
                    nArray[2] = diversionElement.y;
                    object[3] = (ResNode)diversionElement.x;
                    nArray[3] = diversionElement.y - n2;
                    graphics.fillPolygon((int[])object, nArray, 4);
                }
            }
        }
        WorldPt worldPt = new WorldPt();
        WorldPt worldPt2 = new WorldPt();
        worldLine.getSlopeAtCoord(1.0, worldPt, worldPt2);
        this.drawEndArrow(graphics, mapScale, worldLine.getLastPt(), worldPt2, true, resNode != null);
        if (bl) {
            graphics.setPaintMode();
        }
    }

    public void drawDiversion(Graphics graphics, MapScale mapScale, DiversionElement diversionElement) {
        int[] nArray;
        int[] nArray2;
        int n;
        ResNode resNode = diversionElement.getUpstreamNode();
        ResNode resNode2 = diversionElement.getDownstreamNode();
        WorldLine worldLine = diversionElement.getLine();
        if (worldLine == null) {
            System.out.println("drawDiversion: no world line for diversion " + diversionElement.getName());
            return;
        }
        if (worldLine.getFirstPt() == null || worldLine.getLastPt() == null) {
            System.out.println("drawDiversion: invalid world line for diversion " + diversionElement.getName());
            return;
        }
        double d = (double)this._diversionData.diversionWidth / 1.5;
        if (resNode != null) {
            worldLine.getFirstPt().init(resNode.getLocation());
        }
        if (resNode2 != null) {
            worldLine.getLastPt().init(resNode2.getLocation());
        }
        if ((n = worldLine.getLocalRegionArrays(mapScale, nArray2 = new int[worldLine.pts.size() << 1], nArray = new int[worldLine.pts.size() << 1], d)) > 0) {
            graphics.setPaintMode();
            graphics.setColor(this._diversionData.fillColor);
            graphics.fillPolygon(nArray2, nArray, n);
            if (this._diversionData.drawName) {
                graphics.getFont();
                this.drawConformingString(graphics, mapScale, diversionElement.getLine(), diversionElement.getName(), 0.5, (int)d, this._diversionData.nameFont, this._diversionData.fillColor, 1, (float)this._glyphLevel + 0.35f);
            }
        }
        resNode.getLocation();
        diversionElement = new WorldPt();
        resNode = new WorldPt();
        worldLine.getSlopeAtCoord(1.0, (WorldPt)diversionElement, (WorldPt)resNode);
        if (resNode2 != null) {
            graphics.setColor(this._diversionData.conColor);
        } else {
            graphics.setColor(this._diversionData.disConColor);
        }
        this.drawEndArrow(graphics, mapScale, worldLine.getLastPt(), (WorldPt)resNode, false, resNode2 != null);
    }

    public ResNode createDiversionNode(LocalPt localPt, ResNode resNode) {
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return null;
        }
        if ((streamAlignmentGlyph = streamAlignmentGlyph.findReach(localPt, null)) == null) {
            return null;
        }
        double d = streamAlignmentGlyph.getLine().getCoordAtLocation(worldPt);
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        double d2 = this._mapPanel.scale().x2e(localPt.x + (int)((double)this._junctionData.junctionWidth / 2.0)) - this._mapPanel.scale().x2e(localPt.x);
        JunctionElement junctionElement = this._sysmap.findJunction(worldPt, d2);
        if (junctionElement != null) {
            ResNode resNode2 = junctionElement.getDownstreamNode();
            if (resNode2 != null) {
                localPt = this._sysmap.createNode(worldPt);
                localPt.setLocation(resNode2.getLocation());
                localPt.setStreamStation(resNode2.getStreamStation());
                localPt.setStream(resNode2.getStream());
                localPt.setStreamIndex(resNode2.getStreamIndex());
                localPt.setStreamCoord(resNode2.getStreamCoord());
                if (resNode == null) {
                    junctionElement.addNode((ResNode)localPt, 0);
                } else {
                    junctionElement.addNode((ResNode)localPt, 1);
                }
                return localPt;
            }
            worldPt = junctionElement.getReferencePt();
            streamAlignmentGlyph.getLine().getCoordAtLocation(worldPt);
        }
        return null;
    }

    public ResNode createDivOutletNode(LocalPt localPt, ResNode resNode) {
        WorldPt worldPt = this._mapPanel.scale().lp2wp(localPt);
        ReservoirElement reservoirElement = null;
        StreamAlignmentGlyph streamAlignmentGlyph = this.getStreamAlignmentGlyph();
        if (streamAlignmentGlyph == null) {
            return null;
        }
        if ((streamAlignmentGlyph = streamAlignmentGlyph.findReach(localPt, null)) == null) {
            return null;
        }
        double d = streamAlignmentGlyph.getLine().getCoordAtLocation(worldPt);
        if (d == Double.NEGATIVE_INFINITY) {
            return null;
        }
        double d2 = this._mapPanel.scale().x2e(localPt.x + (int)((double)this._junctionData.junctionWidth / 2.0)) - this._mapPanel.scale().x2e(localPt.x);
        if (resNode != null) {
            resNode = this._sysmap.findJunction(worldPt, d2);
            if (resNode != null) {
                ResNode resNode2 = resNode.getDownstreamNode();
                if (resNode2 != null) {
                    localPt = this._sysmap.createNode(worldPt);
                    localPt.setLocation(resNode2.getLocation());
                    localPt.setStreamStation(resNode2.getStreamStation());
                    localPt.setStream(resNode2.getStream());
                    localPt.setStreamIndex(resNode2.getStreamIndex());
                    localPt.setStreamCoord(resNode2.getStreamCoord());
                    resNode.addNode((ResNode)localPt, 1);
                    return localPt;
                }
                worldPt = resNode.getReferencePt();
                streamAlignmentGlyph.getLine().getCoordAtLocation(worldPt);
            }
        } else {
            reservoirElement = this.findReservoir(worldPt);
        }
        if (reservoirElement != null) {
            localPt = this._sysmap.createNode(worldPt);
            localPt.setStreamIndex(streamAlignmentGlyph.getIndex());
            localPt.setStreamCoord(d);
            localPt.setStreamStation(streamAlignmentGlyph.getStationByCoord(d));
            reservoirElement.addNode((ResNode)localPt, 0);
            return localPt;
        }
        return null;
    }

    public ModelDrawingAttributeSet getAttributeSet() {
        return this._rssDas;
    }

    public String getToolTipText(WorldPt worldPt, MouseEvent mouseEvent) {
        if (this._sysmap == null || worldPt == null) {
            return null;
        }
        if ((worldPt = this.findObject(worldPt)) == null) {
            return null;
        }
        if (worldPt instanceof ReservoirElement) {
            return "Reservoir: " + worldPt.getName();
        }
        if (worldPt instanceof ReachElement) {
            return "<html>Reach: " + worldPt.getName() + "<br>Status: " + (((Element)worldPt).isActive() ? " Active" : " <font=+0 color=red>Inactive</font>") + "</html>";
        }
        if (worldPt instanceof JunctionElement) {
            return "Junction: " + worldPt.getName();
        }
        if (worldPt instanceof DiversionElement) {
            return "Diversion: " + worldPt.getName();
        }
        return null;
    }

    protected StreamAlignmentGlyph getStreamAlignmentGlyph() {
        return (StreamAlignmentGlyph)this._mapPanel.findGlyphOfClass(StreamAlignmentGlyph.class.getName());
    }

    public void setParentGlyph(MapGlyph mapGlyph) {
        this._parentGlyph = mapGlyph;
    }
}

