/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.rss.client.AbstractAlternativeEditor$1;
import hec.rss.client.AbstractAlternativeEditor$2;
import hec.rss.client.AbstractAlternativeEditor$3;
import hec.rss.client.AbstractAlternativeEditor$4;
import hec.rss.client.AbstractAlternativeEditor$AlternativeTableModel;
import hec.watershed.client.NameDescriptionPanel;
import hec.watershed.model.Condition;
import hec.watershed.model.ModelAlt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.ComboBoxModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public abstract class AbstractAlternativeEditor
extends RmaJDialog
implements ChangeListener,
ListSelectionListener {
    protected static final String a = "None";
    protected ReflectMultiListener m_rml = new ReflectMultiListener();
    protected JMenuItem m_newMenuItem;
    protected JMenuItem m_saveMenuItem;
    protected JMenuItem m_saveAsMenuItem;
    protected JMenuItem m_deleteMenuItem;
    protected JMenu _altMenu;
    protected boolean m_newAlt;
    protected boolean DEBUG = Boolean.getBoolean("AlternativeEditor.DEBUG");
    protected Vector m_alternativeList = new Vector();
    protected Hashtable m_modelAltTable = new Hashtable();
    protected RmiFileCallBackImpl[] m_callback = new RmiFileCallBackImpl[1];
    protected ManagerProxyListContainer _wksp;
    protected JPanel groupPanel = new JPanel(new GridBagLayout());
    protected GridBagConstraints _groupPanelGbc;
    protected NameDescriptionPanel nameDescriptionPanel = new NameDescriptionPanel(8L);
    protected RmaJTextField modelAltIdTxt = new RmaJTextField();
    protected JTabbedPane tabPane = new AbstractAlternativeEditor$1(this);
    protected RmaJLabel configurationLabel = new RmaJLabel("Configuration:");
    protected RmaJComboBox configurationComboBox = new RmaJComboBox((ComboBoxModel)new RmaListModel(true));
    protected RmaJComboBox systemComboBox = new AbstractAlternativeEditor$2(this, (ComboBoxModel)new RmaListModel(true));
    protected RmaJLabel systemLabel = new RmaJLabel("Reservoir Network");
    protected RmaJTable alternativeTable;
    protected boolean _okToClearForm;
    protected Pattern _pattern;
    protected JSplitPane _splitter;

    protected Condition getConfiguration(Long l) {
        for (int i = 0; i < this.configurationComboBox.getItemCount(); ++i) {
            Condition condition = (Condition)this.configurationComboBox.getItemAt(i);
            if (condition.getId() != l.longValue()) continue;
            return condition;
        }
        return null;
    }

    public AbstractAlternativeEditor(Frame frame, boolean bl) {
        super(frame, bl);
        AbstractAlternativeEditor abstractAlternativeEditor = this;
        this.alternativeTable = new AbstractAlternativeEditor$3(abstractAlternativeEditor, (Component)((Object)abstractAlternativeEditor));
        this._okToClearForm = true;
        this.buildControls();
    }

    public AbstractAlternativeEditor(Dialog dialog, boolean bl) {
        super(dialog, bl);
        AbstractAlternativeEditor abstractAlternativeEditor = this;
        this.alternativeTable = new AbstractAlternativeEditor$3(abstractAlternativeEditor, (Component)((Object)abstractAlternativeEditor));
        this._okToClearForm = true;
        this.buildControls();
    }

    protected void buildControls() {
        JMenu jMenu;
        Serializable serializable = new JMenuBar();
        this.setJMenuBar((JMenuBar)serializable);
        this._altMenu = jMenu = new JMenu("Alternative");
        jMenu.setMnemonic('A');
        this.m_newMenuItem = new JMenuItem("New...", 110);
        this.m_newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        jMenu.add(this.m_newMenuItem);
        AbstractAlternativeEditor abstractAlternativeEditor = this;
        this.m_newMenuItem.addActionListener((ActionListener)this.m_rml.add((Object)abstractAlternativeEditor, (Object)abstractAlternativeEditor.m_newMenuItem, "menuItemNew_Action"));
        this.m_saveMenuItem = new JMenuItem("Save", 115);
        this.m_saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        AbstractAlternativeEditor abstractAlternativeEditor2 = this;
        this.m_saveMenuItem.addActionListener((ActionListener)this.m_rml.add((Object)abstractAlternativeEditor2, (Object)abstractAlternativeEditor2.m_saveMenuItem, "menuItemSave_Action"));
        jMenu.add(this.m_saveMenuItem);
        this.m_saveAsMenuItem = new JMenuItem("Save As...", 97);
        AbstractAlternativeEditor abstractAlternativeEditor3 = this;
        this.m_saveAsMenuItem.addActionListener((ActionListener)this.m_rml.add((Object)abstractAlternativeEditor3, (Object)abstractAlternativeEditor3.m_saveAsMenuItem, "menuItemSaveAs_Action"));
        jMenu.add(this.m_saveAsMenuItem);
        this.m_deleteMenuItem = new JMenuItem("Delete", 100);
        this.m_deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2, false));
        AbstractAlternativeEditor abstractAlternativeEditor4 = this;
        this.m_deleteMenuItem.addActionListener((ActionListener)this.m_rml.add((Object)abstractAlternativeEditor4, (Object)abstractAlternativeEditor4.m_deleteMenuItem, "menuItemDelete_Action"));
        this.m_deleteMenuItem.setEnabled(false);
        jMenu.add(this.m_deleteMenuItem);
        jMenu.addSeparator();
        this.addApplicationMenus(jMenu);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Close", 99);
        jMenuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)jMenuItem, "menuItemExit_Action"));
        jMenu.add(jMenuItem);
        ((JMenuBar)serializable).add(jMenu);
        this.getContentPane().setLayout(new GridBagLayout());
        this.alternativeTable.setModel((TableModel)((Object)this.getTableModel()));
        this.alternativeTable.setCellRenderer();
        this.alternativeTable.getSelectionModel().setSelectionMode(0);
        this.alternativeTable.setCellSelectionEnabled(false);
        this.alternativeTable.setColumnSelectionAllowed(false);
        this.alternativeTable.setRowSelectionAllowed(true);
        this.alternativeTable.setAddRemoveEnabled(false);
        this.alternativeTable.getSelectionModel().addListSelectionListener(this);
        this.groupPanel.add((Component)this.configurationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
        this.groupPanel.add((Component)this.configurationComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        serializable = this.alternativeTable.getScrollPane().getSize();
        this.alternativeTable.getScrollPane().getSize().height = 100;
        this.alternativeTable.getScrollPane().setMinimumSize((Dimension)serializable);
        this.groupPanel.add((Component)this.alternativeTable.getScrollPane(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, RmaInsets.insets((int)5, (int)5, (int)5, (int)5), 0, 0));
        this._groupPanelGbc = new GridBagConstraints(0, 0, 2, 1, 1.0, 2.0, 18, 1, RmaInsets.insets((int)0, (int)0, (int)0, (int)0), 0, 0);
        serializable = new JPanel(new GridBagLayout());
        ((Container)serializable).add((Component)this.nameDescriptionPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        ((Container)serializable).add((Component)this.systemLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)5, (int)10, (int)0, (int)0), 0, 0));
        ((Container)serializable).add((Component)this.systemComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        ((Container)serializable).add(this.tabPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 3.0, 16, 1, RmaInsets.insets((int)5, (int)5, (int)5, (int)5), 0, 0));
        this._splitter = new JSplitPane(0, this.groupPanel, (Component)serializable);
        this._splitter.setResizeWeight(0.2);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._splitter, serializable);
        this.nameDescriptionPanel.setNameEditable(false);
        AbstractAlternativeEditor abstractAlternativeEditor5 = this;
        this.systemComboBox.addItemListener((ItemListener)this.m_rml.add((Object)abstractAlternativeEditor5, (Object)abstractAlternativeEditor5.systemComboBox, "systemComboBoxChanged"));
        AbstractAlternativeEditor abstractAlternativeEditor6 = this;
        this.configurationComboBox.addItemListener((ItemListener)this.m_rml.add((Object)abstractAlternativeEditor6, (Object)abstractAlternativeEditor6.configurationComboBox, "configurationComboBoxChanged"));
        this.systemComboBox.setEnabled(false);
    }

    protected void addApplicationMenus(JMenu jMenu) {
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        this.m_saveMenuItem.setEnabled(bl);
    }

    protected boolean isUniqueAltName(String string) {
        if (this.m_alternativeList != null) {
            for (int i = 0; i < this.m_alternativeList.size(); ++i) {
                NamedType namedType = (NamedType)this.m_alternativeList.get(i);
                if (namedType == null || !string.equalsIgnoreCase(namedType.getName())) continue;
                return false;
            }
        }
        return true;
    }

    public ManagerProxyListContainer getWorkspace() {
        return this._wksp;
    }

    protected void menuItemSave_Action() {
        if (!this.saveForm()) {
            return;
        }
        this.setModified(false);
    }

    protected abstract void menuItemNew_Action();

    protected abstract void menuItemSaveAs_Action();

    protected abstract void menuItemDelete_Action();

    protected abstract boolean saveForm();

    protected abstract boolean hasAlternative();

    protected abstract void systemComboBoxChanged();

    protected abstract void configurationComboBoxChanged();

    public void menuItemExit_Action() {
        if (this.isModified() && this.hasAlternative()) {
            int n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Data Has Changed!\nWould you like to save?");
            if (n == 0) {
                if (!this.saveForm()) {
                    return;
                }
            } else {
                if (n == 2) {
                    return;
                }
                this.m_newAlt = false;
            }
        }
        this.setModified(false);
        this.setVisible(false);
    }

    public boolean isValidName(String string) {
        if (string == null || string.length() == 0) {
            RMAIO.postError((Component)((Object)this), (String)"The Name entered is invalid!\nPlease use 1 or more characters for the Alternative name.");
            return false;
        }
        string.trim();
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        block11: {
            block12: {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (!this.isModified() || !this.hasAlternative()) break block11;
                if (!this.systemComboBox.isEnabled()) break block12;
                int n = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Data Has Changed!\nWould you like to save?");
                switch (n) {
                    case 0: {
                        if (!this.saveForm()) {
                            return;
                        }
                        break block11;
                    }
                    case 1: {
                        this.m_newAlt = false;
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
                break block11;
            }
            int n = RMAIO.postYesNoWarning((Component)((Object)this), (String)"Data Has Changed!\nWould you like to save?");
            if (n == 0 && !this.saveForm()) {
                return;
            }
        }
        this.setDefaultState();
        int n = this.alternativeTable.getSelectedRow();
        if (n >= 0) {
            Manager manager;
            RowSorter rowSorter = this.alternativeTable.getRowSorter();
            if (rowSorter != null) {
                n = rowSorter.convertRowIndexToModel(n);
            }
            if ((manager = ((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).getAlternativeAt(n)) != null) {
                this.fillForm(manager);
                this.m_newAlt = false;
            }
            return;
        }
        this.clearForm();
        this.setFormEnabled(false);
    }

    protected void setDefaultState() {
        this.setFormEnabled(false);
        this.m_newAlt = false;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.m_deleteMenuItem.isEnabled();
        super.setEditable(bl);
        if (!bl) {
            this.m_deleteMenuItem.setEnabled(false);
        } else {
            this.m_deleteMenuItem.setEnabled(bl2);
        }
        this.alternativeTable.setIsEditable(true);
        this.nameDescriptionPanel.setNameEditable(false);
    }

    protected void initializeForm() {
        this.setDefaultState();
    }

    public void clearForm() {
        this.nameDescriptionPanel.setName("");
        this.nameDescriptionPanel.setDescription("");
    }

    protected abstract void fillForm(Manager var1);

    protected ModelAlt getModelAlt(Identifier identifier, String string) {
        if (identifier == null || identifier.getPath() == null) {
            return null;
        }
        Object object = (ModelAlt)this.m_modelAltTable.get(identifier.getPath());
        if (object == null) {
            object = RMAIO.getFileNameNoExtension((String)identifier.getPath());
            String string2 = RMAIO.getDirectoryFromPath((String)identifier.getPath());
            string2 = string2.concat("/").concat((String)object).concat(".malt");
            object = new Identifier(string2);
            if ((object = (ModelAlt)this._wksp.openManager(string, (Identifier)object)) != null) {
                this.m_modelAltTable.put(identifier.getPath(), object);
            }
        }
        return object;
    }

    protected void setFormEnabled(boolean bl) {
        this.m_deleteMenuItem.setEnabled(bl);
        this.systemComboBox.setForeground(Color.black);
        this.tabPane.setEnabled(this.hasAlternative());
        this.configurationComboBox.setEnabled(!this.m_newAlt);
    }

    public void setSelectedAlternative(String string) {
        int n;
        Object object;
        int n2;
        if (string == null) {
            this.alternativeTable.getScrollPane().setVisible(true);
            this.configurationComboBox.setVisible(true);
            this.configurationLabel.setVisible(true);
            this.groupPanel.setVisible(true);
            return;
        }
        boolean bl = false;
        for (n2 = 0; n2 < this.configurationComboBox.getItemCount(); ++n2) {
            object = (Condition)this.configurationComboBox.getItemAt(n2);
            if (!object.isStudyCondition()) continue;
            this.configurationComboBox.setSelectedIndex(n2);
            bl = true;
            break;
        }
        if (!bl) {
            this.configurationComboBox.setSelectedIndex(this.configurationComboBox.getItemCount() - 1);
        }
        this.configurationComboBox.setVisible(false);
        this.configurationLabel.setVisible(false);
        this.groupPanel.setVisible(false);
        n2 = this.alternativeTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            Manager manager = ((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).getAlternativeAt(n);
            object = this.alternativeTable.getCell(n, 0);
            if (!string.equals(manager.getName()) && !string.equals(object)) continue;
            System.out.println("setSelectedAlternative:found alternative (" + String.valueOf(object) + ") match at row " + n);
            int n3 = n;
            SwingUtilities.invokeLater(new AbstractAlternativeEditor$4(this, n3));
            return;
        }
        System.out.println("setSelectedAlternative: Can't find alternative (" + string + ")");
        System.out.println("setSelectedAlternative: Selected Configuration is " + String.valueOf(this.configurationComboBox.getSelectedItem()));
        System.out.println("setSelectedAlternative: Available alternatives are:");
        for (n = 0; n < this.alternativeTable.getRowCount(); ++n) {
            System.out.println("\t" + String.valueOf(this.alternativeTable.getValueAt(n, 0)));
        }
    }

    public String getPaddedName(String string) {
        if (string.length() < 10) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = string.length(); i < 10; ++i) {
                stringBuffer.append("-");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    protected SimulationRun getSimRun(String string, String string2, String string3) {
        Object object;
        String string4;
        if (this._wksp instanceof ClientWorkspace) {
            string4 = this.getPaddedName(string);
            object = ((ClientWorkspace)this._wksp).getManagerIdentifier(string2, string3, string4, ".simrun");
        } else if (this._wksp instanceof SimulationPeriod) {
            int n = string.indexOf(":");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (string.length() > 10) {
                string = string.substring(0, 10);
            }
            object = RMAIO.userNameToFileName((String)string.trim());
            string4 = "/";
            String string5 = ".simrun";
            object = ((SimulationPeriod)this._wksp).getSimulationPath() + string4 + string2 + string4 + (String)object + (String)(string5.length() > 0 && string5.charAt(0) == '.' ? string5 : "." + string5);
            object = new Identifier((String)object);
            object.setName(string);
            object.setClassName(string3);
        } else {
            return null;
        }
        string4 = null;
        if (object != null) {
            string4 = (SimulationRun)this._wksp.openManager(string2, object);
        }
        return string4;
    }

    protected AbstractAlternativeEditor$AlternativeTableModel getTableModel() {
        return new AbstractAlternativeEditor$AlternativeTableModel(this);
    }

    protected boolean isValidID(String string) {
        return string != null && string.length() > 0;
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            Enumeration enumeration = this.m_modelAltTable.elements();
            while (enumeration.hasMoreElements()) {
                this._wksp.unloadManager(ClientApp.app().getAppType(), ((ModelAlt)enumeration.nextElement()).getIdentifier());
            }
            this.m_modelAltTable.clear();
        }
        super.setVisible(bl);
    }

    protected boolean allowsNoConfiguration() {
        return false;
    }

    protected List filterIdVector(List list) {
        if (this._pattern == null) {
            return list;
        }
        ArrayList<Identifier> arrayList = new ArrayList<Identifier>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Identifier identifier = (Identifier)list.get(i);
            if (!this.passesFilter(identifier.getName())) continue;
            arrayList.add(identifier);
        }
        return arrayList;
    }

    protected boolean passesFilter(String string) {
        if (this._pattern == null) {
            return true;
        }
        return this._pattern.matcher(string).matches();
    }
}

