/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.model.TSRecordProxy;
import hec.model.ModelVariable;
import hec.model.TSLocation;
import hec.rss.client.AbstractModelVariablePanel$1;
import hec.rss.client.AbstractModelVariablePanel$2;
import hec.rss.client.AbstractModelVariablePanel$3;
import hec.rss.client.AbstractModelVariablePanel$4;
import hec.rss.client.AbstractModelVariablePanel$5;
import hec.rss.client.AbstractModelVariablePanel$TableModel;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableSorter;

public abstract class AbstractModelVariablePanel
extends JPanel {
    protected String[] COLNAMES = new String[]{"Time-Series", "Element Type", "Variable"};
    protected RmaJComboBox _nameFilterCombo;
    protected RmaJComboBox _typeFilterCombo;
    protected RmaJComboBox _variableFilterCombo;
    protected RmaJTable _elementTable;
    protected RmaTableSorter _sorter;
    protected AbstractModelVariablePanel$TableModel _tableModel;
    protected AbstractModelVariablePanel$TableModel _currentTableModel;
    protected ActionListener _al;
    protected ItemListener _il;
    protected Element _selectedElement;
    protected ModelVariable _selectedModelVariable;
    protected TSRecordProxy _selectedTSProxy;
    protected RssSystem _network;
    protected static Hashtable a = new Hashtable();

    public AbstractModelVariablePanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        Object object = new JLabel("Filter");
        ((JLabel)object).setDisplayedMnemonic('F');
        Cloneable cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 0;
        cloneable.gridwidth = 1;
        cloneable.anchor = 18;
        cloneable.fill = 0;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)object, cloneable);
        JPanel jPanel = new JPanel(new GridBagLayout());
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 1;
        cloneable.weightx = 1.0;
        cloneable.gridwidth = 3;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add((Component)jPanel, cloneable);
        this._nameFilterCombo = new RmaJComboBox();
        this._nameFilterCombo.setEditable(true);
        ((JLabel)object).setLabelFor((Component)this._nameFilterCombo);
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 0;
        cloneable.gridwidth = 1;
        cloneable.weightx = 1.0;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._nameFilterCombo, cloneable);
        this._typeFilterCombo = new RmaJComboBox();
        this._typeFilterCombo.setEditable(true);
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        cloneable.gridy = 0;
        cloneable.gridwidth = 1;
        cloneable.weightx = 1.0;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._typeFilterCombo, cloneable);
        this._variableFilterCombo = new RmaJComboBox();
        this._variableFilterCombo.setEditable(true);
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        cloneable.gridy = 0;
        cloneable.gridwidth = 1;
        cloneable.weightx = 1.0;
        cloneable.anchor = 18;
        cloneable.fill = 2;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._variableFilterCombo, cloneable);
        AbstractModelVariablePanel abstractModelVariablePanel = this;
        this._elementTable = new AbstractModelVariablePanel$1(abstractModelVariablePanel, abstractModelVariablePanel);
        this._tableModel = new AbstractModelVariablePanel$TableModel(this);
        this._tableModel.getDataVector().clear();
        this._currentTableModel = this._tableModel;
        this._elementTable.setModel((TableModel)((Object)this._tableModel));
        this._elementTable.setEditable(false);
        this._elementTable.setAddRemoveEnabled(false);
        this._elementTable.setSelectionMode(0);
        this._elementTable.setColumnSelectionAllowed(false);
        this._elementTable.setCellSelectionEnabled(false);
        this._elementTable.setRowSelectionAllowed(true);
        this._sorter = new RmaTableSorter(this._elementTable.getModel());
        this._elementTable.setModel((TableModel)this._sorter);
        this._sorter.addMouseListenerToHeaderInTable((JTable)this._elementTable);
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        cloneable.gridy = 3;
        cloneable.gridwidth = 3;
        cloneable.weightx = 1.0;
        cloneable.weighty = 1.0;
        cloneable.anchor = 18;
        cloneable.fill = 1;
        cloneable.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        AbstractModelVariablePanel abstractModelVariablePanel2 = this;
        abstractModelVariablePanel2.add((Component)abstractModelVariablePanel2._elementTable.getScrollPane(), cloneable);
        object = new AbstractModelVariablePanel$2(this);
        cloneable = new AbstractModelVariablePanel$3(this);
        this._nameFilterCombo.getActionMap().put("filter", (Action)((Object)cloneable));
        this._nameFilterCombo.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "filter");
        this._typeFilterCombo.getActionMap().put("filter", (Action)((Object)cloneable));
        this._typeFilterCombo.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "filter");
        this._variableFilterCombo.getActionMap().put("filter", (Action)((Object)cloneable));
        this._variableFilterCombo.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "filter");
        this._al = new AbstractModelVariablePanel$4(this);
        this._il = new AbstractModelVariablePanel$5(this);
        this._nameFilterCombo.addFocusListener((FocusListener)object);
        this._typeFilterCombo.addFocusListener((FocusListener)object);
        this._variableFilterCombo.addFocusListener((FocusListener)object);
        this._nameFilterCombo.addActionListener(this._al);
        this._typeFilterCombo.addActionListener(this._al);
        this._variableFilterCombo.addActionListener(this._al);
        this._nameFilterCombo.addItemListener(this._il);
        this._typeFilterCombo.addItemListener(this._il);
        this._variableFilterCombo.addItemListener(this._il);
    }

    void filterTable(Object object) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (object == this._nameFilterCombo) {
            object = this._nameFilterCombo.getSelectedItem();
            if (object != null) {
                string = object.toString();
            }
            string2 = (String)this._typeFilterCombo.getSelectedItem();
            string3 = (String)this._variableFilterCombo.getSelectedItem();
        } else if (object == this._typeFilterCombo) {
            object = this._typeFilterCombo.getSelectedItem();
            if (object != null) {
                string2 = object.toString();
            }
            string3 = (String)this._variableFilterCombo.getSelectedItem();
            string = (String)this._nameFilterCombo.getSelectedItem();
        } else if (object == this._variableFilterCombo) {
            object = this._variableFilterCombo.getSelectedItem();
            if (object != null) {
                string3 = object.toString();
            }
            string = (String)this._nameFilterCombo.getSelectedItem();
            string2 = (String)this._typeFilterCombo.getSelectedItem();
        }
        this.fillForm(string, string2, string3);
    }

    protected void clearPanel() {
        this._elementTable.deleteCells();
        this._nameFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
        this._typeFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
        this._variableFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
        this._selectedElement = null;
        this._selectedTSProxy = null;
        this._selectedModelVariable = null;
    }

    public void setSelectedElement(Element element) {
        this._selectedElement = element;
        if (this._selectedElement == null) {
            this._nameFilterCombo.setSelectedItem((Object)"");
            this._typeFilterCombo.setSelectedItem((Object)"");
            return;
        }
        this._nameFilterCombo.setSelectedItem((Object)element.getFullName());
        this._typeFilterCombo.setSelectedItem((Object)element.getElementType());
    }

    public void setSelectedTSProxy(TSRecordProxy tSRecordProxy, Element element) {
        this._selectedTSProxy = tSRecordProxy;
        this._selectedElement = element;
        if (this._selectedTSProxy == null || element == null) {
            this._nameFilterCombo.setSelectedItem((Object)"");
            this._typeFilterCombo.setSelectedItem((Object)"");
            return;
        }
        this._nameFilterCombo.setSelectedItem((Object)this._network.getNameForKeyString(tSRecordProxy.getName()));
        this._typeFilterCombo.setSelectedItem((Object)element.getElementType());
    }

    public void setSelectedModelVariable(ModelVariable modelVariable) {
        this._selectedModelVariable = modelVariable;
        if (this._selectedModelVariable != null) {
            this._variableFilterCombo.setSelectedItem((Object)this._selectedModelVariable.toString());
            return;
        }
        this._variableFilterCombo.setSelectedItem((Object)"");
    }

    public Element getSelectedElement() {
        return this._selectedElement;
    }

    public TSRecordProxy getSelectedTSProxy() {
        return this._selectedTSProxy;
    }

    public ModelVariable getSelectedModelVariable() {
        return this._selectedModelVariable;
    }

    public void setNetwork(RssSystem rssSystem) {
        this._network = rssSystem;
        this.fillForm("", "", "");
    }

    void setElement(Element element) {
        if (element == null) {
            this._nameFilterCombo.setSelectedItem((Object)"");
        } else {
            this._nameFilterCombo.setSelectedItem((Object)element.getFullName());
        }
        this._typeFilterCombo.setSelectedItem((Object)"");
        this._variableFilterCombo.setSelectedItem((Object)"");
    }

    private String getFilterString(String string) {
        if (string != null) {
            return string.toLowerCase();
        }
        return "";
    }

    protected Element getElementForTSProxy(TSRecordProxy object) {
        if (object == null) {
            return null;
        }
        TSLocation tSLocation = object.getParent();
        if (tSLocation == null) {
            return null;
        }
        if (tSLocation instanceof Element) {
            object = (Element)tSLocation;
        } else if (tSLocation instanceof Function) {
            object = ((Function)tSLocation).getElement();
        } else {
            if (tSLocation instanceof RssNode) {
                object = ((RssNode)tSLocation).getUpstreamElement();
                if (object != null && ((Element)object).isNodeComputed((RssNode)tSLocation)) {
                    return object;
                }
                object = ((RssNode)tSLocation).getDownstreamElement();
                if (object != null && ((Element)object).isNodeComputed((RssNode)tSLocation)) {
                    return object;
                }
                return null;
            }
            object = null;
        }
        return object;
    }

    private void fillForm(String string, String string2, String string3) {
        this._tableModel.getDataVector().clear();
        if (this._network == null) {
            this._nameFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
            this._typeFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
            this._variableFilterCombo.setModel((ComboBoxModel)new RmaListModel(false));
            return;
        }
        String string4 = this.getFilterString(string);
        String string5 = this.getFilterString(string2);
        String string6 = this.getFilterString(string3);
        RmaListModel rmaListModel = new RmaListModel(false);
        rmaListModel.addElement((Object)"");
        RmaListModel rmaListModel2 = new RmaListModel(false);
        rmaListModel2.addElement((Object)"");
        RmaListModel rmaListModel3 = new RmaListModel(false);
        rmaListModel3.addElement((Object)"");
        RmaTableModel rmaTableModel = (RmaTableModel)this._sorter.getModel();
        this._elementTable.deleteCells();
        this._network.updateTSProxyList();
        Vector vector = this._network.getActiveTSProxies(null, 1);
        vector = this._network.getActiveTSProxies(vector, 0);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Element element;
            TSRecordProxy tSRecordProxy = (TSRecordProxy)vector.elementAt(i);
            if (tSRecordProxy == null) continue;
            boolean bl = true;
            if (a.containsKey(new Integer(tSRecordProxy.getVariableId())) || (element = this.getElementForTSProxy(tSRecordProxy)) == null) continue;
            element = element.getTopParent();
            String string7 = element.getElementType();
            String string8 = this._network.getNameForKeyString(tSRecordProxy.getName());
            tSRecordProxy.setFullName(string8);
            int n2 = tSRecordProxy.getVariableId();
            ModelVariable modelVariable = RssModelVariableSet.getModelVariable(n2);
            if (!this.passesFilter(string8, string4)) {
                bl = false;
            }
            if (!this.passesFilter(string7, string5) || !bl || !this.passesFilter(modelVariable.toString(), string6)) continue;
            Vector<Object> vector2 = new Vector<Object>(3);
            vector2.add(tSRecordProxy);
            vector2.add(string7);
            vector2.add(modelVariable);
            this.addToList(rmaListModel3, modelVariable.toString());
            rmaTableModel.addRow(vector2);
            this.addToList(rmaListModel, string8);
            this.addToList(rmaListModel2, string7);
        }
        this._sorter.reallocateIndexes();
        this._sorter.fireTableDataChanged();
        this._nameFilterCombo.removeActionListener(this._al);
        this._typeFilterCombo.removeActionListener(this._al);
        this._variableFilterCombo.removeActionListener(this._al);
        this._nameFilterCombo.removeItemListener(this._il);
        this._typeFilterCombo.removeItemListener(this._il);
        this._variableFilterCombo.removeItemListener(this._il);
        this._nameFilterCombo.setModel((ComboBoxModel)rmaListModel);
        this._typeFilterCombo.setModel((ComboBoxModel)rmaListModel2);
        this._variableFilterCombo.setModel((ComboBoxModel)rmaListModel3);
        this._nameFilterCombo.setSelectedItem((Object)string);
        this._typeFilterCombo.setSelectedItem((Object)string2);
        this._variableFilterCombo.setSelectedItem((Object)string3);
        this._nameFilterCombo.addActionListener(this._al);
        this._typeFilterCombo.addActionListener(this._al);
        this._variableFilterCombo.addActionListener(this._al);
        this._nameFilterCombo.addItemListener(this._il);
        this._typeFilterCombo.addItemListener(this._il);
        this._variableFilterCombo.addItemListener(this._il);
    }

    private void addSubElements(Element element, RmaTableModel rmaTableModel, RmaListModel rmaListModel, RmaListModel rmaListModel2, RmaListModel rmaListModel3, String string, String string2, String string3) {
        Vector vector = element.getElementVector();
        Vector vector2 = new Vector();
        String string4 = "Flow";
        for (int i = 0; i < vector.size(); ++i) {
            Vector<Object> vector3;
            String string5;
            Element element2 = (Element)vector.get(i);
            String string6 = element2.getFullName();
            if (!this.passesFilter(string6, string)) continue;
            vector2.clear();
            element2.getModelVariables(vector2);
            if (vector2.size() == 0) {
                string5 = element2.getElementType();
                if (string5 == null || string5.length() == 0) {
                    string5 = element.getElementType();
                }
                if (!this.passesFilter(string5, string2) || !this.passesFilter(string4, string3)) continue;
                vector3 = new Vector<Object>(3);
                vector3.add(element2);
                vector3.add(string5);
                vector3.add(string4);
                this.addToList(rmaListModel, string6);
                this.addToList(rmaListModel2, string5);
                this.addToList(rmaListModel3, string4);
                rmaTableModel.addRow(vector3);
                continue;
            }
            for (int j = 0; j < vector2.size(); ++j) {
                Object e = vector2.get(j);
                if (!this.passesFilter(e.toString(), string3)) continue;
                string5 = element2.getElementType();
                if (string5 == null || string5.length() == 0) {
                    string5 = element.getElementType();
                }
                if (!this.passesFilter(string5, string2)) continue;
                vector3 = new Vector<String>(3);
                vector3.add(string6);
                vector3.add(string5);
                vector3.add(e);
                this.addToList(rmaListModel, string6);
                this.addToList(rmaListModel2, string5);
                this.addToList(rmaListModel3, e.toString());
                rmaTableModel.addRow(vector3);
            }
        }
    }

    private void addToList(RmaListModel rmaListModel, String string) {
        if (!rmaListModel.contains((Object)string)) {
            rmaListModel.addElement((Object)string);
        }
    }

    private boolean passesFilter(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.toLowerCase().startsWith(string2);
    }

    public boolean isValidForm() {
        String string = null;
        if (this._selectedElement == null) {
            string = "No Element Selected";
        } else if (this._selectedTSProxy == null) {
            string = "No Time Series Record Selected";
        } else if (this._selectedModelVariable == null) {
            string = "No Variable Selected";
        }
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, "Incomplete Form", 1);
        }
        return string == null;
    }
}

