/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.ManagerProxyListManager;
import hec.dssgui.DSSListSelector;
import hec.dssgui.DSSListSelectorParent;
import hec.dssgui.ListSelection;
import hec.dssgui.TableFrame;
import hec.gfx2d.G2dDialog;
import hec.gui.AbstractEditorPanel;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.TimeSeriesContainer;
import hec.lang.NamedType;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AbstractTimeSeriesPanel$1;
import hec.rss.client.AbstractTimeSeriesPanel$2;
import hec.rss.client.AbstractTimeSeriesPanel$3;
import hec.rss.client.AbstractTimeSeriesPanel$4;
import hec.rss.client.AbstractTimeSeriesPanel$5;
import hec.rss.client.AbstractTimeSeriesPanel$6;
import hec.rss.client.AbstractTimeSeriesPanel$DssPathSelectionListener;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public abstract class AbstractTimeSeriesPanel
extends AbstractEditorPanel
implements ListSelectionListener {
    private static final FluentLogger l = FluentLogger.forEnclosingClass();
    protected static final int a = 0;
    protected static final int b = 1;
    protected static final int c = 2;
    protected static final int d = 3;
    protected static final int e = 4;
    protected static final int f = 5;
    protected static final int g = 6;
    protected static final int h = 7;
    protected static final int i = 8;
    protected static final String j = "OBS";
    protected static final String k = "Default";
    protected ReflectMultiListener m_rml = new ReflectMultiListener();
    protected Vector _inputVec;
    protected boolean _inputColVisible = true;
    protected Vector _reqTSProxyVec;
    protected DSSListSelector _selectFrame;
    protected RmaJTable timeSeriesTable;
    private JButton _dssPathSelectButton;
    private JButton _plotButton;
    private JButton _tabulateButton;
    protected JPanel _buttonPanel;
    private JMenuItem _copyPathNameMenuItem;

    public AbstractTimeSeriesPanel() {
        AbstractTimeSeriesPanel abstractTimeSeriesPanel = this;
        this.timeSeriesTable = new AbstractTimeSeriesPanel$1(abstractTimeSeriesPanel, (Component)((Object)abstractTimeSeriesPanel), new String[]{"Location", "Variable", "Input", "DSS File", "Part A", "Part B", "Part C", "Part E", "Part F"});
        this.buildControls();
    }

    protected boolean isTableCellEditable(int n, int n2) {
        return this.timeSeriesTable.getModel().isCellEditable(n, n2);
    }

    public boolean isColumnCellEditable(int n, int n2) {
        return false;
    }

    protected void buildControls() {
        this._inputVec = new Vector();
        this._inputVec.add(j);
        this._inputVec.add(k);
        this.setLayout(new GridBagLayout());
        this.timeSeriesTable.setColumnBackground(0, (Color)UIManager.get("TextField.disabledBackground"));
        this.timeSeriesTable.setColumnBackground(1, (Color)UIManager.get("TextField.disabledBackground"));
        this.timeSeriesTable.setColumnEnabled(false, 0);
        this.timeSeriesTable.setColumnEnabled(false, 1);
        this.timeSeriesTable.setComboBoxEditor(2, this._inputVec);
        this.timeSeriesTable.setNumRows(0);
        this.timeSeriesTable.setAutoResizeMode(0);
        this.timeSeriesTable.setCellSelectionEnabled(false);
        this.timeSeriesTable.setColumnSelectionAllowed(false);
        this.timeSeriesTable.setRowSelectionAllowed(true);
        this.timeSeriesTable.setColumnWidths(new int[]{85, 75, 95, 75, 75, 75, 75, 75, 75});
        this.timeSeriesTable.getSelectionModel().setSelectionMode(2);
        this.timeSeriesTable.setAddRemoveEnabled(false);
        this.timeSeriesTable.setPasteAddsRows(false);
        JScrollPane jScrollPane = this.timeSeriesTable.getScrollPane();
        this.add(jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        this._buttonPanel = new JPanel(new GridBagLayout());
        AbstractTimeSeriesPanel abstractTimeSeriesPanel = this;
        abstractTimeSeriesPanel.add(abstractTimeSeriesPanel._buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 14, 2, RmaInsets.insets((int)5, (int)5, (int)5, (int)5), 0, 0));
        this._plotButton = new AbstractTimeSeriesPanel$2(this, "Plot");
        this._plotButton.setEnabled(false);
        this._buttonPanel.add((Component)this._plotButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        this._tabulateButton = new AbstractTimeSeriesPanel$3(this, "Tabulate");
        this._tabulateButton.setEnabled(false);
        this._buttonPanel.add((Component)this._tabulateButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 0, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        this._dssPathSelectButton = new AbstractTimeSeriesPanel$4(this, "Select DSS Path...");
        this._buttonPanel.add((Component)this._dssPathSelectButton, new GridBagConstraints(5, 0, 1, 1, 0.01, 0.0, 14, 0, RmaInsets.insets((int)0, (int)0, (int)0, (int)0), 0, 0));
        AbstractTimeSeriesPanel abstractTimeSeriesPanel2 = this;
        this._plotButton.addActionListener((ActionListener)this.m_rml.add((Object)abstractTimeSeriesPanel2, (Object)abstractTimeSeriesPanel2._plotButton, "plotDssPathAction"));
        AbstractTimeSeriesPanel abstractTimeSeriesPanel3 = this;
        this._tabulateButton.addActionListener((ActionListener)this.m_rml.add((Object)abstractTimeSeriesPanel3, (Object)abstractTimeSeriesPanel3._tabulateButton, "tabulateDssPathAction"));
        AbstractTimeSeriesPanel abstractTimeSeriesPanel4 = this;
        this._dssPathSelectButton.addActionListener((ActionListener)this.m_rml.add((Object)abstractTimeSeriesPanel4, (Object)abstractTimeSeriesPanel4._dssPathSelectButton, "selectDssPath_Action"));
        this.timeSeriesTable.getSelectionModel().addListSelectionListener(this);
        this._dssPathSelectButton.setEnabled(false);
        if (!"cavi".equalsIgnoreCase(AppDaddy.getApp().getAppType())) {
            this.timeSeriesTable.setColumnVisible(2, false, 0);
            this._inputColVisible = false;
        }
        this.timeSeriesTable.addMouseListener((MouseListener)new AbstractTimeSeriesPanel$5(this));
        this._copyPathNameMenuItem = new JMenuItem("Copy DSS Pathname");
        this._copyPathNameMenuItem.addActionListener(new AbstractTimeSeriesPanel$6(this));
        this.timeSeriesTable.addPopupItem((JComponent)this._copyPathNameMenuItem, 0);
    }

    protected void copyDssPathNameAction() {
        int n = this.timeSeriesTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        Object object = new DSSPathname();
        String string = (String)this.timeSeriesTable.getValueAt(n, this.getAPartCol());
        object.setAPart(string);
        string = (String)this.timeSeriesTable.getValueAt(n, this.getBPartCol());
        object.setBPart(string);
        string = (String)this.timeSeriesTable.getValueAt(n, this.getCPartCol());
        object.setCPart(string);
        string = (String)this.timeSeriesTable.getValueAt(n, this.getEPartCol());
        object.setEPart(string);
        Object object2 = (String)this.timeSeriesTable.getValueAt(n, this.getFPartCol());
        object.setFPart((String)object2);
        object2 = new StringSelection(object.getPathname());
        object = Toolkit.getDefaultToolkit().getSystemClipboard();
        object.setContents((Transferable)object2, null);
    }

    protected void displayDSSPath(String string, String string2) {
        ((FluentLogger.Api)l.atInfo()).log("displayDSSPath file=%s path=%s", (Object)string, (Object)string2);
        boolean bl = AppDaddy.getApp().isNetworked();
        ListSelection listSelection = new ListSelection("HecDssVue", 2, false, bl);
        if (string != null) {
            listSelection.setDSSFilename(string);
        }
        if (string2 != null) {
            listSelection.setFilter(string2);
        }
        listSelection.setVisible(true);
    }

    public String getTabname() {
        return "Time-Series";
    }

    public void setPanelEnabled(boolean bl) {
    }

    public abstract boolean savePanel();

    public abstract void fillPanel(NamedType var1);

    public void selectDssPath_Action() {
        try {
            Object object;
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean bl = AppDaddy.getApp().isNetworked();
            this.timeSeriesTable.commitEdit(true);
            int n = this.timeSeriesTable.getSelectedRow();
            boolean bl2 = false;
            if (this._selectFrame == null) {
                this._selectFrame = new DSSListSelector((DSSListSelectorParent)new AbstractTimeSeriesPanel$DssPathSelectionListener(this), "Select Pathname", 1, false, bl);
                bl2 = true;
            }
            if (n >= 0) {
                Object object2 = (String)this.timeSeriesTable.getValueAt(n, this.getDssFileCol());
                if (object2 != null && ((String)object2).length() > 0) {
                    if (!RMAIO.isFullPath((String)object2)) {
                        object2 = AppDaddy.getWorkspace().getWorkspacePath() + "/" + (String)object2;
                    }
                    this._selectFrame.setDSSFilename((String)object2);
                } else {
                    this._selectFrame.setDirectory(AppDaddy.getWorkspace().getWorkspacePath());
                }
            }
            if ((object = SwingUtilities.windowForComponent((Component)((Object)this))) instanceof AbstractAlternativeEditor) {
                object = (AbstractAlternativeEditor)object;
                if ((object = ((AbstractAlternativeEditor)object).getWorkspace()) instanceof ClientWorkspace) {
                    object = (ClientWorkspace)object;
                    this._selectFrame.setDirectory(object.getWorkspacePath());
                } else if (object instanceof ManagerProxyListManager) {
                    object = (ManagerProxyListManager)object;
                    this._selectFrame.setDirectory(object.getWorkspacePath());
                }
            }
            this._selectFrame.setVisible(true);
            if (bl2) {
                RMAUtil.setWindowAlwaysOnTop((Window)this._selectFrame, (boolean)true);
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected Vector<TimeSeriesContainer> getSelectedData() {
        Vector<TimeSeriesContainer> vector = new Vector<TimeSeriesContainer>();
        this.timeSeriesTable.commitEdit(true);
        int[] nArray = this.timeSeriesTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return vector;
        }
        DSSPathname dSSPathname = new DSSPathname();
        HecTime hecTime = new HecTime();
        HecTime hecTime2 = new HecTime();
        Object object = null;
        try {
            object = ClientApp.Workspace().getData().getDSSFileManager();
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)l.atInfo()).log("getSelectedData:RemoteException %s", (Object)remoteException.getMessage());
            remoteException.printStackTrace();
        }
        if (object == null) {
            ((FluentLogger.Api)l.atInfo()).log("getSelectedData:failed to get DssFileManager from Watershed");
            return vector;
        }
        DSSManager dSSManager = (DSSManager)object.getRemote();
        if (dSSManager == null) {
            ((FluentLogger.Api)l.atInfo()).log("getSelectedData:failed to get DssFileManager from Watershed's remote wrapper");
            return vector;
        }
        vector.ensureCapacity(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)this.timeSeriesTable.getValueAt(nArray[i], this.getDssFileCol());
            object = (String)this.timeSeriesTable.getValueAt(nArray[i], this.getAPartCol());
            String string2 = (String)this.timeSeriesTable.getValueAt(nArray[i], this.getBPartCol());
            String string3 = (String)this.timeSeriesTable.getValueAt(nArray[i], this.getCPartCol());
            String string4 = (String)this.timeSeriesTable.getValueAt(nArray[i], this.getEPartCol());
            String string5 = (String)this.timeSeriesTable.getValueAt(nArray[i], this.getFPartCol());
            dSSPathname.setAPart((String)object);
            dSSPathname.setBPart(string2);
            dSSPathname.setCPart(string3);
            dSSPathname.setEPart(string4);
            dSSPathname.setFPart(string5);
            if (string.isEmpty() || dSSPathname.getPathname().equals("//////")) {
                if (nArray.length != 1) continue;
                AbstractTimeSeriesPanel abstractTimeSeriesPanel = this;
                JOptionPane.showMessageDialog((Component)((Object)abstractTimeSeriesPanel), "No DSS File/Path entered for " + String.valueOf(abstractTimeSeriesPanel.timeSeriesTable.getValueAt(nArray[i], 0)) + "-" + String.valueOf(this.timeSeriesTable.getValueAt(nArray[i], 1)), "Missing Entry", 1);
                continue;
            }
            string = ClientApp.Workspace().makeAbsolutePath(string);
            object = new DSSIdentifier(string, dSSPathname.getPathname());
            try {
                dSSManager.getTimeSeriesExtents((DSSIdentifier)object, hecTime2, hecTime);
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)l.atInfo()).log("getSelectedData:failed to get start/end time for %s error:%s", object, (Object)remoteException);
            }
            if (!hecTime2.isDefined()) {
                hecTime2.set("01Jan1900 0000");
            }
            if (!hecTime.isDefined()) {
                hecTime.setCurrent();
            }
            object.setStartTime(hecTime2);
            object.setEndTime(hecTime);
            ((FluentLogger.Api)l.atInfo()).log("getSelectedData:plotting %s from %s", (Object)object.getDSSPath(), (Object)object.getFileName());
            string3 = null;
            boolean bl = false;
            try {
                string3 = dSSManager.readTS((DSSIdentifier)object, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ((FluentLogger.Api)l.atInfo()).log("getSelectedData: FileNotFoundException %s" + fileNotFoundException.getMessage());
                bl = true;
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)l.atInfo()).log("getSelectedData: RemoteException %s", (Object)remoteException.getMessage());
                remoteException.printStackTrace();
            }
            if (string3 == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Failed to find Data for " + dSSPathname.getPathname() + "\nin file " + string + (bl ? "\nFile doesn't exist." : ""));
                continue;
            }
            vector.add((TimeSeriesContainer)string3);
        }
        return vector;
    }

    public void tabulateDssPathAction() {
        Vector<TimeSeriesContainer> vector = this.getSelectedData();
        if (vector.size() == 0) {
            return;
        }
        TableFrame tableFrame = new TableFrame((JFrame)ClientApp.frame());
        tableFrame.setData(vector);
        tableFrame.setVisible(true);
    }

    public void plotDssPathAction() {
        G2dDialog g2dDialog = this.getSelectedData();
        if (g2dDialog.size() == 0) {
            return;
        }
        g2dDialog = new G2dDialog(null, "", false, g2dDialog);
        g2dDialog.setVisible(true);
    }

    protected int getInputPos(String string) {
        if (string == null || string.startsWith(k) || "".equals(string)) {
            return 0;
        }
        if (j.equals(string)) {
            return -1;
        }
        if ((string = RMAIO.getType((String)string, (String)" ")) == null || "".equals(string)) {
            return 0;
        }
        return RMAIO.parseInt((String)string, (int)0);
    }

    protected void setInputPos(int n, int n2) {
        if (!this._inputColVisible) {
            return;
        }
        switch (n) {
            case -1: {
                this.timeSeriesTable.setValueAt((Object)j, n2, this.getInputCol());
                return;
            }
            case 0: {
                String string = (String)this._inputVec.get(1);
                this.timeSeriesTable.setValueAt((Object)string, n2, this.getInputCol());
                return;
            }
        }
        String string = "" + n;
        if (this._inputVec.size() >= 3) {
            int n3 = this._inputVec.size();
            for (int i = 2; i < n3; ++i) {
                String string2 = RMAIO.getType((String)((String)this._inputVec.get(i)), (String)" ");
                if (!string.equals(string2)) continue;
                this.timeSeriesTable.setValueAt(this._inputVec.get(i), n2, this.getInputCol());
                return;
            }
        }
        this.timeSeriesTable.setValueAt((Object)k, n2, this.getInputCol());
    }

    public void windowClosing() {
        if (this._selectFrame != null && this._selectFrame.isVisible()) {
            this._selectFrame.setVisible(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        boolean bl = this.timeSeriesTable.getSelectedRow() != -1 && this.isDefaultVariant();
        this._dssPathSelectButton.setEnabled(bl);
        this._plotButton.setEnabled(bl);
        this._tabulateButton.setEnabled(bl);
    }

    protected boolean isDefaultVariant() {
        return true;
    }

    public void setProgramOrder(Vector vector, String string) {
        Object object;
        int n;
        this._inputVec.clear();
        this._inputVec.add(j);
        if (vector == null || string == null) {
            this._inputVec.add(k);
            return;
        }
        vector = (Vector)vector.clone();
        for (n = vector.size() - 1; n >= 0; --n) {
            object = vector.get(n);
            if (!(object instanceof ProgramOrderItem)) {
                vector.remove(n);
                continue;
            }
            if (string.equalsIgnoreCase((object = (ProgramOrderItem)object).getName())) break;
        }
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            object = (ProgramOrderItem)vector.get(i);
            if (object == null || !string.equalsIgnoreCase(object.getName())) continue;
            ++n2;
        }
        if (n2 == 1) {
            Object object2 = k;
            object = (ProgramOrderItem)vector.get(n);
            int n3 = object.getInputModelNumber();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = (ProgramOrderItem)vector.get(n2);
                if (object.getIndex() != n3) continue;
                object2 = (String)object2 + " (" + n3 + " " + object.toString() + ")";
            }
            this._inputVec.add(object2);
        } else {
            this._inputVec.add(k);
        }
        if (n < 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            object = (ProgramOrderItem)vector.get(i);
            this._inputVec.add(i + 1 + " " + object.toString());
        }
    }

    protected int getLocationCol() {
        return 0;
    }

    protected int getVariableCol() {
        return 1;
    }

    protected int getInputCol() {
        if (this._inputColVisible) {
            return 2;
        }
        return -1;
    }

    protected int getDssFileCol() {
        if (this._inputColVisible) {
            return 3;
        }
        return 2;
    }

    protected int getAPartCol() {
        if (this._inputColVisible) {
            return 4;
        }
        return 3;
    }

    protected int getBPartCol() {
        if (this._inputColVisible) {
            return 5;
        }
        return 4;
    }

    protected int getCPartCol() {
        if (this._inputColVisible) {
            return 6;
        }
        return 5;
    }

    protected int getEPartCol() {
        if (this._inputColVisible) {
            return 7;
        }
        return 6;
    }

    protected int getFPartCol() {
        if (this._inputColVisible) {
            return 8;
        }
        return 7;
    }

    protected boolean isInputColVisible() {
        return this._inputColVisible;
    }
}

