/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.AdjustmentLimitsPanel$1;
import hec.rss.client.AdjustmentLimitsPanel$2;
import hec.rss.client.AdjustmentLimitsPanel$3;
import hec.rss.client.AdjustmentLimitsPanel$4;
import hec.rss.client.AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits;
import hec.rss.client.AdjustmentOptions;
import hec.rss.client.AdjustmentOptions$AdjustmentLimitsType;
import hec.rss.model.ReservoirElement;
import hec.rss.model.StorageZone;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.list.RmaListModel;

public class AdjustmentLimitsPanel
extends JPanel {
    private JDialog _parent;
    private JPanel _maxCardPanel;
    private JPanel _minCardPanel;
    private RmaJComboBox<StorageZone> _maxZoneCombo;
    private RmaJDecimalField _maxElevationDecimalField;
    private RmaJDecimalField _maxStorageDecField;
    private RmaJComboBox<StorageZone> _minZoneCombo;
    private RmaJDecimalField _minElevationDecField;
    private RmaJDecimalField _minStorageDecField;
    private RmaJComboBox<AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits> _maxTypeCombo;
    private RmaJComboBox<AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits> _minTypeCombo;
    private RmaJDecimalField _maxElevationOtherDecimalField;
    private RmaJDecimalField _minElevationOtherDecimalField;
    private RmaJDecimalField _maxStorageOtherDecimalField;
    private RmaJDecimalField _minStorageOtherDecimalField;
    private ReservoirElement _reservoirElement;

    AdjustmentLimitsPanel(JDialog jDialog) {
        this.setLayout(new GridBagLayout());
        this._parent = jDialog;
        this.setBorder(new TitledBorder("Adjustment Limits"));
        this.buildControls();
        this.addActionListeners();
    }

    private void buildControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJLabel rmaJLabel = new RmaJLabel("Max Type:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this.add((Component)rmaJLabel, gridBagConstraints);
        rmaJLabel = this.getAdjustmentLimitTypeItems();
        this._maxTypeCombo = new RmaJComboBox((Object[])rmaJLabel);
        this._maxTypeCombo.setModifiable(true);
        this._maxTypeCombo.setSelectedItem(rmaJLabel[0]);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        AdjustmentLimitsPanel adjustmentLimitsPanel = this;
        adjustmentLimitsPanel.add((Component)adjustmentLimitsPanel._maxTypeCombo, gridBagConstraints);
        rmaJLabel = new RmaJLabel("Max:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this.add((Component)rmaJLabel, gridBagConstraints);
        this._maxCardPanel = new JPanel(new CardLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        AdjustmentLimitsPanel adjustmentLimitsPanel2 = this;
        adjustmentLimitsPanel2.add((Component)adjustmentLimitsPanel2._maxCardPanel, gridBagConstraints);
        this._maxCardPanel.add(AdjustmentOptions$AdjustmentLimitsType.ZONE.toString(), this.createMaxZonePanel());
        this._maxCardPanel.add(AdjustmentOptions$AdjustmentLimitsType.ELEVATION.toString(), this.createMaxElevationPanel());
        this._maxCardPanel.add(AdjustmentOptions$AdjustmentLimitsType.STORAGE.toString(), this.createMaxStoragePanel());
        rmaJLabel = new RmaJLabel("Min Type:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this.add((Component)rmaJLabel, gridBagConstraints);
        rmaJLabel = this.getAdjustmentLimitTypeItems();
        this._minTypeCombo = new RmaJComboBox((Object[])rmaJLabel);
        this._minTypeCombo.setModifiable(true);
        this._minTypeCombo.setSelectedItem(rmaJLabel[0]);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        AdjustmentLimitsPanel adjustmentLimitsPanel3 = this;
        adjustmentLimitsPanel3.add((Component)adjustmentLimitsPanel3._minTypeCombo, gridBagConstraints);
        rmaJLabel = new RmaJLabel("Min:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this.add((Component)rmaJLabel, gridBagConstraints);
        this._minCardPanel = new JPanel(new CardLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        AdjustmentLimitsPanel adjustmentLimitsPanel4 = this;
        adjustmentLimitsPanel4.add((Component)adjustmentLimitsPanel4._minCardPanel, gridBagConstraints);
        this._minCardPanel.add("Zone", this.createMinZonePanel());
        this._minCardPanel.add("Elevation", this.createMinElevationPanel());
        this._minCardPanel.add("Storage", this.createMinStoragePanel());
    }

    private ParamDouble convertElevationToStorage(double d) {
        if (this._reservoirElement != null) {
            double d2 = this._reservoirElement.getStorageFunction().elevationToStorage(d);
            return new ParamDouble(d2, Parameter.PARAMID_STOR, this._reservoirElement.getUnitSystem(), 1);
        }
        return new ParamDouble(0.0, Parameter.PARAMID_STOR);
    }

    private ParamDouble convertStorageToElevation(double d) {
        if (this._reservoirElement != null) {
            double d2 = this._reservoirElement.getStorageFunction().storageToElevation(d);
            return new ParamDouble(d2, Parameter.PARAMID_ELEV, this._reservoirElement.getUnitSystem(), 3);
        }
        return new ParamDouble(0.0, Parameter.PARAMID_ELEV);
    }

    public void fillPanel(AdjustmentOptions adjustmentOptions, List<StorageZone> list, ReservoirElement reservoirElement) {
        this._reservoirElement = reservoirElement;
        this.setSelectedAdjustmentTypes(adjustmentOptions);
        this._minZoneCombo.setModel((ComboBoxModel)new RmaListModel(false, list));
        this._maxZoneCombo.setModel((ComboBoxModel)new RmaListModel(false, list));
        if (!list.isEmpty()) {
            int n = adjustmentOptions.f();
            int n2 = adjustmentOptions.e();
            AdjustmentLimitsPanel adjustmentLimitsPanel = this;
            adjustmentLimitsPanel.selectTheCorrectZone(adjustmentLimitsPanel._minZoneCombo, n);
            AdjustmentLimitsPanel adjustmentLimitsPanel2 = this;
            adjustmentLimitsPanel2.selectTheCorrectZone(adjustmentLimitsPanel2._maxZoneCombo, n2);
        }
        double d = adjustmentOptions.a();
        this._minElevationDecField.setValue(new ParamDouble(d, Parameter.PARAMID_ELEV, this._reservoirElement.getUnitSystem()));
        this._minElevationOtherDecimalField.setValue(this.convertElevationToStorage(d));
        double d2 = adjustmentOptions.b();
        this._maxElevationDecimalField.setValue(new ParamDouble(d2, Parameter.PARAMID_ELEV, this._reservoirElement.getUnitSystem()));
        this._maxElevationOtherDecimalField.setValue(this.convertElevationToStorage(d2));
        double d3 = adjustmentOptions.c();
        this._minStorageDecField.setValue(new ParamDouble(d3, Parameter.PARAMID_STOR, this._reservoirElement.getUnitSystem()));
        this._minStorageOtherDecimalField.setValue(this.convertStorageToElevation(d3));
        double d4 = adjustmentOptions.d();
        this._maxStorageDecField.setValue(new ParamDouble(d4, Parameter.PARAMID_STOR, this._reservoirElement.getUnitSystem()));
        this._maxStorageOtherDecimalField.setValue(this.convertStorageToElevation(d4));
    }

    private void selectTheCorrectZone(RmaJComboBox rmaJComboBox, int n) {
        for (int i = 0; i < rmaJComboBox.getItemCount(); ++i) {
            StorageZone storageZone = (StorageZone)rmaJComboBox.getItemAt(i);
            if (storageZone.getIndex() != n) continue;
            rmaJComboBox.setSelectedIndex(i);
            return;
        }
    }

    private void addActionListeners() {
        this._minTypeCombo.addActionListener(actionEvent -> this.minTypeComboChanged());
        this._maxTypeCombo.addActionListener(actionEvent -> this.maxTypeComboChanged());
        this.addDecimalFieldDocumentListeners();
    }

    private void addDecimalFieldDocumentListeners() {
        this._minElevationDecField.getDocument().addDocumentListener(new AdjustmentLimitsPanel$1(this));
        this._maxElevationDecimalField.getDocument().addDocumentListener(new AdjustmentLimitsPanel$2(this));
        this._maxStorageDecField.getDocument().addDocumentListener(new AdjustmentLimitsPanel$3(this));
        this._minStorageDecField.getDocument().addDocumentListener(new AdjustmentLimitsPanel$4(this));
    }

    private void updateMinStorageText() {
        double d = this._minStorageDecField.getValue();
        this._minStorageOtherDecimalField.setValue(this.convertStorageToElevation(d));
    }

    private void updateMaxStorageText() {
        double d = this._maxStorageDecField.getValue();
        this._maxStorageOtherDecimalField.setValue(this.convertStorageToElevation(d));
    }

    private void updateMaxElevationText() {
        double d = this._maxElevationDecimalField.getValue();
        this._maxElevationOtherDecimalField.setValue(this.convertElevationToStorage(d));
    }

    private void updateMinElevationText() {
        double d = this._minElevationDecField.getValue();
        this._minElevationOtherDecimalField.setValue(this.convertElevationToStorage(d));
    }

    AdjustmentOptions$AdjustmentLimitsType getMaxLimitType() {
        return ((AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits)this._maxTypeCombo.getSelectedItem()).a();
    }

    AdjustmentOptions$AdjustmentLimitsType getMinLimitType() {
        return ((AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits)this._minTypeCombo.getSelectedItem()).a();
    }

    public double getMaxElevation() {
        return this._maxElevationDecimalField.getValue();
    }

    public double getMinElevation() {
        return this._minElevationDecField.getValue();
    }

    public double getMaxStorage() {
        return this._maxStorageDecField.getValue();
    }

    double getMinStorage() {
        return this._minStorageDecField.getValue();
    }

    StorageZone getMinZone() {
        return (StorageZone)this._minZoneCombo.getSelectedItem();
    }

    StorageZone getMaxZone() {
        return (StorageZone)this._maxZoneCombo.getSelectedItem();
    }

    private void minTypeComboChanged() {
        AdjustmentOptions$AdjustmentLimitsType adjustmentOptions$AdjustmentLimitsType = ((AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits)this._minTypeCombo.getSelectedItem()).a();
        if (adjustmentOptions$AdjustmentLimitsType != null) {
            ((CardLayout)this._minCardPanel.getLayout()).show(this._minCardPanel, adjustmentOptions$AdjustmentLimitsType.toString());
        }
    }

    private void maxTypeComboChanged() {
        AdjustmentOptions$AdjustmentLimitsType adjustmentOptions$AdjustmentLimitsType = ((AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits)this._maxTypeCombo.getSelectedItem()).a();
        if (adjustmentOptions$AdjustmentLimitsType != null) {
            ((CardLayout)this._maxCardPanel.getLayout()).show(this._maxCardPanel, adjustmentOptions$AdjustmentLimitsType.toString());
        }
    }

    private JPanel createMaxZonePanel() {
        this._maxZoneCombo = new RmaJComboBox();
        this._maxZoneCombo.setModifiable(true);
        AdjustmentLimitsPanel adjustmentLimitsPanel = this;
        return adjustmentLimitsPanel.createZonePanel(adjustmentLimitsPanel._maxZoneCombo);
    }

    private JPanel createMinZonePanel() {
        this._minZoneCombo = new RmaJComboBox();
        this._minZoneCombo.setModifiable(true);
        AdjustmentLimitsPanel adjustmentLimitsPanel = this;
        return adjustmentLimitsPanel.createZonePanel(adjustmentLimitsPanel._minZoneCombo);
    }

    private JPanel createZonePanel(RmaJComboBox rmaJComboBox) {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)5);
        rmaJPanel.add((Component)rmaJComboBox, gridBagConstraints);
        return rmaJPanel;
    }

    private JPanel createDecimalFieldWithOtherUnitsPanel(RmaJDecimalField rmaJDecimalField, RmaJDecimalField rmaJDecimalField2) {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)rmaJDecimalField, gridBagConstraints);
        rmaJDecimalField2.setBorder(null);
        rmaJDecimalField2.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)rmaJDecimalField2, gridBagConstraints);
        rmaJDecimalField = new RmaJLabel("(%S)");
        rmaJDecimalField.setLabelFor((Component)rmaJDecimalField2);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)5);
        rmaJPanel.add((Component)rmaJDecimalField, gridBagConstraints);
        return rmaJPanel;
    }

    private JPanel createMaxElevationPanel() {
        this._maxElevationDecimalField = new RmaJDecimalField();
        this._maxElevationDecimalField.setEmptyOk(false);
        this._maxElevationOtherDecimalField = new RmaJDecimalField();
        AdjustmentLimitsPanel adjustmentLimitsPanel = this;
        return adjustmentLimitsPanel.createDecimalFieldWithOtherUnitsPanel(adjustmentLimitsPanel._maxElevationDecimalField, this._maxElevationOtherDecimalField);
    }

    private JPanel createMaxStoragePanel() {
        this._maxStorageDecField = new RmaJDecimalField();
        this._maxStorageDecField.setMinValue(0.0);
        this._maxStorageDecField.setEmptyOk(false);
        this._maxStorageOtherDecimalField = new RmaJDecimalField();
        AdjustmentLimitsPanel adjustmentLimitsPanel = this;
        return adjustmentLimitsPanel.createDecimalFieldWithOtherUnitsPanel(adjustmentLimitsPanel._maxStorageDecField, this._maxStorageOtherDecimalField);
    }

    private JPanel createMinElevationPanel() {
        this._minElevationDecField = new RmaJDecimalField();
        this._minElevationDecField.setEmptyOk(false);
        this._minElevationOtherDecimalField = new RmaJDecimalField();
        AdjustmentLimitsPanel adjustmentLimitsPanel = this;
        return adjustmentLimitsPanel.createDecimalFieldWithOtherUnitsPanel(adjustmentLimitsPanel._minElevationDecField, this._minElevationOtherDecimalField);
    }

    private JPanel createMinStoragePanel() {
        this._minStorageDecField = new RmaJDecimalField();
        this._minStorageDecField.setMinValue(0.0);
        this._minStorageDecField.setEmptyOk(false);
        this._minStorageOtherDecimalField = new RmaJDecimalField();
        AdjustmentLimitsPanel adjustmentLimitsPanel = this;
        return adjustmentLimitsPanel.createDecimalFieldWithOtherUnitsPanel(adjustmentLimitsPanel._minStorageDecField, this._minStorageOtherDecimalField);
    }

    private AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits[] getAdjustmentLimitTypeItems() {
        AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits[] adjustmentLimitsPanel$AdjustmentLimitTypesAndUnitsArray = new AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits[3];
        AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits[] adjustmentLimitsPanel$AdjustmentLimitTypesAndUnitsArray2 = adjustmentLimitsPanel$AdjustmentLimitTypesAndUnitsArray;
        adjustmentLimitsPanel$AdjustmentLimitTypesAndUnitsArray[0] = new AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits(AdjustmentOptions$AdjustmentLimitsType.ZONE);
        adjustmentLimitsPanel$AdjustmentLimitTypesAndUnitsArray2[1] = new AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits(AdjustmentOptions$AdjustmentLimitsType.ELEVATION);
        adjustmentLimitsPanel$AdjustmentLimitTypesAndUnitsArray2[2] = new AdjustmentLimitsPanel$AdjustmentLimitTypesAndUnits(AdjustmentOptions$AdjustmentLimitsType.STORAGE);
        return adjustmentLimitsPanel$AdjustmentLimitTypesAndUnitsArray2;
    }

    private void setSelectedAdjustmentTypes(AdjustmentOptions object) {
        AdjustmentOptions$AdjustmentLimitsType adjustmentOptions$AdjustmentLimitsType = object.l();
        if (adjustmentOptions$AdjustmentLimitsType == AdjustmentOptions$AdjustmentLimitsType.ZONE) {
            this._maxTypeCombo.setSelectedIndex(0);
        } else if (adjustmentOptions$AdjustmentLimitsType == AdjustmentOptions$AdjustmentLimitsType.ELEVATION) {
            this._maxTypeCombo.setSelectedIndex(1);
        } else if (adjustmentOptions$AdjustmentLimitsType == AdjustmentOptions$AdjustmentLimitsType.STORAGE) {
            this._maxTypeCombo.setSelectedIndex(2);
        }
        object = object.m();
        if (object == AdjustmentOptions$AdjustmentLimitsType.ZONE) {
            this._minTypeCombo.setSelectedIndex(0);
            return;
        }
        if (object == AdjustmentOptions$AdjustmentLimitsType.ELEVATION) {
            this._minTypeCombo.setSelectedIndex(1);
            return;
        }
        if (object == AdjustmentOptions$AdjustmentLimitsType.STORAGE) {
            this._minTypeCombo.setSelectedIndex(2);
        }
    }
}

