/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.model.SimulationPeriod;
import hec.heclib.dss.DSSPathname;
import hec.hecmath.DssCompare;
import hec.io.Identifier;
import hec.rss.client.AltDssComparisonDlg$1;
import hec.rss.client.AltDssComparisonDlg$2;
import hec.rss.client.AltDssComparisonDlg$3;
import hec.rss.client.AltDssComparisonDlg$4;
import hec.rss.client.AltDssComparisonDlg$ConfirmOptionsDlg;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.table.TableRowSorter;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextArea;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class AltDssComparisonDlg
extends RmaJDialog {
    private RmaJTextArea _altInfoFld;
    private RmaJTable _resultsTable;
    private JButton _runComparisonBtn;
    private ButtonCmdPanel _cmdPanel;
    private RmaJTextArea _summaryFld;
    private Identifier _id;
    private SimulationPeriod _simulation;

    public AltDssComparisonDlg(HecClientFrame hecClientFrame, SimulationPeriod simulationPeriod, Identifier identifier) {
        super((Frame)hecClientFrame, false);
        this._simulation = simulationPeriod;
        this._id = identifier;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        AltDssComparisonDlg altDssComparisonDlg = this;
        altDssComparisonDlg.setLocationRelativeTo(altDssComparisonDlg.getParent());
    }

    private void buildControls() {
        this.setTitle("Results Differences");
        this.getContentPane().setLayout(new GridBagLayout());
        Object object = new JLabel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)object, gridBagConstraints);
        this._altInfoFld = new RmaJTextArea();
        this._altInfoFld.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._altInfoFld, gridBagConstraints);
        object = new String[]{"Type", "Path", "Param", "Max Abs Diff", "Avg Diff", "RMS Diff"};
        AltDssComparisonDlg altDssComparisonDlg = this;
        this._resultsTable = new AltDssComparisonDlg$1(altDssComparisonDlg, (Component)((Object)altDssComparisonDlg), (Object[])object);
        object = (String[])this._resultsTable.getModel();
        object.setColumnClass(0, String.class);
        object.setColumnClass(1, String.class);
        object.setColumnClass(2, String.class);
        object.setColumnClass(3, Double.class);
        object.setColumnClass(4, Double.class);
        object.setColumnClass(5, Double.class);
        object = new TableRowSorter<RmaTableModel>((RmaTableModel)object);
        this._resultsTable.setRowSorter((RowSorter)object);
        this._resultsTable.setHorizontalAlignment(0, 0);
        this._resultsTable.setDoubleCellEditor(3);
        this._resultsTable.setDoubleCellEditor(4);
        this._resultsTable.setDoubleCellEditor(5);
        this._resultsTable.setColumnWidths(new int[]{64, 300, 130, 130, 130, 130});
        this._resultsTable.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._resultsTable.getScrollPane(), gridBagConstraints);
        this._summaryFld = new RmaJTextArea();
        this._summaryFld.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._summaryFld, gridBagConstraints);
        this._runComparisonBtn = new JButton("Run Comparison");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._runComparisonBtn, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(256);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
    }

    private void addListeners() {
        this._runComparisonBtn.addActionListener(new AltDssComparisonDlg$2(this));
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new AltDssComparisonDlg$3(this));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(116, 0);
        if (keyStroke != null) {
            AltDssComparisonDlg$4 altDssComparisonDlg$4 = new AltDssComparisonDlg$4(this);
            this.getRootPane().getActionMap().put("refresh", altDssComparisonDlg$4);
            this.getRootPane().getInputMap(2).put(keyStroke, "refresh");
        }
    }

    protected void refresh() {
        this.fillForm();
    }

    protected void runComparisonAction() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Object object;
            DssCompare dssCompare = new DssCompare(ClientApp.Workspace().getTitleName(), this._id.getName());
            String string = this._simulation.getSimulationPath() + "/referenceResults/rss/";
            string = string + this._simulation.getOutputDSSFileName();
            Object object2 = this._simulation.getRunTimeWindow();
            String string2 = object2.getStartTimeString();
            object2 = object2.getEndTimeString();
            Object object3 = this._altInfoFld.getText();
            BufferedReader bufferedReader = new BufferedReader(new StringReader((String)object3));
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            try {
                while ((object3 = bufferedReader.readLine()) != null) {
                    int n = ((String)object3).indexOf("Dss path parts:");
                    if (n < 0 || (n = ((String)(object3 = ((String)object3).substring(n + 15))).indexOf("tolerance:")) < 0) continue;
                    object = ((String)object3).substring(0, n).trim();
                    arrayList.add((double[])object);
                    object3 = ((String)object3).substring(n + 10).trim();
                    arrayList2.add(object3);
                }
            }
            catch (IOException iOException) {
                System.out.println("IOException " + String.valueOf(iOException));
                iOException.printStackTrace();
            }
            if (arrayList.size() == 0) {
                object3 = new String[]{};
            } else {
                object3 = new String[arrayList.size()];
                arrayList.toArray((T[])object3);
            }
            if (arrayList2.size() == 0) {
                object = new double[]{0.1, 0.01, 1.0, 1.0};
            } else {
                object = new double[arrayList2.size()];
                for (int i = 0; i < arrayList2.size(); ++i) {
                    object[i] = RMAIO.parseDouble((String)((String)arrayList2.get(i)));
                }
            }
            AltDssComparisonDlg$ConfirmOptionsDlg altDssComparisonDlg$ConfirmOptionsDlg = new AltDssComparisonDlg$ConfirmOptionsDlg(this, (String[])object3, (double[])object);
            altDssComparisonDlg$ConfirmOptionsDlg.setVisible(true);
            if (altDssComparisonDlg$ConfirmOptionsDlg.isCanceled()) {
                return;
            }
            object3 = altDssComparisonDlg$ConfirmOptionsDlg.getPaths();
            object = altDssComparisonDlg$ConfirmOptionsDlg.getTolerances();
            dssCompare.getDataSetResults(this._simulation.getOutputDSSFilePath(), string, string2, (String)object2, this.getOutputFile(), (String[])object3, object, true, "\t", false);
            this.fillForm();
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private String getOutputFile() {
        return this._id.getPath();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillForm() {
        Object object;
        Object object2;
        Object object3;
        block27: {
            boolean bl;
            block26: {
                this._resultsTable.deleteCells();
                object3 = this.getOutputFile();
                object2 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
                object = new Identifier((String)object3);
                try {
                    object2 = object2.openFile(ClientApp.app().getUser(), (Identifier)object);
                }
                catch (RemoteException remoteException) {
                    System.out.println("fillForm: RemoteException " + String.valueOf(remoteException));
                    remoteException.printStackTrace();
                    return;
                }
                if (object2 == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Failed to find results file " + object.getPath());
                    return;
                }
                if ((object2 = object2.getFile()) == null) {
                    System.out.println("fillForm:failed to get file from " + object.getPath());
                    return;
                }
                object2 = object2.getBufferedReader();
                System.out.println("fillForm:reading " + (String)object3);
                object = new ArrayList();
                bl = false;
                while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                    if (((String)object3).startsWith("Watershed")) {
                        object.add(0, object3);
                        continue;
                    }
                    if (((String)object3).startsWith("#")) {
                        object.add(((String)object3).substring(1));
                        continue;
                    }
                    if (((String)object3).length() == 0 || !((String)object3).startsWith("Type:")) continue;
                    bl = true;
                    break;
                }
                this.fillAltInfo((List<String>)object);
                if (bl) break block26;
                if (object2 == null) return;
                try {
                    ((BufferedReader)object2).close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            bl = false;
            DSSPathname dSSPathname = new DSSPathname();
            while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                if (((String)object3).length() == 0 || ((String)object3).startsWith("Type:")) continue;
                if (((String)object3).startsWith("Summary")) {
                    bl = true;
                    break;
                }
                object = ((String)object3).split("\t");
                if (object == null || ((Object)object).length < 5) continue;
                object3 = new Vector<Object>(6);
                ((Vector)object3).add(object[0]);
                ((Vector)object3).add(object[1]);
                dSSPathname.setPathname((String)object[1]);
                ((Vector)object3).add(dSSPathname.cPart());
                ((Vector)object3).add(RMAIO.parseDouble((String)object[2]));
                ((Vector)object3).add(RMAIO.parseDouble((String)object[3]));
                ((Vector)object3).add(RMAIO.parseDouble((String)object[4]));
                this._resultsTable.appendRow((Vector)object3);
            }
            if (bl) break block27;
            if (object2 == null) return;
            try {
                ((BufferedReader)object2).close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        object = new StringBuffer();
        while ((object3 = ((BufferedReader)object2).readLine()) != null) {
            if (((String)object3).length() == 0) continue;
            ((StringBuffer)object).append(((String)object3).trim());
            ((StringBuffer)object).append("\n");
        }
        this._summaryFld.setText(((StringBuffer)object).toString());
        if (object2 == null) return;
        try {
            ((BufferedReader)object2).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (IOException iOException) {
            try {
                System.out.println("IOException " + String.valueOf(iOException));
                iOException.printStackTrace();
                if (object2 == null) return;
            }
            catch (Throwable throwable) {
                if (object2 == null) throw throwable;
                try {
                    ((BufferedReader)object2).close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ((BufferedReader)object2).close();
                return;
            }
            catch (IOException iOException3) {
                return;
            }
        }
    }

    private void fillAltInfo(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(list.get(i));
            stringBuffer.append("\n");
        }
        this._altInfoFld.setText(stringBuffer.toString());
    }
}

