/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AltDssOutputPanel$1;
import hec.rss.client.AlternativePanel;
import hec.rss.client.DssOutputPanel;
import hec.rss.model.DiversionElement;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;

public class AltDssOutputPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private RssAlt _alternative;
    private RmaJCheckBox _outputAllCheckbox;
    public RmaJCheckBox _outputAllInputCheckbox;
    private JTabbedPane _tabbedPane;
    private DssOutputPanel _reservoirPanel;
    private DssOutputPanel _reachesPanel;
    private DssOutputPanel _diversionPanel;
    private DssOutputPanel _junctionsPanel;
    private DssOutputPanel _stateVariablePanel;

    public AltDssOutputPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add(jPanel, gridBagConstraints);
        this._outputAllCheckbox = new RmaJCheckBox("Write All Computed Time Series");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)this._outputAllCheckbox, gridBagConstraints);
        this._outputAllCheckbox.addActionListener((ActionListener)new AltDssOutputPanel$1(this));
        this._outputAllCheckbox.setSelected(true);
        this._outputAllInputCheckbox = new RmaJCheckBox("Write All Interpolated Input Time Series");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)this._outputAllInputCheckbox, gridBagConstraints);
        this._outputAllInputCheckbox.setSelected(true);
        this._tabbedPane = new JTabbedPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltDssOutputPanel altDssOutputPanel = this;
        altDssOutputPanel.add(altDssOutputPanel._tabbedPane, gridBagConstraints);
        this._reservoirPanel = new DssOutputPanel("Reservoirs", this);
        this._reachesPanel = new DssOutputPanel("Reaches", this);
        this._diversionPanel = new DssOutputPanel("Diversions", this);
        this._junctionsPanel = new DssOutputPanel("Junctions", this);
        this._stateVariablePanel = new DssOutputPanel("State Variables", this);
        this._tabbedPane.add(this._reservoirPanel.getTabName(), (Component)((Object)this._reservoirPanel));
        this._tabbedPane.add(this._reachesPanel.getTabName(), (Component)((Object)this._reachesPanel));
        this._tabbedPane.add(this._diversionPanel.getTabName(), (Component)((Object)this._diversionPanel));
        this._tabbedPane.add(this._junctionsPanel.getTabName(), (Component)((Object)this._junctionsPanel));
        this._tabbedPane.add(this._stateVariablePanel.getTabName(), (Component)((Object)this._stateVariablePanel));
    }

    @Override
    public String getTabname() {
        return "DSS Output";
    }

    @Override
    public void clearPanel() {
        this._outputAllCheckbox.setSelected(true);
        this._reservoirPanel.clearPanel();
        this._reachesPanel.clearPanel();
        this._diversionPanel.clearPanel();
        this._junctionsPanel.clearPanel();
        this._stateVariablePanel.clearPanel();
    }

    public void writeAllCheckBoxAction() {
        boolean bl = !this._outputAllCheckbox.isSelected();
        this._tabbedPane.setEnabled(bl);
        this._reservoirPanel.setEnabled(bl);
        this._reachesPanel.setEnabled(bl);
        this._diversionPanel.setEnabled(bl);
        this._junctionsPanel.setEnabled(bl);
        this._stateVariablePanel.setEnabled(bl);
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
    }

    @Override
    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt) || object == null) {
            this._outputAllCheckbox.setSelected(true);
            return;
        }
        this._alternative = (RssAlt)object;
        this._outputAllCheckbox.setSelected(this._alternative.getWriteDSSOutputDataTable().writeAll());
        this._outputAllInputCheckbox.setSelected(this._alternative.getWriteDSSOutputDataTable().writeAllInputData());
        this._reservoirPanel.fillPanel(this._alternative.getSystem().getElementVectorByClass(ReservoirElement.class), this._alternative);
        this._reachesPanel.fillPanel(this._alternative.getSystem().getElementVectorByClass(ReachElement.class), this._alternative);
        this._diversionPanel.fillPanel(this._alternative.getSystem().getElementVectorByClass(DiversionElement.class), this._alternative);
        this._junctionsPanel.fillPanel(this._alternative.getSystem().getElementVectorByClass(JunctionElement.class), this._alternative);
        object = this._alternative.getSystem().getStateVariableList();
        Vector vector = new Vector();
        vector.addAll(object);
        this._stateVariablePanel.fillPanel(vector, this._alternative);
        AltDssOutputPanel altDssOutputPanel = this;
        altDssOutputPanel.setSystem(altDssOutputPanel._alternative.getSystem());
        EventQueue.invokeLater(() -> this.writeAllCheckBoxAction());
        this.setModified(false);
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        if (rssAlt == null) {
            return false;
        }
        rssAlt.getWriteDSSOutputDataTable().clear();
        rssAlt.getWriteDSSOutputDataTable().setWriteAllDSSOutput(this._outputAllCheckbox.isSelected());
        rssAlt.getWriteDSSOutputDataTable().setwriteAllInputData(this._outputAllInputCheckbox.isSelected());
        this._reservoirPanel.savePanel(rssAlt);
        this._reachesPanel.savePanel(rssAlt);
        this._diversionPanel.savePanel(rssAlt);
        this._junctionsPanel.savePanel(rssAlt);
        this._stateVariablePanel.savePanel(rssAlt);
        this.setModified(false);
        return true;
    }
}

