/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AltFirmYieldPanel$1;
import hec.rss.client.AltFirmYieldPanel$2;
import hec.rss.client.AltFirmYieldPanel$3;
import hec.rss.client.AltFirmYieldPanel$4;
import hec.rss.client.AltFirmYieldPanel$5;
import hec.rss.client.AltFirmYieldPanel$6;
import hec.rss.client.AltFirmYieldPanel$7;
import hec.rss.client.AltFirmYieldPanel$8;
import hec.rss.client.AltFirmYieldPanel$9;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.FirmYieldRuleRef;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.table.TableRowSorter;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableSorter;
import rma.swing.table.WildcardRowFilter;

public class AltFirmYieldPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private EnabledJPanel _contentPanel;
    private RmaJComboBox _nameFilterCombo;
    private RmaJComboBox _ruleFilterCombo;
    private RmaJComboBox _ruleTypeFilterCombo;
    private RmaJTable _elementTable;
    private RmaTableModel _elementTableModel;
    private RmaTableSorter _sorter;
    private JButton _selectButton;
    private RmaJTextField _selectedValueTxt;
    private JPanel _optionsPanel;
    private RmaJDecimalField _storToleranceFld;
    private RmaJDecimalField _ruleToleranceFld;
    private RmaJIntegerField _maxIterationFld;
    private RssSystem _network;
    private RssAlt _alternative;
    private RmaJTable _resZoneTable;
    private FirmYieldRuleRef _selectedRef;
    private ActionListener _al;
    private ItemListener _il;
    private AlternativeEditor _editor;

    public AltFirmYieldPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this._contentPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        this._contentPanel.setBorder((Border)BorderFactory.createTitledBorder("Select \"Demand\" Rule to Maximize"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)15, (int)0, (int)0);
        AltFirmYieldPanel altFirmYieldPanel = this;
        altFirmYieldPanel.add((Component)altFirmYieldPanel._contentPanel, gridBagConstraints);
        Object object = new JLabel("Filter");
        ((JLabel)object).setDisplayedMnemonic('F');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._contentPanel.add((Component)object, (Object)gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._contentPanel.add((Component)jPanel, (Object)gridBagConstraints);
        this._nameFilterCombo = new RmaJComboBox();
        this._nameFilterCombo.setEditable(true);
        ((JLabel)object).setLabelFor((Component)this._nameFilterCombo);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._nameFilterCombo, gridBagConstraints);
        this._ruleFilterCombo = new RmaJComboBox();
        this._ruleFilterCombo.setEditable(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._ruleFilterCombo, gridBagConstraints);
        this._ruleTypeFilterCombo = new RmaJComboBox();
        this._ruleTypeFilterCombo.setEditable(true);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._ruleTypeFilterCombo, gridBagConstraints);
        object = new String[]{"Location", "Rule", "Rule Type"};
        AltFirmYieldPanel altFirmYieldPanel2 = this;
        this._elementTable = new AltFirmYieldPanel$1(altFirmYieldPanel2, (Component)((Object)altFirmYieldPanel2), (Object[])object);
        this._elementTable.setEditable(false);
        this._elementTable.setAddRemoveEnabled(false);
        this._elementTable.setRowHeight(this._elementTable.getRowHeight() + 5);
        this._elementTable.setSelectionMode(0);
        this._elementTable.setColumnSelectionAllowed(false);
        this._elementTable.setCellSelectionEnabled(false);
        this._elementTable.setRowSelectionAllowed(true);
        this._elementTableModel = (RmaTableModel)this._elementTable.getModel();
        object = new TableRowSorter<RmaTableModel>(this._elementTableModel);
        this._elementTable.setRowSorter((RowSorter)object);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.75;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._contentPanel.add((Component)this._elementTable.getScrollPane(), (Object)gridBagConstraints);
        this._selectButton = new JButton("Select");
        this._selectButton.setMnemonic('S');
        this._selectButton.setEnabled(false);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._contentPanel.add((Component)this._selectButton, (Object)gridBagConstraints);
        object = new JLabel("Selected Rule");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
        this._contentPanel.add((Component)object, (Object)gridBagConstraints);
        this._selectedValueTxt = new AltFirmYieldPanel$2(this);
        this._selectedValueTxt.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)2, (int)5, (int)0, (int)5);
        this._contentPanel.add((Component)this._selectedValueTxt, (Object)gridBagConstraints);
        AltFirmYieldPanel altFirmYieldPanel3 = this;
        this._resZoneTable = new AltFirmYieldPanel$3(altFirmYieldPanel3, (Component)((Object)altFirmYieldPanel3), new String[]{"Reservoir", "Operations Set", "Zone"});
        this._resZoneTable.setEditable(false);
        this._resZoneTable.setAddRemoveEnabled(false);
        this._resZoneTable.setRowHeight(this._resZoneTable.getRowHeight() + 5);
        this._resZoneTable.deleteCells();
        this._resZoneTable.setColumnEnabled(false, 0);
        this._resZoneTable.setColumnEnabled(false, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.75;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._contentPanel.add((Component)this._resZoneTable.getScrollPane(), (Object)gridBagConstraints);
        this._optionsPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._contentPanel.add((Component)this._optionsPanel, (Object)gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._optionsPanel.add((Component)new JSeparator(), gridBagConstraints);
        object = new JLabel("Maximum Iterations:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._optionsPanel.add((Component)object, gridBagConstraints);
        this._maxIterationFld = new RmaJIntegerField();
        this._maxIterationFld.setMinValue(0);
        ((JLabel)object).setLabelFor((Component)this._maxIterationFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._optionsPanel.add((Component)this._maxIterationFld, gridBagConstraints);
        object = new JLabel("Storage Test Tolerance:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._optionsPanel.add((Component)object, gridBagConstraints);
        this._storToleranceFld = new RmaJDecimalField();
        this._storToleranceFld.setMinValue(0.0);
        ((JLabel)object).setLabelFor((Component)this._storToleranceFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._optionsPanel.add((Component)this._storToleranceFld, gridBagConstraints);
        object = new JLabel("Rule Test Tolerance:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._optionsPanel.add((Component)object, gridBagConstraints);
        this._ruleToleranceFld = new RmaJDecimalField();
        this._ruleToleranceFld.setMinValue(0.0);
        ((JLabel)object).setLabelFor((Component)this._ruleToleranceFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._optionsPanel.add((Component)this._ruleToleranceFld, gridBagConstraints);
    }

    protected void addListeners() {
        this._selectButton.addActionListener(new AltFirmYieldPanel$4(this));
        this._elementTable.getSelectionModel().addListSelectionListener(new AltFirmYieldPanel$5(this));
        AltFirmYieldPanel$6 altFirmYieldPanel$6 = new AltFirmYieldPanel$6(this);
        AltFirmYieldPanel$7 altFirmYieldPanel$7 = new AltFirmYieldPanel$7(this);
        this._nameFilterCombo.getActionMap().put("filter", altFirmYieldPanel$7);
        this._nameFilterCombo.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "filter");
        this._ruleFilterCombo.getActionMap().put("filter", altFirmYieldPanel$7);
        this._ruleFilterCombo.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "filter");
        this._ruleTypeFilterCombo.getActionMap().put("filter", altFirmYieldPanel$7);
        this._ruleTypeFilterCombo.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "filter");
        this._al = new AltFirmYieldPanel$8(this);
        this._il = new AltFirmYieldPanel$9(this);
        this._nameFilterCombo.addFocusListener((FocusListener)altFirmYieldPanel$6);
        this._ruleFilterCombo.addFocusListener((FocusListener)altFirmYieldPanel$6);
        this._ruleTypeFilterCombo.addFocusListener((FocusListener)altFirmYieldPanel$6);
        this._nameFilterCombo.addActionListener(this._al);
        this._ruleFilterCombo.addActionListener(this._al);
        this._ruleTypeFilterCombo.addActionListener(this._al);
        this._nameFilterCombo.addItemListener(this._il);
        this._ruleFilterCombo.addItemListener(this._il);
        this._ruleTypeFilterCombo.addItemListener(this._il);
    }

    void filterTable(Object object) {
        Object object2 = null;
        String string = null;
        String string2 = null;
        if (object == this._nameFilterCombo) {
            object = this._nameFilterCombo.getSelectedItem();
            if (object != null) {
                object2 = object.toString();
            }
            string = (String)this._ruleFilterCombo.getSelectedItem();
            string2 = (String)this._ruleTypeFilterCombo.getSelectedItem();
        } else if (object == this._ruleFilterCombo) {
            object = this._ruleFilterCombo.getSelectedItem();
            if (object != null) {
                string = object.toString();
            }
            string2 = (String)this._ruleTypeFilterCombo.getSelectedItem();
            object2 = (String)this._nameFilterCombo.getSelectedItem();
        } else if (object == this._ruleTypeFilterCombo) {
            object = this._ruleTypeFilterCombo.getSelectedItem();
            if (object != null) {
                string2 = object.toString();
            }
            object2 = (String)this._nameFilterCombo.getSelectedItem();
            string = (String)this._ruleFilterCombo.getSelectedItem();
        }
        object = new ArrayList<Object>(3);
        if (object2 != null && ((String)object2).length() > 0) {
            object2 = new WildcardRowFilter((String)object2, 0);
            object.add(object2);
        }
        if (string != null && string.length() > 0) {
            object2 = new WildcardRowFilter(string, 1);
            object.add(object2);
        }
        if (string2 != null && string2.length() > 0) {
            object2 = new WildcardRowFilter(string2, 2);
            object.add(object2);
        }
        if (object.size() > 0) {
            object2 = RowFilter.andFilter(object);
            ((TableRowSorter)this._elementTable.getRowSorter()).setRowFilter(object2);
            return;
        }
        ((TableRowSorter)this._elementTable.getRowSorter()).setRowFilter(null);
    }

    protected void updateSelectButtonStateAction() {
        int n = this._elementTable.getSelectedRow();
        this._selectButton.setEnabled(n != -1);
    }

    protected void selectLocationAction() {
        int n = this._elementTable.getSelectedRow();
        this.setModified(true);
        if (n == -1) {
            this._selectedRef = null;
            AltFirmYieldPanel altFirmYieldPanel = this;
            altFirmYieldPanel.updateSelectedValueField(altFirmYieldPanel._selectedRef);
            return;
        }
        FirmYieldRuleRef firmYieldRuleRef = (FirmYieldRuleRef)this._elementTableModel.getValueAt(n, 0);
        if (firmYieldRuleRef == null) {
            this._selectedRef = null;
            AltFirmYieldPanel altFirmYieldPanel = this;
            altFirmYieldPanel.updateSelectedValueField(altFirmYieldPanel._selectedRef);
            return;
        }
        this._selectedRef = firmYieldRuleRef;
        AltFirmYieldPanel altFirmYieldPanel = this;
        altFirmYieldPanel.updateSelectedValueField(altFirmYieldPanel._selectedRef);
        this.fillReservoirTable();
    }

    private void updateSelectedValueField(FirmYieldRuleRef object) {
        if (object == null || ((FirmYieldRuleRef)object).a() == null) {
            this._selectedValueTxt.setText("");
            return;
        }
        object = this._selectedRef.c() + " - " + this._selectedRef.d() + " - " + this._selectedRef.e();
        this._selectedValueTxt.setText((String)object);
    }

    private void fillReservoirTable() {
        this._resZoneTable.deleteCells();
        if (this._selectedRef == null) {
            return;
        }
        List<ReservoirElement> list = this._selectedRef.a(this._alternative);
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Cloneable cloneable = list.get(i);
            int n2 = this._alternative.getResOpSetSelection(cloneable.getIndex());
            OpSet opSet = cloneable.getReservoirOp().getOperationSet(n2);
            if (opSet == null) continue;
            Vector<NamedType> vector = new Vector<NamedType>(3);
            vector.add((NamedType)cloneable);
            vector.add(opSet);
            this._resZoneTable.appendRow(vector);
            cloneable = opSet.getZoneVector();
            this._resZoneTable.setComboBoxRowEditor(n, 2, (Vector)cloneable);
            ++n;
        }
    }

    @Override
    public void fillPanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)namedType;
    }

    private void fillReservoirTable(List<StorageZoneRef> list) {
        int n = this._resZoneTable.getRowCount();
        block0: for (int i = 0; i < list.size(); ++i) {
            StorageZone storageZone;
            StorageZoneRef storageZoneRef = list.get(i);
            if (storageZoneRef == null || (storageZone = storageZoneRef.getStorageZone()) == null) continue;
            ReservoirElement reservoirElement = storageZone.getReservoirElement();
            OpSet opSet = storageZone.getOpSet();
            for (int j = 0; j < n; ++j) {
                ReservoirElement reservoirElement2 = (ReservoirElement)this._resZoneTable.getValueAt(j, 0);
                OpSet opSet2 = (OpSet)this._resZoneTable.getValueAt(j, 1);
                if (reservoirElement2 != reservoirElement || opSet2.getIndex() != opSet.getIndex()) continue;
                this._resZoneTable.setValueAt((Object)storageZone, j, 2);
                continue block0;
            }
        }
    }

    private void fillCombos(String string, String string2, String string3) {
        this.getFilterString(string);
        this.getFilterString(string2);
        this.getFilterString(string3);
        RmaListModel rmaListModel = new RmaListModel(false);
        rmaListModel.addElement((Object)"");
        RmaListModel rmaListModel2 = new RmaListModel(false);
        rmaListModel2.addElement((Object)"");
        RmaListModel rmaListModel3 = new RmaListModel(false);
        rmaListModel3.addElement((Object)"");
        int n = this._elementTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = (FirmYieldRuleRef)this._elementTable.getValueAt(i, 0);
            if (object == null) continue;
            String string4 = ((FirmYieldRuleRef)object).toString();
            String string5 = ((FirmYieldRuleRef)object).d();
            object = ((FirmYieldRuleRef)object).e();
            this.addToList(rmaListModel3, (String)object);
            this.addToList(rmaListModel, string4);
            this.addToList(rmaListModel2, string5);
        }
        this._nameFilterCombo.removeActionListener(this._al);
        this._ruleFilterCombo.removeActionListener(this._al);
        this._ruleTypeFilterCombo.removeActionListener(this._al);
        this._nameFilterCombo.removeItemListener(this._il);
        this._ruleFilterCombo.removeItemListener(this._il);
        this._ruleTypeFilterCombo.removeItemListener(this._il);
        this._nameFilterCombo.setModel((ComboBoxModel)rmaListModel);
        this._ruleFilterCombo.setModel((ComboBoxModel)rmaListModel2);
        this._ruleTypeFilterCombo.setModel((ComboBoxModel)rmaListModel3);
        this._nameFilterCombo.setSelectedItem((Object)string);
        this._ruleFilterCombo.setSelectedItem((Object)string2);
        this._ruleTypeFilterCombo.setSelectedItem((Object)string3);
        this._nameFilterCombo.addActionListener(this._al);
        this._ruleFilterCombo.addActionListener(this._al);
        this._ruleTypeFilterCombo.addActionListener(this._al);
        this._nameFilterCombo.addItemListener(this._il);
        this._ruleFilterCombo.addItemListener(this._il);
        this._ruleTypeFilterCombo.addItemListener(this._il);
    }

    private boolean passesFilter(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.toLowerCase().startsWith(string2);
    }

    private void addToList(RmaListModel rmaListModel, String string) {
        if (!rmaListModel.contains((Object)string)) {
            rmaListModel.addElement((Object)string);
        }
    }

    private String getFilterString(String string) {
        if (string != null) {
            return string.toLowerCase();
        }
        return "";
    }

    @Override
    public String getTabname() {
        return "Firm Yield";
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        AltFirmYieldPanel altFirmYieldPanel = this;
        return altFirmYieldPanel.savePanel(altFirmYieldPanel._alternative);
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        if (rssAlt == null) {
            rssAlt = this._alternative;
        }
        if (rssAlt == null) {
            return true;
        }
        if (this._selectedRef != null) {
            int n = this._resZoneTable.getRowCount();
            ArrayList<StorageZoneRef> arrayList = new ArrayList<StorageZoneRef>();
            this._resZoneTable.commitEdit(true);
            for (int i = 0; i < n; ++i) {
                Cloneable cloneable;
                if (!(this._resZoneTable.getValueAt(i, 2) instanceof StorageZone) || (cloneable = (StorageZone)this._resZoneTable.getValueAt(i, 2)) == null) continue;
                cloneable = new StorageZoneRef((StorageZone)cloneable);
                arrayList.add((StorageZoneRef)cloneable);
            }
            this._selectedRef.a(arrayList);
        }
        return true;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._network = rssSystem;
    }

    @Override
    public void clearPanel() {
        this._maxIterationFld.clearPerformed();
        this._storToleranceFld.clearPerformed();
        this._ruleToleranceFld.clearPerformed();
        this._elementTable.clearPerformed();
        this._selectedValueTxt.clearPerformed();
        this._resZoneTable.clearPerformed();
    }

    public void updateReservoirZones(ReservoirElement reservoirElement, OpSet opSet) {
        if (reservoirElement == null) {
            return;
        }
        for (int i = 0; i < this._resZoneTable.getRowCount(); ++i) {
            Object object = (ReservoirElement)this._resZoneTable.getValueAt(i, 0);
            if (object != reservoirElement || (object = (OpSet)this._resZoneTable.getValueAt(i, 1)) == opSet) continue;
            StorageZone storageZone = (StorageZone)this._resZoneTable.getValueAt(i, 2);
            this._resZoneTable.setValueAt((Object)opSet, i, 1);
            if (opSet == null) {
                this._resZoneTable.setComboBoxRowEditor(i, 2, new Vector(0));
                this._resZoneTable.setValueAt(null, i, 2);
                return;
            }
            object = opSet.getZoneVector();
            this._resZoneTable.setComboBoxRowEditor(i, 2, (Vector)object);
            if (storageZone != null) {
                String string = storageZone.getName();
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    storageZone = (StorageZone)((Vector)object).get(j);
                    if (!string.equals(storageZone.getName())) continue;
                    this._resZoneTable.setValueAt((Object)storageZone, i, 2);
                    return;
                }
                this._resZoneTable.setValueAt(null, i, 2);
                continue;
            }
            this._resZoneTable.setValueAt(null, i, 2);
        }
    }
}

