/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.model.ModelVariable;
import hec.rss.client.AltHindcastPanel$1;
import hec.rss.client.AltHindcastPanel$2;
import hec.rss.client.AltHindcastPanel$TypeComboItemListener;
import hec.rss.client.AltHindcastPanel$TypeComboListCellRenderer;
import hec.rss.client.AlternativePanel;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.ControlStructure;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.HindcastData;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.table.ComboBoxRenderer;
import rma.swing.table.RmaCellEditor;

public class AltHindcastPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private static Color f = UIManager.getColor("TextField.disabledBackground");
    protected static final String a = "<html>The <b>" + HindcastData.e + "</b> option may only be applied to one controlled outlet of a reservoir.  It will<br>use the lookback reservoir elevation (or storage) along with the known inflows to calculate the<br>total lookback release for each timestep of the lookback period and apply these releases to <i>this</i><br>outlet only.  The lookback release for all other outlets will be set to Constant with a value of 0.0<br> and the fields will be disabled.<br>To reenable the lookback release options for the other outlets, select a different lookback option<br>for this outlet.</html>";
    protected static final String b = "<html>Sets the first value of the of lookback reservoir elevation/storage<br>with the constant, and calculates the rest of the time series based<br>on the mass balance of net inflow and total release.</html>";
    protected static final String c = "<html>Sets the first value of the of lookback reservoir elevation/storage<br>with the value from the reservoir guide curve and calculates the rest of<br>the timeseries based on the mass balance of net inflow and total release.</html>";
    protected static final String d = "<html>Sets the first value of the of lookback reservoir elevation/storage<br>with a value from an input time series and calculates the rest of the<br>lookback based on the mass balance of net inflow and total release.</html>";
    protected static final String e = "<html>The <b>" + HindcastData.e + "</b> lookback option uses the mass balance equation, the Lookback Elevation,<br>and Known Inflow to compute the total reservoir release for Reservoir: <b>{0}</b> for each<br>timestep of the lookback period.  That total release will be applied to Outlet: <b>{1}</b>.  All<br>other outlets will be set to Constant: 0.0.  These include:{2}</html>";
    RssAlt m_alternative;
    RssSystem m_system;
    RmaJTable _hindcastTable;
    private boolean DEBUG;
    private List<HindcastData> _systemHindcastVec;
    private List<HindcastData> _altHindcastVec;
    private boolean _updatingOutlets;
    private boolean _confirmingLookbackElev;

    public AltHindcastPanel() {
        AltHindcastPanel altHindcastPanel = this;
        this._hindcastTable = new AltHindcastPanel$1(altHindcastPanel, (Component)((Object)altHindcastPanel), new String[]{"Location", "Variable", "Type", "Value"});
        this.DEBUG = Boolean.getBoolean("DEBUG");
        this._systemHindcastVec = null;
        this._altHindcastVec = null;
        try {
            this.jbInit();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this.m_system = rssSystem;
        this.initializeTable();
    }

    public void setPanelEnabled(boolean bl) {
    }

    @Override
    public String getTabname() {
        return "Lookback";
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        this.m_alternative = rssAlt;
        return this.savePanel();
    }

    public boolean savePanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return false;
        }
        return this.savePanel((RssAlt)namedType);
    }

    public boolean savePanel() {
        if (this.m_alternative == null) {
            return true;
        }
        if (this._systemHindcastVec == null) {
            return true;
        }
        this._hindcastTable.commitEdit(true);
        Vector<HindcastData> vector = new Vector<HindcastData>();
        for (int i = 0; i < this._hindcastTable.getNumRows() && i < this._systemHindcastVec.size(); ++i) {
            Object object = this._systemHindcastVec.get(i);
            HindcastData hindcastData = (HindcastData)((HindcastData)object).clone();
            String string = (String)this._hindcastTable.getCell(i, 2);
            if (string.equals(HindcastData.b)) {
                hindcastData.setType(1);
                object = this._hindcastTable.getCell(i, 3);
                if (object instanceof ParamDouble) {
                    hindcastData.setValue(((ParamDouble)object).getValue());
                } else if (string != null) {
                    hindcastData.setValue(object.toString());
                }
            } else if (HindcastData.a.equals(string)) {
                hindcastData.setType(0);
            } else if (HindcastData.d.equals(string)) {
                hindcastData.setType(3);
            } else if (HindcastData.e.equals(string)) {
                hindcastData.setType(4);
            } else if (HindcastData.f.equals(string)) {
                hindcastData.setType(5);
                object = this._hindcastTable.getCell(i, 3);
                if (object instanceof ParamDouble) {
                    hindcastData.setValue(((ParamDouble)object).getValue());
                } else if (string != null) {
                    hindcastData.setValue(object.toString());
                }
            } else if (HindcastData.g.equals(string)) {
                hindcastData.setType(6);
            } else if (HindcastData.h.equals(string)) {
                hindcastData.setType(7);
            } else {
                hindcastData.setType(2);
            }
            vector.add(hindcastData);
        }
        this.m_alternative.setHindcastData(vector);
        this.m_alternative.setModified(true);
        this.setModified(false);
        return true;
    }

    @Override
    public void fillPanel(NamedType object) {
        int n;
        this._hindcastTable.setHorizontalAlignment(4, 3);
        if (!(object instanceof RssAlt)) {
            if (this.DEBUG) {
                System.out.println("Error occurred in " + this.getClass().getName() + ".fillPanel()! Recieved an object\nthat is not of type hec.rss.model.RssAlt");
            }
            return;
        }
        this.m_alternative = (RssAlt)object;
        this._altHindcastVec = this.m_alternative.getHindcastData();
        if (this._altHindcastVec == null || this._altHindcastVec.size() == 0) {
            this.setIgnoreModifiedEvents(false);
            return;
        }
        object = new HashSet();
        for (n = 0; n < this._hindcastTable.getNumRows(); ++n) {
            object.add(n);
        }
        for (n = 0; n < this._altHindcastVec.size(); ++n) {
            HindcastData hindcastData = this._altHindcastVec.get(n);
            for (int i = 0; i < this._hindcastTable.getNumRows(); ++i) {
                HindcastData hindcastData2 = this._systemHindcastVec.get(i);
                if (!hindcastData.getObjectKey().equals(hindcastData2.getObjectKey()) || hindcastData.getVariableId() != hindcastData2.getVariableId()) continue;
                this.setComboBoxEditorForRow(hindcastData, hindcastData2, i);
                object.remove(i);
            }
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            HindcastData hindcastData;
            int n2 = (Integer)iterator.next();
            HindcastData hindcastData3 = hindcastData = this._systemHindcastVec.get(n2);
            this.setComboBoxEditorForRow(hindcastData3, hindcastData3, n2);
        }
        for (int i = 0; i < this._hindcastTable.getNumRows(); ++i) {
            String string = (String)this._hindcastTable.getValueAt(i, 2);
            if (!HindcastData.e.equals(string)) continue;
            this.checkReservoirOutlets(string, i);
        }
        this.setModified(false);
    }

    protected void setComboBoxEditorForRow(HindcastData hindcastData, HindcastData paramDouble, int n) {
        ModelVariable modelVariable = RssModelVariableSet.getModelVariable(paramDouble.getVariableId());
        this._hindcastTable.setCell((Object)hindcastData.getTypeName(), n, 2);
        if (modelVariable == null) {
            this._hindcastTable.setCell((Object)hindcastData.getValueString(), n, 3);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(HindcastData.b);
            vector.add(HindcastData.a);
            if (paramDouble.getVariableId() == 14 || paramDouble.getVariableId() == 15) {
                vector.add(HindcastData.d);
                vector.add(HindcastData.f);
                vector.add(HindcastData.g);
                vector.add(HindcastData.h);
                paramDouble = this.getComboBoxForTable(vector);
                this._hindcastTable.setComboBoxCellEditor(n, 2, (RmaJComboBox)paramDouble);
            } else if (paramDouble.getVariableId() == 41) {
                vector.add(HindcastData.e);
                paramDouble = this.getComboBoxForTable(vector);
                this._hindcastTable.setComboBoxCellEditor(n, 2, paramDouble);
            } else if (paramDouble.getVariableId() == 195) {
                vector.add(HindcastData.c);
                paramDouble = this.getComboBoxForTable(vector);
                this._hindcastTable.setComboBoxCellEditor(n, 2, (RmaJComboBox)paramDouble);
            }
            paramDouble = new ParamDouble(hindcastData.getValue(), modelVariable.getParamId(), this.m_alternative.getUnitSystem());
            this._hindcastTable.setCell((Object)paramDouble, n, 3);
        }
        if (hindcastData.getType() == 1 || hindcastData.getType() == 5) {
            this._hindcastTable.setCellEnabled(true, n, 3);
            this._hindcastTable.setCellEnabled(true, n, 2);
            this._hindcastTable.setCellBackground(n, 3, Color.white);
            return;
        }
        this._hindcastTable.setCellEnabled(false, n, 3);
        this._hindcastTable.setCellBackground(n, 3, f);
    }

    public void clearPanel(boolean bl) {
        if (bl) {
            this._hindcastTable.commitEdit(true);
            this._hindcastTable.deleteCells();
            this._hindcastTable.commitEdit(false);
            return;
        }
        this.initializeTable();
    }

    private void hindcastComboChanged(String string, int n) {
        if (HindcastData.b.equals(string) || HindcastData.f.equals(string)) {
            this._hindcastTable.setCellEnabled(true, n, 3);
            this._hindcastTable.setCellBackground(n, 3, Color.white);
        } else {
            this._hindcastTable.setCellEnabled(false, n, 3);
            this._hindcastTable.setCellBackground(n, 3, f);
        }
        if (HindcastData.e.equals(string)) {
            this.confirmLookbackElev();
            return;
        }
        this.updateHindcastComboChange(string, n);
    }

    private void updateHindcastComboChange(String object, int n) {
        if (this._systemHindcastVec != null && (object = this._systemHindcastVec.get(n)) != null) {
            if (((HindcastData)object).getVariableId() == 14) {
                int n2 = this._systemHindcastVec.size();
                for (n = 0; n < n2; ++n) {
                    HindcastData hindcastData = this._systemHindcastVec.get(n);
                    if (!hindcastData.getObjectKey().equals(((HindcastData)object).getObjectKey()) || hindcastData.getVariableId() != 15) continue;
                    this._hindcastTable.setCell((Object)HindcastData.c, n, 2);
                    this._hindcastTable.setCellEnabled(false, n, 3);
                    this._hindcastTable.setCellBackground(n, 3, f);
                    break;
                }
            } else if (((HindcastData)object).getVariableId() == 15) {
                int n3 = this._systemHindcastVec.size();
                for (n = 0; n < n3; ++n) {
                    HindcastData hindcastData = this._systemHindcastVec.get(n);
                    if (!hindcastData.getObjectKey().equals(((HindcastData)object).getObjectKey()) || hindcastData.getVariableId() != 14) continue;
                    this._hindcastTable.setCell((Object)HindcastData.c, n, 2);
                    this._hindcastTable.setCellEnabled(false, n, 3);
                    this._hindcastTable.setCellBackground(n, 3, f);
                    break;
                }
            }
        }
        this._hindcastTable.repaint();
    }

    void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        Vector<String> vector = new Vector<String>();
        vector.add(HindcastData.b);
        vector.add(HindcastData.a);
        vector = this.getComboBoxForTable(vector);
        RmaCellEditor rmaCellEditor = new RmaCellEditor(vector);
        rmaCellEditor.setClickCountToStart(1);
        vector.setBorder(null);
        this._hindcastTable.getColumnModel().getColumn(2).setCellEditor((TableCellEditor)rmaCellEditor);
        this._hindcastTable.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new ComboBoxRenderer());
        this._hindcastTable.setDoubleCellEditor(3, true);
        this._hindcastTable.setPrecision(2);
        this._hindcastTable.setPasteAddsRows(false);
        this._hindcastTable.setColumnWidths(new int[]{192, 150, 210, 85});
        this._hindcastTable.setUnitsHeaderRenderer();
        vector.setSelectedItem(HindcastData.b);
        this._hindcastTable.setColumnEnabled(false, 0);
        this._hindcastTable.setColumnEnabled(false, 1);
        this._hindcastTable.setColumnBackground(0, f);
        this._hindcastTable.setColumnBackground(1, f);
        AltHindcastPanel altHindcastPanel = this;
        altHindcastPanel.add(altHindcastPanel._hindcastTable.getScrollPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets((int)5, (int)5, (int)5, (int)5), 0, 0));
        this._hindcastTable.setAddRemoveEnabled(false);
        this._hindcastTable.setRowHeight(this._hindcastTable.getRowHeight() + 5);
        this._hindcastTable.removePopupMenuSumOptions();
        this._hindcastTable.removePopupMenuRowEditingOptions();
    }

    public void confirmLookbackElev() {
        this._confirmingLookbackElev = true;
        int n = this._hindcastTable.getSelectedRow();
        String string = (String)this._hindcastTable.getValueAt(n, 2);
        EventQueue.invokeLater(() -> this.confirmLookbackElev(n, string));
    }

    private void confirmLookbackElev(int n, String string) {
        try {
            Object object;
            Object object2 = this._systemHindcastVec.get(n);
            object2 = ((HindcastData)object2).getObjectKey();
            object2 = this.m_system.getObjectForKeyString((String)object2);
            String string2 = "unknown";
            String string3 = "unknown";
            if (object2 instanceof AdjustableFlow) {
                object2 = ((AdjustableFlow)object2).getElement();
                string3 = object2.getName();
            }
            if (object2 instanceof Element) {
                object2 = (Element)object2;
                do {
                    if ((object = ((Element)object2).getParent()) == null) continue;
                    object2 = object;
                } while (object != null && !(object2 instanceof ReservoirElement));
                if (object instanceof ReservoirElement) {
                    string2 = ((ReservoirElement)object).getName();
                }
            }
            int n2 = this._systemHindcastVec.size();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<ul>");
            for (int i = 0; i < n2; ++i) {
                if (i == n) continue;
                object = this._systemHindcastVec.get(i);
                if ((object = this.findReservoirForHindcastData((HindcastData)object)) == null || !object.getName().equals(string2)) continue;
                stringBuilder.append("<li>");
                stringBuilder.append(this._hindcastTable.getValueAt(i, 0));
                stringBuilder.append("</li>");
            }
            stringBuilder.append("</ul>");
            String string4 = e;
            string4 = MessageFormat.format(string4, string2, string3, stringBuilder.toString());
            n2 = JOptionPane.showOptionDialog((Component)((Object)this), string4, "Confirm Selection", 0, -1, null, new Object[]{"Continue", "Cancel"}, "Continue");
            if (n2 == 0) {
                this.updateHindcastComboChange(HindcastData.e, n);
                this.checkReservoirOutlets(HindcastData.e, n);
            } else {
                this._hindcastTable.setValueAt((Object)string, n, 2);
                this.hindcastComboChanged(string, n);
            }
            return;
        }
        finally {
            this._confirmingLookbackElev = false;
        }
    }

    private RmaJComboBox<String> getComboBoxForTable(Vector<String> object) {
        object = new AltHindcastPanel$2(this, (Vector)object);
        ListCellRenderer listCellRenderer = object.getRenderer();
        object.setRenderer(new AltHindcastPanel$TypeComboListCellRenderer(this, listCellRenderer));
        object.setToolTipText(" ");
        object.addItemListener(new AltHindcastPanel$TypeComboItemListener(this));
        return object;
    }

    public ReservoirElement findReservoirForHindcastData(HindcastData object) {
        object = ((HindcastData)object).getObjectKey();
        if ((object = this.m_system.getObjectForKeyString((String)object)) instanceof ControlStructure) {
            object = (Function)object;
            object = ((Function)object).getElement();
            while (object != null) {
                if (!(object instanceof ReservoirElement)) {
                    object = ((Element)object).getParent();
                    continue;
                }
                if (!(object instanceof ReservoirElement)) continue;
                return (ReservoirElement)object;
            }
        }
        return null;
    }

    private void initializeTable() {
        this._hindcastTable.setNumRows(0);
        this._hindcastTable.deleteCells();
        if (this.m_system == null) {
            return;
        }
        this._systemHindcastVec = this.m_system.getHindcastDataList();
        if (this._systemHindcastVec == null) {
            this._hindcastTable.setNumRows(0);
            return;
        }
        int n = this._systemHindcastVec.size();
        for (int i = 0; i < n; ++i) {
            HindcastData hindcastData = this._systemHindcastVec.get(i);
            if (hindcastData == null) continue;
            Vector<String> vector = new Vector<String>();
            vector.addElement(this.m_system.getNameForKeyString(hindcastData.getObjectKey()));
            vector.addElement(RssModelVariableSet.getVariableName(hindcastData.getVariableId()));
            vector.addElement(hindcastData.getTypeName());
            vector.addElement(hindcastData.getValueString());
            this._hindcastTable.appendRow(vector);
            if (hindcastData.getType() == 1 || hindcastData.getType() == 5) {
                this._hindcastTable.setCellEnabled(true, i, 3);
                this._hindcastTable.setCellBackground(i, 3, Color.white);
                continue;
            }
            this._hindcastTable.setCellEnabled(false, i, 3);
            this._hindcastTable.setCellBackground(i, 3, f);
        }
    }

    @Override
    public void clearPanel() {
    }

    public void checkReservoirOutlets(Object object, int n) {
        if (this._updatingOutlets) {
            return;
        }
        this._updatingOutlets = true;
        try {
            boolean bl;
            Cloneable cloneable = this._systemHindcastVec.get(n);
            cloneable = this.findReservoirForHindcastData((HindcastData)cloneable);
            boolean bl2 = bl = !HindcastData.e.equals(object);
            if (cloneable != null) {
                int n2 = this._hindcastTable.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    if (i == n) continue;
                    Cloneable cloneable2 = this._systemHindcastVec.get(i);
                    if ((cloneable2 = this.findReservoirForHindcastData((HindcastData)cloneable2)) != cloneable) continue;
                    if (!bl) {
                        this._hindcastTable.setValueAt((Object)HindcastData.b, i, 2);
                        this._hindcastTable.setValueAt((Object)0.0, i, 3);
                    }
                    this._hindcastTable.setCellEnabled(bl, i, 2);
                    this._hindcastTable.setCellEnabled(bl, i, 3);
                }
            }
            return;
        }
        finally {
            this._updatingOutlets = false;
        }
    }

    private static String a(String string) {
        if (HindcastData.e.equals(string)) {
            return a;
        }
        if (HindcastData.f.equals(string)) {
            return b;
        }
        if (HindcastData.h.equals(string)) {
            return c;
        }
        if (HindcastData.g.equals(string)) {
            return d;
        }
        return null;
    }
}

