/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gui.AbstractEditorPanel;
import hec.heclib.util.HecTime;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.rss.client.AltHotstartPanel$1;
import hec.rss.client.AltHotstartPanel$2;
import hec.rss.client.AltHotstartPanel$3;
import hec.rss.client.AltHotstartPanel$4;
import hec.rss.client.AltHotstartPanel$5;
import hec.rss.client.AltHotstartPanel$6;
import hec.rss.client.AltHotstartPanel$7;
import hec.rss.client.AltHotstartPanel$8;
import hec.rss.client.AltHotstartPanel$TimeStep;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.HotstartOptions;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.DateTimePanel;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class AltHotstartPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private JPanel _createPanel;
    private RmaJCheckBox _createHotstartCheck;
    private RmaJCheckBox _saveAtEndCheck;
    private RmaJCheckBox _saveAtIntervalCheck;
    private JLabel _intervalLabel;
    private Vector<AltHotstartPanel$TimeStep> _intervals;
    private RmaJComboBox _intervalCombo;
    private RmaJDecimalField _timeStepSaveFld;
    private JPanel _loadPanel;
    private RmaJCheckBox _loadHotstartCheck;
    private RmaJComboBox _altNameCombo;
    private RssSystem _system;
    private RssAlt _rssAlt;
    private EnabledJPanel _intervalPanel;
    private DateTimePanel _intervalDatePanel;
    private RmaJCheckBox _saveAtDateTimeCheck;
    private DateTimePanel _saveAtDatePanel;
    private RmaJCheckBox _saveAtLookbackCheck;
    private AlternativeEditor _editor;

    public AltHotstartPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
        this._editor = alternativeEditor;
    }

    protected void buildControls() {
        this._createPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        this._createPanel.setBorder(BorderFactory.createTitledBorder("Create Hotstart File"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        AltHotstartPanel altHotstartPanel = this;
        altHotstartPanel.add(altHotstartPanel._createPanel, gridBagConstraints);
        this.buildCreatePanel();
        this._loadPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        this._loadPanel.setBorder(BorderFactory.createTitledBorder("Read Hotstart File"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        AltHotstartPanel altHotstartPanel2 = this;
        altHotstartPanel2.add(altHotstartPanel2._loadPanel, gridBagConstraints);
        this.buildLoadPanel();
        this.saveAtDateTimeCheckAction();
        this.createHotstartCheckAction();
        this.saveAtIntervalCheckAction();
        this.loadHotstartCheckAction();
    }

    protected void buildCreatePanel() {
        this._createHotstartCheck = new AltHotstartPanel$1(this, "Create Hotstart File");
        this._createHotstartCheck.setMnemonic('C');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this._createPanel.add((Component)this._createHotstartCheck, gridBagConstraints);
        JComponent jComponent = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._createPanel.add((Component)jComponent, gridBagConstraints);
        JLabel jLabel = new JLabel("Number of Hours to Save (for Rule Lookback):");
        jLabel.setDisplayedMnemonic('T');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
        jComponent.add((Component)jLabel, gridBagConstraints);
        this._timeStepSaveFld = new RmaJDecimalField();
        this._timeStepSaveFld.setMinValue(0.0);
        this._timeStepSaveFld.setPrecision(2);
        jLabel.setLabelFor((Component)this._timeStepSaveFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0E-4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._timeStepSaveFld, gridBagConstraints);
        jLabel = new JLabel(" ");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jComponent.add((Component)jLabel, gridBagConstraints);
        jComponent = new JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)20, (int)0, (int)5);
        this._createPanel.add((Component)jComponent, gridBagConstraints);
        this._saveAtLookbackCheck = new RmaJCheckBox("Save Hotstart File at Start of Simulation");
        this._saveAtLookbackCheck.setMnemonic('L');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)20, (int)0, (int)5);
        this._createPanel.add((Component)this._saveAtLookbackCheck, gridBagConstraints);
        this._saveAtEndCheck = new RmaJCheckBox("Save Hotstart File at End of Simulation");
        this._saveAtEndCheck.setMnemonic('S');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)20, (int)0, (int)5);
        this._createPanel.add((Component)this._saveAtEndCheck, gridBagConstraints);
        this._saveAtDateTimeCheck = new RmaJCheckBox("Save Hotstart File at Date/Time:");
        this._saveAtDateTimeCheck.setMnemonic('v');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)20, (int)0, (int)5);
        this._createPanel.add((Component)this._saveAtDateTimeCheck, gridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)20, (int)0, (int)5);
        this._createPanel.add((Component)jComponent, gridBagConstraints);
        this._saveAtDatePanel = new DateTimePanel(1, "Date:", "Time:", "DDMMMYYYY");
        this._saveAtDatePanel.showTimeAsBeginningOfDay(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)20, (int)0, (int)5);
        jComponent.add((Component)this._saveAtDatePanel, gridBagConstraints);
        jLabel = new JLabel(" ");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        jComponent.add((Component)jLabel, gridBagConstraints);
        this._saveAtIntervalCheck = new RmaJCheckBox("Save Hotstart File at Interval:");
        this._saveAtIntervalCheck.setMnemonic('H');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)20, (int)0, (int)5);
        this._createPanel.add((Component)this._saveAtIntervalCheck, gridBagConstraints);
        this._intervalPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)20, (int)0, (int)0);
        this._createPanel.add((Component)this._intervalPanel, gridBagConstraints);
        this._intervalLabel = new JLabel("Interval:");
        this._intervalLabel.setDisplayedMnemonic('I');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)20, (int)0, (int)5);
        this._intervalPanel.add((Component)this._intervalLabel, (Object)gridBagConstraints);
        this._intervals = new Vector();
        this.fillIntervals();
        this._intervalCombo = new RmaJComboBox(this._intervals);
        this._intervalLabel.setLabelFor((Component)this._intervalCombo);
        this._intervalCombo.setModifiable(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
        this._intervalPanel.add((Component)this._intervalCombo, (Object)gridBagConstraints);
        this._intervalDatePanel = new DateTimePanel(1, "Starting at Date:", "Time:", "DDMMMYYYY");
        this._intervalDatePanel.showTimeAsBeginningOfDay(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
        this._intervalPanel.add((Component)this._intervalDatePanel, (Object)gridBagConstraints);
    }

    private void fillIntervals() {
        AltHotstartPanel$TimeStep altHotstartPanel$TimeStep = new AltHotstartPanel$TimeStep(this, 1, 2, "1 Hour");
        this._intervals.add(altHotstartPanel$TimeStep);
        altHotstartPanel$TimeStep = new AltHotstartPanel$TimeStep(this, 2, 2, "2 Hours");
        this._intervals.add(altHotstartPanel$TimeStep);
        altHotstartPanel$TimeStep = new AltHotstartPanel$TimeStep(this, 3, 2, "3 Hours");
        this._intervals.add(altHotstartPanel$TimeStep);
        altHotstartPanel$TimeStep = new AltHotstartPanel$TimeStep(this, 4, 2, "4 Hours");
        this._intervals.add(altHotstartPanel$TimeStep);
        altHotstartPanel$TimeStep = new AltHotstartPanel$TimeStep(this, 6, 2, "6 Hours");
        this._intervals.add(altHotstartPanel$TimeStep);
        altHotstartPanel$TimeStep = new AltHotstartPanel$TimeStep(this, 12, 2, "12 Hours");
        this._intervals.add(altHotstartPanel$TimeStep);
        altHotstartPanel$TimeStep = new AltHotstartPanel$TimeStep(this, 1, 3, "1 Day");
        this._intervals.add(altHotstartPanel$TimeStep);
    }

    protected void buildLoadPanel() {
        this._loadHotstartCheck = new AltHotstartPanel$2(this, "Load Hotstart File");
        this._loadHotstartCheck.setMnemonic('L');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._loadPanel.add((Component)this._loadHotstartCheck, gridBagConstraints);
        JLabel jLabel = new JLabel("Alternative Name:");
        jLabel.setDisplayedMnemonic('A');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)20, (int)0, (int)5);
        this._loadPanel.add((Component)jLabel, gridBagConstraints);
        this._altNameCombo = new RmaJComboBox();
        jLabel.setLabelFor((Component)this._altNameCombo);
        this._altNameCombo.setModifiable(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0E-4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._loadPanel.add((Component)this._altNameCombo, gridBagConstraints);
    }

    protected void addListeners() {
        this._saveAtIntervalCheck.addActionListener((ActionListener)new AltHotstartPanel$3(this));
        this._loadHotstartCheck.addActionListener((ActionListener)new AltHotstartPanel$4(this));
        this._createHotstartCheck.addActionListener((ActionListener)new AltHotstartPanel$5(this));
        this._saveAtDateTimeCheck.addActionListener((ActionListener)new AltHotstartPanel$6(this));
    }

    protected void saveAtDateTimeCheckAction() {
        boolean bl = this._saveAtDateTimeCheck.isSelected();
        this._saveAtDatePanel.setEnabled(bl);
    }

    protected void createHotstartCheckAction() {
        boolean bl = this._createHotstartCheck.isSelected();
        this._createPanel.setEnabled(bl);
        if (bl) {
            EventQueue.invokeLater(new AltHotstartPanel$7(this));
        }
    }

    protected void loadHotstartCheckAction() {
        boolean bl = this._loadHotstartCheck.isSelected();
        this._loadPanel.setEnabled(bl);
    }

    protected void saveAtIntervalCheckAction() {
        boolean bl = this._saveAtIntervalCheck.isSelected();
        this._intervalPanel.setEnabled(bl);
    }

    public boolean savePanel() {
        AltHotstartPanel altHotstartPanel = this;
        return altHotstartPanel.savePanel(altHotstartPanel._rssAlt);
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    @Override
    public boolean savePanel(RssAlt cloneable) {
        AltHotstartPanel$TimeStep altHotstartPanel$TimeStep;
        if (cloneable == null) {
            cloneable = this._rssAlt;
        }
        if (cloneable == null) {
            return true;
        }
        if (!this.isValidPanel()) {
            return false;
        }
        cloneable = ((RssAlt)cloneable).getHotstartOptions();
        ((HotstartOptions)cloneable).setCreateHotstart(this._createHotstartCheck.isSelected());
        ((HotstartOptions)cloneable).setSaveAtEndofSim(this._saveAtEndCheck.isSelected());
        ((HotstartOptions)cloneable).setSaveAtLookback(this._saveAtLookbackCheck.isSelected());
        ((HotstartOptions)cloneable).setSaveAtInterval(this._saveAtIntervalCheck.isSelected());
        if (!this._intervalDatePanel.getDateUnconverted().isEmpty() && !this._intervalDatePanel.getTimeUnconverted().isEmpty()) {
            ((HotstartOptions)cloneable).setIntervalDateTime(this._intervalDatePanel.getDateTime().element(0));
        }
        if ((altHotstartPanel$TimeStep = (AltHotstartPanel$TimeStep)this._intervalCombo.getSelectedItem()) != null) {
            ((HotstartOptions)cloneable).setTimeStep(altHotstartPanel$TimeStep.a);
            ((HotstartOptions)cloneable).setTimeIncrement(altHotstartPanel$TimeStep.b);
        }
        if (!this._saveAtDatePanel.getDateUnconverted().isEmpty() && !this._saveAtDatePanel.getTimeUnconverted().isEmpty()) {
            altHotstartPanel$TimeStep = this._saveAtDatePanel.getDateTime().element(0);
            ((HotstartOptions)cloneable).setSaveAtDateTime((HecTime)altHotstartPanel$TimeStep);
            ((HotstartOptions)cloneable).setSaveAtDateTime(this._saveAtDateTimeCheck.isSelected());
        }
        ((HotstartOptions)cloneable).setHoursToSave(this._timeStepSaveFld.getValue());
        ((HotstartOptions)cloneable).setLoadHotstart(this._loadHotstartCheck.isSelected());
        ((HotstartOptions)cloneable).setLoadAltName((String)this._altNameCombo.getSelectedItem());
        this.setModified(false);
        return true;
    }

    private boolean isValidPanel() {
        Object[] objectArray;
        int n;
        String string = null;
        if (this._editor.isChangingTabs()) {
            return true;
        }
        if (this._createHotstartCheck.isSelected()) {
            if (this._timeStepSaveFld.getValue() <= 0.0) {
                string = "No Hotstart Hours to Save entered";
            }
            if (string == null && this._saveAtDateTimeCheck.isSelected() && !this._saveAtDatePanel.getDateTime().element(0).isDefined()) {
                string = "No Hotstart Save At Date/Time entered.";
            }
            if (string == null && this._saveAtIntervalCheck.isSelected()) {
                if (this._intervalCombo.getSelectedItem() == null) {
                    string = "No Save At Hotstart Interval selected.";
                } else if (!this._intervalDatePanel.getDateTime().element(0).isDefined()) {
                    string = "No Hotstart Interval Date/Time specified";
                }
            }
        }
        if (string == null && this._loadHotstartCheck.isSelected() && this._altNameCombo.getSelectedItem() == null) {
            string = "No Alternative Name specified to load Hotstart file from.";
        }
        if (string != null && (n = JOptionPane.showOptionDialog((Component)((Object)this), string, "Invalid Hotstart Configuration", 0, 2, null, objectArray = new Object[]{"Save Anyway", "Fix Hotstart Options"}, objectArray[0])) == 1) {
            this._editor.setSelectedTab((Component)((Object)this));
            return false;
        }
        return true;
    }

    @Override
    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            this._rssAlt = null;
        }
        this._rssAlt = (RssAlt)object;
        if (this._rssAlt == null) {
            return;
        }
        object = this._rssAlt.getHotstartOptions();
        this._createHotstartCheck.setSelected(((HotstartOptions)object).shouldCreateHotstart());
        this._saveAtEndCheck.setSelected(((HotstartOptions)object).shouldSaveAtEndofSim());
        this._saveAtLookbackCheck.setSelected(((HotstartOptions)object).shouldSaveAtLookback());
        this._saveAtIntervalCheck.setSelected(((HotstartOptions)object).shouldSaveAtInterval());
        int n = ((HotstartOptions)object).getTimeStep();
        int n2 = ((HotstartOptions)object).getTimeIncrement();
        this.setInterval(n, n2);
        double d = ((HotstartOptions)object).getHoursToSave();
        this._timeStepSaveFld.setText(String.valueOf(d));
        this._loadHotstartCheck.setSelected(((HotstartOptions)object).shouldLoadHotstart());
        String string = ((HotstartOptions)object).getLoadAltName();
        if (string == null) {
            string = "";
        }
        this._saveAtDateTimeCheck.setSelected(((HotstartOptions)object).shouldSaveAtDateTime());
        TimeZone timeZone = ClientApp.Workspace().getTimeZone();
        TimeZone timeZone2 = ClientApp.app().getClientTimeZone();
        this._saveAtDatePanel.setTimeZone(timeZone2);
        this._saveAtDatePanel.setDateTime(((HotstartOptions)object).getSaveAtDateTime(), timeZone);
        this._intervalDatePanel.setTimeZone(timeZone2);
        this._intervalDatePanel.setDateTime(((HotstartOptions)object).getIntervalDateTime(), timeZone);
        this.fillAltNameCombo();
        if (string.length() > 0) {
            this._altNameCombo.setSelectedItem((Object)string);
        } else {
            this._altNameCombo.setSelectedIndex(-1);
        }
        EventQueue.invokeLater(new AltHotstartPanel$8(this));
    }

    private void fillAltNameCombo() {
        Object object = ClientApp.Workspace().getWorkspacePath();
        object = ((String)object).concat("/").concat("rss").concat("/").concat("hotstarts");
        Object object2 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        RmaListModel rmaListModel = new RmaListModel(true);
        try {
            object = object2.getRemoteFileIDList(ClientApp.app().getUser(), (String)object, "*.dss");
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                int n;
                object2 = (Identifier)((Vector)object).get(i);
                int n2 = ((String)(object2 = RMAIO.getFileFromPath((String)object2.getPath()))).indexOf(".");
                if (n2 == (n = ((String)object2).lastIndexOf(".")) || n2 <= 0 || rmaListModel.contains(object2 = ((String)object2).substring(0, n2))) continue;
                rmaListModel.addElement(object2);
            }
            this._altNameCombo.setModel((ComboBoxModel)rmaListModel);
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("fillAltNameCombo: RemoteException " + String.valueOf(remoteException));
            return;
        }
    }

    private void setInterval(int n, int n2) {
        for (int i = 0; i < this._intervals.size(); ++i) {
            AltHotstartPanel$TimeStep altHotstartPanel$TimeStep = this._intervals.get(i);
            if (n != altHotstartPanel$TimeStep.a || n2 != altHotstartPanel$TimeStep.b) continue;
            this._intervalCombo.setSelectedIndex(i);
            return;
        }
        this._intervalCombo.setSelectedIndex(-1);
    }

    @Override
    public String getTabname() {
        return "Hotstart";
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }

    @Override
    public void clearPanel() {
        this._saveAtEndCheck.setSelected(false);
        this._saveAtIntervalCheck.setSelected(false);
        this._intervalCombo.setSelectedIndex(-1);
        this._timeStepSaveFld.setText("");
        this._loadHotstartCheck.setSelected(false);
        this._altNameCombo.setSelectedIndex(-1);
        this._createHotstartCheck.setSelected(false);
        this.saveAtIntervalCheckAction();
        this.loadHotstartCheckAction();
        this.createHotstartCheckAction();
    }
}

