/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.ManagerProxyListManager;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.dssgui.DSSListSelector;
import hec.dssgui.DSSListSelectorParent;
import hec.dssgui.TableFrame;
import hec.gfx2d.G2dDialog;
import hec.gui.AbstractEditorPanel;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.Identifier;
import hec.io.TimeSeriesContainer;
import hec.lang.NamedType;
import hec.model.TSRecord;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AltObsDataPanel$1;
import hec.rss.client.AltObsDataPanel$2;
import hec.rss.client.AltObsDataPanel$3;
import hec.rss.client.AltObsDataPanel$4;
import hec.rss.client.AltObsDataPanel$DssPathSelectionListener;
import hec.rss.client.AltObservedContainerPanel;
import hec.rss.client.AltTimeSeriesPanel;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.model.TsVariant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public class AltObsDataPanel
extends AbstractEditorPanel
implements AlternativePanel,
ChangeListener {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    public static final String TAB_NAME = "Observed Data";
    private RssAlt _alternative;
    private RssSystem _system;
    private Vector _reqTSProxyVec;
    private Vector _obsDataList;
    private DSSListSelector _selectFrame;
    private RmaJTable _timeSeriesTable;
    private JButton _plotButton;
    private JButton _tabulateButton;
    protected JPanel _buttonPanel;
    private JButton _dssPathSelectButton;
    private TsVariant _variant;

    public AltObsDataPanel(AlternativeEditor alternativeEditor, AltObservedContainerPanel altObservedContainerPanel) {
        super((LayoutManager)new GridBagLayout());
        AltObsDataPanel altObsDataPanel = this;
        this._timeSeriesTable = new AltObsDataPanel$1(altObsDataPanel, (Component)((Object)altObsDataPanel), new String[]{"Location", "Variable", "DSS File", "Part A", "Part B", "Part C", "Part E", "Part F"});
        this.buildControls();
        this.addListeners();
    }

    @Override
    public void stateChanged(ChangeEvent serializable) {
        if (serializable.getSource() instanceof JTabbedPane && ((JTabbedPane)(serializable = (JTabbedPane)serializable.getSource())).getSelectedComponent() == this) {
            AltObsDataPanel altObsDataPanel = this;
            altObsDataPanel.fillPanel((NamedType)altObsDataPanel._alternative);
        }
    }

    public void setPanelEnabled(boolean bl) {
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.tableRowSelected();
    }

    @Override
    public void setSystem(RssSystem object) {
        int n;
        this._timeSeriesTable.setNumRows(0);
        this._timeSeriesTable.deleteCells();
        this._timeSeriesTable.removePopupMenuRowEditingOptions();
        this._timeSeriesTable.removePopupMenuSumOptions();
        if (object == null) {
            this._timeSeriesTable.setNumRows(0);
            return;
        }
        this._system = object;
        if (this._alternative != null) {
            ((RssSystem)object).setAlternative(this._alternative);
        }
        this._obsDataList = new Vector();
        ((RssSystem)object).updateTSProxyList();
        this._obsDataList = ((RssSystem)object).getObservedDataTSProxies(this._obsDataList);
        this._reqTSProxyVec = ((RssSystem)object).getActiveTSProxies(null, 0);
        this._reqTSProxyVec = (Vector)this._reqTSProxyVec.clone();
        if (this._obsDataList == null || this._reqTSProxyVec == null) {
            return;
        }
        for (n = this._reqTSProxyVec.size() - 1; n >= 0; --n) {
            object = (TSRecordProxy)this._reqTSProxyVec.elementAt(n);
            if (object == null || this._obsDataList.contains(object = object.getName() + ":" + object.getVariableId())) continue;
            this._reqTSProxyVec.remove(n);
        }
        for (n = 0; n < this._reqTSProxyVec.size(); ++n) {
            object = (TSRecordProxy)this._reqTSProxyVec.elementAt(n);
            if (object == null) continue;
            Vector<String> vector = new Vector<String>(8);
            vector.add(this._system.getNameForKeyString(object.getName()));
            vector.add(RssModelVariableSet.getVariableName(object.getVariableId()));
            vector.add(object.getDSSFilename());
            this._timeSeriesTable.appendRow(vector);
        }
    }

    @Override
    public String getTabname() {
        AltObsDataPanel altObsDataPanel = this;
        if (altObsDataPanel.isDefaultVariant(altObsDataPanel._variant)) {
            return TAB_NAME;
        }
        return this._variant.getName();
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        this._alternative = rssAlt;
        return this.savePanel();
    }

    public boolean savePanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return false;
        }
        return this.savePanel((RssAlt)namedType);
    }

    public boolean savePanel() {
        String string;
        if (this._alternative == null) {
            return true;
        }
        if (this._system == null) {
            return true;
        }
        if (this._alternative.getSystem() != this._system) {
            return true;
        }
        ManagerProxyListContainer managerProxyListContainer = this._alternative.getProxyList().getContainer();
        TSDataSet tSDataSet = this.getTsDataSet();
        String string2 = managerProxyListContainer instanceof ClientWorkspace ? ((ClientWorkspace)managerProxyListContainer).getWorkspacePath() : ((ManagerProxyListManager)managerProxyListContainer).getWorkspacePath();
        if (tSDataSet == null) {
            AltObsDataPanel altObsDataPanel = this;
            if (altObsDataPanel.isDefaultVariant(altObsDataPanel._variant)) {
                string = ClientApp.app().getAppType();
                Identifier identifier = this.getManagerIdentifier(string, TSDataSet.class.getName(), this._alternative.getName() + "Obs", "fits");
                tSDataSet = (TSDataSet)managerProxyListContainer.newManager(string, TSDataSet.class.getName());
                tSDataSet.setName(this._alternative.getName() + "Obs");
                tSDataSet.setDescription(this._alternative.getDescription() + " (Observed TS Data Set)");
                boolean bl = managerProxyListContainer instanceof ClientWorkspace ? ((ClientWorkspace)managerProxyListContainer).saveManagerAs(string, (Manager)tSDataSet, identifier) : ((ManagerProxyListManager)managerProxyListContainer).saveManagerAs(string, (Manager)tSDataSet, identifier);
                if (!bl) {
                    ((FluentLogger.Api)a.atInfo()).log("----------------------------------------------------------------------------------------");
                    ((FluentLogger.Api)a.atInfo()).log("ERROR <AltTimSeriesPanel.savePanel()> : Unable to create a new Observed Time Series Data Set");
                    ((FluentLogger.Api)a.atInfo()).log("----------------------------------------------------------------------------------------");
                    return false;
                }
                this._alternative.setObservedDataSetPath(tSDataSet.getIdentifier().getPath());
            }
        }
        if (tSDataSet == null) {
            ((FluentLogger.Api)a.atInfo()).log("Failed to Save " + (this._variant == null ? "Default" : this._variant.getName()) + " Obs DataSet because its null");
            return false;
        }
        tSDataSet.clearTSRecordList();
        for (int i = 0; i < this._timeSeriesTable.getNumRows(); ++i) {
            managerProxyListContainer = (TSRecordProxy)this._reqTSProxyVec.elementAt(i);
            string = managerProxyListContainer.getName();
            int n = managerProxyListContainer.getVariableId();
            if (string == null || string.isEmpty() || n == Integer.MIN_VALUE) continue;
            TSRecord tSRecord = tSDataSet.getTSRecord(string, n);
            if (tSRecord == null) {
                int n2 = n;
                tSRecord = tSDataSet.createTSRecord(string, n2, RssModelVariableSet.getParamName(n2));
            }
            Object object = this._timeSeriesTable.getValueAt(i, 2).toString();
            object = RMAIO.getRelativePath((String)string2, (String)object);
            tSRecord.setInputDataPos(-1);
            tSRecord.setDSSFilename((String)object);
            object = "/" + this._timeSeriesTable.getValueAt(i, 3).toString().trim() + "/" + this._timeSeriesTable.getValueAt(i, 4).toString().trim() + "/" + this._timeSeriesTable.getValueAt(i, 5).toString().trim() + "//" + this._timeSeriesTable.getValueAt(i, 6).toString().trim() + "/" + this._timeSeriesTable.getValueAt(i, 7).toString().trim() + "/";
            tSRecord.setDSSPathname((String)object);
        }
        tSDataSet.saveManager();
        this.setModified(false);
        return true;
    }

    @Override
    public void fillPanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)namedType;
        this._system = this._alternative.getSystem();
        if (this._system == null) {
            return;
        }
        if (this._variant == null) {
            this._variant = AltTimeSeriesPanel.l;
        }
        AltObsDataPanel altObsDataPanel = this;
        altObsDataPanel.setSystem(altObsDataPanel._system);
        namedType = this.getTsDataSet();
        if (namedType == null) {
            this.setIgnoreModifiedEvents(false);
            return;
        }
        for (int i = 0; i < this._timeSeriesTable.getNumRows(); ++i) {
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._reqTSProxyVec.elementAt(i);
            String string = tSRecordProxy.getName();
            int n = tSRecordProxy.getVariableId();
            if (string == null || string.isEmpty() || n == Integer.MIN_VALUE) continue;
            TSRecord tSRecord = namedType.getTSRecord(string, n);
            if (tSRecord == null) {
                ((FluentLogger.Api)a.atInfo()).log("NULL TSRecord for (NAME,PARAM) = (" + string + "," + RssModelVariableSet.getVariableName(n) + ")");
                continue;
            }
            this._timeSeriesTable.setValueAt((Object)tSRecord.getDSSFilename(), i, 2);
            Vector vector = DSSPathname.parseDssPath((String)tSRecord.getDSSPathname());
            if (vector == null) continue;
            this._timeSeriesTable.setValueAt(vector.get(0), i, 3);
            this._timeSeriesTable.setValueAt(vector.get(1), i, 4);
            this._timeSeriesTable.setValueAt(vector.get(2), i, 5);
            this._timeSeriesTable.setValueAt(vector.get(4), i, 6);
            this._timeSeriesTable.setValueAt(vector.get(5), i, 7);
        }
        this.tableRowSelected();
        this.setModified(false);
    }

    private TSDataSet getTsDataSet() {
        AltObsDataPanel altObsDataPanel = this;
        TSDataSet tSDataSet = altObsDataPanel.isDefaultVariant(altObsDataPanel._variant) ? this._alternative.getObservedTSDataSet() : this._alternative.getObservedTSDataSet(this._variant);
        return tSDataSet;
    }

    @Override
    public void clearPanel() {
        AltObsDataPanel altObsDataPanel = this;
        altObsDataPanel.setSystem(altObsDataPanel._system);
        this._timeSeriesTable.deleteCells();
        this.tableRowSelected();
    }

    public void selectDssPath_Action() {
        try {
            String string;
            int n;
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean bl = ClientApp.app().networked;
            if (this._selectFrame != null && this._selectFrame.isVisible()) {
                if (this._selectFrame.getState() == 1) {
                    this._selectFrame.setState(0);
                }
                return;
            }
            this._selectFrame = new DSSListSelector((DSSListSelectorParent)new AltObsDataPanel$DssPathSelectionListener(this), "Select Observed Time Series Path", 1, false, bl);
            Object object = SwingUtilities.windowForComponent((Component)((Object)this));
            if (object instanceof AlternativeEditor) {
                object = (AlternativeEditor)object;
                if ((object = ((AbstractAlternativeEditor)object).getWorkspace()) instanceof ClientWorkspace) {
                    object = (ClientWorkspace)object;
                    this._selectFrame.setDirectory(object.getWorkspacePath());
                } else if (object instanceof ManagerProxyListManager) {
                    object = (ManagerProxyListManager)object;
                    this._selectFrame.setDirectory(object.getWorkspacePath());
                }
            }
            if ((n = this._timeSeriesTable.getSelectedRow()) >= 0 && (string = (String)this._timeSeriesTable.getValueAt(n, 2)) != null && !string.isEmpty()) {
                if (!RMAIO.isFullPath((String)string)) {
                    string = ClientApp.Workspace().makeAbsolutePath(string);
                }
                this._selectFrame.setDSSFilename(string);
            }
            this._selectFrame.setVisible(true);
            RMAUtil.setWindowAlwaysOnTop((Window)this._selectFrame, (boolean)true);
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void buildControls() {
        JComponent jComponent = new JLabel("Select Locations that display Observed data in output reports and plots");
        this.add(jComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        this._timeSeriesTable.setColumnBackground(0, Color.lightGray);
        this._timeSeriesTable.setColumnBackground(1, Color.lightGray);
        this._timeSeriesTable.setColumnEnabled(false, 0);
        this._timeSeriesTable.setColumnEnabled(false, 1);
        this._timeSeriesTable.setNumRows(0);
        this._timeSeriesTable.setAutoResizeMode(0);
        this._timeSeriesTable.setCellSelectionEnabled(false);
        this._timeSeriesTable.setColumnSelectionAllowed(false);
        this._timeSeriesTable.setRowSelectionAllowed(true);
        this._timeSeriesTable.setColumnWidths(new int[]{75, 75, 75, 75, 75, 75, 75, 75});
        this._timeSeriesTable.getSelectionModel().setSelectionMode(2);
        this._timeSeriesTable.setAddRemoveEnabled(false);
        this._timeSeriesTable.setPasteAddsRows(false);
        this._timeSeriesTable.setAutoResizeMode(4);
        jComponent = this._timeSeriesTable.getScrollPane();
        this.add(jComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        this._buttonPanel = new JPanel(new GridBagLayout());
        AltObsDataPanel altObsDataPanel = this;
        altObsDataPanel.add(altObsDataPanel._buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 14, 2, RmaInsets.insets((int)5, (int)5, (int)5, (int)5), 0, 0));
        this._plotButton = new AltObsDataPanel$2(this, "Plot");
        this._plotButton.setEnabled(false);
        this._buttonPanel.add((Component)this._plotButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        this._tabulateButton = new AltObsDataPanel$3(this, "Tabulate");
        this._tabulateButton.setEnabled(false);
        this._buttonPanel.add((Component)this._tabulateButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 0, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        this._dssPathSelectButton = new AltObsDataPanel$4(this, "Select DSS Path");
        this._buttonPanel.add((Component)this._dssPathSelectButton, new GridBagConstraints(5, 0, 1, 1, 0.01, 0.0, 14, 0, RmaInsets.insets((int)0, (int)0, (int)0, (int)0), 0, 0));
        this.tableRowSelected();
    }

    protected void addListeners() {
        this._dssPathSelectButton.addActionListener(actionEvent -> this.selectDssPath_Action());
        this._timeSeriesTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.tableRowSelected());
        this._plotButton.addActionListener(actionEvent -> this.plotDssPathAction());
        this._tabulateButton.addActionListener(actionEvent -> this.tabulateDssPathAction());
    }

    private void tableRowSelected() {
        int n = this._timeSeriesTable.getSelectedRow();
        n = n >= 0 ? 1 : 0;
        this._dssPathSelectButton.setEnabled(n != 0);
        this._plotButton.setEnabled(n != 0);
        this._tabulateButton.setEnabled(n != 0);
    }

    public void setVariant(TsVariant tsVariant) {
        this._variant = tsVariant;
    }

    public TsVariant getTsVariant() {
        return this._variant;
    }

    public void windowClosing() {
        if (this._selectFrame != null && this._selectFrame.isVisible()) {
            this._selectFrame.setVisible(false);
        }
    }

    public Identifier getManagerIdentifier(String object, String string, String string2, String string3) {
        String string4;
        String string5 = null;
        if (this._alternative != null) {
            string4 = (RmiWorkspace)this._alternative.getWorkspace().getRemote();
            try {
                string5 = string4.getWorkspacePath();
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)a.atInfo()).log("getManagerIdentifier: RMI Error getting workspace path");
            }
        }
        string4 = RMAIO.userNameToFileName((String)string2.trim());
        String string6 = "/";
        object = string5 != null ? string5 + string6 + (String)object + string6 + string4 + (String)(string3.length() > 0 && string3.charAt(0) == '.' ? string3 : "." + string3) : (String)object + string6 + string4 + (String)(string3.length() > 0 && string3.charAt(0) == '.' ? string3 : "." + string3);
        object = new Identifier((String)object);
        object.setName(string2);
        object.setClassName(string);
        return object;
    }

    public boolean hasObservedData() {
        return this._timeSeriesTable.getRowCount() > 0;
    }

    private boolean isDefaultVariant(TsVariant tsVariant) {
        return AltTimeSeriesPanel.l == tsVariant || tsVariant == null;
    }

    protected Vector<TimeSeriesContainer> getSelectedData() {
        Vector<TimeSeriesContainer> vector = new Vector<TimeSeriesContainer>();
        this._timeSeriesTable.commitEdit(true);
        int[] nArray = this._timeSeriesTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return vector;
        }
        DSSPathname dSSPathname = new DSSPathname();
        HecTime hecTime = new HecTime();
        HecTime hecTime2 = new HecTime();
        Object object = null;
        try {
            object = ClientApp.Workspace().getData().getDSSFileManager();
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)a.atInfo()).log("getSelectedData: failed to get DssFileManager. RemoteException %s", (Object)remoteException);
        }
        if (object == null) {
            ((FluentLogger.Api)a.atInfo()).log("getSelectedData:failed to get DssFileManager from Watershed");
            return vector;
        }
        DSSManager dSSManager = (DSSManager)object.getRemote();
        if (dSSManager == null) {
            ((FluentLogger.Api)a.atInfo()).log("getSelectedData:failed to get DssFileManager from Watershed's remote wrapper");
            return vector;
        }
        vector.ensureCapacity(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            String string = (String)this._timeSeriesTable.getValueAt(nArray[i], 2);
            object = (String)this._timeSeriesTable.getValueAt(nArray[i], 3);
            String string2 = (String)this._timeSeriesTable.getValueAt(nArray[i], 4);
            String string3 = (String)this._timeSeriesTable.getValueAt(nArray[i], 5);
            String string4 = (String)this._timeSeriesTable.getValueAt(nArray[i], 6);
            String string5 = (String)this._timeSeriesTable.getValueAt(nArray[i], 7);
            dSSPathname.setAPart((String)object);
            dSSPathname.setBPart(string2);
            dSSPathname.setCPart(string3);
            dSSPathname.setEPart(string4);
            dSSPathname.setFPart(string5);
            if (string.isEmpty() || dSSPathname.getPathname().equals("//////")) {
                if (nArray.length != 1) continue;
                AltObsDataPanel altObsDataPanel = this;
                JOptionPane.showMessageDialog((Component)((Object)altObsDataPanel), "No DSS File/Path entered for " + String.valueOf(altObsDataPanel._timeSeriesTable.getValueAt(nArray[i], 0)) + "-" + String.valueOf(this._timeSeriesTable.getValueAt(nArray[i], 1)), "Missing Entry", 1);
                continue;
            }
            string = ClientApp.Workspace().makeAbsolutePath(string);
            object = new DSSIdentifier(string, dSSPathname.getPathname());
            try {
                dSSManager.getTimeSeriesExtents((DSSIdentifier)object, hecTime2, hecTime);
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)a.atInfo()).log("getSelectedData:failed to get start/end time for %s  error:%s", object, (Object)remoteException.getMessage());
            }
            if (!hecTime2.isDefined()) {
                hecTime2.set("01Jan1900 0000");
            }
            if (!hecTime.isDefined()) {
                hecTime.setCurrent();
            }
            object.setStartTime(hecTime2);
            object.setEndTime(hecTime);
            ((FluentLogger.Api)a.atInfo()).log("getSelectedData:plotting %s from %s", (Object)object.getDSSPath(), (Object)object.getFileName());
            string3 = null;
            boolean bl = false;
            try {
                string3 = dSSManager.readTS((DSSIdentifier)object, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ((FluentLogger.Api)a.atInfo()).log("getSelectedData: FileNotFoundException %s", (Object)fileNotFoundException.getMessage());
                bl = true;
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)a.atInfo()).log("getSelectedData: RemoteException %s", (Object)remoteException);
            }
            if (string3 == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Failed to find Data for " + dSSPathname.getPathname() + "\nin file " + string + (bl ? "\nFile doesn't exist." : ""));
                continue;
            }
            vector.add((TimeSeriesContainer)string3);
        }
        return vector;
    }

    public void plotDssPathAction() {
        G2dDialog g2dDialog = this.getSelectedData();
        if (g2dDialog.isEmpty()) {
            return;
        }
        g2dDialog = new G2dDialog(null, "", false, g2dDialog);
        g2dDialog.setVisible(true);
    }

    public void tabulateDssPathAction() {
        Vector<TimeSeriesContainer> vector = this.getSelectedData();
        if (vector.isEmpty()) {
            return;
        }
        TableFrame tableFrame = new TableFrame((JFrame)ClientApp.frame());
        tableFrame.setData(vector);
        tableFrame.setVisible(true);
    }
}

