/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AltEditorVariantMenuBuilder;
import hec.rss.client.AltObsDataPanel;
import hec.rss.client.AltObservedContainerPanel$1;
import hec.rss.client.AltTimeSeriesPanel;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.TsVariant;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaInsets;

public class AltObservedContainerPanel
extends AbstractEditorPanel
implements AlternativePanel,
ChangeListener {
    private final AlternativeEditor _editor;
    private RssSystem _system;
    private RssAlt _alternative;
    private JTabbedPane _tabbedPane;
    private final Map<String, AltObsDataPanel> _obsPanels = new HashMap<String, AltObsDataPanel>();
    private AltObsDataPanel _defaultPanel;
    private JMenu _variantMenu;

    public AltObservedContainerPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = alternativeEditor;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = this._obsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltObsDataPanel)object.next()).stateChanged(changeEvent);
        }
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        Object object = this._obsPanels.values();
        object = object.iterator();
        boolean bl = true;
        while (object.hasNext()) {
            if (((AltObsDataPanel)object.next()).savePanel(rssAlt)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }

    @Override
    public void clearPanel() {
        Object object = this._obsPanels.values();
        Iterator<AltObsDataPanel> iterator = object.iterator();
        while (iterator.hasNext()) {
            iterator.next().clearPanel();
        }
        iterator = object.iterator();
        iterator.hasNext();
        if (iterator.hasNext()) {
            object = iterator.next().getTsVariant();
            this.removeVariantTab((TsVariant)((Object)object));
        }
        if (this._variantMenu != null) {
            int n = this._variantMenu.getMenuComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!(this._variantMenu.getMenuComponent(i) instanceof JMenu)) continue;
                JMenu jMenu = (JMenu)this._variantMenu.getMenuComponent(i);
                jMenu.removeAll();
            }
        }
        this._system = null;
        this._alternative = null;
        AltEditorVariantMenuBuilder.a();
    }

    public void addVariant(TsVariant tsVariant) {
        if (tsVariant == null) {
            return;
        }
        if (this._tabbedPane == null) {
            this.addTabbedPane();
        }
        String string = tsVariant.getName();
        AltObsDataPanel altObsDataPanel = new AltObsDataPanel(this._editor, this);
        this._obsPanels.put(string, altObsDataPanel);
        altObsDataPanel.setSystem(this._system);
        altObsDataPanel.setVariant(tsVariant);
        altObsDataPanel.fillPanel((NamedType)this._alternative);
        this._tabbedPane.addTab(string, (Component)((Object)altObsDataPanel));
        int n = string.indexOf(45);
        int n2 = this._tabbedPane.getTabCount() - 1;
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this._tabbedPane.setToolTipTextAt(n2, "Observed Time Series Input linking for ResSim in " + string2 + " for Variant " + string3);
        } else {
            this._tabbedPane.setToolTipTextAt(n2, "Time Series Entries for Variant " + string);
        }
        this._tabbedPane.setSelectedIndex(n2);
    }

    public void removeVariantTab(TsVariant tsVariant) {
        if (tsVariant == null) {
            return;
        }
        int n = this.findTabIndexFor(tsVariant);
        if (n >= 0) {
            AltObsDataPanel altObsDataPanel = (AltObsDataPanel)((Object)this._tabbedPane.getComponentAt(n));
            this._obsPanels.remove(altObsDataPanel.getTabname());
            this._tabbedPane.removeTabAt(n);
            if (this._tabbedPane.getTabCount() == 1) {
                AltObservedContainerPanel altObservedContainerPanel = this;
                altObservedContainerPanel.remove(altObservedContainerPanel._tabbedPane);
                this._tabbedPane = null;
                this.addStandAlonePanel();
            }
        }
    }

    private int findTabIndexFor(TsVariant object) {
        int n;
        if (this._tabbedPane != null && (n = this._tabbedPane.getTabCount()) > 1) {
            object = object.getName();
            for (int i = 1; i < n; ++i) {
                String string = this._tabbedPane.getTitleAt(i);
                if (!string.equals(object)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public String getTabname() {
        return "Observed Data";
    }

    @Override
    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        if (object == this._alternative && !this._alternative.isModified()) {
            return;
        }
        this.removeAll();
        this._obsPanels.clear();
        this._tabbedPane = null;
        this._alternative = (RssAlt)object;
        this._alternative.getObsTSVariantNames();
        this._defaultPanel = new AltObsDataPanel(this._editor, this);
        object = AltTimeSeriesPanel.l;
        this._defaultPanel.setSystem(this._system);
        this._defaultPanel.setVariant((TsVariant)((Object)object));
        this._defaultPanel.fillPanel((NamedType)this._alternative);
        this._obsPanels.put(object.getName(), this._defaultPanel);
        this.addStandAlonePanel();
        this.setModified(false);
        object = System.getProperty("InputTimeSeries.variantEditorPrefix");
        if (object != null && this._tabbedPane != null) {
            EventQueue.invokeLater(new AltObservedContainerPanel$1(this, (String)object));
        }
    }

    private void addStandAlonePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltObservedContainerPanel altObservedContainerPanel = this;
        altObservedContainerPanel.add((Component)((Object)altObservedContainerPanel._defaultPanel), gridBagConstraints);
    }

    private void addTabbedPane() {
        AltObservedContainerPanel altObservedContainerPanel = this;
        altObservedContainerPanel.remove((Component)((Object)altObservedContainerPanel._defaultPanel));
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        AltObservedContainerPanel altObservedContainerPanel2 = this;
        altObservedContainerPanel2.add(altObservedContainerPanel2._tabbedPane, gridBagConstraints);
        this._tabbedPane.addTab(AltTimeSeriesPanel.l.getName(), (Component)((Object)this._defaultPanel));
        this._tabbedPane.setToolTipTextAt(0, "Observed Input linking for ResSim in standalone");
    }

    public boolean savePanel() {
        AltObservedContainerPanel altObservedContainerPanel = this;
        return altObservedContainerPanel.savePanel(altObservedContainerPanel._alternative);
    }

    public boolean savePanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return false;
        }
        return this.savePanel((RssAlt)namedType);
    }

    public void windowClosing() {
        Object object = this._obsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            AltObsDataPanel altObsDataPanel = (AltObsDataPanel)object.next();
            altObsDataPanel.windowClosing();
        }
        AltEditorVariantMenuBuilder.a();
    }

    public void setPanelEnabled(boolean bl) {
        Object object = this._obsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            AltObsDataPanel altObsDataPanel = (AltObsDataPanel)object.next();
            altObsDataPanel.setPanelEnabled(bl);
        }
    }

    public Vector getPanelMenus() {
        if (this._alternative == null || this._alternative.getInputTSVariants().isEmpty()) {
            return null;
        }
        Vector<JMenuItem> vector = AltEditorVariantMenuBuilder.a(this._editor);
        this._variantMenu = new JMenu("Variants");
        for (int i = 0; i < vector.size(); ++i) {
            this._variantMenu.add((JMenuItem)vector.get(i));
        }
        Vector<JMenu> vector2 = new Vector<JMenu>(1);
        vector2.add(this._variantMenu);
        return vector2;
    }

    public boolean hasObservedData() {
        Object object = this._obsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            if (!((AltObsDataPanel)object.next()).hasObservedData()) continue;
            return true;
        }
        return false;
    }
}

