/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.AbstractEditorPanel;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.rss.client.AltOperationsPanel$1;
import hec.rss.client.AltOperationsPanel$2;
import hec.rss.client.AltOperationsPanel$3;
import hec.rss.client.AltOperationsPanel$4;
import hec.rss.client.AltOperationsPanel$5;
import hec.rss.client.AltOperationsPanel$6;
import hec.rss.client.AltOperationsPanel$7;
import hec.rss.client.AltOperationsPanel$MisMatchedOpSet;
import hec.rss.client.AltOperationsPanel$OperationsJTable;
import hec.rss.client.AltOperationsPanel$TableRowSaver;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.DiversionElement;
import hec.rss.model.DiversionOp;
import hec.rss.model.OpSet;
import hec.rss.model.OpSetRef;
import hec.rss.model.OperationsElement;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirOp;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssAlt;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssSystem;
import hec.rss.model.WaterAccountSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.util.RMASort;

public class AltOperationsPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private RssAlt _alternative = null;
    private RssSystem _system;
    private AlternativeEditor _editor;
    private RmaJComboBox _waterAccountCombo;
    private List<WaterAccountSet> _useWaterAccountSets = new ArrayList<WaterAccountSet>();
    private boolean _fillingPanel;
    private JComboBox _resOpsTableCombo;
    private JComboBox _sysOpTableCombo;
    private JComboBox _divOpsTableCombo;
    private AltOperationsPanel$OperationsJTable _resOpsTable;
    private AltOperationsPanel$OperationsJTable _divOpsTable;
    private AltOperationsPanel$OperationsJTable _sysopTable;

    public AltOperationsPanel(AlternativeEditor alternativeEditor) {
        AltOperationsPanel altOperationsPanel = this;
        this._resOpsTable = new AltOperationsPanel$OperationsJTable(altOperationsPanel, (Component)((Object)altOperationsPanel));
        AltOperationsPanel altOperationsPanel2 = this;
        this._divOpsTable = new AltOperationsPanel$OperationsJTable(altOperationsPanel2, (Component)((Object)altOperationsPanel2));
        AltOperationsPanel altOperationsPanel3 = this;
        this._sysopTable = new AltOperationsPanel$1(altOperationsPanel3, (Component)((Object)altOperationsPanel3));
        this.buildControls();
        this._editor = alternativeEditor;
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        this._sysopTable.setModel((TableModel)((Object)new AltOperationsPanel$2(this, new String[]{"Reservoir System", "Storage Balance"}, new Object[0][], new boolean[]{false, true})));
        this._sysopTable.setRowHeight(this._sysopTable.getRowHeight() + 5);
        this._sysopTable.setColumnEnabled(false, 0);
        this._sysopTable.setPasteAddsRows(false);
        this._sysOpTableCombo = this._sysopTable.setComboBoxEditor(1, new Vector());
        this._sysopTable.setOpsComboBox(this._sysOpTableCombo);
        this._sysopTable.setAddRemoveEnabled(false);
        this._sysopTable.removePopupMenuRowEditingOptions();
        this._sysopTable.removePopupMenuSumOptions();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltOperationsPanel altOperationsPanel = this;
        altOperationsPanel.add(altOperationsPanel._sysopTable.getScrollPane(), gridBagConstraints);
        this._resOpsTable.setModel((TableModel)((Object)new AltOperationsPanel$3(this, new String[]{"Reservoir", "Operation Set"}, new Object[0][], new boolean[]{false, true})));
        this._resOpsTable.setRowHeight(this._resOpsTable.getRowHeight() + 5);
        this._resOpsTable.setColumnEnabled(false, 0);
        this._resOpsTableCombo = this._resOpsTable.setComboBoxEditor(1, new Vector());
        this._resOpsTable.setOpsComboBox(this._resOpsTableCombo);
        this._resOpsTable.setAddRemoveEnabled(false);
        this._resOpsTable.setPasteAddsRows(false);
        this._resOpsTable.removePopupMenuRowEditingOptions();
        this._resOpsTable.removePopupMenuSumOptions();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        AltOperationsPanel altOperationsPanel2 = this;
        altOperationsPanel2.add(altOperationsPanel2._resOpsTable.getScrollPane(), gridBagConstraints);
        this._divOpsTable.setModel((TableModel)((Object)new AltOperationsPanel$4(this, new String[]{"Diversion", "Operation Set"}, new Object[0][], new boolean[]{false, true})));
        this._divOpsTable.setRowHeight(this._divOpsTable.getRowHeight() + 5);
        this._divOpsTable.setColumnEnabled(false, 0);
        this._divOpsTableCombo = this._divOpsTable.setComboBoxEditor(1, new Vector());
        this._divOpsTable.setOpsComboBox(this._divOpsTableCombo);
        this._divOpsTable.setAddRemoveEnabled(false);
        this._divOpsTable.setPasteAddsRows(false);
        this._divOpsTable.removePopupMenuRowEditingOptions();
        this._divOpsTable.removePopupMenuSumOptions();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        AltOperationsPanel altOperationsPanel3 = this;
        altOperationsPanel3.add(altOperationsPanel3._divOpsTable.getScrollPane(), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Water Account Set Selection"));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add(jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel("Water Account Set:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._waterAccountCombo = new RmaJComboBox();
        this._waterAccountCombo.addItem((Object)"NONE");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)0);
        jPanel.add((Component)this._waterAccountCombo, gridBagConstraints);
        this._waterAccountCombo.addActionListener((ActionListener)new AltOperationsPanel$5(this));
    }

    private void askToSetOperationsSet(int n) {
        Object object = this._sysopTable.getValueAt(n, 1);
        if (!(object instanceof ResSystemOpSet)) {
            return;
        }
        int n2 = JOptionPane.showConfirmDialog((Component)((Object)this), "<html>Set the Reservoirs' Operation Sets to match the selection in the System Balance? <b>" + (object = (ResSystemOpSet)object).getName() + "</b></html>?", "Set Operation Sets", 0, 3);
        if (n2 != 0) {
            return;
        }
        n2 = this._resOpsTable.getRowCount();
        for (int i = 0; i < n2; ++i) {
            NamedType namedType = (ReservoirElement)this._resOpsTable.getValueAt(i, 0);
            OpSetRef opSetRef = ((ResSystemOpSet)object).getOpSetReferences((ReservoirElement)namedType);
            if (opSetRef == null || (namedType = namedType.getReservoirOp().getOperationSet(opSetRef.getOpSetID())) == null) continue;
            this._resOpsTable.setValueAt(namedType, i, 1);
        }
    }

    private void waterAccountComboAction() {
        if (this._waterAccountCombo.getSelectedItem() instanceof WaterAccountSet) {
            this._editor.getYieldAnalysisPanel().setWaterAccounts((WaterAccountSet)this._waterAccountCombo.getSelectedItem());
        } else {
            this._editor.getYieldAnalysisPanel().setWaterAccounts(null);
        }
        this.setModified(true);
    }

    public void setPanelEnabled(boolean bl) {
        this._sysopTable.setEnabled(this._alternative != null);
        this._resOpsTable.setEnabled(this._alternative != null);
    }

    @Override
    public String getTabname() {
        return "Operations";
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        this._alternative = rssAlt;
        return this.savePanel();
    }

    public boolean savePanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return false;
        }
        return this.savePanel((RssAlt)namedType);
    }

    public boolean savePanel() {
        if (this._alternative == null) {
            return true;
        }
        this._sysopTable.commitEdit(true);
        this._resOpsTable.commitEdit(true);
        this._divOpsTable.commitEdit(true);
        this.checkSystemStorageBalance();
        for (int i = 0; i < this._sysopTable.getNumRows(); ++i) {
            ReservoirSysOp reservoirSysOp = (ReservoirSysOp)this._sysopTable.getCell(i, 0);
            Object object = this._sysopTable.getCell(i, 1);
            if (reservoirSysOp == null || reservoirSysOp.getName().isEmpty()) continue;
            if (!(object instanceof ResSystemOpSet) || ((ResSystemOpSet)object).getName().isEmpty()) {
                this._alternative.removeResSysOpSetSelection(reservoirSysOp.getIndex());
                continue;
            }
            this._alternative.addResSysOpSetSelection(reservoirSysOp.getIndex(), ((ResSystemOpSet)object).getIndex());
        }
        AltOperationsPanel$TableRowSaver altOperationsPanel$TableRowSaver = (n, n2) -> this._alternative.addResOpSetSelection(n, n2);
        AltOperationsPanel altOperationsPanel = this;
        if (!altOperationsPanel.checkTable(altOperationsPanel._resOpsTable, "Reservoir", altOperationsPanel$TableRowSaver)) {
            return false;
        }
        altOperationsPanel$TableRowSaver = (n, n2) -> this._alternative.addDivOpSetSelection(n, n2);
        AltOperationsPanel altOperationsPanel2 = this;
        if (!altOperationsPanel2.checkTable(altOperationsPanel2._divOpsTable, "Diversion", altOperationsPanel$TableRowSaver)) {
            return false;
        }
        if (this._waterAccountCombo.getSelectedItem() instanceof WaterAccountSet) {
            this._alternative.setWaterAccountSet((WaterAccountSet)this._waterAccountCombo.getSelectedItem());
        } else {
            this._alternative.setWaterAccountSet(null);
        }
        this.setModified(false);
        return true;
    }

    private void checkSystemStorageBalance() {
        Object object;
        int n;
        if (this._sysopTable.getRowCount() == 0 || this._system == null) {
            return;
        }
        Vector<ReservoirElement> vector = this._system.getElementVectorByClass(ReservoirElement.class);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this._sysopTable.getRowCount(); ++i) {
            Object object2 = this._sysopTable.getValueAt(i, 1);
            if (!(object2 instanceof ResSystemOpSet)) continue;
            object2 = (ResSystemOpSet)object2;
            for (n = 0; n < vector.size(); ++n) {
                OpSet opSet;
                object = vector.get(n);
                NamedType namedType = ((ResSystemOpSet)object2).getOpSetReferences((ReservoirElement)object);
                if (namedType == null || (opSet = this.checkOpSetForReservoir((ReservoirElement)object, (OpSet)(namedType = ((ReservoirElement)object).getReservoirOp().getOperationSet(namedType.getOpSetID())))) == null) continue;
                object = new AltOperationsPanel$MisMatchedOpSet(this, (ResSystemOpSet)object2, (ReservoirElement)object, (OpSet)namedType, opSet);
                arrayList.add(object);
            }
        }
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>The following Reservoirs' Operation Sets are not configured correctly in the Operation Sets table.<br><br>");
            stringBuilder.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"5\">");
            stringBuilder.append("<tr>");
            stringBuilder.append("<th>Reservoir System</th>");
            stringBuilder.append("<th>Reservoir</th>");
            stringBuilder.append("<th>System Operation Set</th>");
            stringBuilder.append("<th>Selected Operation Set</th>");
            stringBuilder.append("</tr>");
            for (n = 0; n < arrayList.size(); ++n) {
                object = (AltOperationsPanel$MisMatchedOpSet)arrayList.get(n);
                stringBuilder.append("<tr>");
                stringBuilder.append("<td>");
                stringBuilder.append(((AltOperationsPanel$MisMatchedOpSet)object).c.getName());
                stringBuilder.append("</td>");
                stringBuilder.append("<td>");
                stringBuilder.append(((AltOperationsPanel$MisMatchedOpSet)object).a.getName());
                stringBuilder.append("</td>");
                stringBuilder.append("<td>");
                stringBuilder.append(((AltOperationsPanel$MisMatchedOpSet)object).b.getName());
                stringBuilder.append("</td>");
                stringBuilder.append("<td>");
                stringBuilder.append(((AltOperationsPanel$MisMatchedOpSet)object).d.getName());
                stringBuilder.append("</td>");
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</table>");
            JOptionPane.showMessageDialog((Component)((Object)this), stringBuilder.toString(), "Mismatched Operation Sets", 2);
        }
    }

    private OpSet checkOpSetForReservoir(ReservoirElement namedType, OpSet opSet) {
        if (namedType == null || opSet == null) {
            return null;
        }
        int n = this._resOpsTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = (ReservoirElement)this._resOpsTable.getValueAt(i, 0);
            if (object == null || object.getIndex() != namedType.getIndex() || !((object = this._resOpsTable.getValueAt(i, 1)) instanceof OpSet)) continue;
            namedType = (OpSet)object;
            if (namedType == opSet) {
                return null;
            }
            return namedType;
        }
        return null;
    }

    private boolean checkTable(RmaJTable rmaJTable, String string, AltOperationsPanel$TableRowSaver altOperationsPanel$TableRowSaver) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < rmaJTable.getNumRows(); ++i) {
            OperationsElement operationsElement = (OperationsElement)rmaJTable.getCell(i, 0);
            Object object = operationsElement.getElementOp();
            n = i + 1;
            if (operationsElement == null || operationsElement.getName().isEmpty() || object == null) {
                arrayList.add(n);
                continue;
            }
            Object object2 = rmaJTable.getCell(i, 1);
            if (object2 instanceof String) {
                if ((object = object.getOperationSet(object2.toString())) != null) {
                    rmaJTable.setCell(object, i, 1);
                }
                object2 = object;
            }
            if (!(object2 instanceof OpSet) || ((OpSet)object2).getName().isEmpty()) {
                arrayList2.add(operationsElement.getName());
                continue;
            }
            altOperationsPanel$TableRowSaver.saveTableData(operationsElement.getIndex(), ((OpSet)object2).getIndex());
        }
        if (!arrayList.isEmpty()) {
            this._editor.setSelectedTab((Component)((Object)this));
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                stringBuilder.append(arrayList.get(n));
                if (n == n2 - 2 && n2 > 1) {
                    stringBuilder.append(" and ");
                    continue;
                }
                if (n >= n2 - 1) continue;
                stringBuilder.append(", ");
            }
            n = n2 > 1 ? JOptionPane.showConfirmDialog((Component)((Object)this), "Invalid " + string + " Element Selected in rows - " + stringBuilder.toString() + "\n in the operations table.\n Do you want to select an Operations set?", "Invalid " + string, 0, 2) : JOptionPane.showConfirmDialog((Component)((Object)this), "Invalid " + string + " Element Selected in row - " + stringBuilder.toString() + "\n in the operations table.\n Do you want to select an Operations set?", "Invalid " + string, 0, 2);
            if (n == 0) {
                return false;
            }
        }
        if (!arrayList2.isEmpty()) {
            this._editor.setSelectedTab((Component)((Object)this));
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = arrayList2.size();
            stringBuilder.append("\n");
            for (n = 0; n < n3; ++n) {
                stringBuilder.append((String)arrayList2.get(n));
                stringBuilder.append("\n");
            }
            n = arrayList2.size() > 1 ? JOptionPane.showConfirmDialog((Component)((Object)this), "Invalid Operation Set selected in the following " + string + "s in the operations table: " + stringBuilder.toString() + "\nDo you want to select the Operations Set?", "Invalid Operation Set", 0, 2) : JOptionPane.showConfirmDialog((Component)((Object)this), "Invalid Operation Set selected in the following Reservoir in the operations table: " + stringBuilder.toString() + "\n in the operations table.\nDo you want to select the Operations Set?", "Invalid Operation Set", 0, 2);
            if (n == 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void fillPanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return;
        }
        this._fillingPanel = true;
        try {
            this._alternative = (RssAlt)namedType;
            for (int i = 0; i < this._sysopTable.getNumRows(); ++i) {
                AsciiSerializable asciiSerializable = (ReservoirSysOp)this._sysopTable.getCell(i, 0);
                if (asciiSerializable == null) continue;
                Vector vector = asciiSerializable.getSystemOpSets();
                vector.add(0, "Implicit");
                this._sysOpTableCombo = this._sysopTable.setComboBoxRowEditor(i, 1, vector);
                this._sysopTable.setOpsComboBox(this._sysOpTableCombo);
                int n = this._alternative.getResSysOpSetSelection(asciiSerializable.getIndex());
                asciiSerializable = asciiSerializable.getSystemOpSet(n);
                if (asciiSerializable != null) {
                    this._sysopTable.setCell(asciiSerializable, i, 1);
                    continue;
                }
                this._sysopTable.setCell("Implicit", i, 1);
            }
            this.fillResOpTable();
            this.fillDivOpTable();
            this.updateWaterAccountSetCombo();
            if (this._alternative.getWaterAccountSet() == null) {
                this._waterAccountCombo.setSelectedItem((Object)"NONE");
            } else {
                this._waterAccountCombo.setSelectedItem((Object)this._alternative.getWaterAccountSet());
            }
            this.setModified(false);
            return;
        }
        finally {
            this._fillingPanel = false;
        }
    }

    private void fillResOpTable() {
        for (int i = 0; i < this._resOpsTable.getNumRows(); ++i) {
            ReservoirOp reservoirOp;
            NamedType namedType = (ReservoirElement)this._resOpsTable.getCell(i, 0);
            if (namedType == null || (reservoirOp = namedType.getReservoirOp()) == null) continue;
            int n = this._alternative.getResOpSetSelection(namedType.getIndex());
            if ((namedType = reservoirOp.getOperationSet(n)) != null) {
                this._resOpsTable.setCell(namedType, i, 1);
                continue;
            }
            this._resOpsTable.setCell(null, i, 1);
        }
    }

    private void fillDivOpTable() {
        for (int i = 0; i < this._divOpsTable.getNumRows(); ++i) {
            DiversionOp diversionOp;
            NamedType namedType = (DiversionElement)this._divOpsTable.getCell(i, 0);
            if (namedType == null || (diversionOp = namedType.getDiversionOps()) == null) continue;
            int n = this._alternative.getDivOpSetSelection(namedType.getIndex());
            if ((namedType = diversionOp.getOperationSet(n)) != null) {
                this._divOpsTable.setCell(namedType, i, 1);
                continue;
            }
            this._divOpsTable.setCell(null, i, 1);
        }
    }

    @Override
    public void clearPanel() {
        this._alternative = null;
        this._sysopTable.commitEdit(true);
        this._sysopTable.deleteCells();
        this._sysopTable.commitEdit(false);
        this._resOpsTable.commitEdit(true);
        this._resOpsTable.deleteCells();
        this._resOpsTable.commitEdit(false);
        this._divOpsTable.commitEdit(true);
        this._divOpsTable.deleteCells();
        this._divOpsTable.commitEdit(false);
        this._waterAccountCombo.setSelectedItem((Object)"NONE");
    }

    private void updateWaterAccountSetCombo() {
        WaterAccountSet waterAccountSet = null;
        if (this._waterAccountCombo.getSelectedItem() instanceof WaterAccountSet) {
            waterAccountSet = (WaterAccountSet)this._waterAccountCombo.getSelectedItem();
        }
        this._waterAccountCombo.removeAllItems();
        this._useWaterAccountSets.clear();
        if (this._alternative.getSystem() == null || this._alternative.getSystem().getWaterAccountSetList() == null) {
            return;
        }
        List<WaterAccountSet> list = this._alternative.getSystem().getWaterAccountSetList();
        this._waterAccountCombo.addItem((Object)"NONE");
        this._waterAccountCombo.setSelectedItem((Object)"NONE");
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            WaterAccountSet waterAccountSet2 = list.get(i);
            if (waterAccountSet2 == null) continue;
            this._waterAccountCombo.addItem((Object)waterAccountSet2);
            for (int j = 0; j < this._resOpsTable.getNumRows(); ++j) {
                if (waterAccountSet2.getSize() == 0) continue;
                ReservoirElement reservoirElement = (ReservoirElement)this._resOpsTable.getCell(j, 0);
                RssReturnStatusConstants rssReturnStatusConstants = reservoirElement.getReservoirOp();
                if (reservoirElement == null || reservoirElement.getName().isEmpty() || rssReturnStatusConstants == null) continue;
                Object object = this._resOpsTable.getCell(j, 1);
                if (object instanceof String) {
                    if ((rssReturnStatusConstants = rssReturnStatusConstants.getOperationSet(object.toString())) != null) {
                        this._resOpsTable.setCell(rssReturnStatusConstants, j, 1);
                    }
                    object = rssReturnStatusConstants;
                }
                if (!(object instanceof OpSet) || ((OpSet)object).getName().isEmpty() || !waterAccountSet2.containsReservoirOpSet(reservoirElement.getIndex(), ((OpSet)object).getIndex()) || this._useWaterAccountSets.contains(waterAccountSet2)) continue;
                this._useWaterAccountSets.add(waterAccountSet2);
            }
        }
        if (waterAccountSet != null) {
            this._waterAccountCombo.setSelectedItem((Object)waterAccountSet);
        }
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._sysopTable.commitEdit(true);
        this._sysopTable.deleteCells();
        this._resOpsTable.commitEdit(true);
        this._resOpsTable.deleteCells();
        this._system = rssSystem;
        if (rssSystem == null) {
            return;
        }
        ReservoirSysOp[] reservoirSysOpArray = rssSystem.getReservoirSysOps();
        Vector vector = new Vector();
        Collections.addAll(vector, reservoirSysOpArray);
        int n = vector.size();
        if (n <= 0) {
            this._sysopTable.setNumRows(0);
        } else {
            this._sysopTable.setNumRows(n);
            RMASort.quickSort(vector);
            for (int i = 0; i < n; ++i) {
                Serializable serializable = (ReservoirSysOp)vector.elementAt(i);
                if (serializable == null) continue;
                this._sysopTable.setCell(serializable, i, 0);
                if (serializable == null) {
                    this._sysopTable.setComboBoxRowEditor(i, 1, new Vector());
                    continue;
                }
                serializable = serializable.getSystemOpSets();
                ((Vector)serializable).insertElementAt("Implicit", 0);
                this._sysopTable.setComboBoxRowEditor(i, 1, (Vector)serializable);
            }
        }
        Dimension dimension = this._sysopTable.getPreferredScrollableViewportSize();
        this._sysopTable.getPreferredScrollableViewportSize().height = this._sysopTable.getRowHeight() * Math.min(this._sysopTable.getRowCount(), 2);
        this._sysopTable.setPreferredScrollableViewportSize(dimension);
        this.fillReservoirTable(rssSystem);
        this.fillDiversionTable(rssSystem);
    }

    protected void fillReservoirTable(RssSystem rssSystem) {
        Object[] objectArray = rssSystem.getReservoirNames();
        if (objectArray == null || objectArray.length == 0) {
            this._resOpsTable.setNumRows(0);
            return;
        }
        this._resOpsTable.setNumRows(objectArray.length);
        RMASort.quickSort((Object[])objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Cloneable cloneable = rssSystem.findReservoir((String)objectArray[i]);
            if (cloneable == null) continue;
            this._resOpsTable.setCell(cloneable, i, 0);
            cloneable = ((ReservoirElement)cloneable).getReservoirOp();
            if (cloneable == null) {
                this._resOpsTable.setComboBoxRowEditor(i, 1, new Vector());
                continue;
            }
            cloneable = ((ReservoirOp)cloneable).getOperationSets();
            ((Vector)cloneable).insertElementAt((OpSet)((Object)""), 0);
            cloneable = this._resOpsTable.setComboBoxRowEditor(i, 1, (Vector)cloneable);
            ((JComboBox)((Object)cloneable)).addItemListener(new AltOperationsPanel$6(this));
        }
    }

    protected void fillDiversionTable(RssSystem rssSystem) {
        Object[] objectArray = rssSystem.getDiversionNames();
        if (objectArray == null || objectArray.length == 0) {
            this._divOpsTable.setNumRows(0);
            return;
        }
        this._divOpsTable.setNumRows(objectArray.length);
        RMASort.quickSort((Object[])objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = rssSystem.findDiversion((String)objectArray[i]);
            if (object == null) continue;
            this._divOpsTable.setCell(object, i, 0);
            object = ((DiversionElement)object).getDiversionOps();
            if (object == null) {
                this._divOpsTable.setComboBoxRowEditor(i, 1, new Vector());
                continue;
            }
            object = ((DiversionOp)object).getOperationSets();
            ((Vector)object).insertElementAt((OpSet)((Object)""), 0);
            object = this._divOpsTable.setComboBoxRowEditor(i, 1, (Vector)object);
            ((JComboBox)object).addItemListener(new AltOperationsPanel$7(this));
        }
    }
}

