/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AltRunControlPanel$1;
import hec.rss.client.AltRunControlPanel$2;
import hec.rss.client.AltRunControlPanel$3;
import hec.rss.client.AltRunControlPanel$4;
import hec.rss.client.AltRunControlPanel$5;
import hec.rss.client.AltRunControlPanel$6;
import hec.rss.client.AltRunControlPanel$7;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.client.RssRunOptionPanel;
import hec.rss.model.OutputVerticalDatumType;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.TimeStepUtil;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.model.AltPluginData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.Duration;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuListener;
import rma.swing.RmaColor;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJRadioButton;
import rma.util.RMAIO;

public class AltRunControlPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private RmaJComboBox<TimeStepUtil> _timeStepCombo;
    private RssRunOptionPanel _runOptPanel;
    private RssAlt _alternative;
    private RssSystem _network;
    private JLabel _msgLineLabel;
    private JLabel _explainationText;
    private AlternativeEditor _editor;
    private RmaJRadioButton _standardRadio;
    private RmaJRadioButton _firmYieldRadio;
    private RmaJRadioButton _yieldAnalysisRadio;
    private ButtonGroup _radioPluginBG;
    private JPanel _alternativeTypePanel;
    private Map<String, AlternativePanel> _pluginRadioMap = new HashMap<String, AlternativePanel>();
    private JPanel _outputVerticalDatumPanel;
    private RmaJRadioButton _asDefinedRadioButton;
    private RmaJRadioButton _navd88RadioButton;
    private RmaJRadioButton _ngvd29RadioButton;
    private RmaJRadioButton _unspecifiedRadioButton;
    private ButtonGroup _verticalDatumButtonGroup;

    public AltRunControlPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridheight = 2;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS0000;
        this.add(jPanel, object);
        JComponent jComponent = new JLabel("Time Step:");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)10, (int)0, (int)5);
        jPanel.add((Component)jComponent, object);
        this._timeStepCombo = new RmaJComboBox((Object[])TimeStepUtil.a(new AltRunControlPanel$1()));
        this._timeStepCombo.setModifiable(true);
        this._timeStepCombo.setToolTipText("<html>This is the compute interval that the Alternative uses.</html>");
        this._timeStepCombo.setSelectedIndex(-1);
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 0.1;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        jPanel.add((Component)this._timeStepCombo, object);
        jComponent = new JPanel(new GridBagLayout());
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.01;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jComponent, object);
        this._explainationText = new JLabel();
        this._explainationText.setVerticalAlignment(1);
        ((GridBagConstraints)object).gridx = 2;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).gridheight = 3;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
        this._runOptPanel = new RssRunOptionPanel(this._editor);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 5;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.01;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)this._runOptPanel, object);
        this._msgLineLabel = new JLabel("");
        object = this._msgLineLabel.getFont();
        this._msgLineLabel.setFont(new Font(((Font)object).getName(), 1, ((Font)object).getSize()));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 16;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)this._msgLineLabel, object);
        boolean bl = Boolean.getBoolean("ResSim.UsesVerticalDatum");
        this._alternativeTypePanel = new JPanel(new GridBagLayout());
        this._alternativeTypePanel.setBorder(BorderFactory.createTitledBorder("Alternative Type"));
        ((GridBagConstraints)object).gridx = 2;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 0.1;
        ((GridBagConstraints)object).weighty = bl ? 0.0 : 0.1;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        AltRunControlPanel altRunControlPanel = this;
        altRunControlPanel.add(altRunControlPanel._alternativeTypePanel, object);
        this._standardRadio = new RmaJRadioButton("Standard");
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        this._alternativeTypePanel.add((Component)this._standardRadio, object);
        this._firmYieldRadio = new RmaJRadioButton("Firm Yield");
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS0505;
        this._yieldAnalysisRadio = new RmaJRadioButton("Yield Analysis");
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS0505;
        this._alternativeTypePanel.add((Component)this._yieldAnalysisRadio, object);
        this._radioPluginBG = new ButtonGroup();
        this._radioPluginBG.add((AbstractButton)this._standardRadio);
        this._radioPluginBG.add((AbstractButton)this._yieldAnalysisRadio);
        this._outputVerticalDatumPanel = new JPanel(new GridBagLayout());
        this._outputVerticalDatumPanel.setBorder(BorderFactory.createTitledBorder("Output Vertical Datum"));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 5, 5);
        AltRunControlPanel altRunControlPanel2 = this;
        altRunControlPanel2.add(altRunControlPanel2._outputVerticalDatumPanel, object);
        this._asDefinedRadioButton = new RmaJRadioButton("As Defined");
        object = "<html>The time series output of elevation for each location will be written in its native<br>vertical datum as specified in the network.  In addition, the specified vertical datum<br>and its conversion offsets will be included in the Vertical Datum block of the<br>time series' Supplemental Information.</html>";
        this._asDefinedRadioButton.setToolTipText((String)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        this._outputVerticalDatumPanel.add((Component)this._asDefinedRadioButton, object);
        this._navd88RadioButton = new RmaJRadioButton("NAVD88");
        object = "<html>The time series output of elevation for each location will be written in NAVD 88  and will be<br>identified as such in the Vertical Datum block of the time series\u2019 Supplemental Information</html>";
        this._navd88RadioButton.setToolTipText((String)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        this._outputVerticalDatumPanel.add((Component)this._navd88RadioButton, object);
        this._ngvd29RadioButton = new RmaJRadioButton("NGVD29");
        object = "<html>The time series output of elevation for each location will be written in NGVD 29 and will be<br>identified as such in the Vertical Datum block of the time series' Supplemental Information.</html>";
        this._ngvd29RadioButton.setToolTipText((String)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        this._outputVerticalDatumPanel.add((Component)this._ngvd29RadioButton, object);
        this._unspecifiedRadioButton = new RmaJRadioButton("Unspecified");
        object = "<html>If Unspecified is selected, the computed elevations will NOT be converted<br>to a specific vertical datum and a Vertical Datum information block will<br>NOT be included in the output records.</html>";
        this._unspecifiedRadioButton.setToolTipText((String)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 5, 5);
        this._outputVerticalDatumPanel.add((Component)this._unspecifiedRadioButton, object);
        this._verticalDatumButtonGroup = new ButtonGroup();
        this._verticalDatumButtonGroup.add((AbstractButton)this._asDefinedRadioButton);
        this._verticalDatumButtonGroup.add((AbstractButton)this._navd88RadioButton);
        this._verticalDatumButtonGroup.add((AbstractButton)this._ngvd29RadioButton);
        this._verticalDatumButtonGroup.add((AbstractButton)this._unspecifiedRadioButton);
        this.fillExplainationText();
        this._outputVerticalDatumPanel.setVisible(bl);
    }

    public void addRadioButton(AlternativePanel alternativePanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJRadioButton rmaJRadioButton = new RmaJRadioButton(alternativePanel.getTabname());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this._alternativeTypePanel.getComponentCount();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        this._alternativeTypePanel.add((Component)rmaJRadioButton, gridBagConstraints);
        rmaJRadioButton.addItemListener((ItemListener)new AltRunControlPanel$2(this));
        this._radioPluginBG.add((AbstractButton)rmaJRadioButton);
        this._pluginRadioMap.put(alternativePanel.getTabname(), alternativePanel);
    }

    public boolean isPluginRadioSelected(String string) {
        if (!this._pluginRadioMap.isEmpty()) {
            Enumeration<AbstractButton> enumeration = this._radioPluginBG.getElements();
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                if (!abstractButton.isSelected() || !abstractButton.getText().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public void selectPluginRadioButton(String string) {
        if (!this._pluginRadioMap.isEmpty()) {
            Enumeration<AbstractButton> enumeration = this._radioPluginBG.getElements();
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                if (!abstractButton.getText().equals(string)) continue;
                abstractButton.setSelected(true);
            }
        }
    }

    private void fillExplainationText() {
        RmaJRadioButton rmaJRadioButton = this._runOptPanel.getDefaultFCMRadio();
        String string = "<html><b>Time Step:</b> The compute interval.  Also, the output interval.<br><br><u><b>Flow Computation Method</b></u><br><b>Program Determined:</b> ResSim will determine the FCM thus:<br>";
        if (this._timeStepCombo.getSelectedIndex() == -1) {
            rmaJRadioButton.setToolTipText("<html>&#160&#160if any of the headwater inflow time-series data is of type period average, then<br>&#160&#160&#160&#160FCM=period average<br>&#160&#160else<br>&#160&#160&#160&#160if the time step (E part) of the inflow time-series data is all > 3hour then<br>&#160&#160&#160&#160&#160&#160FCM=period average<br>&#160&#160&#160&#160else<br>&#160&#160&#160&#160&#160&#160FCM=instantaneous.<br></html>");
        } else {
            rmaJRadioButton.setToolTipText("<html>&#160&#160if any of the inflow time-series data is of type period average, then<br>&#160&#160&#160&#160FCM=period average<br>&#160&#160else<br>&#160&#160&#160&#160if time step > 2hr<br>&#160&#160&#160&#160&#160&#160FCM=period average<br>&#160&#160&#160&#160else<br>&#160&#160&#160&#160&#160&#160FCM=instantaneous.<br></html>");
        }
        String cfr_ignored_0 = string + "</html>";
    }

    private void addListeners() {
        this._timeStepCombo.addItemListener((ItemListener)new AltRunControlPanel$3(this));
        this._timeStepCombo.addPopupMenuListener((PopupMenuListener)new AltRunControlPanel$4(this));
        this._standardRadio.addItemListener((ItemListener)new AltRunControlPanel$5(this));
        this._yieldAnalysisRadio.addItemListener((ItemListener)new AltRunControlPanel$6(this));
    }

    private void radioAction(ItemEvent object) {
        if (((ItemEvent)object).getItem() == this._standardRadio) {
            this._editor.setTabEnabled(this._editor.getYieldAnalysisPanel(), false, "Enable by selecting " + this._yieldAnalysisRadio.getText() + " on the Run Control tab");
            this.setPluginTabEnabled(null);
            return;
        }
        if (((ItemEvent)object).getItem() == this._yieldAnalysisRadio) {
            if (this._yieldAnalysisRadio.isSelected()) {
                this._editor.setTabEnabled(this._editor.getYieldAnalysisPanel(), true, null);
                this.setPluginTabEnabled(null);
                return;
            }
            this._editor.setTabEnabled(this._editor.getYieldAnalysisPanel(), false, "Enable by selecting " + this._yieldAnalysisRadio.getText() + " on the Run Control tab");
            this.setPluginTabEnabled(null);
            return;
        }
        if (((ItemEvent)object).getItem() instanceof RmaJRadioButton) {
            object = ((RmaJRadioButton)((ItemEvent)object).getItem()).getText();
            this.setPluginTabEnabled((String)object);
        }
    }

    private void setTabEnabled(String string, boolean bl) {
        int n = this._editor.getTabbedPane().getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!this._editor.getTabbedPane().getTitleAt(i).equals(string)) continue;
            this._editor.getTabbedPane().setEnabledAt(i, bl);
            if (this._editor.getTabbedPane().getSelectedIndex() != i) break;
            this._editor.getTabbedPane().setSelectedIndex(0);
            return;
        }
    }

    private void setPluginTabEnabled(String object) {
        if (this._pluginRadioMap.isEmpty()) {
            return;
        }
        Object[] objectArray = this._pluginRadioMap.keySet().toArray();
        if (object == null) {
            Set<String> set = this._pluginRadioMap.keySet();
            object = set.iterator();
            while (object.hasNext()) {
                this.setTabEnabled((String)object.next(), false);
            }
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof String)) continue;
            String string = (String)objectArray[i];
            if (string.equals(object)) {
                this.setTabEnabled(string, true);
                continue;
            }
            this.setTabEnabled(string, false);
        }
    }

    protected void timeStepComboAction() {
        this.resetTimeStepComboBackground();
        this.fillExplainationText();
        this.setMsgLine("");
    }

    protected void resetTimeStepComboBackground() {
        this._timeStepCombo.setBackground(UIManager.getColor("ComboBox.background"));
    }

    @Override
    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)object;
        object = this._alternative.getOutputVerticalDatumType();
        switch (AltRunControlPanel$7.a[((Enum)object).ordinal()]) {
            case 1: {
                this._navd88RadioButton.setSelected(true);
                break;
            }
            case 2: {
                this._ngvd29RadioButton.setSelected(true);
                break;
            }
            case 3: {
                this._asDefinedRadioButton.setSelected(true);
                break;
            }
            case 4: {
                this._unspecifiedRadioButton.setSelected(true);
            }
        }
        int n = this._alternative.getTimestep();
        int n2 = this._alternative.getTimestepIncrement();
        boolean bl = false;
        if (n == -1 || n2 == -1) {
            bl = true;
            int[] nArray = RssAlt.a(this._alternative);
            n = nArray[0];
            n2 = nArray[1];
        }
        Object object2 = switch (n2) {
            case 3 -> Duration.ofDays(n);
            case 2 -> Duration.ofHours(n);
            case 1 -> Duration.ofMinutes(n);
            default -> TimeStepUtil.TIME_STEP_ALL.getDuration();
        };
        if (this._alternative.getInputTSDataSet() != null) {
            if (bl && n != -1) {
                this._timeStepCombo.setSelectedItem((Object)TimeStepUtil.a((Duration)object2));
                this._timeStepCombo.setBackground(Color.YELLOW);
                this.setMsgLine("<html>Time Step was selected by ResSim. <br>Please verify that the selected Time Step is correct.</html>");
                this.selectTab();
            } else if (n != -1) {
                this._timeStepCombo.setSelectedItem((Object)TimeStepUtil.a((Duration)object2));
                this._timeStepCombo.setBackground(UIManager.getColor("ComboBox.background"));
                this.setMsgLine("");
            } else {
                this._timeStepCombo.setBackground(Color.YELLOW);
                this._timeStepCombo.setSelectedIndex(-1);
                this.setMsgLine("<html>ResSim was unable to determine a default Time Step.<br> Please select the Time Step</html>");
                this.selectTab();
            }
        }
        if (this._alternative.useYieldAnalysis()) {
            this._yieldAnalysisRadio.setSelected(true);
            this._editor.getYieldAnalysisPanel().setEnabled(true);
            this.setPluginTabEnabled(null);
        } else if (!this._pluginRadioMap.isEmpty()) {
            Object[] objectArray = this._pluginRadioMap.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string;
                if (!(objectArray[i] instanceof String) || this._alternative.getAltPluginData(string = (String)objectArray[i]) == null || !(object2 = this._alternative.getAltPluginData(string)).useCompute()) continue;
                this.setPluginTabEnabled(string);
                this.selectPluginRadioButton(string);
            }
        } else {
            this._standardRadio.setSelected(true);
            this.setPluginTabEnabled(null);
        }
        this._runOptPanel.fillPanel(this._alternative);
        this.fillExplainationText();
    }

    public void updatePlugins(boolean bl) {
        this.setIgnoreModifiedEvents(true);
        if (this._alternative == null) {
            this._standardRadio.setSelected(true);
            this.setPluginTabEnabled(null);
            this.setIgnoreModifiedEvents(false);
            return;
        }
        if (this._alternative.useYieldAnalysis()) {
            this._yieldAnalysisRadio.setSelected(true);
            this.setPluginTabEnabled(null);
        } else if (!this._pluginRadioMap.isEmpty()) {
            Object[] objectArray = this._pluginRadioMap.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                AltPluginData altPluginData;
                String string;
                if (!(objectArray[i] instanceof String) || this._alternative.getAltPluginData(string = (String)objectArray[i]) == null || !(altPluginData = this._alternative.getAltPluginData(string)).useCompute()) continue;
                this.setPluginTabEnabled(string);
                this.setIgnoreModifiedEvents(false);
                return;
            }
            this._standardRadio.setSelected(true);
            this.setPluginTabEnabled(null);
        }
        this.setIgnoreModifiedEvents(false);
    }

    private void setMsgLine(String string) {
        Object object = ClientApp.app().getProperties();
        if (object != null) {
            object = object.getProp("client.compute.warningColor", "yellow");
            RmaColor.parseColorString((String)object);
            this._msgLineLabel.setForeground(Color.RED);
        }
        this._msgLineLabel.setText(string);
    }

    protected void selectTab() {
        this._editor.setSelectedTab((Component)((Object)this));
    }

    public boolean isFirmYieldSelected() {
        return this._firmYieldRadio.isSelected();
    }

    public boolean isYieldAnalysisSelected() {
        return this._yieldAnalysisRadio.isSelected();
    }

    @Override
    public String getTabname() {
        return "Run Control";
    }

    public boolean savePanel() {
        AltRunControlPanel altRunControlPanel = this;
        return altRunControlPanel.savePanel(altRunControlPanel._alternative);
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    @Override
    public void clearPanel() {
        this._timeStepCombo.setSelectedIndex(-1);
        this.resetTimeStepComboBackground();
        this._msgLineLabel.setText("");
    }

    public int getTimestep() {
        int n;
        int n2 = this._timeStepCombo.getSelectedIndex();
        Object object = n2 >= 0 ? (TimeStepUtil)((Object)this._timeStepCombo.getItemAt(n2)) : null;
        int n3 = 1;
        if (object != null && (n = ((String)(object = ((TimeStepUtil)((Object)object)).toString())).indexOf(32)) >= 0) {
            object = ((String)object).substring(0, n);
            n3 = RMAIO.parseInt((String)object, (int)1);
        }
        return n3;
    }

    public int getTimeStepIncrement() {
        int n;
        int n2 = this._timeStepCombo.getSelectedIndex();
        Object object = n2 >= 0 ? (TimeStepUtil)((Object)this._timeStepCombo.getItemAt(n2)) : null;
        int n3 = 2;
        if (object != null && (n = ((String)(object = ((TimeStepUtil)((Object)object)).toString())).indexOf(32)) >= 0) {
            if ("Hour".equalsIgnoreCase((String)(object = ((String)object).substring(n).trim())) || "Hours".equalsIgnoreCase((String)object)) {
                n3 = 2;
            } else if ("Minute".equalsIgnoreCase((String)object) || "Minutes".equalsIgnoreCase((String)object)) {
                n3 = 1;
            } else if (((String)object).equalsIgnoreCase("Day")) {
                n3 = 3;
            } else if (((String)object).equalsIgnoreCase("Second")) {
                n3 = 0;
            }
        }
        return n3;
    }

    @Override
    public boolean savePanel(RssAlt objectArray) {
        Object object = objectArray == null ? this._alternative : objectArray;
        if (object == null) {
            return true;
        }
        if (this._navd88RadioButton.isSelected()) {
            objectArray.setOutputVerticalDatumType(OutputVerticalDatumType.NAVD88);
        } else if (this._ngvd29RadioButton.isSelected()) {
            objectArray.setOutputVerticalDatumType(OutputVerticalDatumType.NGVD29);
        } else if (this._asDefinedRadioButton.isSelected()) {
            objectArray.setOutputVerticalDatumType(OutputVerticalDatumType.AS_DEFINED);
        } else if (this._unspecifiedRadioButton.isSelected()) {
            objectArray.setOutputVerticalDatumType(OutputVerticalDatumType.UNSPECIFIED);
        }
        if (this._timeStepCombo.getSelectedItem() == null) {
            this._editor.setSelectedTab((Component)((Object)this));
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "No Time Step Selected.\nDo you want to select a time step?", "No TimeStep", 0, 2);
            if (n == 0) {
                return false;
            }
        }
        object.setTimeStep(this.getTimestep(), this.getTimeStepIncrement());
        object.setUseYieldAnalysis(this._yieldAnalysisRadio.isSelected());
        if (!this._pluginRadioMap.isEmpty()) {
            objectArray = this._pluginRadioMap.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof String)) continue;
                String string = (String)objectArray[i];
                AltPluginData altPluginData = object.getAltPluginData(string);
                if (altPluginData == null) {
                    altPluginData = (AltPluginData)AltPluginDataFactory.getFactory().getAltPluginData(string);
                    object.addAltPluginData(altPluginData);
                }
                altPluginData.setUseCompute(this.isPluginRadioSelected(string));
            }
        }
        this._runOptPanel.savePanel((RssAlt)object);
        return true;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._network = rssSystem;
    }

    public void setWqVisible(boolean bl) {
        this._runOptPanel.setWqVisible(bl);
    }

    public boolean isWqSelected() {
        return this._runOptPanel.isWqSelected();
    }

    public void setComputingWaterQuality(boolean bl) {
        if (!bl && !this.isEnabled()) {
            return;
        }
        JRadioButton jRadioButton = this.findPluginRadio("Ensemble");
        if (jRadioButton != null) {
            jRadioButton.setEnabled(!bl);
        }
        if ((jRadioButton = this.findPluginRadio("Monte Carlo")) != null) {
            jRadioButton.setEnabled(!bl);
        }
    }

    private JRadioButton findPluginRadio(String string) {
        Enumeration<AbstractButton> enumeration = this._radioPluginBG.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.getText().equals(string)) continue;
            return jRadioButton;
        }
        return null;
    }

    public TimeStepUtil getSelectedTimeStep() {
        return (TimeStepUtil)((Object)this._timeStepCombo.getSelectedItem());
    }
}

