/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AbstractTimeSeriesPanel;
import hec.rss.client.AltEditorVariantMenuBuilder;
import hec.rss.client.AltTimeSeriesContainerPanel$1;
import hec.rss.client.AltTimeSeriesContainerPanel$2;
import hec.rss.client.AltTimeSeriesPanel;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.client.InflowMultiplierEditor;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.TsVariant;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaInsets;

public class AltTimeSeriesContainerPanel
extends AbstractEditorPanel
implements AlternativePanel,
ChangeListener {
    private AlternativeEditor _editor;
    private RssSystem _system;
    private RssAlt _alternative;
    private JTabbedPane _tabbedPane;
    private Map<String, AltTimeSeriesPanel> _tsPanels = new HashMap<String, AltTimeSeriesPanel>();
    private InflowMultiplierEditor _inflowMultiEditor;
    private String _inflowText;
    private Set<String> _msgDisplayedSet = new HashSet<String>();
    AltTimeSeriesPanel _defaultPanel;
    private JMenu _variantMenu;

    public AltTimeSeriesContainerPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = alternativeEditor;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = this._tsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltTimeSeriesPanel)object.next()).stateChanged(changeEvent);
        }
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        Object object = this._tsPanels.values();
        object = object.iterator();
        boolean bl = true;
        while (object.hasNext()) {
            if (((AltTimeSeriesPanel)object.next()).savePanel(rssAlt)) continue;
            bl = false;
        }
        if (this._inflowMultiEditor != null && this._inflowMultiEditor.isModified()) {
            this._inflowMultiEditor.saveForm();
        }
        return bl;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }

    @Override
    public void clearPanel() {
        Object object = this._tsPanels.values();
        Iterator<AltTimeSeriesPanel> iterator = object.iterator();
        while (iterator.hasNext()) {
            iterator.next().clearPanel();
        }
        iterator = object.iterator();
        iterator.hasNext();
        if (iterator.hasNext()) {
            object = iterator.next().getTsVariant();
            this.removeVariantTab((TsVariant)((Object)object));
        }
        this._inflowMultiEditor = null;
        if (this._variantMenu != null) {
            int n = this._variantMenu.getMenuComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!(this._variantMenu.getMenuComponent(i) instanceof JMenu)) continue;
                JMenu jMenu = (JMenu)this._variantMenu.getMenuComponent(i);
                jMenu.removeAll();
            }
        }
        this._system = null;
        this._alternative = null;
        AltEditorVariantMenuBuilder.a();
    }

    public void addVariant(TsVariant tsVariant) {
        if (tsVariant == null) {
            return;
        }
        if (this._tabbedPane == null) {
            this.addTabbedPane();
        }
        String string = tsVariant.getName();
        AltTimeSeriesPanel altTimeSeriesPanel = new AltTimeSeriesPanel(this._editor, this);
        this._tsPanels.put(string, altTimeSeriesPanel);
        altTimeSeriesPanel.setSystem(this._system);
        altTimeSeriesPanel.setVariant(tsVariant);
        ((AbstractTimeSeriesPanel)altTimeSeriesPanel).fillPanel((NamedType)this._alternative);
        this._tabbedPane.addTab(string, (Component)((Object)altTimeSeriesPanel));
        int n = string.indexOf(45);
        int n2 = this._tabbedPane.getTabCount() - 1;
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this._tabbedPane.setToolTipTextAt(n2, "Time Series Input linking for ResSim in " + string2 + " for Variant " + string3);
        } else {
            this._tabbedPane.setToolTipTextAt(n2, "Time Series Entries for Variant " + string);
        }
        this._tabbedPane.setSelectedIndex(n2);
    }

    public void removeVariantTab(TsVariant tsVariant) {
        if (tsVariant == null) {
            return;
        }
        int n = this.findTabIndexFor(tsVariant);
        if (n >= 0) {
            AltTimeSeriesPanel altTimeSeriesPanel = (AltTimeSeriesPanel)((Object)this._tabbedPane.getComponentAt(n));
            this._tsPanels.remove(((AbstractTimeSeriesPanel)altTimeSeriesPanel).getTabname());
            this._tabbedPane.removeTabAt(n);
            if (this._tabbedPane.getTabCount() == 1) {
                AltTimeSeriesContainerPanel altTimeSeriesContainerPanel = this;
                altTimeSeriesContainerPanel.remove(altTimeSeriesContainerPanel._tabbedPane);
                this._tabbedPane = null;
                this.addStandAlonePanel();
            }
        }
    }

    private int findTabIndexFor(TsVariant object) {
        int n;
        if (this._tabbedPane != null && (n = this._tabbedPane.getTabCount()) > 1) {
            object = object.getName();
            for (int i = 1; i < n; ++i) {
                String string = this._tabbedPane.getTitleAt(i);
                if (!string.equals(object)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public String getTabname() {
        return "Time-Series";
    }

    @Override
    public void fillPanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return;
        }
        if (namedType == this._alternative && !this._alternative.isModified()) {
            return;
        }
        this._inflowMultiEditor = null;
        this.removeAll();
        this._tsPanels.clear();
        this._tabbedPane = null;
        this._alternative = (RssAlt)namedType;
        this._alternative.getInputTSVariantNames();
        this._defaultPanel = new AltTimeSeriesPanel(this._editor, this);
        namedType = AltTimeSeriesPanel.l;
        this._defaultPanel.setSystem(this._system);
        this._defaultPanel.setVariant((TsVariant)namedType);
        ((AbstractTimeSeriesPanel)this._defaultPanel).fillPanel((NamedType)this._alternative);
        this._tsPanels.put(namedType.getName(), this._defaultPanel);
        this.addStandAlonePanel();
        this._inflowMultiEditor = new InflowMultiplierEditor(this._editor, this._alternative);
        if (this._alternative.isUsingInflowFactors()) {
            this.setInflowMultipliersBtnIcon(AltTimeSeriesPanel.o);
        } else {
            this.setInflowMultipliersBtnIcon(AltTimeSeriesPanel.n);
        }
        AltTimeSeriesContainerPanel altTimeSeriesContainerPanel = this;
        altTimeSeriesContainerPanel.setTextInInflowPanel(altTimeSeriesContainerPanel._inflowText);
        boolean bl = this.shouldDisplayMsg();
        if (bl && !this._editor.isNewAlt()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>There are one or more new Time Series entries that need input.<br>");
            stringBuilder.append("Please use the Time Series tab to complete the new entries and Save the alternative.");
            if (this._alternative.getInputTSVariantNames().size() > 0) {
                stringBuilder.append("<br><br>You will need to edit and save each Time Series Variant to fully manage the new entries.");
            }
            stringBuilder.append("<html>");
            this.setDisplayedNewTsMsg();
            EventQueue.invokeLater(new AltTimeSeriesContainerPanel$1(this, stringBuilder));
        } else {
            this.setModified(false);
        }
        String string = System.getProperty("InputTimeSeries.variantEditorPrefix");
        if (string != null && this._tabbedPane != null) {
            EventQueue.invokeLater(new AltTimeSeriesContainerPanel$2(this, string));
        }
    }

    private void addStandAlonePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltTimeSeriesContainerPanel altTimeSeriesContainerPanel = this;
        altTimeSeriesContainerPanel.add((Component)((Object)altTimeSeriesContainerPanel._defaultPanel), gridBagConstraints);
    }

    private boolean shouldDisplayMsg() {
        if (this.shouldDisplayNewTsMsg()) {
            Object object = this._tsPanels.values();
            object = object.iterator();
            while (object.hasNext()) {
                if (!((AltTimeSeriesPanel)object.next()).hasNewLocation()) continue;
                return true;
            }
        }
        return false;
    }

    protected void setDisplayedNewTsMsg() {
        this._msgDisplayedSet.add(this._alternative.getName());
    }

    private boolean shouldDisplayNewTsMsg() {
        return !this._msgDisplayedSet.contains(this._alternative.getName());
    }

    private void addTabbedPane() {
        AltTimeSeriesContainerPanel altTimeSeriesContainerPanel = this;
        altTimeSeriesContainerPanel.remove((Component)((Object)altTimeSeriesContainerPanel._defaultPanel));
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        AltTimeSeriesContainerPanel altTimeSeriesContainerPanel2 = this;
        altTimeSeriesContainerPanel2.add(altTimeSeriesContainerPanel2._tabbedPane, gridBagConstraints);
        this._tabbedPane.addTab(AltTimeSeriesPanel.l.getName(), (Component)((Object)this._defaultPanel));
        this._tabbedPane.setToolTipTextAt(0, "Time Series Input linking for ResSim in standalone");
    }

    public boolean savePanel() {
        AltTimeSeriesContainerPanel altTimeSeriesContainerPanel = this;
        return altTimeSeriesContainerPanel.savePanel(altTimeSeriesContainerPanel._alternative);
    }

    public boolean savePanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return false;
        }
        return this.savePanel((RssAlt)namedType);
    }

    public void windowClosing() {
        Object object = this._tsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltTimeSeriesPanel)object.next()).windowClosing();
        }
        this._msgDisplayedSet.clear();
        AltEditorVariantMenuBuilder.a();
    }

    public void setPanelEnabled(boolean bl) {
        Object object = this._tsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltTimeSeriesPanel)object.next()).setPanelEnabled(bl);
        }
    }

    public void setProgramOrder(Vector vector, String string) {
        Object object = this._tsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltTimeSeriesPanel)object.next()).setProgramOrder(vector, string);
        }
    }

    public void editInflowMultipliersAction() {
        SwingUtilities.windowForComponent((Component)((Object)this));
        this._inflowMultiEditor.setVisible(true);
        if (this._inflowMultiEditor.isCanceled()) {
            this.setModified(false);
            return;
        }
        this._inflowMultiEditor.saveForm();
        if (this._inflowMultiEditor.hasDefaultInflows()) {
            this.setInflowMultipliersBtnIcon(AltTimeSeriesPanel.o);
            return;
        }
        this.setInflowMultipliersBtnIcon(AltTimeSeriesPanel.n);
    }

    private void setInflowMultipliersBtnIcon(Icon icon) {
        Object object = this._tsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltTimeSeriesPanel)object.next()).setInflowMultipliersBtnIcon(icon);
        }
    }

    public void setInflowMultipliersBtnVisible(boolean bl) {
        Object object = this._tsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltTimeSeriesPanel)object.next()).setInflowMultipliersBtnVisible(bl);
        }
    }

    public Vector getPanelMenus() {
        if (this._alternative == null || this._alternative.getInputTSVariants().isEmpty()) {
            return null;
        }
        Vector<JMenuItem> vector = AltEditorVariantMenuBuilder.a(this._editor);
        this._variantMenu = new JMenu("Variants");
        for (int i = 0; i < vector.size(); ++i) {
            this._variantMenu.add((JMenuItem)vector.get(i));
        }
        Vector<JMenu> vector2 = new Vector<JMenu>(1);
        vector2.add(this._variantMenu);
        return vector2;
    }

    public void setTextInInflowPanel(String string) {
        this._inflowText = string;
        Object object = this._tsPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltTimeSeriesPanel)object.next()).setTextInInflowPanel(string);
        }
    }
}

