/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.dss.DSSPathname;
import hec.lang.NamedType;
import hec.rss.client.AbstractTimeSeriesPanel;
import hec.rss.client.AltTimeSeriesContainerPanel;
import hec.rss.client.AltTimeSeriesPanel$1;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.model.GVDataSet;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssSystem;
import hec.rss.model.TsVariant;
import hec.rss.model.globalvariable.AltTimeSeriesGlobalData;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.TimeSeriesGlobalVariable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.util.RMAIO;

public class AltTimeSeriesPanel
extends AbstractTimeSeriesPanel
implements AlternativePanel,
ChangeListener {
    public static TsVariant l = new TsVariant("ResSim-Default", false);
    public static String m = "ResSim.TsGvMatchByName";
    private static String p = "Global Variable";
    private static FluentLogger q = FluentLogger.forEnclosingClass();
    static Icon n = RmaImage.getImageIcon((String)"Images/Icons/checkBoxUnselected.gif");
    static Icon o = RmaImage.getImageIcon((String)"Images/Icons/checkBoxSelected.gif");
    private JPanel _inflowPanel;
    RssAlt m_alternative;
    RssSystem m_system;
    private JButton _editInflowMultipliersBtn;
    private ActionListener _variantAL;
    private TsVariant _variant = l;
    private AlternativeEditor _altEditor;
    private AltTimeSeriesContainerPanel _parentPanel;
    private TSDataSet _tsDataSet;
    private JTextField _additionalText;
    private boolean _hasNewLocation;
    private GVDataSet _gvDataSet;
    private int _firstGvRowIndex = -1;
    private int _lastGvRowIndex = -1;

    public AltTimeSeriesPanel(AlternativeEditor alternativeEditor, AltTimeSeriesContainerPanel altTimeSeriesContainerPanel) {
        this._altEditor = alternativeEditor;
        this._parentPanel = altTimeSeriesContainerPanel;
    }

    @Override
    protected void buildControls() {
        super.buildControls();
        this.timeSeriesTable.removePopupMenuSumOptions();
        this.timeSeriesTable.removePopupMenuRowEditingOptions();
        this._inflowPanel = new JPanel(new GridBagLayout());
        this._editInflowMultipliersBtn = new JButton("Inflow Multipliers...");
        this._editInflowMultipliersBtn.setIcon(n);
        new GridBagConstraints();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._buttonPanel.add((Component)this._editInflowMultipliersBtn, gridBagConstraints);
        this._additionalText = new JTextField();
        this._additionalText.setBorder(null);
        this._additionalText.setEditable(false);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._buttonPanel.add((Component)this._additionalText, gridBagConstraints);
        this._editInflowMultipliersBtn.addActionListener(new AltTimeSeriesPanel$1(this));
        this.timeSeriesTable.setAutoResizeMode(2);
        this.timeSeriesTable.setPasteAddsRows(false);
    }

    public JPanel getInflowPanel() {
        return this._inflowPanel;
    }

    protected void editInflowMultipliersAction() {
        this._parentPanel.editInflowMultipliersAction();
    }

    @Override
    public void stateChanged(ChangeEvent serializable) {
        if (serializable.getSource() instanceof JTabbedPane && ((JTabbedPane)(serializable = (JTabbedPane)serializable.getSource())).getSelectedComponent() == this) {
            AltTimeSeriesPanel altTimeSeriesPanel = this;
            ((AbstractTimeSeriesPanel)altTimeSeriesPanel).fillPanel((NamedType)altTimeSeriesPanel.m_alternative);
        }
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this.timeSeriesTable.clearSelection();
        this.timeSeriesTable.setNumRows(0);
        this.timeSeriesTable.deleteCells();
        this.m_system = rssSystem;
        if (rssSystem == null) {
            this.timeSeriesTable.setNumRows(0);
            return;
        }
        if (this.m_alternative != null) {
            rssSystem.setAlternative(this.m_alternative);
        }
        rssSystem.updateTSProxyList();
        this._reqTSProxyVec = rssSystem.getActiveTSProxies(null, 1);
        if (this._reqTSProxyVec == null) {
            return;
        }
        Vector<CallSite> vector = new Vector<CallSite>();
        for (int i = 0; i < this._reqTSProxyVec.size(); ++i) {
            String string;
            TSRecordProxy tSRecordProxy = (TSRecordProxy)this._reqTSProxyVec.elementAt(i);
            if (tSRecordProxy == null) continue;
            Vector<String> vector2 = new Vector<String>();
            String string2 = this.m_system.getNameForKeyString(tSRecordProxy.getName());
            String string3 = string2 + "-" + (string = RssModelVariableSet.getVariableName(tSRecordProxy.getVariableId()));
            if (vector.contains(string3)) continue;
            vector2.addElement(string2);
            vector2.addElement(string);
            vector.addElement((CallSite)((Object)string3));
            vector2.addElement(tSRecordProxy.getDSSFilename());
            this.timeSeriesTable.appendRow(vector2);
        }
        this.addTsGlobalVariables(rssSystem.getInputGlobalVariables(GlobalVariableType.TIME_SERIES));
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        this.m_alternative = rssAlt;
        this._tsDataSet = null;
        return ((AbstractTimeSeriesPanel)this).savePanel();
    }

    public boolean savePanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return false;
        }
        return this.savePanel((RssAlt)namedType);
    }

    @Override
    public boolean savePanel() {
        return this.savePanel(true);
    }

    protected boolean savePanel(boolean bl) {
        int n;
        Object object;
        if (this.m_alternative == null) {
            return true;
        }
        if (this.m_system == null) {
            return true;
        }
        if (this.m_alternative.getSystem() != this.m_system) {
            return true;
        }
        TSDataSet tSDataSet = this._tsDataSet;
        GVDataSet gVDataSet = this._gvDataSet;
        if (tSDataSet == null) {
            AltTimeSeriesPanel altTimeSeriesPanel = this;
            tSDataSet = altTimeSeriesPanel.isDefaultVariant(altTimeSeriesPanel._variant) ? this.m_alternative.getInputTSDataSet() : this.m_alternative.getInputTSDataSet(this._variant.getName(), this._variant.hasNonDefaultInput());
        }
        if (gVDataSet == null) {
            AltTimeSeriesPanel altTimeSeriesPanel = this;
            gVDataSet = altTimeSeriesPanel.isDefaultVariant(altTimeSeriesPanel._variant) ? this.m_alternative.getInputGVDataSet() : this.m_alternative.getInputGVDataSet(this._variant);
        }
        if (tSDataSet == null) {
            object = ClientApp.Workspace().getManagerIdentifier(ClientApp.app().getAppType(), TSDataSet.class.getName(), this.m_alternative.getName(), "fits");
            tSDataSet = (TSDataSet)ClientApp.Workspace().newManager(ClientApp.app().getAppType(), TSDataSet.class.getName());
            tSDataSet.setName(this.m_alternative.getName());
            tSDataSet.setDescription(this.m_alternative.getDescription() + " (TS Data Set)");
            if (!ClientApp.Workspace().saveManagerAs("rss", (Manager)tSDataSet, object)) {
                System.out.println("----------------------------------------------------------------------------------------");
                System.out.println("ERROR <AltTimSeriesPanel.savePanel()> : Unable to create a new Time Series Data Set");
                System.out.println("----------------------------------------------------------------------------------------");
                return false;
            }
            this.m_alternative.setDataSetPath(tSDataSet.getIdentifier().getPath());
        }
        this.timeSeriesTable.commitEdit(true);
        tSDataSet.clearTSRecordList();
        String string = ClientApp.Workspace().getWorkspacePath();
        for (n = 0; n < this.timeSeriesTable.getNumRows(); ++n) {
            String string2;
            object = null;
            String string3 = this.timeSeriesTable.getValueAt(n, this.getLocationCol()).toString();
            String string4 = (String)this.timeSeriesTable.getValueAt(n, this.getVariableCol());
            for (int i = 0; i < this._reqTSProxyVec.size(); ++i) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)this._reqTSProxyVec.elementAt(i);
                string2 = RssModelVariableSet.getVariableName(tSRecordProxy.getVariableId());
                if (!tSRecordProxy.getName().equals(string3) && !this.m_system.getNameForKeyString(tSRecordProxy.getName()).equals(string3) || !string2.equals(string4)) continue;
                object = tSRecordProxy;
                break;
            }
            if (object == null) {
                System.out.println("savePanel: failed to find TS Proxy for " + string3 + " " + string4);
                continue;
            }
            String string5 = object.getName();
            int n2 = object.getVariableId();
            if (string5 == null || string5.length() == 0 || n2 == Integer.MIN_VALUE || p.equalsIgnoreCase(string4)) continue;
            string2 = tSDataSet.getTSRecord(string5, n2);
            if (string2 == null) {
                int n3 = n2;
                string2 = tSDataSet.createTSRecord(string5, n3, RssModelVariableSet.getParamName(n3));
            }
            string3 = this.timeSeriesTable.getValueAt(n, this.getDssFileCol()).toString();
            string3 = RMAIO.getRelativePath((String)string, (String)string3);
            if (this.isInputColVisible()) {
                object = this.timeSeriesTable.getValueAt(n, this.getInputCol()).toString();
                string2.setInputDataPos(this.getInputPos((String)object));
            } else {
                AltTimeSeriesPanel altTimeSeriesPanel = this;
                if (altTimeSeriesPanel.isDefaultVariant(altTimeSeriesPanel._variant)) {
                    string2.setInputDataPos(0);
                }
            }
            string2.setDSSFilename(string3);
            object = "/" + this.timeSeriesTable.getValueAt(n, this.getAPartCol()).toString().trim() + "/" + this.timeSeriesTable.getValueAt(n, this.getBPartCol()).toString().trim() + "/" + this.timeSeriesTable.getValueAt(n, this.getCPartCol()).toString().trim() + "//" + this.timeSeriesTable.getValueAt(n, this.getEPartCol()).toString().trim() + "/" + this.timeSeriesTable.getValueAt(n, this.getFPartCol()).toString().trim() + "/";
            string2.setDSSPathname((String)object);
        }
        tSDataSet.setModified(true);
        n = 1;
        if (bl) {
            n = tSDataSet.saveManager() ? 1 : 0;
        }
        if (gVDataSet != null) {
            n &= this.saveTsGlobalVariables(gVDataSet, bl);
        }
        this.setModified(false);
        return n != 0;
    }

    private boolean saveTsGlobalVariables(GVDataSet gVDataSet, boolean bl) {
        int n;
        if (this._firstGvRowIndex < 0) {
            return true;
        }
        boolean bl2 = Boolean.getBoolean(m);
        for (n = this._firstGvRowIndex; n <= this._lastGvRowIndex; ++n) {
            GlobalVariable globalVariable;
            Object object = (String)this.timeSeriesTable.getValueAt(n, this.getVariableCol());
            if (!p.equalsIgnoreCase((String)object)) continue;
            object = (TimeSeriesGlobalVariable)this.timeSeriesTable.getValueAt(n, this.getLocationCol());
            Object object2 = this.getGvData(gVDataSet, (TimeSeriesGlobalVariable)object);
            Object object3 = null;
            GlobalVariable globalVariable2 = globalVariable = bl2 ? this.m_system.getGlobalVariable(object.getName()) : this.m_system.getGlobalVariable(((TimeSeriesGlobalVariable)object).getIndex());
            if (!((Optional)object2).isPresent()) {
                if (globalVariable != null) {
                    object3 = gVDataSet.createGVRecord(GlobalVariableType.TIME_SERIES, globalVariable.getIndex());
                    object3.setName(object.getName());
                }
            } else {
                object3 = ((Optional)object2).get();
            }
            if (!(object3 instanceof AltTimeSeriesGlobalData)) continue;
            if (globalVariable != null) {
                object3.setGlobalVariable(globalVariable);
            }
            object = (AltTimeSeriesGlobalData)object3;
            object2 = this.timeSeriesTable.getValueAt(n, this.getDssFileCol()).toString();
            object2 = ClientApp.Workspace().getRelativePath((String)object2);
            if (this.isInputColVisible()) {
                object3 = this.timeSeriesTable.getValueAt(n, this.getInputCol()).toString();
                object.setInputDataPos(this.getInputPos((String)object3));
            } else {
                AltTimeSeriesPanel altTimeSeriesPanel = this;
                if (altTimeSeriesPanel.isDefaultVariant(altTimeSeriesPanel._variant)) {
                    object.setInputDataPos(0);
                }
            }
            object.setDSSFilename((String)object2);
            object3 = new DSSPathname();
            object3.setAPart(this.timeSeriesTable.getValueAt(n, this.getAPartCol()).toString().trim());
            object3.setBPart(this.timeSeriesTable.getValueAt(n, this.getBPartCol()).toString().trim());
            object3.setCPart(this.timeSeriesTable.getValueAt(n, this.getCPartCol()).toString().trim());
            object3.setEPart(this.timeSeriesTable.getValueAt(n, this.getEPartCol()).toString().trim());
            object3.setFPart(this.timeSeriesTable.getValueAt(n, this.getFPartCol()).toString().trim());
            object.setDSSPathname(object3.getPathname());
        }
        gVDataSet.setModified(true);
        n = 1;
        if (bl && (n = gVDataSet.saveManager()) == 0) {
            ((FluentLogger.Api)q.atWarning()).log("Failed to save Global Variable Data Set" + gVDataSet.getName());
        }
        return n != 0;
    }

    private boolean isDefaultVariant(TsVariant tsVariant) {
        return l == tsVariant || tsVariant == null;
    }

    @Override
    public void fillPanel(NamedType object) {
        GVDataSet gVDataSet;
        if (!(object instanceof RssAlt)) {
            return;
        }
        this.m_alternative = (RssAlt)object;
        object = this.m_alternative.getSystem();
        if (object == null) {
            return;
        }
        this.setSystem((RssSystem)object);
        if (this._variant == null) {
            this._variant = l;
        }
        if (this.m_alternative.getInputTSDataSet() == null) {
            this.setIgnoreModifiedEvents(false);
            return;
        }
        if (this._variant == l) {
            object = this.m_alternative.getInputTSDataSet();
            gVDataSet = this.m_alternative.getInputGVDataSet();
        } else {
            object = this.m_alternative.getInputTSDataSet(this._variant);
            gVDataSet = this.m_alternative.getInputGVDataSet(this._variant);
        }
        this.fillPanel((TSDataSet)object);
        this.fillPanel(gVDataSet);
    }

    private void fillPanel(GVDataSet gVDataSet) {
        this._gvDataSet = gVDataSet;
        for (int i = this._firstGvRowIndex; i <= this._lastGvRowIndex; ++i) {
            int n = i;
            Object object2 = (String)this.timeSeriesTable.getValueAt(n, this.getVariableCol());
            if (!p.equalsIgnoreCase((String)object2)) continue;
            object2 = (TimeSeriesGlobalVariable)this.timeSeriesTable.getValueAt(n, this.getLocationCol());
            object2 = this.getGvData(gVDataSet, (TimeSeriesGlobalVariable)object2);
            ((Optional)object2).ifPresent(object -> {
                DSSPathname dSSPathname = new DSSPathname(object.getDSSPathname());
                object = this._gvDataSet.getRelativePath(object.getDSSFilename());
                this.timeSeriesTable.setValueAt(object, n, this.getDssFileCol());
                this.timeSeriesTable.setValueAt((Object)dSSPathname.getAPart(), n, this.getAPartCol());
                this.timeSeriesTable.setValueAt((Object)dSSPathname.getBPart(), n, this.getBPartCol());
                this.timeSeriesTable.setValueAt((Object)dSSPathname.getCPart(), n, this.getCPartCol());
                this.timeSeriesTable.setValueAt((Object)dSSPathname.getEPart(), n, this.getEPartCol());
                this.timeSeriesTable.setValueAt((Object)dSSPathname.getFPart(), n, this.getFPartCol());
            });
            if (((Optional)object2).isPresent()) continue;
            this._hasNewLocation = true;
        }
    }

    private void fillPanel(TSDataSet tSDataSet) {
        this._hasNewLocation = false;
        this._tsDataSet = tSDataSet;
        for (int i = 0; i < this.timeSeriesTable.getNumRows(); ++i) {
            Object object = null;
            String string = this.timeSeriesTable.getValueAt(i, this.getLocationCol()).toString();
            String string2 = (String)this.timeSeriesTable.getValueAt(i, this.getVariableCol());
            for (int j = 0; j < this._reqTSProxyVec.size(); ++j) {
                TSRecordProxy tSRecordProxy = (TSRecordProxy)this._reqTSProxyVec.elementAt(j);
                if (!tSRecordProxy.getName().equals(string) && (!this.m_system.getNameForKeyString(tSRecordProxy.getName()).equals(string) || !string2.equals(RssModelVariableSet.getVariableName(tSRecordProxy.getVariableId())))) continue;
                object = tSRecordProxy;
                break;
            }
            if (object == null) continue;
            String string3 = object.getName();
            int n = object.getVariableId();
            if (string3 == null || string3.length() == 0 || n == Integer.MIN_VALUE || p.equalsIgnoreCase(string2)) continue;
            object = tSDataSet.getTSRecord(string3, n);
            if (object == null) {
                System.out.println("NULL TSRecord for (NAME,PARAM) = (" + string3 + "," + RssModelVariableSet.getVariableName(n) + ")");
                this._hasNewLocation = true;
                continue;
            }
            this.timeSeriesTable.setValueAt((Object)object.getDSSFilename(), i, this.getDssFileCol());
            int n2 = object.getInputDataPos();
            this.setInputPos(n2, i);
            object = DSSPathname.parseDssPath((String)object.getDSSPathname());
            if (object == null) continue;
            this.timeSeriesTable.setValueAt(((Vector)object).elementAt(0), i, this.getAPartCol());
            this.timeSeriesTable.setValueAt(((Vector)object).elementAt(1), i, this.getBPartCol());
            this.timeSeriesTable.setValueAt(((Vector)object).elementAt(2), i, this.getCPartCol());
            this.timeSeriesTable.setValueAt(((Vector)object).elementAt(4), i, this.getEPartCol());
            this.timeSeriesTable.setValueAt(((Vector)object).elementAt(5), i, this.getFPartCol());
        }
        if (this.m_alternative.isUsingInflowFactors()) {
            this._editInflowMultipliersBtn.setIcon(o);
        } else {
            this._editInflowMultipliersBtn.setIcon(n);
        }
        this.setModified(false);
    }

    private Optional<GlobalVariableData> getGvData(GVDataSet object, TimeSeriesGlobalVariable timeSeriesGlobalVariable) {
        Optional<GlobalVariableData> optional = Optional.empty();
        if (object != null && timeSeriesGlobalVariable.isInput()) {
            boolean bl = Boolean.getBoolean(m);
            for (GlobalVariableData globalVariableData : ((GVDataSet)((Object)object)).getGVRecords(GlobalVariableType.TIME_SERIES)) {
                if (!(globalVariableData instanceof AltTimeSeriesGlobalData) || (!bl || !globalVariableData.getName().equalsIgnoreCase(timeSeriesGlobalVariable.getName())) && globalVariableData.getIndex() != timeSeriesGlobalVariable.getIndex()) continue;
                optional = Optional.of(globalVariableData);
                break;
            }
        }
        return optional;
    }

    private void addTsGlobalVariables(List<GlobalVariable> list) {
        this._firstGvRowIndex = -1;
        this._lastGvRowIndex = -1;
        if (!list.isEmpty()) {
            this._firstGvRowIndex = this.timeSeriesTable.getRowCount();
        }
        for (GlobalVariable globalVariable : list) {
            if (!globalVariable.isInput()) continue;
            globalVariable.getName();
            String string = p;
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(globalVariable);
            vector.addElement(string);
            this.timeSeriesTable.appendRow(vector);
        }
        if (!list.isEmpty()) {
            this._lastGvRowIndex = this.timeSeriesTable.getRowCount() - 1;
        }
    }

    @Override
    protected void setInputPos(int n, int n2) {
        if (!this._inputColVisible) {
            return;
        }
        switch (n) {
            case -1: {
                this.timeSeriesTable.setValueAt((Object)"OBS", n2, this.getInputCol());
                return;
            }
            case 0: {
                String string = (String)this._inputVec.get(1);
                this.timeSeriesTable.setValueAt((Object)string, n2, this.getInputCol());
                return;
            }
        }
        String string = System.getProperty("InputTimeSeries.variantEditorPrefix");
        if (string != null) {
            this.timeSeriesTable.setValueAt((Object)String.valueOf(n), n2, this.getInputCol());
            return;
        }
        String string2 = "" + n;
        if (this._inputVec.size() >= 3) {
            int n3 = this._inputVec.size();
            for (int i = 2; i < n3; ++i) {
                string = RMAIO.getType((String)((String)this._inputVec.get(i)), (String)" ");
                if (!string2.equals(string)) continue;
                this.timeSeriesTable.setValueAt(this._inputVec.get(i), n2, this.getInputCol());
                return;
            }
        }
        this.timeSeriesTable.setValueAt((Object)"Default", n2, this.getInputCol());
    }

    @Override
    public void clearPanel() {
        AltTimeSeriesPanel altTimeSeriesPanel = this;
        altTimeSeriesPanel.setSystem(altTimeSeriesPanel.m_system);
        this.timeSeriesTable.clearSelection();
        this.timeSeriesTable.deleteCells();
    }

    @Override
    protected boolean isTableCellEditable(int n, int n2) {
        if (this._variant != l) {
            return false;
        }
        if (this.isInputColVisible() && n2 > 1) {
            String string = this.timeSeriesTable.getValueAt(n, this.getInputCol()).toString();
            int n3 = this.getInputPos(string);
            return n3 <= 0;
        }
        return this.timeSeriesTable.getModel().isCellEditable(n, n2);
    }

    public void setVariant(TsVariant tsVariant) {
        this._variant = tsVariant;
        if (tsVariant.hasNonDefaultInput() != this._inputColVisible) {
            this.timeSeriesTable.setColumnVisible(2, tsVariant.hasNonDefaultInput(), 50);
            this._inputColVisible = tsVariant.hasNonDefaultInput();
        }
    }

    public TsVariant getTsVariant() {
        return this._variant;
    }

    @Override
    public String getTabname() {
        if (this._variant == null) {
            return super.getTabname();
        }
        return this._variant.getName();
    }

    @Override
    protected boolean isDefaultVariant() {
        return this._variant == l;
    }

    public void setInflowMultipliersBtnIcon(Icon icon) {
        this._editInflowMultipliersBtn.setIcon(icon);
    }

    public void setInflowMultipliersBtnVisible(boolean bl) {
        this._editInflowMultipliersBtn.setVisible(bl);
    }

    public void setTextInInflowPanel(String string) {
        if (string == null || string.isEmpty()) {
            this._additionalText.setText("");
            this._additionalText.setToolTipText(null);
            return;
        }
        this._additionalText.setText(string);
        this._additionalText.setToolTipText(string);
        this._additionalText.setCaretPosition(0);
    }

    public boolean hasNewLocation() {
        return this._hasNewLocation;
    }
}

