/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.client.ReservoirStorageVsYieldAnalysisPanel;
import hec.rss.client.ReservoirYieldAnalysisPanel;
import hec.rss.client.ReverseReservoirYieldAnalysisPanel;
import hec.rss.client.ReverseWaterAccountYieldAnalysisPanel;
import hec.rss.client.WaterAccountYieldAnalysisPanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.WaterAccountSet;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJRadioButton;
import rma.util.RMAUtil;

public class AltYieldAnalysisPanel
extends AbstractEditorPanel
implements AlternativePanel {
    private RmaJComboBox<YieldAnalysisType> _yieldAnalysisTypeCombo;
    private JPanel _cardPanel;
    private ReservoirYieldAnalysisPanel _resYAPanel;
    private WaterAccountYieldAnalysisPanel _waterAccountPanel;
    private ReverseReservoirYieldAnalysisPanel _reverseResYAPanel;
    private ReverseWaterAccountYieldAnalysisPanel _reverseWaterAccountPanel;
    private ReservoirStorageVsYieldAnalysisPanel _storageVsYAPanel;
    private RmaJRadioButton _bisectionOnlyRadio;
    private RmaJRadioButton _heuristicBisectionRadio;
    private RmaJIntegerField _maxHeuristicIterationField;
    private AlternativeEditor _editor;
    private RssAlt _alternative;
    private RssSystem _network;

    AltYieldAnalysisPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildControls();
    }

    protected void buildControls() {
        Serializable serializable = new JPanel(new GridBagLayout());
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.add((Component)serializable, object);
        JLabel jLabel = new JLabel("Yield Analysis Type:");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)5);
        ((Container)serializable).add(jLabel, object);
        object = new YieldAnalysisType[]{YieldAnalysisType.RESERVOIR, YieldAnalysisType.WATER_ACCOUNT, YieldAnalysisType.REVERSE_RESERVOIR, YieldAnalysisType.REVERSE_WATER_ACCOUNT, YieldAnalysisType.RESERVOIR_STORAGE_VS_YIELD_ANALYSIS};
        this._yieldAnalysisTypeCombo = new RmaJComboBox((Object[])object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)5);
        ((Container)serializable).add((Component)this._yieldAnalysisTypeCombo, object);
        this._yieldAnalysisTypeCombo.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 2) {
                return;
            }
            this.yieldTypeComboChanged();
        });
        serializable = new JSeparator();
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.weightx = 1.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = new Insets(0, 5, 0, 5);
        this.add((Component)serializable, object);
        serializable = new JPanel(new GridBagLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 2;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        this.add(new JScrollPane((Component)serializable), object);
        this._cardPanel = new JPanel(new CardLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        ((Container)serializable).add(this._cardPanel, object);
        this._resYAPanel = new ReservoirYieldAnalysisPanel(this._editor);
        this._cardPanel.add(YieldAnalysisType.RESERVOIR.toString(), this._resYAPanel);
        this._waterAccountPanel = new WaterAccountYieldAnalysisPanel(this._editor);
        this._cardPanel.add(YieldAnalysisType.WATER_ACCOUNT.toString(), this._waterAccountPanel);
        this._reverseResYAPanel = new ReverseReservoirYieldAnalysisPanel(this._editor);
        this._cardPanel.add(YieldAnalysisType.REVERSE_RESERVOIR.toString(), this._reverseResYAPanel);
        this._reverseWaterAccountPanel = new ReverseWaterAccountYieldAnalysisPanel(this._editor);
        this._cardPanel.add(YieldAnalysisType.REVERSE_WATER_ACCOUNT.toString(), this._reverseWaterAccountPanel);
        this._storageVsYAPanel = new ReservoirStorageVsYieldAnalysisPanel(this._editor);
        this._cardPanel.add(YieldAnalysisType.RESERVOIR_STORAGE_VS_YIELD_ANALYSIS.toString(), this._storageVsYAPanel);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Convergence Method"));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 2;
        object.weightx = 1.0;
        object.gridwidth = 2;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        ((Container)serializable).add(jPanel, object);
        this._bisectionOnlyRadio = new RmaJRadioButton("Bisection Search Only");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weighty = 0.0;
        object.gridwidth = 1;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._bisectionOnlyRadio, object);
        this._bisectionOnlyRadio.setSelected(true);
        this._bisectionOnlyRadio.addActionListener(actionEvent -> this.radioAction());
        this._heuristicBisectionRadio = new RmaJRadioButton("Heuristic and Bisection Search");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 0;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._heuristicBisectionRadio, object);
        this._heuristicBisectionRadio.addActionListener(actionEvent -> this.radioAction());
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._bisectionOnlyRadio);
        ((ButtonGroup)serializable).add((AbstractButton)this._heuristicBisectionRadio);
        jLabel = new JLabel("Max Heuristic Iterations:");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        object.gridy = 0;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        jPanel.add((Component)jLabel, object);
        this._maxHeuristicIterationField = new RmaJIntegerField();
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        object.gridy = 0;
        object.weighty = 1.0;
        object.weightx = 1.0;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        jPanel.add((Component)this._maxHeuristicIterationField, object);
        this._maxHeuristicIterationField.setEnabled(true);
    }

    void setWaterAccounts(WaterAccountSet waterAccountSet) {
        this._waterAccountPanel.fillAccountCombo(waterAccountSet);
    }

    private void yieldTypeComboChanged() {
        YieldAnalysisType yieldAnalysisType = (YieldAnalysisType)((Object)this._yieldAnalysisTypeCombo.getSelectedItem());
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, yieldAnalysisType.toString());
        RMAUtil.setParentModified((Component)((Object)this));
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this._editor.isYieldAnalysisSelected() && bl) {
            super.setEnabled(bl);
            this.radioAction();
            this._resYAPanel.setEnabled(bl);
            this._reverseResYAPanel.setEnabled(bl);
            this._waterAccountPanel.setEnabled(bl);
            this._reverseWaterAccountPanel.setEnabled(bl);
            this._storageVsYAPanel.setEnabled(bl);
            return;
        }
        super.setEnabled(false);
        this._resYAPanel.setEnabled(false);
        this._reverseResYAPanel.setEnabled(false);
        this._waterAccountPanel.setEnabled(false);
        this._reverseWaterAccountPanel.setEnabled(false);
        this._storageVsYAPanel.setEnabled(false);
    }

    private void radioAction() {
        this._maxHeuristicIterationField.setEnabled(!this._bisectionOnlyRadio.isSelected());
    }

    private YieldAnalysis getSelectedYieldAnalysis() {
        YieldAnalysis yieldAnalysis;
        if (this._alternative == null) {
            return null;
        }
        switch (this._alternative.getSelectedYieldAnalysis()) {
            case RESERVOIR: {
                yieldAnalysis = this._alternative.getReservoirYieldAnalysis();
                break;
            }
            case REVERSE_RESERVOIR: {
                yieldAnalysis = this._alternative.getReverseReservoirYieldAnalysis();
                break;
            }
            case WATER_ACCOUNT: {
                yieldAnalysis = this._alternative.getWaterAccountYieldAnalysis();
                break;
            }
            case REVERSE_WATER_ACCOUNT: {
                yieldAnalysis = this._alternative.getReverseWaterAccountYieldAnalysis();
                break;
            }
            case RESERVOIR_STORAGE_VS_YIELD_ANALYSIS: {
                yieldAnalysis = this._alternative.getReservoirStorageVsYieldAnalysis();
                break;
            }
            default: {
                return null;
            }
        }
        return yieldAnalysis;
    }

    @Override
    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)object;
        this._resYAPanel.fillPanel((NamedType)this._alternative);
        this._reverseResYAPanel.fillPanel((NamedType)this._alternative);
        this._waterAccountPanel.fillPanel((NamedType)this._alternative);
        this._reverseWaterAccountPanel.fillPanel((NamedType)this._alternative);
        this._storageVsYAPanel.fillPanel((NamedType)this._alternative);
        object = this._alternative.getSelectedYieldAnalysis();
        this._yieldAnalysisTypeCombo.setSelectedItem(object);
        object = this.getSelectedYieldAnalysis();
        if (object != null) {
            boolean bl = ((YieldAnalysis)object).useBisectionOnly();
            if (bl) {
                this._bisectionOnlyRadio.doClick(0);
            } else {
                this._heuristicBisectionRadio.doClick(0);
            }
            this._maxHeuristicIterationField.setValue(((YieldAnalysis)object).getMaxHeuristicIterations());
        }
        this.radioAction();
        EventQueue.invokeLater(() -> this._editor.isYieldAnalysisSelected());
        if (this._editor.isYieldAnalysisSelected()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        this.setModified(false);
    }

    @Override
    public String getTabname() {
        return "Yield Analysis";
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        AltYieldAnalysisPanel altYieldAnalysisPanel = this;
        return altYieldAnalysisPanel.savePanel(altYieldAnalysisPanel._alternative);
    }

    @Override
    public boolean savePanel(RssAlt cloneable) {
        if (cloneable == null) {
            cloneable = this._alternative;
        }
        if (cloneable == null) {
            return true;
        }
        YieldAnalysisType yieldAnalysisType = (YieldAnalysisType)((Object)this._yieldAnalysisTypeCombo.getSelectedItem());
        ((RssAlt)cloneable).setSelectedYieldAnalysis(yieldAnalysisType);
        if (!this._waterAccountPanel.savePanel((RssAlt)cloneable)) {
            return false;
        }
        if (!this._resYAPanel.savePanel((RssAlt)cloneable)) {
            return false;
        }
        if (!this._reverseResYAPanel.savePanel((RssAlt)cloneable)) {
            return false;
        }
        if (!this._reverseWaterAccountPanel.savePanel((RssAlt)cloneable)) {
            return false;
        }
        if (!this._storageVsYAPanel.savePanel((RssAlt)cloneable)) {
            return false;
        }
        cloneable = this.getSelectedYieldAnalysis();
        if (cloneable != null) {
            ((YieldAnalysis)cloneable).setUseBisectionOnly(this._bisectionOnlyRadio.isSelected());
            ((YieldAnalysis)cloneable).setMaxHeuristicIterations(this._maxHeuristicIterationField.getValue());
        }
        this.setModified(false);
        return true;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._network = rssSystem;
    }

    @Override
    public void clearPanel() {
        this._maxHeuristicIterationField.setValue(8);
        this._resYAPanel.clearPanel();
        this._waterAccountPanel.clearPanel();
        this._reverseResYAPanel.clearPanel();
        this._reverseWaterAccountPanel.clearPanel();
        this._storageVsYAPanel.clearPanel();
        this._bisectionOnlyRadio.setSelected(true);
    }
}

