/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.AbstractSimulation;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.TrialRun;
import hec.gui.AbstractEditorPanel;
import hec.io.Identifier;
import hec.lang.ModelReference;
import hec.lang.NamedType;
import hec.model.AltItem;
import hec.model.DataObject;
import hec.rss.RssRmiWorkspace;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AbstractAlternativeEditor$AlternativeTableModel;
import hec.rss.client.AbstractAlternativeEditor$SaveAsDialog;
import hec.rss.client.AltDssOutputPanel;
import hec.rss.client.AltEditorVariantMenuBuilder;
import hec.rss.client.AltHindcastPanel;
import hec.rss.client.AltHotstartPanel;
import hec.rss.client.AltObservedContainerPanel;
import hec.rss.client.AltOperationsPanel;
import hec.rss.client.AltRunControlPanel;
import hec.rss.client.AltTimeSeriesContainerPanel;
import hec.rss.client.AltYieldAnalysisPanel;
import hec.rss.client.AlternativeEditor$1;
import hec.rss.client.AlternativeEditor$2;
import hec.rss.client.AlternativeEditor$3;
import hec.rss.client.AlternativeEditor$RssAlternativeTableModel;
import hec.rss.client.AlternativeEditor$SymWindow;
import hec.rss.client.AlternativePanel;
import hec.rss.client.ImportAlternativeDialog;
import hec.rss.client.RSS;
import hec.rss.client.RSimNetworkMode;
import hec.rss.client.globalvariable.AltGlobalVarPanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSimRun;
import hec.rss.model.RssSimTrialRun;
import hec.rss.model.RssSimulationRun;
import hec.rss.model.RssSystem;
import hec.rss.model.TsVariant;
import hec.rss.model.globalvariable.TableGlobalVariable;
import hec.rss.plugins.ResSimPluginModelPanel;
import hec.rss.plugins.model.PluginAltTabObject;
import hec.rss.server.RssAdvancedOptions;
import hec.rss.wq.client.AltWqPanel;
import hec.supplemental.model.ProgramOrderItem;
import hec.watershed.model.Condition;
import hec.watershed.model.ModelAlt;
import hec.watershed.model.Study;
import hec.watershed.model.StudyDataList;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.lang.Modifiable;
import rma.swing.ClosableDialog;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class AlternativeEditor
extends AbstractAlternativeEditor
implements ClosableDialog {
    public static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static final String EDITOR_TITLE = "ResSim Alternative Editor";
    private static List<PluginAltTabObject> b = new ArrayList<PluginAltTabObject>();
    AltOperationsPanel _operationsPanel;
    AltHindcastPanel _hindcastPanel;
    AltTimeSeriesContainerPanel _timeSeriesPanel;
    AltObservedContainerPanel _obsDataPanel;
    AltHotstartPanel _hotStartPanel;
    AltRunControlPanel _runcontrolPanel;
    AltYieldAnalysisPanel _yieldAnalysisPanel;
    AltDssOutputPanel _dssOutputPanel;
    protected AltWqPanel _wqPanel;
    AltGlobalVarPanel _gvPanel;
    protected JMenuItem _importAltMenuItem;
    protected JMenuItem m_deleteVariantMenuItem;
    RssAlt _selectedAlt = null;
    RssSystem _system = null;
    AlternativePanel _lastPanel;
    private boolean _changingTabs;
    private RowSorter<TableModel> _sorter;
    private List<AlternativePanel> _pluginTabs;

    public AlternativeEditor(Frame frame, boolean bl) {
        super(frame, bl);
        this.setTitle(EDITOR_TITLE);
        this.setSize(735, 700);
        this.setMinimumSize(new Dimension(610, 600));
    }

    public AlternativeEditor(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public static void a(Class clazz, int n) {
        if (clazz == null) {
            return;
        }
        AlternativeEditor.a(new PluginAltTabObject(false, null, clazz, n));
    }

    public static void a(PluginAltTabObject pluginAltTabObject) {
        if (pluginAltTabObject == null) {
            return;
        }
        if (AlternativePanel.class.isAssignableFrom(pluginAltTabObject.getTabClass()) && AbstractEditorPanel.class.isAssignableFrom(pluginAltTabObject.getTabClass())) {
            if (pluginAltTabObject.getTabPosition() < 0) {
                b.add(pluginAltTabObject);
                return;
            }
            b.add(pluginAltTabObject.getTabPosition(), pluginAltTabObject);
            return;
        }
        throw new IllegalArgumentException("Class " + pluginAltTabObject.getTabClass().getName() + " isn't assignable from " + AlternativePanel.class.getName() + " and " + AbstractEditorPanel.class.getName());
    }

    public static void a(Class clazz) {
        for (int i = 0; i < b.size(); ++i) {
            PluginAltTabObject pluginAltTabObject = b.get(i);
            if (pluginAltTabObject == null || pluginAltTabObject.getTabClass() != clazz) continue;
            b.remove(pluginAltTabObject);
        }
    }

    @Override
    protected void buildControls() {
        super.buildControls();
        this._pattern = Pattern.compile("[^:].*");
        this._pluginTabs = new ArrayList<AlternativePanel>();
        this.setDefaultCloseOperation(0);
        this._runcontrolPanel = new AltRunControlPanel(this);
        this._operationsPanel = new AltOperationsPanel(this);
        this._hindcastPanel = new AltHindcastPanel();
        this._timeSeriesPanel = new AltTimeSeriesContainerPanel(this);
        this._obsDataPanel = new AltObservedContainerPanel(this);
        this._hotStartPanel = new AltHotstartPanel(this);
        this._yieldAnalysisPanel = new AltYieldAnalysisPanel(this);
        this._dssOutputPanel = new AltDssOutputPanel();
        this._wqPanel = new AltWqPanel(this);
        this._gvPanel = new AltGlobalVarPanel(this);
        this.tabPane.add(this._runcontrolPanel.getTabname(), (Component)((Object)this._runcontrolPanel));
        this.tabPane.add(this._operationsPanel.getTabname(), (Component)((Object)this._operationsPanel));
        this.tabPane.add(this._hindcastPanel.getTabname(), (Component)((Object)this._hindcastPanel));
        this.tabPane.add(this._timeSeriesPanel.getTabname(), (Component)((Object)this._timeSeriesPanel));
        this.tabPane.add(this._obsDataPanel.getTabname(), (Component)((Object)this._obsDataPanel));
        this.tabPane.add(this._dssOutputPanel.getTabname(), (Component)((Object)this._dssOutputPanel));
        this.tabPane.add(this._hotStartPanel.getTabname(), (Component)((Object)this._hotStartPanel));
        this.tabPane.add(this._gvPanel.getTabname(), (Component)((Object)this._gvPanel));
        this.tabPane.add(this._yieldAnalysisPanel.getTabname(), (Component)((Object)this._yieldAnalysisPanel));
        if (this.hasWatershedWq()) {
            this.tabPane.add(this._wqPanel.getTabname(), (Component)((Object)this._wqPanel));
        }
        this.tabPane.addChangeListener(this);
        this._lastPanel = (AlternativePanel)((Object)this.tabPane.getSelectedComponent());
        this._importAltMenuItem = new JMenuItem("Import Alternative...", 97);
        this.addPluginTabs();
        this.getPreferredSize();
        AlternativeEditor$SymWindow alternativeEditor$SymWindow = new AlternativeEditor$SymWindow(this);
        this.addWindowListener(alternativeEditor$SymWindow);
    }

    boolean hasWatershedWq() {
        RssRmiWorkspace rssRmiWorkspace = (RssRmiWorkspace)ClientApp.Workspace().getChildWorkspace("rss");
        RssAdvancedOptions rssAdvancedOptions = null;
        try {
            rssAdvancedOptions = rssRmiWorkspace.getRssAdvancedOptions();
        }
        catch (RemoteException remoteException) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("resetWorkspace:error getting ResSim Options %s", (Object)remoteException);
        }
        if (rssAdvancedOptions != null) {
            boolean bl = rssAdvancedOptions.hasWaterQuality();
            return bl;
        }
        return false;
    }

    public void fillForm(ManagerProxyListContainer managerProxyListContainer) {
        Object object;
        Vector vector;
        boolean bl = this.hasWatershedWq();
        if (!bl) {
            this.tabPane.remove((Component)((Object)this._wqPanel));
        } else {
            int n = this.tabPane.indexOfTab(this._wqPanel.getTabname());
            if (n < 0) {
                this.tabPane.add(this._wqPanel.getTabname(), (Component)((Object)this._wqPanel));
            }
        }
        this._runcontrolPanel.setWqVisible(bl);
        this.m_modelAltTable.clear();
        this._wksp = managerProxyListContainer;
        this.setIgnoreModifiedEvents(true);
        ((AbstractAlternativeEditor)this).clearForm();
        Object object2 = (StudyDataList)managerProxyListContainer.getCommonDataList(Study.class.getName(), "");
        if (object2 != null) {
            object2.getOpenStudy();
        }
        Object object3 = (AbstractSimulation)managerProxyListContainer.getCommonDataList(Condition.class.getName(), "");
        object2 = null;
        if (object3 != null && (object3 = object3.getObjects()) != null) {
            vector = new Vector(((DataObject[])object3).length);
            object = (RmaListModel)this.configurationComboBox.getModel();
            for (int i = 0; i < ((AbstractSimulation)object3).length; ++i) {
                if (((Condition)object3[i]).isStudyCondition()) {
                    object2 = object3[i];
                    continue;
                }
                vector.add(object3[i]);
            }
            object.setAll((Collection)vector);
            object.setEnableSort(false);
            if (object2 != null) {
                object.addElement(object2);
            }
            if (managerProxyListContainer instanceof ClientWorkspace) {
                object.addElement((Object)"None");
            }
            object.setEnableSort(true);
        }
        this.configurationComboBox.setSelectedIndex(-1);
        if (managerProxyListContainer instanceof AbstractSimulation) {
            if (Boolean.getBoolean("AlternativeEditor.DisplayAllAlts")) {
                object3 = managerProxyListContainer.getManagerIDList("rss", RssAlt.class.getName());
                for (int i = 0; i < ((Vector)object3).size(); ++i) {
                    object = (Identifier)((Vector)object3).get(i);
                    RssAlt rssAlt = (RssAlt)managerProxyListContainer.openManager("rss", (Identifier)object);
                    if (rssAlt == null) continue;
                    this.m_alternativeList.add(rssAlt);
                }
            } else {
                object3 = (AbstractSimulation)managerProxyListContainer;
                vector = object3.getSimulationRuns();
                for (int i = 0; i < vector.size(); ++i) {
                    object = (RssSimulationRun)vector.get(i);
                    if (object == null) continue;
                    this.addAlternative((RssSimulationRun)object);
                }
            }
        } else if (ClientApp.app() instanceof RSS && !Boolean.getBoolean("AlternativeEditor.DisplayAllAlts")) {
            object3 = managerProxyListContainer.getManagerIDList("rss", RssSimRun.class.getName());
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                object = (Identifier)((Vector)object3).get(i);
                RssSimulationRun rssSimulationRun = (RssSimulationRun)managerProxyListContainer.openManager("rss", (Identifier)object);
                if (rssSimulationRun == null) continue;
                this.addAlternative(rssSimulationRun);
            }
        } else {
            object3 = managerProxyListContainer.getManagerIDList("rss", RssAlt.class.getName());
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                RssAlt rssAlt;
                object = (Identifier)((Vector)object3).get(i);
                if (!this._pattern.matcher(object.getName()).matches() || (rssAlt = (RssAlt)managerProxyListContainer.openManager("rss", (Identifier)object)) == null) continue;
                this.m_alternativeList.add(rssAlt);
            }
        }
        if (this._sorter != null) {
            this._sorter.modelStructureChanged();
        } else {
            this._sorter = new TableRowSorter<TableModel>(this.alternativeTable.getModel());
            this.alternativeTable.setRowSorter(this._sorter);
        }
        Vector vector2 = managerProxyListContainer.getManagerIDList("rss", RssSystem.class.getName());
        if (vector2 != null && !vector2.isEmpty()) {
            ((RmaListModel)this.systemComboBox.getModel()).setAll((Collection)vector2);
        }
        this._wqPanel.fillPanel(managerProxyListContainer);
        this.setIgnoreModifiedEvents(false);
        ((AbstractAlternativeEditor)this).setModified(false);
        if (managerProxyListContainer instanceof ClientWorkspace) {
            if (this.configurationComboBox.getItemCount() > 0) {
                this.configurationComboBox.setSelectedIndex(0);
            }
        } else {
            this.m_newMenuItem.setVisible(false);
            this.m_saveAsMenuItem.setVisible(false);
            this.m_deleteMenuItem.setVisible(false);
            if (object2 != null) {
                this.configurationComboBox.setSelectedItem(object2);
            }
            this.configurationComboBox.setVisible(false);
            this.configurationLabel.setVisible(false);
        }
        if (this.alternativeTable.getRowCount() == 1) {
            SwingUtilities.invokeLater(new AlternativeEditor$1(this));
        } else if (this.alternativeTable.getSelectedRow() == -1) {
            this._system = null;
            this._selectedAlt = null;
            this.systemComboBox.setSelectedIndex(-1);
        }
        this.systemComboBox.addMouseListener((MouseListener)new AlternativeEditor$2(this));
    }

    protected void systemComboPopupAction(Point point) {
        if (ClientApp.frame().getCurrentMode() instanceof RSimNetworkMode && this.systemComboBox.getSelectedItem() != null) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Display Network in Module");
            jMenuItem.addActionListener(new AlternativeEditor$3(this));
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show((Component)this.systemComboBox, (int)point.getX(), (int)point.getY());
        }
    }

    protected void displayNetworkInModule() {
        if (!(ClientApp.frame().getCurrentMode() instanceof RSimNetworkMode)) {
            return;
        }
        RSimNetworkMode rSimNetworkMode = (RSimNetworkMode)ClientApp.frame().getCurrentMode();
        Object object = this.systemComboBox.getSelectedItem();
        if (object instanceof Identifier) {
            object = (Identifier)object;
            rSimNetworkMode.openNetwork((Identifier)object);
        }
    }

    public boolean isFirmYieldSelected() {
        return this._runcontrolPanel.isFirmYieldSelected();
    }

    public boolean isYieldAnalysisSelected() {
        return this._runcontrolPanel.isYieldAnalysisSelected();
    }

    private void addAlternative(RssSimulationRun object) {
        Object object2 = object.getRssAlt();
        if (object2 == null) {
            return;
        }
        object2 = (RssAlt)((RssAlt)object2).clone();
        ((RssAlt)object2).setUserName(object.getUserName());
        this.m_alternativeList.add(object2);
        object = object.getTrials();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            TrialRun trialRun = (TrialRun)((Vector)object).get(i);
            if (trialRun == null || trialRun instanceof RssSimTrialRun && (object2 = (RssSimTrialRun)trialRun).isAccepted() || !(trialRun instanceof RssSimulationRun) || (object2 = ((RssSimulationRun)trialRun).getRssAlt()) == null) continue;
            object2 = (RssAlt)((RssAlt)object2).clone();
            ((RssAlt)object2).setUserName(((RssSimulationRun)trialRun).getUserName());
            this.m_alternativeList.add(object2);
        }
    }

    public void setSelectedNetWork(RssSystem rssSystem) {
        if (rssSystem == null) {
            this.systemComboBox.setSelectedIndex(-1);
            return;
        }
        if ((rssSystem = rssSystem.getIdentifier()).equals(this.systemComboBox.getSelectedItem())) {
            return;
        }
        this.setIgnoreModifiedEvents(true);
        this.systemComboBox.setSelectedItem((Object)rssSystem);
        this.setIgnoreModifiedEvents(false);
    }

    @Override
    public void setSelectedAlternative(String string) {
        super.setSelectedAlternative(string);
        if (string == null) {
            this._selectedAlt = null;
        }
    }

    public RssAlt getSelectedAlternative() {
        return this._selectedAlt;
    }

    @Override
    protected void fillForm(Manager manager) {
        if (manager instanceof RssAlt) {
            ((AbstractAlternativeEditor)this).clearForm();
            this.fillForm((RssAlt)manager);
            return;
        }
        ((AbstractAlternativeEditor)this).clearForm();
        this.setDefaultState();
        this.tabPane.setEnabled(false);
    }

    protected void fillForm(RssAlt object) {
        if (object == null) {
            ((AbstractAlternativeEditor)this).clearForm();
            this._selectedAlt = null;
            this.tabPane.setEnabled(false);
            return;
        }
        if (((RssAlt)object).getSystem() == null) {
            ((AbstractAlternativeEditor)this).clearForm();
            this._selectedAlt = object;
            this.tabPane.setEnabled(false);
            this.nameDescriptionPanel.setName(this._selectedAlt.toString());
            this.nameDescriptionPanel.setDescription(this._selectedAlt.getDescription());
            this.m_deleteMenuItem.setEnabled(true);
            this.m_saveAsMenuItem.setEnabled(false);
            JOptionPane.showMessageDialog((Component)((Object)this), "Alternative's Network was deleted.", "Broken Alternative", 0);
            return;
        }
        try {
            int n;
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this._selectedAlt != null) {
                ClientApp.frame().getCurrentMode().unlockManager((Manager)this._selectedAlt, "Failed to unlock Alternative " + this._selectedAlt.toString(), this.m_callback[0], null);
            }
            this._selectedAlt = object;
            this.nameDescriptionPanel.setName(this._selectedAlt.toString());
            this.nameDescriptionPanel.setDescription(this._selectedAlt.getDescription());
            this.m_deleteVariantMenuItem.setEnabled(!this._selectedAlt.getInputTSVariants().isEmpty());
            if (((RssAlt)object).getSystem() != null) {
                this.systemComboBox.setSelectedItem((Object)this._selectedAlt.getSystem().getIdentifier());
            } else {
                this.systemComboBox.setSelectedIndex(-1);
            }
            this._selectedAlt = object;
            this._operationsPanel.fillPanel((NamedType)this._selectedAlt);
            this._hindcastPanel.setSystem(this._system);
            this._hindcastPanel.fillPanel((NamedType)this._selectedAlt);
            this._timeSeriesPanel.fillPanel((NamedType)this._selectedAlt);
            this._obsDataPanel.fillPanel((NamedType)this._selectedAlt);
            AlternativeEditor alternativeEditor = this;
            alternativeEditor.setTabEnabled(alternativeEditor._obsDataPanel, this._obsDataPanel.hasObservedData(), "Enable by Adding Observed Data in a Network Element Editors");
            this._hotStartPanel.fillPanel((NamedType)this._selectedAlt);
            this._runcontrolPanel.fillPanel((NamedType)this._selectedAlt);
            this._yieldAnalysisPanel.fillPanel((NamedType)this._selectedAlt);
            this._dssOutputPanel.fillPanel((NamedType)this._selectedAlt);
            if (this._wqPanel != null) {
                if (!this._selectedAlt.getWaterQualityOptions().shouldRunWq() && this.tabPane.getSelectedComponent() == this._wqPanel) {
                    this.tabPane.setSelectedIndex(0);
                }
                this._wqPanel.fillPanel((NamedType)this._selectedAlt);
            }
            this._gvPanel.fillPanel((NamedType)this._selectedAlt);
            object = this._system.getGlobalVariableList();
            AlternativeEditor alternativeEditor2 = this;
            alternativeEditor2.setTabEnabled(alternativeEditor2._gvPanel, !object.isEmpty(), "Enable by Adding Global Variables in the Network's Global Variable Editor");
            for (n = 0; n < this._pluginTabs.size(); n += 1) {
                this._pluginTabs.get(n).setSystem(this._system);
                this._pluginTabs.get(n).fillPanel((NamedType)this._selectedAlt);
            }
            this.m_saveAsMenuItem.setEnabled(true);
            EventQueue.invokeLater(() -> {
                if (this.tabPane.getSelectedComponent() instanceof AbstractEditorPanel) {
                    AbstractEditorPanel abstractEditorPanel = (AbstractEditorPanel)this.tabPane.getSelectedComponent();
                    this.updatePanelMenus(abstractEditorPanel);
                }
            });
            this.setFormEnabled(true);
            n = ClientApp.frame().getCurrentMode().lockManager((Manager)this._selectedAlt, "Failed to lock Alternative " + this._selectedAlt.toString(), null, null, this.m_callback) ? 1 : 0;
            this.setEditable(n != 0);
            ((AbstractAlternativeEditor)this).setModified(false);
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void setTabEnabled(AbstractEditorPanel abstractEditorPanel, boolean bl, String string) {
        JTabbedPane jTabbedPane = this.getTabbedPane();
        int n = jTabbedPane.indexOfComponent((Component)abstractEditorPanel);
        jTabbedPane.setEnabledAt(n, bl);
        if (!bl) {
            jTabbedPane.setToolTipTextAt(n, string);
        } else {
            jTabbedPane.setToolTipTextAt(n, null);
        }
        if (!bl && jTabbedPane.getSelectedComponent() == abstractEditorPanel) {
            jTabbedPane.setSelectedIndex(0);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.m_newAlt = false;
            this.initializeForm();
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int n = this.m_alternativeList.size();
            for (int i = 0; i < n; ++i) {
                RssAlt rssAlt = (RssAlt)this.m_alternativeList.get(i);
                if (rssAlt == null) continue;
                this._wksp.unloadManager("rss", rssAlt.getIdentifier());
            }
            this.m_alternativeList.clear();
            this.setCursor(Cursor.getDefaultCursor());
            this._timeSeriesPanel.windowClosing();
            if (this._system != null) {
                this._wksp.unloadManager("rss", this._system.getIdentifier());
                this._system = null;
            }
            this._gvPanel.commitEdits();
        }
        super.setVisible(bl);
    }

    @Override
    protected void setDefaultState() {
        super.setDefaultState();
        if (this.tabPane.getSelectedComponent() instanceof AlternativePanel) {
            this._lastPanel = (AlternativePanel)((Object)this.tabPane.getSelectedComponent());
            return;
        }
        if (this.tabPane.getSelectedComponent() instanceof JScrollPane) {
            this._lastPanel = (AlternativePanel)((Object)((JScrollPane)this.tabPane.getSelectedComponent()).getViewport().getComponent(0));
        }
    }

    @Override
    protected void setFormEnabled(boolean bl) {
        super.setFormEnabled(bl);
        this._timeSeriesPanel.setPanelEnabled(bl);
        this._obsDataPanel.setPanelEnabled(bl);
        this._hindcastPanel.setPanelEnabled(bl);
        this._operationsPanel.setPanelEnabled(bl);
        this._runcontrolPanel.updatePlugins(bl);
        if (!this.m_newAlt && bl) {
            this.m_deleteMenuItem.setEnabled(this._selectedAlt != null);
            this.m_saveAsMenuItem.setEnabled(this._selectedAlt != null);
            this.m_deleteVariantMenuItem.setEnabled(this._selectedAlt != null && !this._selectedAlt.getInputTSVariantNames().isEmpty());
            return;
        }
        this.m_deleteMenuItem.setEnabled(false);
        this.m_saveAsMenuItem.setEnabled(false);
        this.m_deleteVariantMenuItem.setEnabled(false);
    }

    @Override
    protected void configurationComboBoxChanged() {
        int n;
        Object object = this.configurationComboBox.getSelectedItem();
        Condition condition = null;
        if (object == null) {
            return;
        }
        if (object instanceof Condition) {
            condition = (Condition)object;
        }
        if (this.isModified() && !this.m_newAlt && this._selectedAlt != null) {
            AlternativeEditor alternativeEditor = this;
            n = RMAIO.postYesNoWarning((Component)((Object)alternativeEditor), (String)(alternativeEditor._selectedAlt.getName() + "'s data Has Changed!\nWould you like to save?"));
            if (n == 0 && !this.saveForm()) {
                return;
            }
        }
        n = 0;
        if (condition != null) {
            n = condition.isStudyCondition();
        }
        ((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).clearTable();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < this.m_alternativeList.size(); ++i) {
                boolean bl;
                RssAlt rssAlt = (RssAlt)this.m_alternativeList.get(i);
                if (rssAlt == null || !this.passesFilter(rssAlt.getName())) continue;
                if (n != 0) {
                    bl = true;
                } else {
                    Identifier identifier = rssAlt.getIdentifier();
                    bl = (identifier = this.getModelAlt(identifier, "rss")) != null ? (condition != null ? identifier.getConfigurationIds().contains(condition.getId()) : ("None".equals(object) ? identifier.getConfigurationIds().isEmpty() : false)) : false;
                }
                if (!bl) continue;
                ((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).addAlternative(rssAlt);
            }
            if (this._sorter != null) {
                this._sorter.modelStructureChanged();
            } else {
                this._sorter = new TableRowSorter<TableModel>(this.alternativeTable.getModel());
                this.alternativeTable.setRowSorter(this._sorter);
            }
            if (this.m_newAlt) {
                return;
            }
            this.m_newAlt = true;
            this._selectedAlt = null;
            if (this._okToClearForm) {
                this._system = null;
            }
            ((AbstractAlternativeEditor)this).clearForm();
            this.m_newAlt = false;
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected boolean passesFilter(String string) {
        if (Boolean.getBoolean("AlternativeEditor.DisplayAllAlts")) {
            return true;
        }
        return super.passesFilter(string);
    }

    @Override
    protected void systemComboBoxChanged() {
        Object object = this.systemComboBox.getSelectedItem();
        if (!(object instanceof Identifier)) {
            if (this._system != null) {
                this._wksp.unloadManager("rss", this._system.getIdentifier());
            }
            return;
        }
        object = (Identifier)object;
        ((FluentLogger.Api)LOGGER.atFine()).log("ID Selected = %s", object);
        boolean bl = false;
        if (this._system != null) {
            bl = this._system.getIdentifier().getPath().equals(object.getPath());
        }
        if (this._system != null && !bl) {
            this._wksp.unloadManager("rss", this._system.getIdentifier());
        }
        if (object == null) {
            this._system = null;
        } else if (!bl) {
            this._system = (RssSystem)this._wksp.openManager("rss", (Identifier)object);
        }
        this._system.getConfiguration();
        this._okToClearForm = false;
        this._okToClearForm = true;
        if (this._selectedAlt != null) {
            this._selectedAlt.setSystemIndex(this._system.getIndex());
            this._selectedAlt.setSystemPath(this._system.getIdentifier().getPath());
        }
        this._operationsPanel.setSystem(this._system);
        this._hindcastPanel.setSystem(this._system);
        this._timeSeriesPanel.setSystem(this._system);
        this._obsDataPanel.setSystem(this._system);
        this._dssOutputPanel.setSystem(this._system);
        this._gvPanel.setSystem(this._system);
    }

    @Override
    public void menuItemNew_Action() {
        int n;
        if (this.isModified() && (n = RMAIO.postYesNoWarning((Component)((Object)this), (String)"Data Has Changed!\nWould you like to save?")) == 0 && !this.saveForm()) {
            return;
        }
        ((AbstractAlternativeEditor)this).clearForm();
        this.alternativeTable.clearSelection();
        AlternativeEditor alternativeEditor = this;
        AbstractAlternativeEditor$SaveAsDialog abstractAlternativeEditor$SaveAsDialog = new AbstractAlternativeEditor$SaveAsDialog(alternativeEditor, (Dialog)((Object)alternativeEditor), "New Alternative ", RssSystem.class.getName());
        abstractAlternativeEditor$SaveAsDialog.setVisible(true);
        if (abstractAlternativeEditor$SaveAsDialog.isCanceled()) {
            return;
        }
        this._selectedAlt = this.newRssAlt(this.nameDescriptionPanel.getName(), this.nameDescriptionPanel.getDescription());
        this._system = this._selectedAlt.getSystem();
        this.m_newAlt = true;
        if (this.configurationComboBox.getSelectedItem() instanceof Condition) {
            if ((Condition)this.configurationComboBox.getSelectedItem() != this._system.getConfiguration() && !((Condition)this.configurationComboBox.getSelectedItem()).isStudyCondition()) {
                if (this._system.getConfiguration() == null) {
                    this.configurationComboBox.setSelectedItem((Object)"None");
                } else {
                    this.configurationComboBox.setSelectedItem((Object)this._system.getConfiguration());
                }
            }
        } else if (this._system.getConfiguration() != null) {
            this.configurationComboBox.setSelectedItem((Object)this._system.getConfiguration());
        }
        this._timeSeriesPanel.fillPanel((NamedType)this._selectedAlt);
        this._obsDataPanel.fillPanel((NamedType)this._selectedAlt);
        this._hindcastPanel.fillPanel((NamedType)this._selectedAlt);
        this._operationsPanel.fillPanel((NamedType)this._selectedAlt);
        this._runcontrolPanel.fillPanel((NamedType)this._selectedAlt);
        this._yieldAnalysisPanel.fillPanel((NamedType)this._selectedAlt);
        this._gvPanel.fillPanel((NamedType)this._selectedAlt);
        for (int i = 0; i < this._pluginTabs.size(); ++i) {
            this._pluginTabs.get(i).setSystem(this._system);
            this._pluginTabs.get(i).fillPanel((NamedType)this._selectedAlt);
        }
        this.m_saveAsMenuItem.setEnabled(false);
        this.tabPane.removeChangeListener(this);
        this.tabPane.setSelectedIndex(0);
        this.tabPane.addChangeListener(this);
        this.setFormEnabled(true);
        ((AbstractAlternativeEditor)this).setModified(true);
    }

    @Override
    public void menuItemDelete_Action() {
        ClientWorkspace clientWorkspace;
        int n = this.alternativeTable.getSelectedRow();
        if (n == -1) {
            RMAIO.postWarning((Component)((Object)this), (String)"Please Select an alternative to delete");
            return;
        }
        n = this.alternativeTable.convertRowIndexToModel(n);
        RssAlt rssAlt = (RssAlt)((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).getAlternativeAt(n);
        if (rssAlt == null) {
            return;
        }
        int n2 = RMAIO.postYesNoWarning((Component)((Object)this), (String)("Do you really want to delete Alternative - " + rssAlt.getName()));
        if (n2 == 1) {
            return;
        }
        if (this._wksp instanceof ClientWorkspace) {
            clientWorkspace = (ClientWorkspace)this._wksp;
            if (!clientWorkspace.deleteManager("rss", rssAlt.getIdentifier())) {
                RMAIO.postError((Component)((Object)this), (String)("An error occurred while trying to delete Alternative - " + rssAlt.getName()));
                return;
            }
        } else {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Can't delete Alternative. Don't have a ClientWorkspace");
            JOptionPane.showMessageDialog((Component)((Object)this), "Can't delete Alternative");
            return;
        }
        ((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).removeAlternativeAt(n);
        Object object = clientWorkspace.getManagerIdentifier("rss", ModelAlt.class.getName(), rssAlt.getName(), ".malt");
        if (object == null || !clientWorkspace.deleteManager("rss", object)) {
            ((FluentLogger.Api)LOGGER.atFine()).log("Could not find identifer for hec.model.ModelAlt - %s", (Object)rssAlt.getName());
        }
        if ((object = rssAlt.getInputTSDataSet()) != null) {
            clientWorkspace.deleteManager("rss", object.getIdentifier(), true);
        }
        if ((object = rssAlt.getOutputTSDataSet()) != null) {
            clientWorkspace.deleteManager("rss", object.getIdentifier(), true);
        }
        if ((object = rssAlt.getObservedTSDataSet()) != null) {
            clientWorkspace.deleteManager("rss", object.getIdentifier(), true);
        }
        object = this.getPaddedName(rssAlt.getName());
        object = clientWorkspace.getManagerIdentifier("rss", RssSimRun.class.getName(), (String)object, ".simrun");
        if (object == null || !clientWorkspace.deleteManager("rss", object)) {
            ((FluentLogger.Api)LOGGER.atFine()).log("Could not find identifer for hec.rss.model.RssSimRun - %s", (Object)rssAlt.getName());
        }
        for (int i = 0; i < this._pluginTabs.size(); ++i) {
            object = this._pluginTabs.get(i);
            if (!(object instanceof ResSimPluginModelPanel)) continue;
            ((ResSimPluginModelPanel)object).deleteAltManager(rssAlt);
        }
        this.m_alternativeList.remove(rssAlt);
        if (this.alternativeTable.getRowCount() > 0) {
            this.alternativeTable.updateSelection(0, 0, false, false);
            return;
        }
        ((AbstractAlternativeEditor)this).clearForm();
    }

    @Override
    protected boolean isUniqueAltName(String string) {
        if (super.isUniqueAltName(string)) {
            ManagerProxy managerProxy = null;
            ManagerProxyList managerProxyList = ClientApp.Workspace().getManagerProxyList("rss");
            try {
                managerProxy = managerProxyList.getManagerProxy(RssAlt.class.getName(), ClientApp.Workspace().getManagerIdentifier("rss", RssAlt.class.getName(), string, ".ralt"));
            }
            catch (Exception exception) {}
            if (managerProxy != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "A " + RMAIO.userNameToFileName((String)string) + " file already exists for the Alternative " + string + ".", "Error", 0);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void menuItemSave_Action() {
        super.menuItemSave_Action();
        this.systemComboBox.setEnabled(false);
    }

    @Override
    protected void menuItemSaveAs_Action() {
        if (this._selectedAlt == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select an Alternative to Save As");
            return;
        }
        int n = this.m_newAlt;
        RssAlt rssAlt = this._selectedAlt;
        this.m_newAlt = true;
        AlternativeEditor alternativeEditor = this;
        AbstractAlternativeEditor$SaveAsDialog abstractAlternativeEditor$SaveAsDialog = new AbstractAlternativeEditor$SaveAsDialog(alternativeEditor, (Dialog)((Object)alternativeEditor), "Save " + this.nameDescriptionPanel.getName() + " As...", RssSystem.class.getName());
        String string = rssAlt.getDescription();
        if (string != null && string.length() > 0) {
            abstractAlternativeEditor$SaveAsDialog.setDescription("Copy of " + string);
        }
        abstractAlternativeEditor$SaveAsDialog.setSaveOnClose(true);
        this.alternativeTable.getSelectedRow();
        abstractAlternativeEditor$SaveAsDialog.setSelectedNetwork(this._selectedAlt.getSystem().getIdentifier());
        abstractAlternativeEditor$SaveAsDialog.setVisible(true);
        if (abstractAlternativeEditor$SaveAsDialog.isCanceled()) {
            this._selectedAlt = rssAlt;
            this.m_newAlt = n;
            return;
        }
        n = this.alternativeTable.getSelectedRow();
        this._selectedAlt = (RssAlt)((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).getAlternativeAt(n);
    }

    protected void menuItemImportAlt_Action() {
        Cloneable cloneable;
        ImportAlternativeDialog importAlternativeDialog = new ImportAlternativeDialog((Frame)AppDaddy.getFrame(), true);
        importAlternativeDialog.setVisible(true);
        if (!importAlternativeDialog.isCanceled() && (cloneable = importAlternativeDialog.getNewAlternative()) != null) {
            this._selectedAlt = cloneable;
            this.m_newAlt = true;
            this.m_alternativeList.add(this._selectedAlt);
            this.setIgnoreModifiedEvents(true);
            cloneable = ClientApp.Workspace().getManagerIDList("rss", RssSystem.class.getName());
            if (cloneable != null && ((Vector)cloneable).size() > 0) {
                this.systemComboBox.removeAllItems();
                ((RmaListModel)this.systemComboBox.getModel()).setAll((Collection)((Object)cloneable));
            }
            this.setIgnoreModifiedEvents(false);
            ((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).addAlternative(this._selectedAlt);
            int n = this.alternativeTable.getNumRows() - 1;
            this.alternativeTable.updateSelection(n, 0, false, false);
            ((AbstractAlternativeEditor)this).setModified(false);
        }
        importAlternativeDialog.dispose();
    }

    @Override
    public void clearForm() {
        if (!this._okToClearForm) {
            return;
        }
        super.clearForm();
        this.systemComboBox.setSelectedIndex(-1);
        this._runcontrolPanel.setIgnoreModifiedEvents(true);
        this._operationsPanel.setIgnoreModifiedEvents(true);
        this._hindcastPanel.setIgnoreModifiedEvents(true);
        this._timeSeriesPanel.setIgnoreModifiedEvents(true);
        this._obsDataPanel.setIgnoreModifiedEvents(true);
        this._hotStartPanel.setIgnoreModifiedEvents(true);
        this._yieldAnalysisPanel.setIgnoreModifiedEvents(true);
        this._gvPanel.setIgnoreModifiedEvents(true);
        this._runcontrolPanel.clearPanel();
        this._operationsPanel.clearPanel();
        this._hindcastPanel.clearPanel(this.m_newAlt);
        this._timeSeriesPanel.clearPanel();
        this._obsDataPanel.clearPanel();
        this._hotStartPanel.clearPanel();
        this._gvPanel.clearPanel();
        this._yieldAnalysisPanel.clearPanel();
        this._runcontrolPanel.setIgnoreModifiedEvents(false);
        this._timeSeriesPanel.setIgnoreModifiedEvents(false);
        this._operationsPanel.setIgnoreModifiedEvents(false);
        this._obsDataPanel.setIgnoreModifiedEvents(false);
        this._hindcastPanel.setIgnoreModifiedEvents(false);
        this._hotStartPanel.setIgnoreModifiedEvents(false);
        this._yieldAnalysisPanel.setIgnoreModifiedEvents(false);
        this._gvPanel.setIgnoreModifiedEvents(false);
        for (int i = 0; i < this._pluginTabs.size(); ++i) {
            AlternativePanel alternativePanel = this._pluginTabs.get(i);
            ((AbstractEditorPanel)alternativePanel).setIgnoreModifiedEvents(true);
            try {
                alternativePanel.clearPanel();
                continue;
            }
            finally {
                ((AbstractEditorPanel)alternativePanel).setIgnoreModifiedEvents(false);
            }
        }
        this._selectedAlt = null;
    }

    @Override
    protected boolean saveForm() {
        boolean bl;
        String string = this.nameDescriptionPanel.getName();
        if (!this.isValidName(string)) {
            return false;
        }
        if (this.m_newAlt && this._selectedAlt != null) {
            bl = this.saveNewAlt(string, this.nameDescriptionPanel.getDescription());
        } else {
            AbstractEditorPanel abstractEditorPanel;
            int n;
            ((FluentLogger.Api)LOGGER.atFine()).log("-------------------------------------------------------------");
            ((FluentLogger.Api)LOGGER.atFine()).log("Saving existing Alternative");
            ((FluentLogger.Api)LOGGER.atFine()).log("-------------------------------------------------------------");
            this._operationsPanel.savePanel();
            this._timeSeriesPanel.savePanel();
            this._obsDataPanel.savePanel();
            this._hindcastPanel.savePanel();
            this._dssOutputPanel.savePanel(this._selectedAlt);
            if (this._gvPanel != null && !this._gvPanel.savePanel(this._selectedAlt)) {
                return false;
            }
            if (this._wqPanel != null && this._selectedAlt.hasWaterQualityOptions() && this._selectedAlt.getWaterQualityOptions().shouldRunWq() && !this._wqPanel.savePanel(this._selectedAlt)) {
                return false;
            }
            if (!this._runcontrolPanel.savePanel()) {
                return false;
            }
            if (!this._hotStartPanel.savePanel()) {
                return false;
            }
            if (!this._yieldAnalysisPanel.savePanel()) {
                return false;
            }
            for (n = 0; n < this._pluginTabs.size(); ++n) {
                abstractEditorPanel = (AbstractEditorPanel)this._pluginTabs.get(n);
                try {
                    if (abstractEditorPanel.savePanel((NamedType)this._selectedAlt)) continue;
                    return false;
                }
                catch (Exception exception) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("saveForm:error saving plugin tab %s Error:%s", (Object)abstractEditorPanel.getTabname(), (Object)exception);
                }
            }
            n = !this.nameDescriptionPanel.getDescription().equals(this._selectedAlt.getDescription()) ? 1 : 0;
            this._selectedAlt.setDescription(this.nameDescriptionPanel.getDescription());
            string = this._wksp.getManagerProxy("rss", RssAlt.class.getName(), this._selectedAlt.getIndex());
            if (string == null) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("Failed to find Alternative to save to. id=%s", this._selectedAlt.getIndex());
                JOptionPane.showMessageDialog((Component)((Object)this), "Failed to find Alternative to save to");
                bl = false;
            } else {
                RssAlt rssAlt = (RssAlt)string.loadManager(null, null);
                if (rssAlt == null) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("Failed to get RssAlt from Proxy %s", (Object)string);
                    bl = false;
                } else {
                    SimulationRun simulationRun;
                    rssAlt.copyInto(this._selectedAlt);
                    bl = this._wksp.saveManager("rss", (Manager)rssAlt);
                    if ((n != 0 || this._pluginTabs.size() > 0) && (simulationRun = this.getSimRun(rssAlt.getName(), "rss", RssSimRun.class.getName())) != null) {
                        boolean bl2 = false;
                        Vector vector = simulationRun.getAltList();
                        for (int i = 0; i < this._pluginTabs.size(); ++i) {
                            abstractEditorPanel = (AbstractEditorPanel)this._pluginTabs.get(i);
                            if (!(abstractEditorPanel instanceof ResSimPluginModelPanel) || !((ResSimPluginModelPanel)abstractEditorPanel).updateAltItemList(vector)) continue;
                            bl2 = true;
                        }
                        Object object = this.getPaddedName(rssAlt.getName());
                        boolean bl3 = false;
                        for (int i = 1; i < vector.size(); ++i) {
                            String string2 = this.getPaddedName(((AltItem)vector.get(i)).getAltName());
                            object = (String)object + string2;
                            bl3 = true;
                        }
                        if (bl3) {
                            simulationRun.setName((String)object);
                            simulationRun.getIdentifier().setName((String)object);
                            bl2 = true;
                        }
                        if (n != 0) {
                            simulationRun.setDescription(this._selectedAlt.getDescription());
                            simulationRun.getIdentifier().setDescription(this._selectedAlt.getDescription() + " (Simulation Run)");
                            bl2 = true;
                        }
                        if (bl2) {
                            this._wksp.saveManager("rss", (Manager)simulationRun);
                            this._wksp.unloadManager("rss", simulationRun.getIdentifier());
                            ((Modifiable)this._wksp).setModified(true);
                        }
                    }
                }
            }
        }
        if (bl) {
            ((AbstractAlternativeEditor)this).setModified(false);
        }
        return bl;
    }

    private boolean saveNewAlt(String object, String string) {
        boolean bl;
        String string2;
        int n;
        ((FluentLogger.Api)LOGGER.atFine()).log("-------------------------------------------------------------");
        ((FluentLogger.Api)LOGGER.atFine()).log("Saving New Alternative");
        ((FluentLogger.Api)LOGGER.atFine()).log("-------------------------------------------------------------");
        if (!(this._wksp instanceof ClientWorkspace)) {
            ((FluentLogger.Api)LOGGER.atFine()).log("saveForm: don't have a clientWorkspace. Can't create new Alt");
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to create new Alternative");
            return false;
        }
        string = (ClientWorkspace)this._wksp;
        if (this.findAlternative((String)object) != null) {
            RMAIO.postError((Component)((Object)this), (String)("Alternative \"" + (String)object + "\" already exists. Please choose another name!"));
            return false;
        }
        Object object2 = (Identifier)this.systemComboBox.getSelectedItem();
        if (object2 == null) {
            RMAIO.postError((Component)((Object)this), (String)"You must select a Reservoir Network in order to save this Alternative");
            return false;
        }
        Condition condition = null;
        RssSystem rssSystem = (RssSystem)ClientApp.Workspace().openManager("rss", object2);
        if (rssSystem != null) {
            condition = rssSystem.getConfiguration();
        }
        rssSystem = string.getManagerIdentifier("rss", RssAlt.class.getName(), (String)object, ".ralt");
        rssSystem.setDescription(this.nameDescriptionPanel.getDescription());
        object = (RssAlt)this._wksp.newManager("rss", RssAlt.class.getName());
        if (object == null) {
            RMAIO.postError((Component)((Object)this), (String)"An Error Occurred when creating a new Reservoir Alternative!\nSave aborted");
            return false;
        }
        ((RssAlt)object).copyInto(this._selectedAlt);
        ((RssAlt)object).setDataSetPath(null);
        ((RssAlt)object).setObservedDataSetPath(null);
        object.setName(rssSystem.getName());
        object.setIdentifier((Identifier)rssSystem);
        object.setDescription(this.nameDescriptionPanel.getDescription());
        ((RssAlt)object).setSystemIndex(this._system.getIndex());
        Object object3 = object;
        ((RssAlt)object3).setSystemPath(object3.getRelativePath(object2.getPath()));
        ((RssAlt)object).setInflowFactorType(this._selectedAlt.getInflowFactorType());
        ((RssAlt)object).setGlobalInflowFactor(this._selectedAlt.getGlobalInflowFactor());
        ((RssAlt)object).setLocationInflowFactors(this._selectedAlt.getLocationInflowFactors());
        ((RssAlt)object).setUsingInflowFactors(this._selectedAlt.isUsingInflowFactors());
        string.saveManagerAs("rss", (Manager)object, (Identifier)rssSystem);
        if (!((RssAlt)object).copyGvDataSetsInto(this._selectedAlt)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        for (n = 0; n < this._pluginTabs.size(); ++n) {
            object2 = this._pluginTabs.get(n);
            if (!(object2 instanceof ResSimPluginModelPanel)) continue;
            ((ResSimPluginModelPanel)object2).createPluginAlternative((RssAlt)object);
        }
        if (!this._runcontrolPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        if (!this._operationsPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        if (!this._timeSeriesPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        if (!this._obsDataPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        if (!this._hindcastPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        if (!this._hotStartPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        if (!this._yieldAnalysisPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        if (!this._dssOutputPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        if (((RssAlt)object).hasWaterQualityOptions() && ((RssAlt)object).getWaterQualityOptions().shouldRunWq() && this._wqPanel != null && !this._wqPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        if (!this._gvPanel.savePanel((RssAlt)object)) {
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        for (n = 0; n < this._pluginTabs.size(); ++n) {
            object2 = this._pluginTabs.get(n);
            if (object2.savePanel((RssAlt)object)) continue;
            string.deleteManager("rss", (Identifier)rssSystem);
            if (object2 instanceof ResSimPluginModelPanel) {
                ((ResSimPluginModelPanel)object2).deleteAltManager((RssAlt)object);
            }
            return false;
        }
        boolean bl2 = string.saveManagerAs("rss", (Manager)object, (Identifier)rssSystem);
        n = bl2 ? 1 : 0;
        if (!bl2) {
            RMAIO.postError((Component)((Object)this), (String)"An Error Occurred when saving the new Reservoir Alternative!\nSave aborted");
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        this._selectedAlt = (RssAlt)((RssAlt)object).clone();
        ((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).addAlternative(this._selectedAlt);
        ((AbstractAlternativeEditor$AlternativeTableModel)((Object)this.alternativeTable.getModel())).getRowCount();
        object2 = new ModelReference(object.getIndex(), object.getClass().getName(), "rss");
        Identifier identifier = string.getManagerIdentifier("rss", ModelAlt.class.getName(), object.getName(), ".malt");
        identifier.setDescription(object.getDescription() + " (Simulation)");
        ModelAlt modelAlt = (ModelAlt)ClientApp.Workspace().newManager("rss", ModelAlt.class.getName());
        if (modelAlt == null) {
            RMAIO.postError((Component)((Object)this), (String)"An Error Occurred when creating a new Model Simulation Alternative!\nSave aborted");
            string.deleteManager("rss", (Identifier)rssSystem);
            return false;
        }
        modelAlt.setModelRef((ModelReference)object2);
        modelAlt.setAltId(object.getName());
        ProgramOrderItem.RSS_MODEL.setIndex(1);
        modelAlt.setProgramIndex(ProgramOrderItem.RSS_MODEL);
        if (condition != null) {
            modelAlt.addConfiguration(condition);
        }
        boolean bl3 = string.saveManagerAs("rss", (Manager)modelAlt, identifier);
        n = bl3 ? 1 : 0;
        if (!bl3) {
            RMAIO.postError((Component)((Object)this), (String)"An Error occurred when trying to save the Model Simulation Alternative");
            string.deleteManager("rss", (Identifier)rssSystem);
            string.deleteManager("rss", identifier);
            return false;
        }
        Vector<AltItem> vector = new Vector<AltItem>();
        object2 = new AltItem("rss", object.getName(), 0, modelAlt.getIndex());
        vector.addElement((AltItem)object2);
        for (int i = 0; i < this._pluginTabs.size(); ++i) {
            object2 = this._pluginTabs.get(i);
            if (!(object2 instanceof ResSimPluginModelPanel)) continue;
            ((ResSimPluginModelPanel)object2).updateAltItemList(vector);
        }
        Object object4 = this.getPaddedName(object.getName());
        for (int i = 1; i < vector.size(); ++i) {
            string2 = this.getPaddedName(vector.get(i).getAltName());
            object4 = (String)object4 + string2;
        }
        Identifier identifier2 = string.getManagerIdentifier("rss", RssSimRun.class.getName(), (String)object4, ".simrun");
        identifier2.setDescription(object.getDescription() + " (Simulation Run)");
        string2 = (SimulationRun)ClientApp.Workspace().newManager("rss", RssSimRun.class.getName());
        if (string2 == null) {
            RMAIO.postError((Component)((Object)this), (String)"An Error occurred when trying to create the Simulation Run");
            string.deleteManager("rss", (Identifier)rssSystem);
            string.deleteManager("rss", identifier);
            return false;
        }
        string2.setAltList(vector);
        string2.setIdentifier(identifier2);
        string2.setUserName(object.getName());
        if (condition != null) {
            string2.setConfigurationId(condition.getId());
        }
        if (!(bl = string.saveManagerAs("rss", (Manager)string2, identifier2))) {
            RMAIO.postError((Component)((Object)this), (String)"An Error occurred when trying to save the Simulation Run");
            string.deleteManager("rss", (Identifier)rssSystem);
            string.deleteManager("rss", identifier);
            string.deleteManager("rss", identifier2);
            return false;
        }
        ((AbstractAlternativeEditor)this).setModified(false);
        int n2 = this.alternativeTable.getNumRows() - 1;
        this.m_saveAsMenuItem.setEnabled(true);
        this.m_alternativeList.add(this._selectedAlt);
        this.alternativeTable.repaint();
        this.alternativeTable.updateSelection(n2, 0, false, false);
        if (this._wksp instanceof ClientWorkspace) {
            ((ClientWorkspace)this._wksp).saveWorkspace();
        }
        return true;
    }

    private RssAlt findAlternative(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.m_alternativeList.size(); ++i) {
            NamedType namedType = (NamedType)this.m_alternativeList.get(i);
            if (namedType == null || !string.equals(namedType.getName())) continue;
            return (RssAlt)namedType;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent serializable) {
        if (serializable.getSource() == this.tabPane) {
            this._changingTabs = true;
            try {
                Object object;
                serializable = this.tabPane.getSelectedComponent();
                if (this._lastPanel != null) {
                    this._lastPanel.switchedFrom((Component)serializable);
                    if (this._lastPanel.isModified()) {
                        this._lastPanel.savePanel(this._selectedAlt);
                    }
                }
                if (serializable instanceof AlternativePanel) {
                    ((AlternativePanel)((Object)serializable)).switchedTo();
                }
                if (serializable == this._operationsPanel) {
                    this._operationsPanel.setIgnoreModifiedEvents(true);
                    this._operationsPanel.setSystem(this._system);
                    this._operationsPanel.fillPanel((NamedType)this._selectedAlt);
                    this._operationsPanel.setIgnoreModifiedEvents(false);
                } else if (serializable == this._hotStartPanel) {
                    this._hotStartPanel.setIgnoreModifiedEvents(true);
                    this._hotStartPanel.fillPanel((NamedType)this._selectedAlt);
                    this._hotStartPanel.setIgnoreModifiedEvents(false);
                } else if (serializable == this._yieldAnalysisPanel) {
                    this._yieldAnalysisPanel.setIgnoreModifiedEvents(true);
                    this._yieldAnalysisPanel.fillPanel((NamedType)this._selectedAlt);
                    this._yieldAnalysisPanel.setIgnoreModifiedEvents(false);
                } else if (serializable == this._hindcastPanel) {
                    this._hindcastPanel.setIgnoreModifiedEvents(true);
                    this._hindcastPanel.setSystem(this._system);
                    this._hindcastPanel.fillPanel((NamedType)this._selectedAlt);
                    this._hindcastPanel.setIgnoreModifiedEvents(false);
                } else if (serializable == this._timeSeriesPanel) {
                    this._timeSeriesPanel.setIgnoreModifiedEvents(true);
                    if (this._system != null) {
                        this._system.setAlternative(this._selectedAlt);
                    }
                    this._timeSeriesPanel.setSystem(this._system);
                    this._timeSeriesPanel.fillPanel((NamedType)this._selectedAlt);
                    this._timeSeriesPanel.setIgnoreModifiedEvents(false);
                } else if (serializable == this._gvPanel) {
                    this._gvPanel.setIgnoreModifiedEvents(true);
                    if (this._system != null) {
                        this._system.setAlternative(this._selectedAlt);
                    }
                    this._gvPanel.setSystem(this._system);
                    this._gvPanel.fillPanel((NamedType)this._selectedAlt);
                    this._gvPanel.setIgnoreModifiedEvents(false);
                } else if (serializable == this._obsDataPanel) {
                    this._obsDataPanel.setIgnoreModifiedEvents(true);
                    if (this._system != null) {
                        this._system.setAlternative(this._selectedAlt);
                    }
                    this._obsDataPanel.setSystem(this._system);
                    this._obsDataPanel.fillPanel((NamedType)this._selectedAlt);
                    this._obsDataPanel.setIgnoreModifiedEvents(false);
                } else if (this._pluginTabs.contains(serializable)) {
                    object = (AlternativePanel)((Object)serializable);
                    ((AbstractEditorPanel)object).setIgnoreModifiedEvents(true);
                    if (this._system != null) {
                        this._system.setAlternative(this._selectedAlt);
                    }
                    object.setSystem(this._system);
                    object.fillPanel((NamedType)this._selectedAlt);
                    ((AbstractEditorPanel)object).setIgnoreModifiedEvents(false);
                }
                if (serializable instanceof AlternativePanel) {
                    this._lastPanel = (AlternativePanel)((Object)serializable);
                }
                if (serializable instanceof AbstractEditorPanel) {
                    object = (AbstractEditorPanel)serializable;
                    this.updatePanelMenus((AbstractEditorPanel)object);
                }
                return;
            }
            finally {
                this._changingTabs = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updatePanelMenus(AbstractEditorPanel object) {
        int n;
        boolean bl;
        JMenuBar jMenuBar;
        block6: {
            jMenuBar = this.getJMenuBar();
            bl = false;
            object = object.getPanelMenus();
            if (jMenuBar.getComponentCount() > 1) {
                for (n = jMenuBar.getComponentCount() - 1; n > 0; --n) {
                    jMenuBar.remove(n);
                    bl = true;
                }
            }
            if (object != null && !((Vector)object).isEmpty()) break block6;
            if (!bl) return;
            jMenuBar.revalidate();
            jMenuBar.repaint();
            this.getRootPane().revalidate();
            this.setJMenuBar(null);
            this.setJMenuBar(jMenuBar);
            return;
        }
        try {
            for (n = 0; n < ((Vector)object).size(); ++n) {
                Object e = ((Vector)object).get(n);
                if (!(e instanceof JMenuItem)) continue;
                jMenuBar.add((JMenuItem)e);
                bl = true;
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            jMenuBar.revalidate();
            jMenuBar.repaint();
            this.getRootPane().revalidate();
            this.setJMenuBar(null);
            this.setJMenuBar(jMenuBar);
            throw throwable;
        }
        jMenuBar.revalidate();
        jMenuBar.repaint();
        this.getRootPane().revalidate();
        this.setJMenuBar(null);
        this.setJMenuBar(jMenuBar);
    }

    public boolean isChangingTabs() {
        return this._changingTabs;
    }

    RssAlt newRssAlt(String string, String string2) {
        RssAlt rssAlt = new RssAlt();
        rssAlt.setName(string);
        rssAlt.setDescription(string2);
        if (this._system != null) {
            rssAlt.setSystemIndex(this._system.getIndex());
            rssAlt.setSystemPath(this._system.getIdentifier().getPath());
            rssAlt.setWorkspace(this._system.getWorkspace());
            rssAlt.setProxyList(this._system.getProxyList());
            if (this._wksp instanceof ClientWorkspace) {
                string2 = (ClientWorkspace)this._wksp;
                string = string2.getManagerIdentifier("rss", RssAlt.class.getName(), string, ".ralt");
                rssAlt.setIdentifier((Identifier)string);
            }
        } else {
            rssAlt.setWorkspace(new RemoteWrapper((Remote)this._wksp.getChildWorkspace("rss")));
            rssAlt.setProxyList(this._wksp.getManagerProxyList("rss"));
        }
        return rssAlt;
    }

    @Override
    protected boolean hasAlternative() {
        return this._selectedAlt != null;
    }

    public void setProgramOrder(Vector vector, String string) {
        this._timeSeriesPanel.setProgramOrder(vector, string);
    }

    public void updateGlobalVariable(TsVariant tsVariant, TableGlobalVariable tableGlobalVariable) {
        this._gvPanel.updateGlobalVariable(tsVariant, tableGlobalVariable);
    }

    public void addVariant(TsVariant tsVariant) {
        this._timeSeriesPanel.addVariant(tsVariant);
        this._obsDataPanel.addVariant(tsVariant);
        this._gvPanel.addVariant(tsVariant);
    }

    public void removeVariantTab(TsVariant tsVariant) {
        this._timeSeriesPanel.removeVariantTab(tsVariant);
        this._obsDataPanel.removeVariantTab(tsVariant);
        this._gvPanel.removeVariantTab(tsVariant);
    }

    public AbstractEditorPanel getSelectedTab() {
        Component component = this.tabPane.getSelectedComponent();
        if (component instanceof AbstractEditorPanel) {
            return (AbstractEditorPanel)component;
        }
        return null;
    }

    public boolean closeDialog() {
        this.AlternativeEditor_Closing();
        return true;
    }

    void AlternativeEditor_WindowClosing(WindowEvent windowEvent) {
        if (this._gvPanel.windowClosing()) {
            this.menuItemExit_Action();
        }
    }

    @Override
    protected boolean allowsNoConfiguration() {
        return true;
    }

    public void AlternativeEditor_Closing() {
        if (this.isModified()) {
            int n = RMAIO.postYesNoWarning((Component)((Object)this), (String)"Data Has Changed! Save before closing?");
            if (n == 0) {
                this.saveForm();
            } else if (n == 1) {
                ((AbstractAlternativeEditor)this).setModified(false);
                this.m_newAlt = false;
            }
        }
        this.dispose();
    }

    @Override
    protected void addApplicationMenus(JMenu jMenu) {
        this.m_deleteVariantMenuItem = AltEditorVariantMenuBuilder.b(this);
        jMenu.add(this.m_deleteVariantMenuItem);
    }

    @Override
    public void setModified(boolean bl) {
        if (bl) {
            this.setTitle("ResSim Alternative Editor*");
        } else {
            this.setTitle(EDITOR_TITLE);
        }
        super.setModified(bl);
    }

    public void setSelectedTab(Component component) {
        this.tabPane.setSelectedComponent(component);
    }

    public AltYieldAnalysisPanel getYieldAnalysisPanel() {
        return this._yieldAnalysisPanel;
    }

    public AltHotstartPanel getHotstartPanel() {
        return this._hotStartPanel;
    }

    public AltOperationsPanel getOperationsPanel() {
        return this._operationsPanel;
    }

    public AltTimeSeriesContainerPanel getTimeSeriesPanel() {
        return this._timeSeriesPanel;
    }

    protected void addPluginTabs() {
        for (int i = 0; i < b.size(); ++i) {
            PluginAltTabObject pluginAltTabObject = b.get(i);
            if (pluginAltTabObject == null) continue;
            Object object = pluginAltTabObject.getTabClass();
            try {
                object = ((Class)object).newInstance();
            }
            catch (InstantiationException instantiationException) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("InstantiationException %s", (Object)instantiationException);
                if (instantiationException.getCause() != null) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atInfo()).withCause(instantiationException.getCause())).log();
                    continue;
                }
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atInfo()).withCause((Throwable)instantiationException)).log();
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("IllegalAccessException %s", (Object)illegalAccessException);
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atInfo()).withCause((Throwable)illegalAccessException)).log();
                continue;
            }
            catch (Throwable throwable) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("addPluginTabs: Error loading plugin tab %s", (Object)throwable);
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atInfo()).withCause(throwable)).log();
                continue;
            }
            this.addTab((AlternativePanel)object);
            if (!pluginAltTabObject.hasRadioButton()) continue;
            this._runcontrolPanel.addRadioButton((AlternativePanel)object);
        }
    }

    protected void addTab(AlternativePanel alternativePanel) {
        if (alternativePanel == null) {
            return;
        }
        ((FluentLogger.Api)LOGGER.atInfo()).log("addTab:adding %s", (Object)alternativePanel.getTabname());
        this.tabPane.add((Component)((JComponent)((Object)alternativePanel)), alternativePanel.getTabname());
        this._pluginTabs.add(alternativePanel);
    }

    public AltRunControlPanel getRunControlPanel() {
        return this._runcontrolPanel;
    }

    @Override
    protected AbstractAlternativeEditor$AlternativeTableModel getTableModel() {
        return new AlternativeEditor$RssAlternativeTableModel(this);
    }

    public boolean isNewAlt() {
        return this.m_newAlt;
    }

    public void setWqPanelEnabled(boolean bl) {
        if (this.hasWatershedWq()) {
            int n = this.tabPane.indexOfComponent((Component)((Object)this._wqPanel));
            this.tabPane.setEnabledAt(n, bl);
            this._runcontrolPanel.setComputingWaterQuality(bl);
        }
    }

    public RssSystem getNetwork() {
        return this._system;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabPane;
    }
}

