/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientWorkspace;
import hec.gui.WizardPanel;
import hec.lang.NamedType;
import hec.rss.client.AssignNetworkElementsPanel$1;
import hec.rss.client.AssignNetworkElementsPanel$2;
import hec.rss.client.AssignNetworkElementsPanel$ReservoirChildElement;
import hec.rss.model.DivertedOutletElement;
import hec.rss.model.Element;
import hec.rss.model.ElementAssignmentContainer;
import hec.rss.model.ReservoirDamElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;
import rma.util.RMASort;

public class AssignNetworkElementsPanel
extends WizardPanel {
    public static final String PANEL_NAME = "AssignElements";
    private JLabel _panelTitle;
    private JLabel _selectedNetworkLabel;
    private JLabel _currentNetworkLabel;
    private RmaJTextField _watershedNameTxt;
    private RmaJTable _networkTable;
    private TableModelListener _networkTableListener;
    private String[] _columnNames;
    private RmaTableModel _networkTableModel;

    public AssignNetworkElementsPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this._panelTitle = new JLabel("Assign Network Elements");
        Serializable serializable = this._panelTitle.getFont();
        this._panelTitle.setFont(new Font(serializable.getName(), 1, serializable.getSize()));
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        AssignNetworkElementsPanel assignNetworkElementsPanel = this;
        assignNetworkElementsPanel.add(assignNetworkElementsPanel._panelTitle, serializable);
        JComponent jComponent = new JLabel("Watershed:");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = -1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jComponent, serializable);
        this._watershedNameTxt = new RmaJTextField();
        this._watershedNameTxt.setEditable(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        AssignNetworkElementsPanel assignNetworkElementsPanel2 = this;
        assignNetworkElementsPanel2.add((Component)assignNetworkElementsPanel2._watershedNameTxt, serializable);
        jComponent = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jComponent, serializable);
        this._currentNetworkLabel = new JLabel("Current Network: ");
        serializable = new GridBagConstraints();
        new GridBagConstraints().weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = -1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._currentNetworkLabel, serializable);
        this._selectedNetworkLabel = new JLabel("Selected Network: ", 4);
        serializable = new GridBagConstraints();
        new GridBagConstraints().weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 12;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._selectedNetworkLabel, serializable);
        this._columnNames = new String[]{"Import Into", "Element Type", "Import From"};
        this._networkTableModel = this.createTableModel();
        AssignNetworkElementsPanel assignNetworkElementsPanel3 = this;
        this._networkTable = new AssignNetworkElementsPanel$1(assignNetworkElementsPanel3, (Component)((Object)assignNetworkElementsPanel3));
        this._networkTable.setModel((TableModel)this._networkTableModel);
        this._networkTable.setColumnEnabled(false, 0);
        this._networkTable.setColumnEnabled(false, 1);
        this._networkTable.setComboBoxEditor(2, new Object[0]);
        this._networkTable.setCellSelectionEnabled(false);
        this._networkTable.setRowSelectionAllowed(true);
        int n = this._networkTable.getRowHeight();
        this._networkTable.setRowHeight(n + 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._networkTable.getScrollPane(), gridBagConstraints);
        this._networkTableListener = new AssignNetworkElementsPanel$2(this);
    }

    private RmaTableModel createTableModel() {
        return new RmaTableModel(this._columnNames, new Object[1][this._columnNames.length], new boolean[this._columnNames.length]);
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        int n = this._networkTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2 = this._networkTable.getValueAt(i, 0);
            if (object2 != (object = this._networkTable.getValueAt(i, 2))) continue;
            JOptionPane.showMessageDialog((Component)((Object)this), "The Import Into Element " + String.valueOf(object2) + " cannot be imported from itself", "Assignment Error", 0);
            this._networkTable.updateSelection(i, 2, false, false);
            return false;
        }
        return true;
    }

    public void setWorkspace(ClientWorkspace clientWorkspace) {
        if (clientWorkspace != null) {
            this._watershedNameTxt.setText(clientWorkspace.getTitleName());
            return;
        }
        this._watershedNameTxt.setText("");
    }

    public void setImportFromNetwork(RssSystem rssSystem) {
        int n;
        Object object = new Vector<String>(0);
        for (n = 0; n < this._networkTable.getRowCount(); ++n) {
            this._networkTable.setValueAt(null, n, 2);
            if (!(this._networkTable.getValueAt(n, 0) instanceof AssignNetworkElementsPanel$ReservoirChildElement)) continue;
            this._networkTable.setCellEnabled(false, n, 2);
            ((Vector)object).add(0, "");
            this._networkTable.setComboBoxRowEditor(n, 2, (Vector)object);
        }
        if (rssSystem != null) {
            this._selectedNetworkLabel.setText("Selected Network: " + rssSystem.getName());
            n = this._networkTable.getRowCount();
            block1: for (int i = 0; i < n; ++i) {
                int n2;
                object = this._networkTable.getValueAt(i, 0);
                if (!(object instanceof Element)) continue;
                object = (Element)object;
                Vector<?> vector = rssSystem.getElementVectorByClass(object.getClass());
                RMASort.quickSort(vector);
                vector.add(0, "");
                this._networkTable.setComboBoxRowEditor(i, 2, vector);
                boolean bl = false;
                String string = object.getName();
                for (n2 = 1; n2 < vector.size(); ++n2) {
                    object = (Element)vector.get(n2);
                    if (!string.equals(object.getName())) continue;
                    this._networkTable.setValueAt(object, i, 2);
                    bl = true;
                    break;
                }
                if (!bl) {
                    for (n2 = 1; n2 < vector.size(); ++n2) {
                        object = (Element)vector.get(n2);
                        if (!string.equalsIgnoreCase(object.getName())) continue;
                        this._networkTable.setValueAt(object, i, 2);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                string = RMAIO.removeChar((String)string, (char)' ');
                for (n2 = 1; n2 < vector.size(); ++n2) {
                    object = (Element)vector.get(n2);
                    String string2 = RMAIO.removeChar((String)object.getName(), (char)' ');
                    if (!string.equalsIgnoreCase(string2)) continue;
                    this._networkTable.setValueAt(object, i, 2);
                    continue block1;
                }
            }
            return;
        }
        this._selectedNetworkLabel.setText("Selected Network: ");
    }

    public void setImportInToNetwork(RssSystem rssSystem) {
        if (rssSystem != null) {
            this._currentNetworkLabel.setText("Current Network: " + rssSystem.getName());
            return;
        }
        this._currentNetworkLabel.setText("Current Network: ");
    }

    public void setSelectedElements(NamedType[] namedTypeArray) {
        this._networkTableModel.clearNonEditableCells();
        this._networkTable.setColumnEnabled(false, 0);
        this._networkTable.setColumnEnabled(false, 1);
        this._networkTable.setColumnEnabled(true, 2);
        this._networkTable.getModel().removeTableModelListener(this._networkTableListener);
        this._networkTable.commitEdit(false);
        this._networkTable.deleteCells();
        this._networkTable.clearAllComboBoxRowEditorValues(2);
        for (int i = 0; i < namedTypeArray.length; ++i) {
            int n;
            Element element = (Element)namedTypeArray[i];
            Vector<Object> vector = new Vector<Object>(3);
            vector.add(element);
            vector.add(element.getElementType());
            this._networkTable.appendRow(vector);
            if (!(element instanceof ReservoirElement)) continue;
            ReservoirElement reservoirElement = (ReservoirElement)element;
            Vector vector2 = reservoirElement.getElementsByClass(ReservoirDamElement.class, null);
            if (vector2 != null && vector2.size() > 0) {
                for (n = 0; n < vector2.size(); ++n) {
                    element = (Element)vector2.get(n);
                    vector = new Vector<AssignNetworkElementsPanel$ReservoirChildElement>(3);
                    vector.add(new AssignNetworkElementsPanel$ReservoirChildElement(reservoirElement, element));
                    vector.add(element.getElementType());
                    this._networkTable.appendRow(vector);
                    this._networkTable.setCellEnabled(false, this._networkTable.getRowCount() - 1, 2);
                }
            }
            if ((vector2 = reservoirElement.getElementsByClass(DivertedOutletElement.class, null)) == null || vector2.size() <= 0) continue;
            for (n = 0; n < vector2.size(); ++n) {
                element = (Element)vector2.get(n);
                vector = new Vector<AssignNetworkElementsPanel$ReservoirChildElement>(3);
                vector.add(new AssignNetworkElementsPanel$ReservoirChildElement(reservoirElement, element));
                vector.add(element.getElementType());
                this._networkTable.appendRow(vector);
                this._networkTable.setCellEnabled(false, this._networkTable.getRowCount() - 1, 2);
            }
        }
        this._networkTable.getModel().addTableModelListener(this._networkTableListener);
    }

    public List getImportList() {
        this._networkTable.commitEdit(true);
        int n = this._networkTable.getRowCount();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object = this._networkTable.getValueAt(i, 2);
            Object object2 = this._networkTable.getValueAt(i, 0);
            if (object2 instanceof AssignNetworkElementsPanel$ReservoirChildElement) {
                object2 = ((AssignNetworkElementsPanel$ReservoirChildElement)object2).a;
            }
            if (!(object instanceof Element) || !(object2 instanceof Element)) continue;
            object = new ElementAssignmentContainer((Element)object2, (Element)object);
            arrayList.add(object);
        }
        return arrayList;
    }

    public List getNotImportedList() {
        this._networkTable.commitEdit(true);
        int n = this._networkTable.getRowCount();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object = this._networkTable.getValueAt(i, 2);
            Object object2 = this._networkTable.getValueAt(i, 0);
            if (object2 instanceof AssignNetworkElementsPanel$ReservoirChildElement) {
                object2 = ((AssignNetworkElementsPanel$ReservoirChildElement)object2).a;
            }
            if (object instanceof Element) continue;
            object = new ElementAssignmentContainer((Element)object2, null);
            arrayList.add(object);
        }
        return arrayList;
    }

    public int getElementCount() {
        return this._networkTable.getRowCount();
    }
}

