/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.LookAndFeel;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.StreamAlignment;
import hec.gui.WizardDialog;
import hec.gui.WizardPanel;
import hec.model.StreamElement;
import hec.rss.client.AssignStreamStationingPanel$1;
import hec.rss.client.AssignStreamStationingPanel$2;
import hec.rss.client.AssignStreamStationingPanel$NodeLocation;
import hec.rss.client.SelectStreamsDialog;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class AssignStreamStationingPanel
extends WizardPanel {
    public static final String PANEL_NAME = "AssignStreams";
    private JLabel _panelTitle;
    private JLabel _selectedNetworkLabel;
    private JLabel _currentNetworkLabel;
    private RmaJTextField _watershedNameTxt;
    private RmaJTable _networkTable;
    private JButton _setStreamNamesButton;
    private SelectStreamsDialog _selectStreamsDialog;
    private TableModelListener _networkTableListener;
    private String[] _columnNames;
    private RmaTableModel _networkTableModel;
    private RssSystem _importFromNetwork;
    private StreamAlignment _currentStreamAlignment;
    private String[] _streamNames;
    private HashMap _streamNameMap;

    public AssignStreamStationingPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        this._panelTitle = new JLabel("Assign Stream Names");
        Serializable serializable = this._panelTitle.getFont();
        this._panelTitle.setFont(new Font(serializable.getName(), 1, serializable.getSize()));
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)4, (int)4, (int)4, (int)4);
        AssignStreamStationingPanel assignStreamStationingPanel = this;
        assignStreamStationingPanel.add(assignStreamStationingPanel._panelTitle, serializable);
        JComponent jComponent = new JLabel("Watershed:");
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = -1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jComponent, serializable);
        this._watershedNameTxt = new RmaJTextField();
        this._watershedNameTxt.setEditable(false);
        serializable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        AssignStreamStationingPanel assignStreamStationingPanel2 = this;
        assignStreamStationingPanel2.add((Component)assignStreamStationingPanel2._watershedNameTxt, serializable);
        jComponent = new JPanel(new GridBagLayout());
        serializable = new GridBagConstraints();
        new GridBagConstraints().weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jComponent, serializable);
        this._currentNetworkLabel = new JLabel("New Network: ");
        serializable = new GridBagConstraints();
        new GridBagConstraints().weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = -1;
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._currentNetworkLabel, serializable);
        this._selectedNetworkLabel = new JLabel("Import From Network: ", 4);
        serializable = new GridBagConstraints();
        new GridBagConstraints().weightx = 1.0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).anchor = 12;
        ((GridBagConstraints)serializable).fill = 2;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._selectedNetworkLabel, serializable);
        this._columnNames = new String[]{"Imported Element", "Element Type", "From Stream", "To Stream"};
        this._networkTableModel = this.createTableModel();
        AssignStreamStationingPanel assignStreamStationingPanel3 = this;
        this._networkTable = new AssignStreamStationingPanel$1(assignStreamStationingPanel3, (Component)((Object)assignStreamStationingPanel3));
        this._networkTable.setRowSorter(new TableRowSorter<RmaTableModel>(this._networkTableModel));
        this._networkTable.setModel((TableModel)this._networkTableModel);
        this._networkTable.setColumnEnabled(false, 0);
        this._networkTable.setColumnEnabled(false, 1);
        this._networkTable.setComboBoxEditor(3, new Object[0]);
        this._networkTable.setColumnEnabled(true, 3);
        this._networkTable.setCellSelectionEnabled(true);
        int n = this._networkTable.getRowHeight();
        this._networkTable.setRowHeight(n + 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._networkTable.getScrollPane(), gridBagConstraints);
        this._setStreamNamesButton = new JButton("Assign Stream Names");
        this._setStreamNamesButton.setEnabled(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jComponent.add((Component)this._setStreamNamesButton, gridBagConstraints);
        this._setStreamNamesButton.addActionListener(new AssignStreamStationingPanel$2(this));
    }

    private RmaTableModel createTableModel() {
        return new RmaTableModel(this._columnNames, new Object[1][this._columnNames.length], new boolean[this._columnNames.length]);
    }

    public String getPanelName() {
        return PANEL_NAME;
    }

    public boolean isValidPanel() {
        List list = this.saveImportNetworkStreams(false);
        if (list.size() > 0) {
            String[] stringArray = new String[list.size() + 1];
            String[] stringArray2 = stringArray;
            stringArray[0] = "The following elements still require stream assignments:";
            for (int i = 0; i < list.size(); ++i) {
                Object object = (AssignStreamStationingPanel$NodeLocation)list.get(i);
                stringArray2[i + 1] = object = "<html><b>" + ((AssignStreamStationingPanel$NodeLocation)object).toString() + "</b></html>";
            }
            JOptionPane.showMessageDialog((Component)((Object)this), stringArray2, "Assignment Error", 0);
            return false;
        }
        return true;
    }

    public void setWorkspace(ClientWorkspace clientWorkspace) {
        if (clientWorkspace != null) {
            this._watershedNameTxt.setText(clientWorkspace.getTitleName());
            return;
        }
        this._watershedNameTxt.setText("");
    }

    public void setImportFromNetwork(RssSystem object) {
        if (object == null) {
            this._selectedNetworkLabel.setText("Import From Network: ");
            return;
        }
        this._importFromNetwork = object;
        new Vector(0);
        ((RssSystem)object).getElementVector();
        Vector vector = ((RssSystem)object).getNodeVector();
        this._selectedNetworkLabel.setText("Import From Network: " + object.getName());
        this._networkTableModel.clearNonEditableCells();
        this._networkTable.setColumnEnabled(false, 0);
        this._networkTable.setColumnEnabled(false, 1);
        this._networkTable.setColumnEnabled(false, 2);
        this._networkTable.getModel().removeTableModelListener(this._networkTableListener);
        this._networkTable.commitEdit(false);
        this._networkTable.deleteCells();
        int n = this._networkTable.getColumnCount();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            object = (RssNode)vector.get(i);
            if (object.getStreamIndex() < 0 && (object.getStreamName() == null || object.getStreamName().trim().length() <= 0)) continue;
            Vector<Object> vector2 = new Vector<Object>(n);
            object = new AssignStreamStationingPanel$NodeLocation((RssNode)object, this._importFromNetwork);
            vector2.add(object);
            vector2.add(((AssignStreamStationingPanel$NodeLocation)object).a());
            vector2.add(((AssignStreamStationingPanel$NodeLocation)object).b);
            this._networkTable.appendRow(vector2);
        }
    }

    public void setNewNetworkName(String string) {
        if (string != null) {
            this._currentNetworkLabel.setText("New Network: " + string);
            return;
        }
        this._currentNetworkLabel.setText("New Network: ");
    }

    public void setStreamAlignment(StreamAlignment streamAlignment) {
        this._currentStreamAlignment = streamAlignment;
        if (this._currentStreamAlignment == null || this._importFromNetwork == null) {
            return;
        }
        this.matchStreamNames();
    }

    protected void matchStreamNames() {
        int n;
        Object object = this._currentStreamAlignment.getElementVector();
        if (object == null || ((Vector)object).size() <= 0) {
            return;
        }
        this._streamNames = new String[((Vector)object).size() + 1];
        this._streamNames[0] = "";
        int n2 = 1;
        for (n = 0; n < ((Vector)object).size(); ++n) {
            if (!(((Vector)object).get(n) instanceof StreamElement)) continue;
            this._streamNames[n2] = ((StreamElement)((Vector)object).get(n)).getName();
            ++n2;
        }
        this._networkTable.setComboBoxEditor(3, (Object[])this._streamNames);
        n = this._networkTable.getRowCount();
        for (n2 = 0; n2 < n; ++n2) {
            object = this._networkTable.getValueAt(n2, 0);
            if (!(object instanceof AssignStreamStationingPanel$NodeLocation)) continue;
            object = (AssignStreamStationingPanel$NodeLocation)object;
            String string = (String)this._networkTable.getValueAt(n2, 2);
            if (string == null || string.length() <= 0) continue;
            if (((AssignStreamStationingPanel$NodeLocation)object).d) {
                int n3 = RMAIO.parseInt((String)string, (int)-1);
                this._currentStreamAlignment.findReach(n3);
            }
            for (int i = 0; i < this._streamNames.length; ++i) {
                if (!string.equalsIgnoreCase(this._streamNames[i])) continue;
                this._networkTable.setValueAt((Object)string, n2, 3);
            }
        }
    }

    public void selectStreamsAction() {
        String string;
        Object object;
        if (this._streamNames == null || this._streamNames.length < 2) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No streams available to assign");
            return;
        }
        this._networkTable.commitEdit(true);
        this._streamNameMap = new HashMap();
        int n = this._networkTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            object = this._networkTable.getValueAt(i, 2);
            if (object == null || ((String)object).trim().length() <= 0) continue;
            string = (String)object;
            object = this._networkTable.getValueAt(i, 3);
            if (object instanceof String && ((String)object).trim().length() > 0) {
                object = (String)object;
                this._streamNameMap.put(string, object);
                continue;
            }
            if (this._streamNameMap.get(string) != null) continue;
            this._streamNameMap.put(string, "");
        }
        Object object2 = (WizardDialog)SwingUtilities.windowForComponent((Component)((Object)this));
        this._selectStreamsDialog = new SelectStreamsDialog((Dialog)object2);
        this._selectStreamsDialog.setLists(this._streamNameMap, this._streamNames);
        this._selectStreamsDialog.setTitle("Select Stream Name");
        this._selectStreamsDialog.setVisible(true);
        if (this._selectStreamsDialog.isCanceled()) {
            this._selectStreamsDialog.dispose();
            return;
        }
        object2 = this._selectStreamsDialog.getStreamNameMapping();
        this._selectStreamsDialog.dispose();
        if (object2 != null) {
            n = this._networkTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                string = (String)this._networkTable.getValueAt(i, 2);
                object = this._networkTable.getValueAt(i, 3);
                if (object instanceof String && ((String)object).trim().length() > 0 || ((HashMap)object2).get(string) == null) continue;
                object = (String)((HashMap)object2).get(string);
                this._networkTable.setValueAt(object, i, 3);
            }
        }
        this._networkTable.repaint();
    }

    public List saveImportNetworkStreams(boolean bl) {
        ArrayList<AssignStreamStationingPanel$NodeLocation> arrayList = new ArrayList<AssignStreamStationingPanel$NodeLocation>();
        this._networkTable.commitEdit(true);
        int n = this._networkTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            AssignStreamStationingPanel$NodeLocation assignStreamStationingPanel$NodeLocation = (AssignStreamStationingPanel$NodeLocation)this._networkTable.getValueAt(i, 0);
            String string = (String)this._networkTable.getValueAt(i, 3);
            if (string == null || string.trim().length() <= 0) {
                arrayList.add(assignStreamStationingPanel$NodeLocation);
                continue;
            }
            if ((string = this._currentStreamAlignment.findReach(string)) == null) {
                arrayList.add(assignStreamStationingPanel$NodeLocation);
                continue;
            }
            assignStreamStationingPanel$NodeLocation.a.setStream((StreamElement)string);
        }
        return arrayList;
    }

    public List getElementAssigmentsList() {
        this._networkTable.commitEdit(true);
        Vector vector = new Vector(this._networkTable.getRowCount());
        int n = this._networkTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Vector<Object> vector2 = new Vector<Object>(4);
            Object object = (AssignStreamStationingPanel$NodeLocation)this._networkTable.getValueAt(i, 0);
            vector2.add(((AssignStreamStationingPanel$NodeLocation)object).toString());
            vector2.add(((AssignStreamStationingPanel$NodeLocation)object).a());
            vector2.add(((AssignStreamStationingPanel$NodeLocation)object).c);
            object = (String)this._networkTable.getValueAt(i, 3);
            if (object == null || ((String)object).trim().length() <= 0) {
                vector2.add("");
                continue;
            }
            StreamElement streamElement = this._currentStreamAlignment.findReach((String)object);
            if (streamElement == null) {
                vector2.add("");
                continue;
            }
            vector2.add(object);
            vector.add(vector2);
        }
        return vector;
    }

    public List getElementsNotAssignedList() {
        List list = this.saveImportNetworkStreams(false);
        Vector vector = new Vector(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Vector<String> vector2 = new Vector<String>(3);
            AssignStreamStationingPanel$NodeLocation assignStreamStationingPanel$NodeLocation = (AssignStreamStationingPanel$NodeLocation)list.get(i);
            vector2.add(assignStreamStationingPanel$NodeLocation.toString());
            vector2.add(assignStreamStationingPanel$NodeLocation.a());
            vector2.add(assignStreamStationingPanel$NodeLocation.b);
            vector.add(vector2);
        }
        return vector;
    }

    public int getElementCount() {
        return this._networkTable.getRowCount();
    }

    public static void a(String[] object) {
        try {
            LookAndFeel.setLookAndFeel();
        }
        catch (Exception exception) {}
        object = new JDialog(null, true);
        AssignStreamStationingPanel assignStreamStationingPanel = new AssignStreamStationingPanel();
        ((JDialog)object).getContentPane().add((Component)((Object)assignStreamStationingPanel));
        ((Window)object).setSize(800, 400);
        ((Window)object).setLocation(300, 200);
        ((Dialog)object).setVisible(true);
        System.exit(0);
    }
}

