/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.dssgui.DSSListSelector;
import hec.dssgui.DSSListSelectorParent;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.rss.client.BaseDssPanel$DssFileFocusListener;
import hec.rss.client.BaseDssPanel$DssPathFocusListener;
import hec.rss.client.BaseDssPanel$DssPathSelectionListener;
import hec.rss.client.BaseDssPanel$WrapperDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import rma.lang.Modifiable;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;
import rma.util.RMAUtil;

public abstract class BaseDssPanel
extends EnabledJPanel
implements Modifiable {
    public static final String DSS_DATA_PROPERTY = "DssData";
    private static String a;
    private final JDialog _parent;
    private RmaJTextField _aPartText;
    private RmaJTextField _bPartText;
    private RmaJTextField _cPartText;
    private RmaJTextField _dPartText;
    private RmaJTextField _dssFileNameText;
    private RmaJTextField _ePartText;
    private RmaJTextField _fPartText;
    private JButton _fileChooserButton;
    private DSSListSelector _selectFrame;
    private String _oldDssPath = null;
    private String _oldDssFile = null;
    private boolean _modified;
    private BaseDssPanel$WrapperDialog _wrapperDialog;

    public BaseDssPanel(JDialog jDialog) {
        super((LayoutManager)new GridBagLayout());
        this._parent = jDialog;
        this.buildComponents();
        this.addListeners();
    }

    private void buildComponents() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        JComponent jComponent = new JLabel("DSS File:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)jComponent, gridBagConstraints);
        this._dssFileNameText = new RmaJTextField();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        rmaJPanel.add((Component)this._dssFileNameText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        this.add((Component)rmaJPanel, gridBagConstraints);
        this._fileChooserButton = new JButton("Select DSS Path...");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)10, (int)5, (int)0, (int)5);
        BaseDssPanel baseDssPanel = this;
        baseDssPanel.add(baseDssPanel._fileChooserButton, gridBagConstraints);
        this._aPartText = new RmaJTextField();
        this._bPartText = new RmaJTextField();
        this._cPartText = new RmaJTextField();
        this._dPartText = new RmaJTextField();
        this._ePartText = new RmaJTextField();
        this._fPartText = new RmaJTextField();
        rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        jComponent = this.createDssPathRowPanel("A", "C", "E", this._aPartText, this._cPartText, this._ePartText);
        JPanel jPanel = this.createDssPathRowPanel("B", "D", "F", this._bPartText, this._dPartText, this._fPartText);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this.add((Component)rmaJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(new JLabel(), gridBagConstraints);
    }

    public void setModified(boolean bl) {
        this._modified = bl;
        if (bl) {
            RMAUtil.setParentModified((Component)((Object)this));
        }
    }

    public boolean isModified() {
        return this._modified;
    }

    private JPanel createDssPathRowPanel(String object, String object2, String object3, RmaJTextField rmaJTextField, RmaJTextField rmaJTextField2, RmaJTextField rmaJTextField3) {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridLayout(1, 3));
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        object = new JLabel((String)object + ":");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel2.add((Component)object, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        rmaJPanel2.add((Component)rmaJTextField, gridBagConstraints);
        object = new RmaJPanel((LayoutManager)new GridBagLayout());
        object2 = new JLabel((String)object2 + ":");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)object2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        ((Container)object).add((Component)rmaJTextField2, gridBagConstraints);
        object2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        object3 = new JLabel((String)object3 + ":");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object2).add((Component)object3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        ((Container)object2).add((Component)rmaJTextField3, gridBagConstraints);
        rmaJPanel.add((Component)rmaJPanel2);
        rmaJPanel.add((Component)object);
        rmaJPanel.add((Component)object2);
        return rmaJPanel;
    }

    protected void addAccessoryFields(int n) {
    }

    protected void addListeners() {
        this._dssFileNameText.addFocusListener((FocusListener)new BaseDssPanel$DssFileFocusListener(this));
        this._fileChooserButton.addActionListener(actionEvent -> this.fileChooserButtonActionPerformed());
        BaseDssPanel$DssPathFocusListener baseDssPanel$DssPathFocusListener = new BaseDssPanel$DssPathFocusListener(this);
        this._aPartText.addFocusListener((FocusListener)baseDssPanel$DssPathFocusListener);
        this._bPartText.addFocusListener((FocusListener)baseDssPanel$DssPathFocusListener);
        this._cPartText.addFocusListener((FocusListener)baseDssPanel$DssPathFocusListener);
        this._dPartText.addFocusListener((FocusListener)baseDssPanel$DssPathFocusListener);
        this._ePartText.addFocusListener((FocusListener)baseDssPanel$DssPathFocusListener);
        this._fPartText.addFocusListener((FocusListener)baseDssPanel$DssPathFocusListener);
        this.setToolTipText("");
    }

    private void fileChooserButtonActionPerformed() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object object = this.getSelectorTitle();
            this._selectFrame = new DSSListSelector((DSSListSelectorParent)new BaseDssPanel$DssPathSelectionListener(this), (String)object, 1, 1, false, false);
            this._selectFrame.setTitle((String)object);
            object = ClientApp.Workspace().getWorkspacePath();
            Object object2 = this._dssFileNameText.getText();
            if (object2 != null && !((String)object2).isEmpty()) {
                if ((object2 = this.getDirectoryFromFile((String)object2)) != null) {
                    object = object2;
                }
            } else if (a != null && !a.isEmpty()) {
                object2 = a;
                if ((object2 = this.getDirectoryFromFile((String)object2)) != null) {
                    object = object2;
                }
            }
            this._selectFrame.setDirectory((String)object);
            object2 = Paths.get(this.getDssFilePath(), new String[0]);
            if (!object2.toString().isEmpty()) {
                this._selectFrame.setDirectory(this.getDirectoryFromFile(object2.toString()));
                if (!object2.isAbsolute()) {
                    object2 = Paths.get(ClientApp.Workspace().makeAbsolutePath(object2.toString()), new String[0]);
                }
                this._selectFrame.setDssFilename(object2.toString());
            }
            if (this._wrapperDialog == null || !this._wrapperDialog.isVisible()) {
                BaseDssPanel baseDssPanel = this;
                this._wrapperDialog = new BaseDssPanel$WrapperDialog(baseDssPanel, baseDssPanel._parent, this._selectFrame.getContentPane());
            }
            this.enableRecentFiles();
            this._wrapperDialog.setVisible(true);
            if (this._selectFrame.getState() == 1) {
                this._selectFrame.restore();
            }
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void enableRecentFiles() {
        for (Component component : this._wrapperDialog.getJMenuBar().getMenu(0).getMenuComponents()) {
            String string;
            if (!(component instanceof JMenuItem) || (string = ((JMenuItem)component).getText()) == null) continue;
            try {
                if (!Paths.get(string, new String[0]).toFile().exists()) continue;
                component.setEnabled(true);
            }
            catch (InvalidPathException invalidPathException) {}
        }
    }

    protected abstract String getSelectorTitle();

    private String getDirectoryFromFile(String string) {
        Path path = Paths.get(string, new String[0]);
        if (!path.isAbsolute()) {
            path = Paths.get(this.getDefaultDirectory(), new String[0]).resolve(path);
        }
        if (path.getParent() == null || string.isEmpty()) {
            return null;
        }
        return path.getParent().toString();
    }

    public String getDefaultDirectory() {
        return ClientApp.Workspace().getWorkspacePath();
    }

    public void validateData() {
    }

    public void fillPanel(DSSIdentifier object) {
        this.clearPanel();
        if (object == null) {
            return;
        }
        this._dssFileNameText.setText(object.getFileName());
        object = object.getDSSPath();
        object = new DSSPathname((String)object);
        this._aPartText.setText(object.aPart());
        this._bPartText.setText(object.bPart());
        this._cPartText.setText(object.cPart());
        this._dPartText.setText(object.dPart());
        this._ePartText.setText(object.ePart());
        this._fPartText.setText(object.fPart());
    }

    public String getDssFilePath() {
        return this._dssFileNameText.getText();
    }

    public String getDssPath() {
        String string = this._aPartText.getText();
        String string2 = this._bPartText.getText();
        String string3 = this._cPartText.getText();
        String string4 = this._dPartText.getText();
        String string5 = this._ePartText.getText();
        String string6 = this._fPartText.getText();
        DSSPathname dSSPathname = new DSSPathname();
        dSSPathname.setAPart(string != null ? string : "");
        dSSPathname.setBPart(string2 != null ? string2 : "");
        dSSPathname.setCPart(string3 != null ? string3 : "");
        dSSPathname.setDPart(string4 != null ? string4 : "");
        dSSPathname.setEPart(string5 != null ? string5 : "");
        dSSPathname.setFPart(string6 != null ? string6 : "");
        return dSSPathname.getPathname();
    }

    protected void clearPanel() {
        this._dssFileNameText.setText("");
        this._aPartText.setText("");
        this._bPartText.setText("");
        this._cPartText.setText("");
        this._dPartText.setText("");
        this._ePartText.setText("");
        this._fPartText.setText("");
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent.isAltDown() && mouseEvent.isControlDown() && mouseEvent.isShiftDown()) {
            return "Class: " + ((Object)((Object)this)).getClass().getName() + " hash:" + System.identityHashCode((Object)this);
        }
        return null;
    }

    protected void setFileName(String string) {
        this._oldDssFile = this._dssFileNameText.getText();
        this._dssFileNameText.setText(string);
        this._dssFileNameText.setModified(true);
    }

    protected void setPathName(String string) {
        this._oldDssPath = this.getDssPath();
        string = new DSSPathname(string);
        this._aPartText.setText(string.aPart());
        this._bPartText.setText(string.bPart());
        this._cPartText.setText(string.cPart());
        this._dPartText.setText(string.dPart());
        this._ePartText.setText(string.ePart());
        this._fPartText.setText(string.fPart());
    }

    protected void closeSelectorFrame() {
        if (this._selectFrame != null) {
            this._selectFrame.setVisible(false);
        }
    }

    protected void setLastSelectedFile(String string) {
        a = string;
    }

    protected abstract void setDataContainer(List[] var1);

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.closeDssSelector();
        }
    }

    protected void closeDssSelector() {
        if (this._selectFrame != null && this._selectFrame.isVisible()) {
            this._selectFrame.setVisible(false);
        }
    }

    protected abstract String getPropertyChangeName();

    public DSSListSelector getSelector() {
        return this._selectFrame;
    }

    static /* synthetic */ void a(BaseDssPanel baseDssPanel, String string, Object object, Object object2) {
        baseDssPanel.firePropertyChange(string, object, object2);
    }

    static /* synthetic */ void b(BaseDssPanel baseDssPanel, String string, Object object, Object object2) {
        baseDssPanel.firePropertyChange(string, object, object2);
    }
}

