/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.RepeatDialog;
import hec.clientapp.client.ClientApp;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.model.NoRepeatInterval;
import hec.model.RepeatInterval;
import hec.rss.client.CapacityScheduleDialog$1;
import hec.rss.client.CapacityScheduleDialog$2;
import hec.rss.client.CapacityScheduleDialog$3;
import hec.rss.model.CapacityOutage;
import hec.rss.model.Element;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DateTimePanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJObjectButton;
import rma.swing.list.RmaListModel;

public class CapacityScheduleDialog
extends RmaJDialog {
    private RmaJComboBox _outletCombo;
    private DateTimePanel _startDateTime;
    private DateTimePanel _endDateTime;
    private RmaJDecimalField _capacityFactor;
    private RmaJDescriptionField _notesField;
    private RmaJObjectButton _repeatButton;
    private ButtonCmdPanel _cmdPanel;
    private boolean _canceled;
    private RepeatDialog _repeatDialog;
    private CapacityOutage _outage;

    public CapacityScheduleDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.buildControls();
    }

    public CapacityScheduleDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Outlet Capacity Schedule Entry");
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)10, (int)0);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel("Outlet");
        jLabel.setDisplayedMnemonic('O');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)6, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._outletCombo = new RmaJComboBox();
        jLabel.setLabelFor((Component)this._outletCombo);
        this._outletCombo.setModifiable(true);
        jLabel.setLabelFor((Component)this._outletCombo);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._outletCombo, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        jLabel = new JLabel("Date");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Time");
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)15);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Start");
        jLabel.setDisplayedMnemonic('S');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ClientApp.app();
        TimeZone timeZone = ClientApp.Workspace().getTimeZone();
        this._startDateTime = new DateTimePanel(1, null, null, "DDMMMYYYY");
        this._startDateTime.showTimeAsBeginningOfDay(true);
        this._startDateTime.setDataTimeZone(timeZone);
        jLabel.setLabelFor((Component)this._startDateTime);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)5);
        jPanel.add((Component)this._startDateTime, gridBagConstraints);
        jLabel = new JLabel("End");
        jLabel.setDisplayedMnemonic('E');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._endDateTime = new DateTimePanel(1, null, null, "DDMMMYYYY");
        this._endDateTime.setDataTimeZone(timeZone);
        jLabel.setLabelFor((Component)this._endDateTime);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)0, (int)0, (int)5);
        jPanel.add((Component)this._endDateTime, gridBagConstraints);
        jLabel = new JLabel("Capacity Factor");
        jLabel.setDisplayedMnemonic('C');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)20, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this._capacityFactor = new RmaJDecimalField();
        jLabel.setLabelFor((Component)this._capacityFactor);
        this._capacityFactor.setMinValue(0.0);
        this._capacityFactor.setMaxValue(1.0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)20, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._capacityFactor, gridBagConstraints);
        jLabel = new JLabel("Repeat");
        jLabel.setDisplayedMnemonic('R');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this._repeatButton = new RmaJObjectButton(null, "None");
        jLabel.setLabelFor((Component)this._repeatButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._repeatButton, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        jLabel = new JLabel("Note:");
        jLabel.setDisplayedMnemonic('N');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)15, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._notesField = new RmaJDescriptionField();
        jLabel.setLabelFor((Component)this._notesField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)15, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._notesField, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this.addWindowListener(new CapacityScheduleDialog$1(this));
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new CapacityScheduleDialog$2(this));
        this._repeatButton.addActionListener((ActionListener)new CapacityScheduleDialog$3(this));
        this.pack();
        CapacityScheduleDialog capacityScheduleDialog = this;
        capacityScheduleDialog.setLocationRelativeTo(capacityScheduleDialog.getParent());
    }

    public void clearForm() {
        super.clearForm();
        this._outage = null;
        this._repeatButton.setObject(null);
        this._outletCombo.setEnabled(true);
    }

    protected void displayRepeatDialog() {
        if (this._repeatDialog == null) {
            this._repeatDialog = new RepeatDialog((Dialog)((Object)this), true);
        }
        this._repeatDialog.clearForm();
        this._repeatDialog.setRepeatInterval((RepeatInterval)this._repeatButton.getObject());
        this._repeatDialog.setVisible(true);
        if (this._repeatDialog.isCanceled()) {
            return;
        }
        this._repeatButton.setObject((Object)this._repeatDialog.getRepeatInterval());
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setSelectedOutlet(Element element) {
        if (element == null) {
            this._outletCombo.setSelectedIndex(-1);
            return;
        }
        this._outletCombo.setSelectedItem((Object)element);
        this._outletCombo.setEnabled(false);
    }

    public void setCapacityFactor(double d) {
        this._capacityFactor.setValue(d);
    }

    public void setStartDateTime(HecTime hecTime) {
        if (hecTime == null) {
            return;
        }
        ClientApp.app();
        this._startDateTime.setDateTime(hecTime, ClientApp.Workspace().getTimeZone());
    }

    public void setEndDateTime(HecTime hecTime) {
        if (hecTime == null) {
            return;
        }
        if (!hecTime.isDefined()) {
            this._endDateTime.clear();
            return;
        }
        ClientApp.app();
        this._endDateTime.setDateTime(hecTime, ClientApp.Workspace().getTimeZone());
    }

    public void setRepeatValue(String string) {
    }

    public void setOutlets(List list) {
        list = new RmaListModel(false, (Collection)list);
        this._outletCombo.setModel((ComboBoxModel)((Object)list));
    }

    public HecTime getStartDateTime() {
        HecTimeArray hecTimeArray = this._startDateTime.getDateTime();
        hecTimeArray = hecTimeArray.element(0);
        return hecTimeArray;
    }

    public HecTime getEndDateTime() {
        HecTimeArray hecTimeArray = this._endDateTime.getDateTime();
        hecTimeArray = hecTimeArray.element(0);
        return hecTimeArray;
    }

    public void setCapacityOutage(CapacityOutage capacityOutage) {
        this.clearForm();
        if (capacityOutage == null) {
            return;
        }
        this._outage = capacityOutage;
        this.setCapacityFactor(capacityOutage.getFactor());
        this.setStartDateTime(capacityOutage.getStartTime());
        this.setEndDateTime(capacityOutage.getEndTime());
        CapacityScheduleDialog capacityScheduleDialog = this;
        capacityScheduleDialog.setNote(capacityScheduleDialog._outage.getDescription());
        this._repeatButton.setObject((Object)this._outage.getRepeatInterval());
    }

    public CapacityOutage getCapacityOutage() {
        if (this._outage == null) {
            this._outage = new CapacityOutage();
        }
        this._outage.setStartTime(this.getStartDateTime());
        this._outage.setEndTime(this.getEndDateTime());
        this._outage.setFactor(this.getCapacityFactor());
        this._outage.setDescription(this.getNote());
        this._outage.setRepeatInterval((RepeatInterval)this._repeatButton.getObject());
        if (this._outage.getRepeatInterval() == null) {
            this._outage.setRepeatInterval((RepeatInterval)new NoRepeatInterval());
        }
        return this._outage;
    }

    public void setNote(String string) {
        if (string == null) {
            this._notesField.setText("");
            return;
        }
        this._notesField.setText(string);
    }

    public String getNote() {
        return this._notesField.getText();
    }

    public double getCapacityFactor() {
        return this._capacityFactor.getValue();
    }

    public String getRepeatingString() {
        if (this._repeatButton.getText().equalsIgnoreCase("None")) {
            return "No";
        }
        return this._repeatButton.getText();
    }

    protected boolean isValidForm() {
        String string = null;
        RmaJComboBox rmaJComboBox = null;
        if (this._outletCombo.getSelectedItem() == null) {
            string = "Please select an Outlet";
            rmaJComboBox = this._outletCombo;
        } else if (this._capacityFactor.getValueUndefined() == Double.NEGATIVE_INFINITY) {
            string = "Please enter a Capacity Factor";
            rmaJComboBox = this._capacityFactor;
        } else if (!this._startDateTime.getDateTime().element(0).isDefined()) {
            string = "Please enter a Start date";
            rmaJComboBox = this._startDateTime;
        } else if (!this._endDateTime.getDateTime().element(0).isDefined()) {
            string = "Please enter an End date";
            rmaJComboBox = this._endDateTime;
        }
        if (string != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), string, "Incomplete Form", 2);
            rmaJComboBox.requestFocus();
            return false;
        }
        return true;
    }

    public Element getSelectedOutlet() {
        return (Element)this._outletCombo.getSelectedItem();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this._startDateTime.setDisplayTimeZone(CapacityScheduleDialog.getTimeZone());
            this._endDateTime.setDisplayTimeZone(CapacityScheduleDialog.getTimeZone());
        }
        super.setVisible(bl);
    }
}

