/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.heclib.util.intContainer;
import hec.lang.NamedType;
import hec.model.RunTimeWindow;
import hec.rss.client.CapacityScheduleDialog;
import hec.rss.client.CapacitySchedulePanel$1;
import hec.rss.client.CapacitySchedulePanel$2;
import hec.rss.client.CapacitySchedulePanel$3;
import hec.rss.client.CapacitySchedulePanel$CapacityTableModel;
import hec.rss.client.CapacityTabulateDialog;
import hec.rss.client.OperationsTab;
import hec.rss.client.ReservoirJFrame;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.CapacityOutage;
import hec.rss.model.CapacitySchedule;
import hec.rss.model.Element;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirOp;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Spillway;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.swing.print.PageText;

public class CapacitySchedulePanel
extends DefaultJPanel
implements OperationsTab {
    private RmaJTable _capacityTable;
    private CapacitySchedulePanel$CapacityTableModel _tableModel;
    private JButton _delButton;
    private JButton _dupButton;
    private JButton _editButton;
    private ReflectMultiListener _listener;
    private boolean _controlsCreated;
    private ReservoirOp _resOp;
    private OpSet _opSet;
    private RunTimeWindow _runTimeWindow;
    private CapacityScheduleDialog _capacityScheduleDialog;
    private List _outletList = new ArrayList();

    public boolean areControlsCreated() {
        return this._controlsCreated;
    }

    public void createControls() {
        this.setLayout(new GridBagLayout());
        this._listener = new ReflectMultiListener();
        JLabel jLabel = new JLabel("Scheduled Capacity Outage");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jLabel, gridBagConstraints);
        CapacitySchedulePanel capacitySchedulePanel = this;
        this._capacityTable = new CapacitySchedulePanel$1(capacitySchedulePanel, (Component)((Object)capacitySchedulePanel), new String[]{"Outlet", "Start Date", "End Date", "Cap. Factor", "Repeating"});
        this._tableModel = new CapacitySchedulePanel$CapacityTableModel(this);
        this._capacityTable.setModel((TableModel)((Object)this._tableModel));
        this._capacityTable.setAddRemoveEnabled(true);
        this._capacityTable.setAllColumnsEnabled(false);
        this._capacityTable.setMlHeaderRenderer();
        this._capacityTable.setHorizontalAlignment(0, 1);
        this._capacityTable.setHorizontalAlignment(0, 2);
        this._capacityTable.setHorizontalAlignment(0, 4);
        this._capacityTable.setDoubleCellEditor(3);
        this._capacityTable.setColumnWidths(new int[]{168, 130, 130, 60, 80});
        this._capacityTable.getSelectionModel().addListSelectionListener(new CapacitySchedulePanel$2(this));
        this._capacityTable.setColumnSelectionAllowed(false);
        this._capacityTable.setCellSelectionEnabled(false);
        this._capacityTable.setRowSelectionAllowed(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        CapacitySchedulePanel capacitySchedulePanel2 = this;
        capacitySchedulePanel2.add(capacitySchedulePanel2._capacityTable.getScrollPane(), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jPanel, gridBagConstraints);
        JButton jButton = new JButton("Add");
        jButton.setMnemonic('A');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jButton, gridBagConstraints);
        this._dupButton = new JButton("Duplicate");
        this._dupButton.setMnemonic('D');
        this._dupButton.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._dupButton, gridBagConstraints);
        this._delButton = new JButton("Delete");
        this._delButton.setMnemonic('E');
        this._delButton.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._delButton, gridBagConstraints);
        this._editButton = new JButton("Edit");
        this._editButton.setMnemonic('E');
        this._editButton.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._editButton, gridBagConstraints);
        JButton jButton2 = new JButton("Plot");
        jButton2.setMnemonic('P');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)20, (int)5, (int)0, (int)5);
        jPanel.add((Component)jButton2, gridBagConstraints);
        jLabel = new JLabel("");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jButton.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jButton, "addEntryAction"));
        CapacitySchedulePanel capacitySchedulePanel3 = this;
        this._dupButton.addActionListener((ActionListener)this._listener.add((Object)capacitySchedulePanel3, (Object)capacitySchedulePanel3._dupButton, "duplicateEntryAction"));
        CapacitySchedulePanel capacitySchedulePanel4 = this;
        this._delButton.addActionListener((ActionListener)this._listener.add((Object)capacitySchedulePanel4, (Object)capacitySchedulePanel4._delButton, "deleteEntryAction"));
        CapacitySchedulePanel capacitySchedulePanel5 = this;
        this._editButton.addActionListener((ActionListener)this._listener.add((Object)capacitySchedulePanel5, (Object)capacitySchedulePanel5._editButton, "editEntryAction"));
        jButton2.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jButton2, "plotOutagesAction"));
        this._capacityTable.addMouseListener((MouseListener)new CapacitySchedulePanel$3(this));
        this._controlsCreated = true;
    }

    public void editEntryAction() {
        int n = this._capacityTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        this.editEntryAction(n);
    }

    public void editEntryAction(int n) {
        Object object;
        if (this._capacityScheduleDialog == null) {
            object = (ReservoirJFrame)((Object)SwingUtilities.windowForComponent((Component)((Object)this)));
            this._capacityScheduleDialog = new CapacityScheduleDialog((Dialog)object, true);
        }
        this._capacityScheduleDialog.clearForm();
        this._capacityScheduleDialog.setOutlets(this.getOutletList());
        object = this._tableModel.getOutletAt(n);
        this._capacityScheduleDialog.setSelectedOutlet((Element)object);
        this._capacityScheduleDialog.setCapacityOutage(this._tableModel.getCapacityOutageAt(n));
        this._capacityScheduleDialog.setVisible(true);
        if (this._capacityScheduleDialog.isCanceled()) {
            return;
        }
        this._tableModel.setCapacityOutageAt(n, this._capacityScheduleDialog.getCapacityOutage());
        this._tableModel.setOutletAt(n, this._capacityScheduleDialog.getSelectedOutlet());
    }

    public void deleteEntryAction() {
        int n;
        int[] nArray = this._capacityTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select one or more rows in the table to delete", "No Rows Selected", 1);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>Confirm deletion of the following Outlet Outages:<br><br>");
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append("<b>");
            stringBuffer.append(this._capacityTable.getValueAt(nArray[n], 0).toString());
            stringBuffer.append(" starting at ");
            stringBuffer.append(this._capacityTable.getValueAt(nArray[n], 1));
            stringBuffer.append("<br>");
        }
        stringBuffer.append("<b>");
        n = JOptionPane.showConfirmDialog((Component)((Object)this), stringBuffer.toString(), "Confirm Deletions", 0);
        if (n != 0) {
            return;
        }
        this._capacityTable.deleteRow();
    }

    public void addEntryAction() {
        Object object;
        if (this._capacityScheduleDialog == null) {
            object = (ReservoirJFrame)((Object)SwingUtilities.windowForComponent((Component)((Object)this)));
            this._capacityScheduleDialog = new CapacityScheduleDialog((Dialog)object, true);
        }
        this._capacityScheduleDialog.clearForm();
        this._capacityScheduleDialog.setOutlets(this.getOutletList());
        this._capacityScheduleDialog.setVisible(true);
        if (this._capacityScheduleDialog.isCanceled()) {
            return;
        }
        object = this._capacityScheduleDialog.getSelectedOutlet();
        Vector<Object> vector = new Vector<Object>(2);
        vector.add(object);
        vector.add(this._capacityScheduleDialog.getCapacityOutage());
        this._capacityTable.appendRow(vector);
    }

    public void duplicateEntryAction() {
        int[] nArray = this._capacityTable.getSelectedRows();
        Vector<Object> vector = new Vector<Object>(2);
        for (int i = 0; i < nArray.length; ++i) {
            Element element = this._tableModel.getOutletAt(nArray[i]);
            CapacityOutage capacityOutage = this._tableModel.getCapacityOutageAt(nArray[i]);
            vector.add(element);
            vector.add(capacityOutage.clone());
            this._capacityTable.appendRow(vector);
        }
    }

    public void plotOutagesAction() {
        if (this._capacityTable.getRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Outages to show.", "Information", 1);
            return;
        }
        CapacitySchedule capacitySchedule = new CapacitySchedule();
        capacitySchedule.clearOutages();
        int n = this._tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            Element element = this._tableModel.getOutletAt(i);
            CapacityOutage capacityOutage = this._tableModel.getCapacityOutageAt(i);
            capacitySchedule.addOutage(element, capacityOutage);
        }
        ReservoirJFrame reservoirJFrame = (ReservoirJFrame)((Object)SwingUtilities.windowForComponent((Component)((Object)this)));
        CapacityTabulateDialog capacityTabulateDialog = new CapacityTabulateDialog((Dialog)((Object)reservoirJFrame), "Capacity Factors", false);
        capacityTabulateDialog.setSystem(this._resOp.getReservoirElement().getSystem());
        capacityTabulateDialog.setCapacitySchedule(capacitySchedule, this._runTimeWindow);
        capacityTabulateDialog.setLocationRelativeTo((Component)((Object)this));
        capacityTabulateDialog.setVisible(true);
    }

    public List getOutletList() {
        return this._outletList;
    }

    @Override
    public void setReservoirOp(ReservoirOp cloneable) {
        this._resOp = cloneable;
        cloneable = this._resOp.getReservoirElement();
        Vector vector = new Vector();
        ((Element)((Object)cloneable)).getElementsByClass(AdjustableFlow.class, vector);
        ((Element)((Object)cloneable)).getElementsByClass(Spillway.class, vector);
        this._capacityTable.deleteCells();
        this._outletList.clear();
        this._outletList.addAll(vector);
    }

    public void setRunTimeWindow(RunTimeWindow runTimeWindow) {
        this._runTimeWindow = runTimeWindow;
    }

    public void setOpSet(OpSet object) {
        if (!this._controlsCreated) {
            this.createControls();
        }
        this._capacityTable.deleteCells();
        this._opSet = object;
        if (object == null) {
            return;
        }
        object = ((OpSet)object).getCapacitySchedule();
        object = ((CapacitySchedule)object).getCapacityOutages();
        Object object2 = object.keySet();
        object2 = object2.iterator();
        String string = "Capacity Outages Report\nfor\n" + ((RssTSLocationObject)this._opSet).getSystem().getName() + " Network\n" + this._opSet.getElementOp().getOperationsElement().getName() + " Reservoir\n" + this._opSet.getName() + " Operations Set";
        this._capacityTable.setPrintTitle(new PageText(string, 0));
        while (object2.hasNext()) {
            string = (intContainer)object2.next();
            List list = (List)object.get(string);
            for (int i = 0; i < list.size(); ++i) {
                CapacityOutage capacityOutage = (CapacityOutage)list.get(i);
                Vector<NamedType> vector = new Vector<NamedType>(2);
                vector.add(this.getElement(((intContainer)string).value));
                vector.add(capacityOutage);
                this._tableModel.addRow(vector);
            }
        }
    }

    private Element getElement(int n) {
        return this._resOp.getReservoirElement().getElement(n);
    }

    @Override
    public void clearForm() {
        if (!this._controlsCreated) {
            return;
        }
        this._capacityTable.deleteCells();
    }

    public boolean savePanel() {
        if (!this._controlsCreated) {
            return true;
        }
        if (this._opSet == null) {
            return true;
        }
        CapacitySchedule capacitySchedule = this._opSet.getCapacitySchedule();
        capacitySchedule.clearOutages();
        int n = this._tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            Element element = this._tableModel.getOutletAt(i);
            CapacityOutage capacityOutage = this._tableModel.getCapacityOutageAt(i);
            capacitySchedule.addOutage(element, capacityOutage);
        }
        return true;
    }
}

