/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.geometry.Axis;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.PopupPlotCreator;
import hec.gfx2d.TimeSeriesDataSet;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.heclib.util.intContainer;
import hec.io.TimeSeriesContainer;
import hec.lang.DSSPathString;
import hec.model.RepeatInterval;
import hec.model.RunTimeWindow;
import hec.rss.client.CapacityTabulateDialog$1;
import hec.rss.client.CapacityTabulateDialog$2;
import hec.rss.client.CapacityTabulateDialog$OutagePopupPlotCreator;
import hec.rss.model.CapacityOutage;
import hec.rss.model.CapacitySchedule;
import hec.rss.model.Element;
import hec.rss.model.ModelConst;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DateTimePanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAIO;

public class CapacityTabulateDialog
extends RmaJDialog {
    private DateTimePanel _startTimePanel;
    private DateTimePanel _endTimePanel;
    private RmaJComboBox _timeStepCombo;
    private G2dPanel _plotPanel;
    private ButtonCmdPanel _cmdPanel;
    private List _outages;
    private ReflectMultiListener _listener;
    private RssSystem _system;
    private CapacitySchedule _schedule;
    private PopupPlotCreator _popupPlotCreator = new CapacityTabulateDialog$OutagePopupPlotCreator(this);
    private static final String[] a = new String[]{"15 Minute", "30 Minute", "1 Hour", "3 Hours", "6 Hours", "12 Hours", "1 Day"};

    public CapacityTabulateDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.buildControls();
    }

    public CapacityTabulateDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.buildControls();
    }

    private void buildControls() {
        this._listener = new ReflectMultiListener();
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        JComponent jComponent = new JLabel("Start Date:");
        ((JLabel)jComponent).setDisplayedMnemonic('S');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._startTimePanel = new DateTimePanel(1, "", "Time:", "DDMMMYYYY");
        ((JLabel)jComponent).setLabelFor((Component)this._startTimePanel);
        this._startTimePanel.setTimeZone(ClientApp.app().getClientTimeZone());
        this._startTimePanel.setDataTimeZone(ClientApp.Workspace().getTimeZone());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._startTimePanel, gridBagConstraints);
        jComponent = new JLabel("End Date:");
        ((JLabel)jComponent).setDisplayedMnemonic('E');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._endTimePanel = new DateTimePanel(1, "", "Time:", "DDMMMYYYY");
        ((JLabel)jComponent).setLabelFor((Component)this._endTimePanel);
        this._endTimePanel.setTimeZone(ClientApp.app().getClientTimeZone());
        this._endTimePanel.setDataTimeZone(ClientApp.Workspace().getTimeZone());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._endTimePanel, gridBagConstraints);
        jComponent = new JLabel("Time Step:");
        ((JLabel)jComponent).setDisplayedMnemonic('T');
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._timeStepCombo = new RmaJComboBox((Object[])a);
        this._timeStepCombo.setSelectedItem((Object)"1 Hour");
        ((JLabel)jComponent).setLabelFor((Component)this._timeStepCombo);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._timeStepCombo, gridBagConstraints);
        jComponent = new JButton("Update Plot");
        ((AbstractButton)jComponent).setMnemonic('U');
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._plotPanel = new CapacityTabulateDialog$1(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._plotPanel, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(256);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        ((AbstractButton)jComponent).addActionListener((ActionListener)this._listener.add((Object)this, (Object)jComponent, "updatePlotAction"));
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new CapacityTabulateDialog$2(this));
        this.pack();
    }

    public void updatePlotAction() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Object object = this._startTimePanel.getDateTime();
            HecTimeArray hecTimeArray = this._endTimePanel.getDateTime();
            object = object.element(0);
            hecTimeArray = hecTimeArray.element(0);
            if (hecTimeArray.lessThan((HecTime)object)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "End Time must be after Start Time", "Invalid Times", 2);
                return;
            }
            int n = this.getTimestep();
            int n2 = this.getTimeStepType();
            RunTimeWindow runTimeWindow = new RunTimeWindow();
            runTimeWindow.setStartTime((HecTime)object);
            runTimeWindow.setEndTime((HecTime)hecTimeArray);
            runTimeWindow.setTimeStep(n, n2);
            runTimeWindow.getNumSteps();
            object = this.buildCapacityFactorArray(runTimeWindow);
            ArrayList<TimeSeriesDataSet> arrayList = new ArrayList<TimeSeriesDataSet>(object.size());
            for (int i = 0; i < object.size(); ++i) {
                hecTimeArray = (TimeSeriesContainer)object.get(i);
                TimeSeriesDataSet timeSeriesDataSet = new TimeSeriesDataSet((TimeSeriesContainer)hecTimeArray);
                if (hecTimeArray.timeZoneID != null) {
                    timeSeriesDataSet.setGmtOffset(hecTimeArray.timeZoneRawOffset / 3600000);
                }
                arrayList.add(timeSeriesDataSet);
            }
            PlotLayout plotLayout = new PlotLayout();
            plotLayout.setToolbarOff();
            object = plotLayout.addViewport(100.0);
            for (int i = 0; i < arrayList.size(); ++i) {
                object.addCurve("Y1", arrayList.get(i));
            }
            this._plotPanel.buildComponents(plotLayout);
            G2dGlyph g2dGlyph = this._plotPanel.getViewports();
            object = g2dGlyph[0].getGlyphVector();
            Axis axis = g2dGlyph[0].getAxis("Y1");
            axis.setAutomaticMaximumOff();
            axis.setAutomaticMinimumOff();
            axis.setMaximumLimit(1.0);
            axis.setMinimumLimit(-0.1);
            g2dGlyph[0].getAxisTics("Y1");
            for (int i = 0; i < arrayList.size(); ++i) {
                TimeSeriesDataSet timeSeriesDataSet = (TimeSeriesDataSet)arrayList.get(i);
                boolean bl = timeSeriesDataSet._timeSeries.version.length() > 1;
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    g2dGlyph = (G2dGlyph)((Vector)object).get(j);
                    plotLayout = g2dGlyph.getG2dObject();
                    if (!(plotLayout instanceof TimeSeriesDataSet) || timeSeriesDataSet != (plotLayout = (TimeSeriesDataSet)plotLayout)) continue;
                    g2dGlyph = g2dGlyph.getLine();
                    if (bl) {
                        G2dGlyph g2dGlyph2 = g2dGlyph;
                        g2dGlyph2.setFillColor(g2dGlyph2.getLineColorString());
                        g2dGlyph.setFillType("below");
                        continue;
                    }
                    g2dGlyph.setLineWidth(5.0f);
                }
            }
            axis.computeScaling(0.0, 1.0);
            this._plotPanel.paintGfx();
            this._plotPanel.revalidate();
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected List buildCapacityFactorArray(RunTimeWindow runTimeWindow) {
        Map map = this._schedule.getCapacityOutages();
        new ArrayList();
        map.size();
        Object object = map.keySet();
        object = object.iterator();
        int n = runTimeWindow.getNumSteps();
        ArrayList<TimeSeriesContainer> arrayList = new ArrayList<TimeSeriesContainer>();
        DSSPathname dSSPathname = new DSSPathname();
        int n2 = 0;
        try {
            n2 = ((RmiWorkspace)this._system.getWorkspace().getRemote()).getTimeZone().getRawOffset();
        }
        catch (RemoteException remoteException) {
            System.out.println("buildCapacityFactorArray: failed to get TZ offset " + String.valueOf(remoteException));
        }
        while (object.hasNext()) {
            Object object2 = (intContainer)object.next();
            Object object3 = this._system.getElement(((intContainer)object2).value);
            if (object3 == null) {
                System.out.println("buildCapacityFactorArray: failed to find element for Index=" + ((intContainer)object2).value);
                continue;
            }
            double[] dArray = new double[n];
            int[] nArray = new int[n];
            object3 = ((Element)object3).getTSRecordProxy(127);
            object3 = this.constructTSRecordProxyDssPath((TSRecordProxy)object3, "CAPACITY-FACTOR", runTimeWindow);
            dSSPathname.setPathname((String)object3);
            TimeSeriesContainer timeSeriesContainer = new TimeSeriesContainer();
            new TimeSeriesContainer().fullName = dSSPathname.pathname();
            timeSeriesContainer.watershed = dSSPathname.aPart();
            timeSeriesContainer.location = dSSPathname.bPart();
            timeSeriesContainer.parameter = dSSPathname.cPart();
            timeSeriesContainer.version = dSSPathname.fPart();
            timeSeriesContainer.type = "PER-AVER";
            timeSeriesContainer.timeZoneRawOffset = n2;
            timeSeriesContainer.numberValues = n;
            timeSeriesContainer.units = "Factor";
            timeSeriesContainer.startTime = runTimeWindow.getStartTime().value();
            timeSeriesContainer.endTime = runTimeWindow.getEndTime().value();
            timeSeriesContainer.interval = runTimeWindow.getTimeStepMinutes();
            nArray[0] = timeSeriesContainer.startTime;
            for (int i = 1; i < nArray.length; ++i) {
                nArray[i] = nArray[i - 1] + timeSeriesContainer.interval;
            }
            timeSeriesContainer.times = nArray;
            timeSeriesContainer.fullName = dSSPathname.pathname();
            Arrays.fill(dArray, 1.0);
            object2 = (List)map.get(object2);
            int n3 = object2.size();
            HecTime hecTime = new HecTime();
            HecTime hecTime2 = new HecTime();
            for (int i = 0; i < n3; ++i) {
                int n4;
                object3 = (CapacityOutage)object2.get(i);
                RepeatInterval repeatInterval = ((CapacityOutage)object3).getRepeatInterval();
                TimeSeriesContainer timeSeriesContainer2 = new TimeSeriesContainer();
                new TimeSeriesContainer().watershed = dSSPathname.aPart();
                timeSeriesContainer2.location = dSSPathname.bPart();
                timeSeriesContainer2.parameter = dSSPathname.cPart();
                timeSeriesContainer2.version = "Outage " + (i + 1) + (String)(repeatInterval != null ? "(" + repeatInterval.toString() + ")" : "");
                timeSeriesContainer2.type = "PER-AVER";
                timeSeriesContainer2.timeZoneRawOffset = n2;
                timeSeriesContainer2.units = "Factor";
                timeSeriesContainer2.startTime = runTimeWindow.getStartTime().value();
                timeSeriesContainer2.endTime = runTimeWindow.getEndTime().value();
                timeSeriesContainer2.interval = runTimeWindow.getTimeStepMinutes();
                timeSeriesContainer2.numberValues = n;
                nArray[0] = timeSeriesContainer2.startTime;
                for (n4 = 1; n4 < nArray.length; ++n4) {
                    nArray[n4] = nArray[n4 - 1] + timeSeriesContainer2.interval;
                }
                timeSeriesContainer2.times = nArray;
                timeSeriesContainer2.values = new double[n];
                Arrays.fill(timeSeriesContainer2.values, 0.0);
                arrayList.add(timeSeriesContainer2);
                if (!((CapacityOutage)object3).isActive()) continue;
                hecTime.set(runTimeWindow.getStartTime());
                for (n4 = 0; n4 < n; ++n4) {
                    hecTime2.set(hecTime);
                    hecTime2.add(runTimeWindow.getTimeStepMinutes());
                    double d = ((CapacityOutage)object3).getFactorForStep(hecTime, hecTime2);
                    if (d != 1.0) {
                        timeSeriesContainer2.values[n4] = d;
                    }
                    this.fillCapacityArray(n4, dArray, d);
                    hecTime.set(hecTime2);
                }
            }
            timeSeriesContainer.values = dArray;
            arrayList.add(timeSeriesContainer);
        }
        return arrayList;
    }

    private void fillCapacityArray(int n, double[] dArray, double d) {
        if (dArray[n] == 1.0 || dArray[n] > d) {
            dArray[n] = d;
        }
    }

    private void fillCapacityArray(HecTime hecTime, HecTime hecTime2, RunTimeWindow runTimeWindow, double[] dArray, double[] dArray2, double d) {
        HecTime hecTime3;
        int n = runTimeWindow.getStepAtTime(hecTime);
        int n2 = runTimeWindow.getStepAtTime(hecTime2);
        int n3 = runTimeWindow.getNumSteps();
        if (n > n3) {
            return;
        }
        if (n < 0 && n2 < 0) {
            return;
        }
        HecTime hecTime4 = runTimeWindow.getTimeAtStep(n);
        if (n != n2) {
            hecTime3 = runTimeWindow.getTimeAtStep(n2);
        } else {
            hecTime3 = new HecTime(hecTime4);
            hecTime3.add(runTimeWindow.getTimeIncrement() * 60);
        }
        if (!hecTime4.equalTo(hecTime) || !hecTime3.greaterThan(hecTime2)) {
            hecTime4.value();
            hecTime3.value();
            hecTime.value();
            hecTime2.value();
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 >= n3) {
            n2 = n3;
        }
        if (n > n2) {
            return;
        }
        double d2 = -d + -17.0;
        for (int i = n; i < n2; ++i) {
            if (dArray[i] != 1.0 && !(dArray[i] < d2)) continue;
            dArray[i] = d2;
            dArray2[i] = d;
        }
    }

    public void setCapacitySchedule(CapacitySchedule capacitySchedule, RunTimeWindow object) {
        int n;
        CapacityOutage capacityOutage;
        List list;
        if (capacitySchedule == null || capacitySchedule.getCapacityOutages().size() == 0) {
            this._plotPanel.buildComponents(new ArrayList(0), false, false);
            return;
        }
        this._schedule = capacitySchedule;
        capacitySchedule = new HecTime();
        HecTime hecTime = new HecTime();
        Iterator iterator = this._schedule.getCapacityOutages();
        iterator = iterator.values();
        if ((iterator = iterator.iterator()).hasNext()) {
            list = (List)iterator.next();
            if (list.size() > 0) {
                capacityOutage = (CapacityOutage)list.get(0);
                capacitySchedule.set(capacityOutage.getStartTime());
                hecTime.set(capacityOutage.getEndTime());
            }
        } else {
            return;
        }
        do {
            for (n = 0; n < list.size(); ++n) {
                capacityOutage = (CapacityOutage)list.get(n);
                if (capacityOutage.getStartTime().lessThan((HecTime)capacitySchedule)) {
                    capacitySchedule.set(capacityOutage.getStartTime());
                }
                if (!capacityOutage.getEndTime().greaterThan(hecTime)) continue;
                hecTime.set(capacityOutage.getEndTime());
            }
            if (!iterator.hasNext()) continue;
            list = (List)iterator.next();
        } while (iterator.hasNext());
        if (object != null) {
            capacitySchedule.set(object.getLookbackTime());
            hecTime.set(object.getEndTime());
            n = this._timeStepCombo.getSelectedIndex();
            object = object.getTimeStepString(1);
            int n2 = 2;
            for (int i = 0; i < a.length; ++i) {
                if (!a[i].equalsIgnoreCase((String)object)) continue;
                n2 = i;
                break;
            }
            this._timeStepCombo.setSelectedIndex(n2);
            if (this._timeStepCombo.getSelectedIndex() < 0) {
                this._timeStepCombo.setSelectedIndex(n);
            }
        }
        TimeZone timeZone = ClientApp.Workspace().getTimeZone();
        this._endTimePanel.setDateTime(hecTime, timeZone);
        this._startTimePanel.setDateTime((HecTime)capacitySchedule, timeZone);
        this.updatePlotAction();
    }

    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }

    public int getTimestep() {
        int n;
        String string = (String)this._timeStepCombo.getSelectedItem();
        int n2 = 1;
        if (string != null && (n = string.indexOf(32)) >= 0) {
            string = string.substring(0, n);
            n2 = RMAIO.parseInt((String)string, (int)1);
        }
        return n2;
    }

    public int getTimeStepType() {
        int n;
        String string = (String)this._timeStepCombo.getSelectedItem();
        int n2 = 2;
        if (string != null && (n = string.indexOf(32)) >= 0) {
            if ((string = string.substring(n).trim()).equalsIgnoreCase("Hour")) {
                n2 = 2;
            } else if (string.equalsIgnoreCase("Hours")) {
                n2 = 2;
            } else if (string.equalsIgnoreCase("Minute")) {
                n2 = 1;
            } else if (string.equalsIgnoreCase("Minutes")) {
                n2 = 1;
            } else if (string.equalsIgnoreCase("Day")) {
                n2 = 3;
            } else if (string.equalsIgnoreCase("Second")) {
                n2 = 0;
            }
        }
        return n2;
    }

    public String constructTSRecordProxyDssPath(TSRecordProxy object, String string, RunTimeWindow runTimeWindow) {
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        stringArray[0] = "";
        stringArray2[1] = this._system.getNameForKeyString(object.getName());
        stringArray2[2] = object.getParamName();
        if ((stringArray2[2].equals("FLOW") || stringArray2[2].equals("Flow")) && !string.equals("-REG")) {
            stringArray2[2] = stringArray2[2] + string;
        } else if (stringArray2[2].equals(ModelConst.m) && !string.equals("-REG")) {
            stringArray2[2] = stringArray2[2] + string;
        } else if (stringArray2[2].equals(ModelConst.k) && !string.equals("-REG")) {
            stringArray2[2] = stringArray2[2] + string;
        } else if (stringArray2[2].equals(ModelConst.n)) {
            stringArray2[2] = ModelConst.n;
        } else if (stringArray2[2].equals(ModelConst.k)) {
            stringArray2[2] = ModelConst.k;
        } else if (stringArray2[2].length() == 0) {
            stringArray2[2] = string;
        }
        stringArray2[3] = runTimeWindow.getStartDateString();
        stringArray2[4] = runTimeWindow.getTimeStepString(0);
        stringArray2[5] = "";
        object = DSSPathString.getPathname((String[])stringArray2);
        return object;
    }
}

