/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.OperationsTab;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirOp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJIntegerField;

public class CompProjectedElevPanel
extends DefaultJPanel
implements OperationsTab {
    private RmaJIntegerField _projectionTimeWindowFld;
    private RmaJCheckBox _useProjectedCheck;
    private boolean _controlsCreated;
    private OpSet _opSet;

    public CompProjectedElevPanel() {
        super((LayoutManager)new GridBagLayout());
    }

    public void createControls() {
        JLabel jLabel = new JLabel("Projected Reservoir Elevation");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        jLabel = new JLabel("Projection Time Window (hrs):");
        jLabel.setDisplayedMnemonic('P');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jLabel, gridBagConstraints);
        this._projectionTimeWindowFld = new RmaJIntegerField();
        this._projectionTimeWindowFld.setMinValue(0);
        this._projectionTimeWindowFld.setColumns(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        CompProjectedElevPanel compProjectedElevPanel = this;
        compProjectedElevPanel.add((Component)compProjectedElevPanel._projectionTimeWindowFld, gridBagConstraints);
        this._useProjectedCheck = new RmaJCheckBox("Use Projected Reservoir Elevation to determine Operation Zone");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        CompProjectedElevPanel compProjectedElevPanel2 = this;
        compProjectedElevPanel2.add((Component)compProjectedElevPanel2._useProjectedCheck, gridBagConstraints);
        this._controlsCreated = true;
    }

    @Override
    public void setReservoirOp(ReservoirOp reservoirOp) {
    }

    @Override
    public void clearForm() {
        if (!this._controlsCreated) {
            return;
        }
        this._projectionTimeWindowFld.setValue(0);
        this._useProjectedCheck.setSelected(false);
    }

    public boolean areControlsCreated() {
        return this._controlsCreated;
    }

    public void fillPanel() {
        int n = this._opSet.getCompProjElevHours();
        this._projectionTimeWindowFld.setValue(n);
        this._useProjectedCheck.setSelected(this._opSet.useProjectedResElevForOpZone());
    }

    public boolean savePanel() {
        if (!this._controlsCreated) {
            return true;
        }
        int n = this._projectionTimeWindowFld.getValue();
        this._opSet.setCompProjElevHours(n);
        this._opSet.setUseProjectedResElevForOpZone(this._useProjectedCheck.isSelected());
        return true;
    }

    public void setOpSet(OpSet opSet) {
        this._opSet = opSet;
    }
}

