/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.ConnectivityDlg$1;
import hec.rss.client.ConnectivityDlg$SearchLoc;
import hec.rss.client.reports.PrintableReport;
import hec.rss.model.Element;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import rma.swing.FindDialog;
import rma.swing.FindListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;

public class ConnectivityDlg
extends RmaJFrame
implements PrintableReport,
FindListener {
    private static Color a = new Color(170, 170, 170);
    private static Color b = new Color(220, 220, 220);
    RmaJTable _table;
    private Vector _listenerList = new Vector();
    private ReflectMultiListener _listener = new ReflectMultiListener();
    private FindDialog _findDialog;
    private ConnectivityDlg$SearchLoc _searchLoc;

    public ConnectivityDlg() {
        this.createComponents();
    }

    void createComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(640, 450);
        this.setLocation();
        this.buildMenus();
        ConnectivityDlg connectivityDlg = this;
        this._table = new ConnectivityDlg$1(connectivityDlg, (Component)((Object)connectivityDlg), new String[]{"Element/\nNode", "ID", "Name", "Function/\nUpstrm Elem", "Parent/\nDnstrm Elem"});
        this._table.setMlHeaderRenderer();
        this._table.setEnabled(false);
        this._table.setCellSelectionEnabled(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.setRowSelectionAllowed(true);
        this._table.setAddRemoveEnabled(false);
        this._table.getSelectionModel().setSelectionMode(0);
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this._table.getScrollPane(), object);
        JLabel jLabel = new JLabel();
        object = new String("<html>Table Notes:");
        object = (String)object + "<br>Dark gray rows represent primary network elements";
        object = (String)object + "<br>Light gray rows represent child elements";
        object = (String)object + "<br>White rows represent nodes";
        object = (String)object + "<br>In name fields, ~E# references the name of element with id #<html>";
        jLabel.setText((String)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((GridBagConstraints)object).fill = 2;
        this.getContentPane().add((Component)jLabel, object);
    }

    private void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Export", 69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "exportReport"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Print", 80);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "printReport"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Print Preview", 118);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "printPreviewReport"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Close", 67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "closeDialog"));
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Find");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Find", 70);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "findAction"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Find Next", 78);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "findNextAction"));
        jMenu.add(jMenuItem);
        this.setJMenuBar(jMenuBar);
    }

    public void fillForm(RssSystem rssSystem) {
        Vector vector = rssSystem.getElementVector();
        if (vector == null) {
            this._table.clearColors();
            this._table.deleteCells();
            return;
        }
        this.fillForm(vector);
        this.setTitle("ResSim Network Connectivity - " + rssSystem.getName());
    }

    public void fillForm(List list) {
        this.setTitle("ResSim Network Connectivity");
        this._table.clearColors();
        this._table.deleteCells();
        int n = list.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Element element = (Element)list.get(i);
            if (element == null) continue;
            n2 = this.addElementRow(element, n2);
        }
    }

    int addElementRow(Element element, int n) {
        Object object = new Vector<Object>();
        Object object2 = element.getClass().getName();
        object2 = ((String)object2).substring(((String)object2).lastIndexOf(".") + 1);
        ((Vector)object).addElement(object2);
        ((Vector)object).addElement(new Integer(element.getIndex()));
        ((Vector)object).addElement(element);
        if (element.getFunction() == null) {
            ((Vector)object).addElement("");
        } else {
            object2 = element.getFunction().getClass().getName();
            String string = ((String)object2).substring(((String)object2).lastIndexOf(".") + 1);
            ((Vector)object).addElement(string);
        }
        if (element.getParent() != null) {
            ((Vector)object).add(element.getParent());
        } else {
            ((Vector)object).add("");
        }
        this._table.appendRow(object);
        if (element.getParent() == null) {
            this._table.setRowBackground(n, a);
        } else {
            this._table.setRowBackground(n, b);
        }
        ++n;
        object2 = element.getNodeVector();
        for (int i = 0; i < ((Vector)object2).size(); ++i) {
            object = (RssNode)((Vector)object2).elementAt(i);
            if (object == null) continue;
            n = this.addNodeRow((RssNode)object, element.getNodeDir(i), n);
        }
        Vector vector = element.getElementVector();
        for (int i = 0; i < vector.size(); ++i) {
            element = (Element)vector.elementAt(i);
            if (element == null) continue;
            n = this.addElementRow(element, n);
        }
        return n;
    }

    int addNodeRow(RssNode rssNode, int n, int n2) {
        Vector<Object> vector = new Vector<Object>();
        if (n == 1) {
            vector.add("Inflow Node");
        } else {
            vector.add("Outflow Node");
        }
        vector.add(new Integer(rssNode.getIndex()));
        vector.add(rssNode.getName());
        Element element = rssNode.getUpstreamElement();
        if (element != null) {
            vector.add(new Integer(element.getIndex()));
        } else {
            vector.add("");
        }
        element = rssNode.getDownstreamElement();
        if (element != null) {
            vector.add(new Integer(element.getIndex()));
        } else {
            vector.add("");
        }
        this._table.appendRow(vector);
        return ++n2;
    }

    @Override
    public void exportReport() {
        this._table.exportData();
    }

    public void printReport() {
        this._table.printData();
    }

    @Override
    public void printPreviewReport() {
        this._table.printPreview();
    }

    void closeDialog() {
        this.setVisible(false);
    }

    public void findAction() {
        if (this._findDialog == null) {
            ConnectivityDlg connectivityDlg = this;
            this._findDialog = new FindDialog((Frame)((Object)connectivityDlg), (FindListener)connectivityDlg);
            this._findDialog.pack();
            this._findDialog.setLocationRelativeTo((Component)((Object)this));
            this._findDialog.setWholeWordCheckBoxText("Entire Cell");
        }
        this._findDialog.setVisible(true);
    }

    public void findNextAction() {
        if (this._findDialog == null) {
            this.findAction();
            return;
        }
        this._findDialog.findNext();
    }

    public boolean selectFirstRecord(String string, boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        int n2 = 0;
        if (this._searchLoc == null) {
            this._searchLoc = new ConnectivityDlg$SearchLoc(this, 0, 0);
        } else {
            n = this._searchLoc.b;
            n2 = this._searchLoc.a;
            if (n == this._table.getColumnCount() - 1) {
                ++n2;
                n = 0;
            } else {
                ++n;
            }
        }
        while (n2 < this._table.getRowCount()) {
            while (n < this._table.getColumnCount()) {
                if (this.checkCell(n2, n, string, bl2, bl3)) {
                    return true;
                }
                ++n;
            }
            n = 0;
            ++n2;
        }
        if (bl && this._searchLoc.a != 0 && this._searchLoc.b != 0) {
            for (n2 = 0; n2 < this._searchLoc.a; ++n2) {
                for (n = 0; n < this._table.getColumnCount(); ++n) {
                    if (!this.checkCell(n2, n, string, bl2, bl3)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean selectLastRecord(String string, boolean bl, boolean bl2) {
        int n;
        int n2;
        if (this._searchLoc == null) {
            ConnectivityDlg connectivityDlg = this;
            this._searchLoc = new ConnectivityDlg$SearchLoc(connectivityDlg, connectivityDlg._table.getRowCount() - 1, this._table.getColumnCount() - 1);
            n2 = this._searchLoc.b;
            n = this._searchLoc.a;
        } else {
            n2 = this._searchLoc.b;
            n = this._searchLoc.a;
            if (n2 == 0) {
                --n;
                n2 = this._table.getColumnCount() - 1;
            } else {
                --n2;
            }
            if (n < 0) {
                n = this._table.getRowCount() - 1;
            }
        }
        while (n >= 0) {
            while (n2 >= 0) {
                if (this.checkCell(n, n2, string, bl, bl2)) {
                    return true;
                }
                --n2;
            }
            n2 = this._table.getColumnCount() - 1;
            --n;
        }
        return false;
    }

    private boolean checkCell(int n, int n2, String string, boolean bl, boolean bl2) {
        Object object = this._table.getValueAt(n, n2);
        if (object == null) {
            return false;
        }
        if (this.cellMatches(object.toString(), string, bl, bl2)) {
            this.selectCellMatch(n, n2);
            return true;
        }
        return false;
    }

    private void selectCellMatch(int n, int n2) {
        this._table.updateSelection(n, n2, false, false);
        if (this._searchLoc == null) {
            this._searchLoc = new ConnectivityDlg$SearchLoc(this, n, n2);
        }
        this._searchLoc.a = n;
        this._searchLoc.b = n2;
    }

    private boolean cellMatches(String string, String string2, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return string.equals(string2);
            }
            return string.equalsIgnoreCase(string2);
        }
        if (bl2) {
            return string.indexOf(string2) >= 0;
        }
        return string.toUpperCase().indexOf(string2.toUpperCase()) >= 0;
    }
}

