/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.AbstractSimulationMode;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.SimTrialRunTreeNode;
import hec.clientapp.client.SimulationRunTreeNode;
import hec.clientapp.client.SimulationTreeNode;
import hec.clientapp.model.AbstractSimulation;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.lang.ModelReference;
import hec.lang.WorkspaceNameFactory;
import hec.map.MapGlyph;
import hec.rss.client.CopySimulationDataDialog$1;
import hec.rss.client.CopySimulationDataDialog$2;
import hec.rss.client.CopySimulationDataDialog$3;
import hec.rss.client.CopySimulationDataDialog$4;
import hec.rss.client.CopySimulationDataDialog$5;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;

public class CopySimulationDataDialog
extends RmaJDialog {
    private int _dialogMode;
    private RmaJTextField simulationTxt;
    private RmaJTextField simulationRunTxt;
    private RmaJTextField trialRunTxt;
    private RmaJTextField configurationTxt;
    private ButtonCmdPanel cmdPanel;
    private boolean _canceled = false;
    private AbstractSimulation _simulation;
    private SimulationRun _baseRun;
    private SimulationRun _newRun;
    private JPanel runListPanel;
    private RmaJTable _runTable;
    private Vector _modelOrder = null;
    private Vector _altIdList = null;
    private Vector _labelList = new Vector();
    ColumnGroup _columnGroup;
    private String _simType;
    private JButton _selectAllButton;
    private JButton _unSelectAllButton;

    public CopySimulationDataDialog(Frame frame, boolean bl, String string) {
        super(frame, bl);
        this._simType = string;
        this.buildControls();
        this.addListeners();
    }

    public CopySimulationDataDialog(Frame frame, boolean bl) {
        this(frame, bl, "Simulation");
    }

    private void buildControls() {
        this._dialogMode = 1;
        this.getContentPane().setLayout(new GridBagLayout());
        CopySimulationDataDialog copySimulationDataDialog = this;
        copySimulationDataDialog.setTitle("Save " + copySimulationDataDialog._simType + " Run Model Parameters to Base Directory");
        Object object = new JLabel(this._simType + ":", 4);
        new GridBagConstraints();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)object, gridBagConstraints);
        this.simulationTxt = new RmaJTextField();
        this.simulationTxt.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.simulationTxt, gridBagConstraints);
        object = new JSeparator();
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)object, gridBagConstraints);
        CopySimulationDataDialog copySimulationDataDialog2 = this;
        this._runTable = new CopySimulationDataDialog$1(copySimulationDataDialog2, (Component)((Object)copySimulationDataDialog2), new String[]{"Copy\nData", "Model " + this._simType + " \nAlternative"});
        this._runTable.setTableHeader((JTableHeader)new GroupableTableHeader(this._runTable.getColumnModel()));
        this._runTable.setColumnWidths(new int[]{53, 144, 200, 53});
        this._runTable.setMlHeaderRenderer();
        object = this._runTable.getColumnModel();
        this._columnGroup = new ColumnGroup("");
        this._columnGroup.add((Object)object.getColumn(0));
        this._columnGroup.add((Object)object.getColumn(1));
        this._columnGroup.setBackground(new Color(-16744320));
        this._columnGroup.setForeground(Color.white);
        object = (GroupableTableHeader)this._runTable.getTableHeader();
        object.addColumnGroup(this._columnGroup);
        this._runTable.setCellSelectionEnabled(false);
        this._runTable.setColumnSelectionAllowed(false);
        this._runTable.setRowSelectionAllowed(true);
        this._runTable.setCheckBoxCellEditor(0);
        this._runTable.setColumnEnabled(false, 1);
        this._runTable.setPopupMenuEnabled(false);
        this._runTable.setRowHeight(20);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._runTable.getScrollPane(), gridBagConstraints);
        object = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)object, gridBagConstraints);
        this._selectAllButton = new JButton("Select All");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._selectAllButton, gridBagConstraints);
        this._unSelectAllButton = new JButton("Unselect All");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)object).add((Component)this._unSelectAllButton, gridBagConstraints);
        this.cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this.cmdPanel, gridBagConstraints);
        this.pack();
        this.setLocation();
    }

    private void addListeners() {
        this.cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new CopySimulationDataDialog$2(this));
        this.addWindowListener(new CopySimulationDataDialog$3(this));
        this._selectAllButton.addActionListener(new CopySimulationDataDialog$4(this));
        this._unSelectAllButton.addActionListener(new CopySimulationDataDialog$5(this));
    }

    protected void selectAll(boolean bl) {
        int n = this._runTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            this._runTable.setValueAt((Object)bl, i, 0);
        }
    }

    public void setSimulation(SimulationPeriod simulationPeriod) {
        this._simulation = simulationPeriod;
        if (this._simulation != null) {
            this.simulationTxt.setText(simulationPeriod.getName());
            this._columnGroup.setHeaderValue((Object)simulationPeriod.getName());
        }
        if (!((simulationPeriod = ClientApp.frame().getCurrentMode()) instanceof AbstractSimulationMode)) {
            return;
        }
        this._runTable.deleteCells();
        simulationPeriod = (AbstractSimulationMode)simulationPeriod;
        simulationPeriod = simulationPeriod.getSimulationTree();
        simulationPeriod = (SimulationTreeNode)simulationPeriod.getModel().getRoot();
        DefaultMutableTreeNode cfr_ignored_0 = (DefaultMutableTreeNode)simulationPeriod.getChildAt(0);
        int n = simulationPeriod.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)simulationPeriod.getChildAt(i);
            this.addNode(defaultMutableTreeNode);
        }
    }

    private void addNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!(defaultMutableTreeNode instanceof SimTrialRunTreeNode) && defaultMutableTreeNode instanceof SimulationRunTreeNode) {
            SimulationRunTreeNode simulationRunTreeNode = (SimulationRunTreeNode)defaultMutableTreeNode;
            Object object = simulationRunTreeNode.getSimulationRun();
            Vector<Boolean> vector = new Vector<Boolean>();
            vector.add(Boolean.FALSE);
            vector.add((Boolean)object);
            this._runTable.appendRow(vector);
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                object = (DefaultMutableTreeNode)simulationRunTreeNode.getChildAt(i);
                this.addNode((DefaultMutableTreeNode)object);
            }
        }
    }

    public void setRefreshData() {
        CopySimulationDataDialog copySimulationDataDialog = this;
        copySimulationDataDialog.setTitle("Replace " + copySimulationDataDialog._simType + " Run Model Parameters from Base Directory");
        TableColumnModel tableColumnModel = this._runTable.getColumnModel();
        tableColumnModel.getColumn(0).setHeaderValue("Restore\nData");
        this._runTable.setColumnWidths(new int[]{55, 146, 194, 55});
        this._dialogMode = 2;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    protected boolean saveForm() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this._dialogMode == 1) {
                boolean bl = this.copyData();
                return bl;
            }
            if (this._dialogMode == 2) {
                boolean bl = this.refreshData();
                return bl;
            }
            return false;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean copyData() {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        if (this._simulation == null) {
            return false;
        }
        int[] nArray = this.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            String string = ClientApp.app().getAppType();
            for (int i = 0; i < nArray.length; ++i) {
                SimulationRun simulationRun = (SimulationRun)this._runTable.getCell(nArray[i], 1);
                if (simulationRun == null) {
                    System.out.println("copyData: failed to find SimulationRun in table for row " + nArray[i]);
                    continue;
                }
                if ((simulationRun = simulationRun.getModelAlt(string)) == null) {
                    System.out.println("copyData: failed to find ModelAlt in table for row " + nArray[i]);
                    continue;
                }
                ModelReference modelReference = simulationRun.getModelRef();
                if (modelReference == null) {
                    System.out.println("copyData: failed to find ModelReference from " + String.valueOf(simulationRun));
                    continue;
                }
                String string2 = WorkspaceNameFactory.getWorkspaceName((String)modelReference.wkspName);
                Manager manager = clientWorkspace.openManager(string2, modelReference.className, modelReference.id);
                if (manager == null) {
                    System.out.println("copyData: failed to load Model Manager from ModelReference " + String.valueOf(modelReference));
                    continue;
                }
                Manager manager2 = simulationRun.getManager();
                if (simulationRun == null) {
                    System.out.println("copyData: failed to get Run's Model Manager from Model Reference " + String.valueOf(modelReference));
                    continue;
                }
                if (manager2.isModified()) {
                    this._simulation.saveManager(string2, manager2);
                }
                if (!manager.refreshData(manager2)) {
                    System.out.println("copyData: failed to copy data to base directory");
                }
                this._simulation.unloadManager(string2, simulationRun.getIdentifier());
                clientWorkspace.unloadManager(string2, manager.getIdentifier());
            }
            return true;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "No rows selected to save", "", 2);
        return false;
    }

    private boolean refreshData() {
        ClientApp.Workspace();
        if (this._simulation == null) {
            return false;
        }
        Object object = this.getSelectedRows();
        if (object != null && ((int[])object).length > 0) {
            MapGlyph mapGlyph;
            String string = ClientApp.app().getAppType();
            for (int i = 0; i < ((int[])object).length; ++i) {
                SimulationRun simulationRun = (SimulationRun)this._runTable.getCell(object[i], 1);
                if (simulationRun == null) {
                    System.out.println("refreshData: failed to find SimulationRun in table for row " + object[i]);
                    continue;
                }
                ModelAlt modelAlt = simulationRun.getModelAlt(string);
                if (modelAlt == null) {
                    System.out.println("refreshData:failed to find ModelAlt for Run " + String.valueOf(simulationRun) + " program=" + string);
                    continue;
                }
                boolean bl = this._baseRun instanceof SimulationTrialRun ? modelAlt.refreshDataFile((ManagerProxyListContainer)this._simulation) : modelAlt.refreshDataFile((ManagerProxyListContainer)ClientApp.Workspace());
                if (bl) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "Refresh for " + modelAlt.getName() + " failed", "Refresh Failed", 2);
            }
            if (this._simulation instanceof SimulationPeriod) {
                SimulationPeriod simulationPeriod = (SimulationPeriod)this._simulation;
                simulationPeriod.runExtract(simulationPeriod.getSimulationExtract((ManagerProxyListContainer)ClientApp.Workspace()));
            }
            if ((mapGlyph = ClientApp.frame().getMapPanel().findGlyphOfClass("hec.rss.client.RssSimRunGlyph")) != null) {
                MapGlyph mapGlyph2 = mapGlyph.findGlyphOfClass("hec.rss.client.RssSystemGlyph");
                object = mapGlyph2;
                if (mapGlyph2 != null) {
                    object.reInit();
                }
            }
            ClientApp.frame().getMapPanel().paintMap();
            return true;
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "No rows selected to refresh", "", 2);
        return false;
    }

    private int[] getSelectedRows() {
        int n = this._runTable.getRowCount();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = this._runTable.getCell(i, 0).toString();
            if (!string.equalsIgnoreCase("true")) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public void setSimulationRun(SimulationRun simulationRun) {
        this._baseRun = simulationRun;
        int n = this._runTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (this._runTable.getValueAt(i, 1) != simulationRun) continue;
            this._runTable.setValueAt((Object)Boolean.TRUE, i, 0);
            return;
        }
    }
}

