/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.SimulationPeriod;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.Identifier;
import hec.rss.client.CreateSimulationDialog$1;
import hec.rss.client.CreateSimulationDialog$2;
import hec.rss.client.CreateSimulationDialog$3;
import hec.rss.client.CreateSimulationDialog$4;
import hec.rss.client.CreateSimulationDialog$5;
import hec.rss.client.CreateSimulationDialog$6;
import hec.rss.client.CreateSimulationDialog$SimulationTimePanel;
import hec.rss.model.RssSimRun;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DateTimeGroup;
import rma.swing.RmaInsets;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class CreateSimulationDialog
extends RmaJDialog {
    public static final int NEW_SIMULATION = 0;
    public static final int EDIT_SIMULATION = 1;
    String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    SimulationPeriod m_simulation = null;
    JLabel jLabelStartDate;
    JLabel jLabelStartTime;
    RmaJ24HourTimeField jTFStartTime;
    RmaJCalendarField jTFStartDate;
    DateTimeGroup m_StartDateGroup;
    JLabel jLabelLookbackDate;
    JLabel jLabelLookbackTime;
    RmaJ24HourTimeField jTFLookbackTime;
    RmaJCalendarField jTFLookbackDate;
    DateTimeGroup m_lookbackDateGroup;
    JLabel jLabelEndTime;
    JLabel jLabelEndDate;
    RmaJ24HourTimeField jTFEndTime;
    RmaJCalendarField jTFEndDate;
    DateTimeGroup m_endDateGroup;
    RmaJCheckBox computeUnRegFlowCheck;
    RmaJCheckBox computeResHoldoutsCheck;
    JLabel jLabelName;
    JLabel jLTimeStep;
    RmaJTextField jTFName;
    RmaJComboBox jCBTimeStep;
    RmaJCheckBox runNewExtractCB;
    ButtonCmdPanel cmdPanel;
    RmaJTable alternativeTable;
    private boolean _canceled = false;

    public CreateSimulationDialog(Frame object, boolean bl) {
        super((Frame)object, bl);
        this.setTitle("Simulation Period");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabelName = new JLabel("Name");
        this.jLabelName.setDisplayedMnemonic('N');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.getContentPane().add((Component)this.jLabelName, object);
        this.jTFName = new RmaJTextField();
        this.jLabelName.setLabelFor((Component)this.jTFName);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this.jTFName, object);
        JPanel jPanel = new CreateSimulationDialog$SimulationTimePanel(this, new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Simulation Times"));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)jPanel, object);
        this.jLabelStartDate = new JLabel("Start Date");
        this.jLabelStartDate.setDisplayedMnemonic('S');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this.jLabelStartDate, object);
        this.jTFStartDate = new RmaJCalendarField("DDMMMYYYY", "");
        this.jLabelStartDate.setLabelFor((Component)this.jTFStartDate);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this.jTFStartDate, object);
        this.jLabelStartTime = new JLabel("Time");
        this.jLabelStartTime.setDisplayedMnemonic('i');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this.jLabelStartTime, object);
        this.jTFStartTime = new RmaJ24HourTimeField();
        this.jTFStartTime.setColumns(5);
        this.jLabelStartTime.setLabelFor((Component)this.jTFStartTime);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this.jTFStartTime, object);
        this.m_StartDateGroup = new DateTimeGroup(this.jTFStartDate, this.jTFStartTime);
        this.jLabelLookbackDate = new JLabel("Lookback Date");
        this.jLabelLookbackDate.setDisplayedMnemonic('L');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this.jLabelLookbackDate, object);
        this.jTFLookbackDate = new RmaJCalendarField("DDMMMYYYY", "");
        this.jLabelLookbackDate.setLabelFor((Component)this.jTFLookbackDate);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this.jTFLookbackDate, object);
        this.jLabelLookbackTime = new JLabel("Time");
        this.jLabelLookbackTime.setDisplayedMnemonic('m');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this.jLabelLookbackTime, object);
        this.jTFLookbackTime = new RmaJ24HourTimeField();
        this.jTFLookbackTime.setColumns(5);
        this.jLabelLookbackTime.setLabelFor((Component)this.jTFLookbackTime);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this.jTFLookbackTime, object);
        this.m_lookbackDateGroup = new DateTimeGroup(this.jTFLookbackDate, this.jTFLookbackTime);
        this.jLabelEndDate = new JLabel("End Date");
        this.jLabelEndDate.setDisplayedMnemonic('E');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        jPanel.add((Component)this.jLabelEndDate, object);
        this.jTFEndDate = new RmaJCalendarField("DDMMMYYYY", "");
        this.jLabelEndDate.setLabelFor((Component)this.jTFEndDate);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        jPanel.add((Component)this.jTFEndDate, object);
        this.jLabelEndTime = new JLabel("Time");
        this.jLabelEndTime.setDisplayedMnemonic('e');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        jPanel.add((Component)this.jLabelEndTime, object);
        this.jTFEndTime = new RmaJ24HourTimeField();
        this.jTFEndTime.setColumns(5);
        this.jLabelEndTime.setLabelFor((Component)this.jTFEndTime);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        jPanel.add((Component)this.jTFEndTime, object);
        this.m_endDateGroup = new DateTimeGroup(this.jTFEndDate, this.jTFEndTime);
        this.jLTimeStep = new JLabel("Time Step");
        this.jLTimeStep.setDisplayedMnemonic('T');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 4;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        jPanel.add((Component)this.jLTimeStep, object);
        object = new String[]{"15 Minute", "30 Minute", "1 Hour", "3 Hours", "6 Hours", "12 Hours", "1 Day"};
        this.jCBTimeStep = new RmaJComboBox((Object[])object);
        this.jLTimeStep.setLabelFor((Component)this.jCBTimeStep);
        this.jCBTimeStep.setBorder(UIManager.getBorder("TextField.border"));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 4;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this.jCBTimeStep, object);
        this.runNewExtractCB = new RmaJCheckBox("Run New Extract");
        this.runNewExtractCB.setMnemonic('r');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        ((GridBagConstraints)object).gridy = 4;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this.runNewExtractCB, object);
        object = new JPanel(new GridBagLayout());
        ((JComponent)object).setBorder(new TitledBorder("Default Compute Options"));
        this.computeUnRegFlowCheck = new RmaJCheckBox("Compute Unregulated Flow");
        this.computeUnRegFlowCheck.setMnemonic('u');
        this.computeUnRegFlowCheck.setMargin(RmaInsets.insets((int)0, (int)0, (int)0, (int)0));
        ((Container)object).add((Component)this.computeUnRegFlowCheck, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)0, (int)5, (int)5, (int)5), 0, 0));
        this.computeResHoldoutsCheck = new RmaJCheckBox("Compute Reservoir Holdouts");
        this.computeResHoldoutsCheck.setMnemonic('R');
        this.computeResHoldoutsCheck.setMargin(RmaInsets.insets((int)0, (int)0, (int)0, (int)0));
        ((Container)object).add((Component)this.computeResHoldoutsCheck, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, RmaInsets.insets((int)0, (int)5, (int)5, (int)5), 0, 0));
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Alternatives"));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jPanel, object);
        CreateSimulationDialog createSimulationDialog = this;
        this.alternativeTable = new CreateSimulationDialog$1(createSimulationDialog, (Component)((Object)createSimulationDialog), new String[]{"Select", "Name", "Description"});
        this.alternativeTable.setCheckBoxCellEditor(0);
        this.alternativeTable.setAddRemoveEnabled(false);
        this.alternativeTable.setColumnEnabled(false, 1);
        this.alternativeTable.setColumnEnabled(false, 2);
        this.alternativeTable.setRowHeight(20);
        this.alternativeTable.setColumnWidths(new int[]{57, 171, 153});
        this.alternativeTable.setCellSelectionEnabled(false);
        this.alternativeTable.setColumnSelectionAllowed(false);
        this.alternativeTable.setRowSelectionAllowed(true);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        jPanel.add((Component)this.alternativeTable.getScrollPane(), object);
        this.cmdPanel = new ButtonCmdPanel(12);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 4;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).anchor = 16;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this.cmdPanel, object);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new CreateSimulationDialog$2(this));
        this.addWindowListener(new CreateSimulationDialog$3(this));
        ((JComponent)this.getContentPane()).registerKeyboardAction(new CreateSimulationDialog$4(this), KeyStroke.getKeyStroke(10, 0, true), 1);
        this.jTFStartTime.addFocusListener((FocusListener)new CreateSimulationDialog$5(this));
        this.jTFStartDate.addFocusListener((FocusListener)new CreateSimulationDialog$6(this));
        this.pack();
    }

    public CreateSimulationDialog(Frame frame, boolean bl, String string) {
        this(frame, bl);
        this.setTitle(string);
    }

    public CreateSimulationDialog(Frame frame, String string, boolean bl) {
        this(frame, bl);
        this.setTitle(string);
    }

    public CreateSimulationDialog() {
        this(null, "", false);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            this.setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
        } else {
            this.jTFName.setModified(false);
        }
        super.setVisible(bl);
    }

    public String getStartDate() {
        HecTimeArray hecTimeArray = this.m_StartDateGroup.getDateTime();
        return hecTimeArray.element(0).date(4) + "," + RMAIO.removeChar((String)hecTimeArray.element(0).time(), (char)':');
    }

    public String getEndDate() {
        HecTimeArray hecTimeArray = this.m_endDateGroup.getDateTime();
        return hecTimeArray.element(0).date(4) + "," + RMAIO.removeChar((String)hecTimeArray.element(0).time(), (char)':');
    }

    public String getLookbackDate() {
        HecTimeArray hecTimeArray = this.m_lookbackDateGroup.getDateTime();
        return hecTimeArray.element(0).date(4) + "," + RMAIO.removeChar((String)hecTimeArray.element(0).time(), (char)':');
    }

    public void fillForm(SimulationPeriod simulationPeriod) {
        int n;
        if (simulationPeriod == null) {
            return;
        }
        this.m_simulation = simulationPeriod;
        this.jTFName.setText(simulationPeriod.getName());
        Object object = simulationPeriod.getRunTimeWindow();
        this.m_StartDateGroup.setDateTime(object.getStartTime(), simulationPeriod.getGmtOffset());
        this.m_endDateGroup.setDateTime(object.getEndTime(), simulationPeriod.getGmtOffset());
        this.m_lookbackDateGroup.setDateTime(object.getLookbackTime(), simulationPeriod.getGmtOffset());
        this.alternativeTable.setNumRows(0);
        object = ClientApp.Workspace().getManagerIDList("rss", RssSimRun.class.getName());
        if (object == null || ((Vector)object).size() == 0) {
            return;
        }
        String[] stringArray = simulationPeriod.getAlternatives();
        for (n = 0; n < ((Vector)object).size(); ++n) {
            object2 = (Identifier)((Vector)object).elementAt(n);
            object2 = (RssSimRun)ClientApp.Workspace().openManager("rss", (Identifier)object2);
            if (object2 == null) continue;
            Vector<Object> vector = new Vector<Object>();
            boolean bl = false;
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].equals(object2.getName())) continue;
                bl = true;
                break;
            }
            if (bl) {
                vector.addElement(Boolean.TRUE);
            } else {
                vector.addElement(Boolean.FALSE);
            }
            vector.addElement(object2.getName());
            vector.addElement(((RssSimRun)object2).getDescription());
            this.alternativeTable.appendRow(vector);
        }
        n = simulationPeriod.getTimestep();
        Object object2 = switch (simulationPeriod.getTimeIncrementType()) {
            case 3 -> "DAY";
            case 2 -> n == 1 ? "Hour" : "Hours";
            case 1 -> "Minutes";
            default -> "Hour";
        };
        this.jCBTimeStep.setSelectedItem((Object)(n + " " + (String)object2));
    }

    public void fillForm() {
        this.m_simulation = null;
        Object object = new GregorianCalendar();
        int n = ((Calendar)object).get(1);
        String string = String.valueOf(((Calendar)object).get(2) + 1);
        String string2 = String.valueOf(((Calendar)object).get(5));
        String string3 = String.valueOf(((Calendar)object).get(11));
        object = String.valueOf(((Calendar)object).get(12));
        object = (String)(string3.length() == 1 ? "0" + string3 : string3) + (String)(((String)object).length() == 1 ? "0" + (String)object : object);
        Object object2 = (String)(string.length() == 1 ? "0" + string : string) + "/" + (String)(string2.length() == 1 ? "0" + string2 : string2) + "/" + String.valueOf(n);
        object = (String)object2 + ", " + (String)object;
        object = new HecTime((String)object);
        object2 = object.date(4);
        object = object.time().substring(0, 2) + "00";
        int n2 = ClientApp.Workspace().getGmtOffset() * 60;
        int cfr_ignored_0 = ClientApp.app().getClientTimeZone().getRawOffset() / 60000;
        object = new HecTime((String)object2 + ", " + (String)object).getJavaDate(0);
        object = new HecTime((Date)object, n2);
        this.m_StartDateGroup.setDateTime((HecTime)object, ClientApp.Workspace().getTimeZone());
        this.m_lookbackDateGroup.setDateTime((HecTime)object, ClientApp.Workspace().getTimeZone());
        this.m_endDateGroup.setDateTime((HecTime)object, ClientApp.Workspace().getTimeZone());
        this.m_StartDateGroup.setDisplayTimeZone(ClientApp.app().getClientTimeZone());
        this.m_lookbackDateGroup.setDisplayTimeZone(ClientApp.app().getClientTimeZone());
        this.m_endDateGroup.setDisplayTimeZone(ClientApp.app().getClientTimeZone());
        this.buildSimulationtDir(object.date(4) + ", " + object.time());
        this.alternativeTable.setNumRows(0);
        object = ClientApp.Workspace().getManagerIDList("rss", RssSimRun.class.getName());
        if (object == null || ((Vector)object).size() == 0) {
            return;
        }
        this.alternativeTable.deleteCells();
        this.alternativeTable.setNumRows(((Vector)object).size());
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Object object3 = (Identifier)((Vector)object).elementAt(i);
            object3 = (RssSimRun)ClientApp.Workspace().openManager("rss", (Identifier)object3);
            if (object3 == null) continue;
            this.alternativeTable.setCell((Object)object3.getName(), i, 1);
            this.alternativeTable.setCell((Object)((RssSimRun)object3).getDescription(), i, 2);
        }
    }

    private void buildSimulationtDir(String object) {
        object = new HecTime((String)object);
        String string = Integer.toString(object.isoDate());
        object = Integer.toString(object.isoTime() / 100);
        int n = ((String)object).length();
        for (int i = 0; i < 4 - n; ++i) {
            object = "0" + (String)object;
        }
        StringBuffer stringBuffer = new StringBuffer(string + "-" + (String)object);
        stringBuffer.insert(4, ".");
        stringBuffer.insert(7, ".");
        this.jTFName.setText(String.valueOf(stringBuffer));
    }

    private boolean validSimulationDate(String string) {
        String string2 = "Simulation Date must be the format 'ddMMMCCYY'(14Jan1999)";
        if (string == null || string.equals("") || string.length() != 9) {
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), string2 + "0", "Error", 0);
            return false;
        }
        block3: for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            switch (i) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (Character.isDigit((char)n)) continue block3;
                    JOptionPane.showMessageDialog((Component)ClientApp.frame(), string2 + "1", "Error", 0);
                    return false;
                }
                default: {
                    string = string.substring(2, 5);
                    for (n = 0; n < this.months.length; ++n) {
                        if (!string.equalsIgnoreCase(this.months[n])) continue;
                        return true;
                    }
                    JOptionPane.showMessageDialog((Component)ClientApp.frame(), string2 + "2", "Error", 0);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validSimulationTime(String string, String object) {
        int n;
        String string2 = (String)object + " time must be the format 'hhmm'(1300) and end on the hour";
        object = (String)object + " time must be between 0000 and 2400";
        if (string == null || string.equals("") || string.length() < 4) {
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), string2, "Error", 0);
            return false;
        }
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), string2, "Error", 0);
            return false;
        }
        if (n < 0 || n > 2400) {
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), object, "Error", 0);
            return false;
        }
        if (n % 100 != 0) {
            JOptionPane.showMessageDialog((Component)ClientApp.frame(), string2, "Error", 0);
            return false;
        }
        return true;
    }

    private void enterPressed() {
        JButton jButton = this.getRootPane().getDefaultButton();
        if (jButton == null) {
            return;
        }
        jButton.doClick();
    }

    public void jBOK_actionPerformed() {
        if (this.validForm()) {
            this._canceled = false;
            this.setVisible(false);
        }
    }

    public void jBCancel_actionPerformed() {
        this._canceled = true;
        this.setVisible(false);
    }

    private boolean validForm() {
        if (this.m_simulation == null) {
            String string = this.jTFName.getText();
            if (string == null || string.equals("")) {
                RMAIO.postError((Component)((Object)this), (String)"Invalid Simulation Name");
                return false;
            }
            string = ClientApp.Workspace().getWorkspacePath().concat("/").concat(ClientApp.app().getAppType()).concat("/").concat(RMAIO.userNameToFileName((String)this.getSimulationDirectory()));
            Identifier identifier = new Identifier(string);
            new Identifier(string)._directory = true;
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            try {
                if (rmiFileManager.fileExists(identifier)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Directory Structure\n\n" + string + "\n\nfor Simulation " + this.getName() + " already exists.\n\nUse Simulation Open if you want use this Simulation date/time again.", "New Simulation Error", 2);
                    return false;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("validForm: RMI Error checking existance of directory " + String.valueOf(identifier));
            }
        }
        return true;
    }

    private String getSimulationDirectory() {
        return this.jTFName.getText();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public String getName() {
        return this.jTFName.getText();
    }

    public int getTimestep() {
        int n;
        String string = (String)this.jCBTimeStep.getSelectedItem();
        int n2 = 1;
        if (string != null && (n = string.indexOf(32)) >= 0) {
            string = string.substring(0, n);
            n2 = RMAIO.parseInt((String)string, (int)1);
        }
        return n2;
    }

    public int getTimeStepType() {
        int n;
        String string = (String)this.jCBTimeStep.getSelectedItem();
        int n2 = 2;
        if (string != null && (n = string.indexOf(32)) >= 0) {
            if ((string = string.substring(n).trim()).equalsIgnoreCase("Hour")) {
                n2 = 2;
            } else if (string.equalsIgnoreCase("Hours")) {
                n2 = 2;
            } else if (string.equalsIgnoreCase("Minute")) {
                n2 = 1;
            } else if (string.equalsIgnoreCase("Minutes")) {
                n2 = 1;
            } else if (string.equalsIgnoreCase("Day")) {
                n2 = 3;
            } else if (string.equalsIgnoreCase("Second")) {
                n2 = 0;
            }
        }
        return n2;
    }

    public boolean computeReservoirHoldouts() {
        return this.computeResHoldoutsCheck.isSelected();
    }

    public boolean computeUnRegulatedFlow() {
        return this.computeUnRegFlowCheck.isSelected();
    }

    public String[] getSelectedRuns() {
        Vector vector = this.alternativeTable.getCells();
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (Vector)vector.elementAt(i);
            Object object2 = ((Vector)object).elementAt(0);
            if (!((String)(object2 = object2.toString())).equalsIgnoreCase("true") || !((object2 = ((Vector)object).elementAt(1)) instanceof String)) continue;
            object = (String)object2;
            vector2.addElement(object);
            System.out.println("selected alt is " + (String)object);
        }
        vector2.trimToSize();
        Object[] objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public void setEditMode(int n) {
        if (n != 0 && n != 1) {
            System.out.println("Invalide Edit Mode (" + n + ") Defaulting to NEW SIMULATION MODE");
            n = 0;
        }
        if (n == 0) {
            this.runNewExtractCB.setSelected(true);
            this.runNewExtractCB.setEnabled(false);
            return;
        }
        this.runNewExtractCB.setSelected(false);
        this.runNewExtractCB.setEnabled(true);
    }

    public boolean runSimulationExtract() {
        return this.runNewExtractCB.isSelected();
    }
}

