/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.DefaultDownstreamOptionsEditor$1;
import hec.rss.client.DefaultDownstreamOptionsEditor$2;
import hec.rss.client.DefaultDownstreamOptionsEditor$3;
import hec.rss.client.DefaultDownstreamOptionsEditor$4;
import hec.rss.client.DefaultDownstreamOptionsEditor$5;
import hec.rss.model.DownstreamOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;

public class DefaultDownstreamOptionsEditor
extends RmaJDialog {
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private JPanel _attenuationPanel;
    private JRadioButton _option1Radio;
    private RmaJIntegerField _lagSpaceMaxIterations;
    private RmaJDecimalField _lagSpaceAbsFlowTol;
    private RmaJDecimalField _lagSpaceFractionLimit;
    private JRadioButton _option2Radio;
    private RmaJIntegerField _predictorMaxIterations;
    private RmaJDecimalField _predictionCorrectionFactor;
    private JRadioButton _option4Radio;
    private JPanel _rocPanel;
    private RmaJCheckBox _considerROCCheckbox;
    private RmaJIntegerField _rocMaxLookahead;
    private JPanel _rtwPanel;
    private RmaJCheckBox _considerRTWCheckbox;
    private RmaJDecimalField _rtwMultiplier;
    private RmaJButton _resetDefaultsButton;
    private DownstreamOptions _defaultOps;
    private RmaJDecimalField _weightModelField;
    private RmaJDecimalField _weightRegField;
    private RmaJDecimalField _weightLimField;
    private RmaJDecimalField _weightZeroInField;

    public DefaultDownstreamOptionsEditor(RmaJDialog rmaJDialog, DownstreamOptions downstreamOptions, boolean bl) {
        super((Dialog)rmaJDialog, true);
        this._defaultOps = downstreamOptions;
        this.buildControls();
        this.addListeners();
        this.fill();
        this.pack();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Global Downstream Options");
        Serializable serializable = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)serializable, gridBagConstraints);
        this._attenuationPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        this._attenuationPanel.setBorder(new TitledBorder("Correct for Attenuation"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._attenuationPanel, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._attenuationPanel.add((Component)serializable, gridBagConstraints);
        JLabel jLabel = new JLabel("Model Weight");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._weightModelField = new RmaJDecimalField();
        this._weightModelField.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        jLabel.setLabelFor((Component)this._weightModelField);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._weightModelField, gridBagConstraints);
        jLabel = new JLabel("Regularization Weight");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._weightRegField = new RmaJDecimalField();
        this._weightRegField.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        jLabel.setLabelFor((Component)this._weightRegField);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._weightRegField, gridBagConstraints);
        jLabel = new JLabel("Min/Max Constraint Weight");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._weightLimField = new RmaJDecimalField();
        this._weightLimField.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        jLabel.setLabelFor((Component)this._weightLimField);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._weightLimField, gridBagConstraints);
        jLabel = new JLabel("Inflow >=0 Constraint Weight");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._weightZeroInField = new RmaJDecimalField();
        this._weightZeroInField.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        jLabel.setLabelFor((Component)this._weightZeroInField);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._weightZeroInField, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._attenuationPanel.add((Component)serializable, gridBagConstraints);
        this._option1Radio = new JRadioButton("Option 1 (Lagged Space Adjustment)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ((Container)serializable).add(this._option1Radio, gridBagConstraints);
        jLabel = new JLabel("   Max Iterations:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._lagSpaceMaxIterations = new RmaJIntegerField();
        jLabel.setLabelFor((Component)this._lagSpaceMaxIterations);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        gridBagConstraints.ipadx = 100;
        ((Container)serializable).add((Component)this._lagSpaceMaxIterations, gridBagConstraints);
        jLabel = new RmaJLabel("   Absolute Flow Tolerance (%S):");
        jLabel.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._lagSpaceAbsFlowTol = new RmaJDecimalField();
        this._lagSpaceAbsFlowTol.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        jLabel.setLabelFor((Component)this._lagSpaceAbsFlowTol);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._lagSpaceAbsFlowTol, gridBagConstraints);
        jLabel = new JLabel("   Tolerance Fraction of Limit (%):");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._lagSpaceFractionLimit = new RmaJDecimalField();
        this._lagSpaceFractionLimit.setMinValue(0.0);
        this._lagSpaceFractionLimit.setMaxValue(100.0);
        jLabel.setLabelFor((Component)this._lagSpaceFractionLimit);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._lagSpaceFractionLimit, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._attenuationPanel.add((Component)serializable, gridBagConstraints);
        this._option2Radio = new JRadioButton("Option 2 (Predictor Corrector)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._option2Radio, gridBagConstraints);
        jLabel = new JLabel("   Max Iterations");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._predictorMaxIterations = new RmaJIntegerField();
        jLabel.setLabelFor((Component)this._predictorMaxIterations);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._predictorMaxIterations, gridBagConstraints);
        jLabel = new JLabel("   Correction Factor (0.0-1.0):");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._predictionCorrectionFactor = new RmaJDecimalField();
        this._predictionCorrectionFactor.setMaxValue(1.0);
        this._predictionCorrectionFactor.setMinValue(0.0);
        jLabel.setLabelFor((Component)this._predictionCorrectionFactor);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._predictionCorrectionFactor, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._attenuationPanel.add((Component)serializable, gridBagConstraints);
        this._option4Radio = new JRadioButton("Option 3 (PEST Correction)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        if (Boolean.getBoolean("ResSim.HasDSPestOption")) {
            ((Container)serializable).add(this._option4Radio, gridBagConstraints);
        }
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._option1Radio);
        ((ButtonGroup)serializable).add(this._option2Radio);
        ((ButtonGroup)serializable).add(this._option4Radio);
        this._rocPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        this._rocPanel.setBorder(new TitledBorder("Rate of Change Constraints"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._rocPanel, gridBagConstraints);
        this._considerROCCheckbox = new RmaJCheckBox("Consider ROC Constraints");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rocPanel.add((Component)this._considerROCCheckbox, gridBagConstraints);
        jLabel = new JLabel("Max Lookahead for ROC (Number of Time Steps):");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rocPanel.add((Component)jLabel, gridBagConstraints);
        this._rocMaxLookahead = new RmaJIntegerField();
        jLabel.setLabelFor((Component)this._rocMaxLookahead);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._rocPanel.add((Component)this._rocMaxLookahead, gridBagConstraints);
        this._rtwPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        this._rtwPanel.setBorder(new TitledBorder("Routing Time Window"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._rtwPanel, gridBagConstraints);
        this._considerRTWCheckbox = new RmaJCheckBox("Limit look ahead time window for downstream control");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rtwPanel.add((Component)this._considerRTWCheckbox, gridBagConstraints);
        jLabel = new JLabel("<html>Multiplier on estimated routing lag:<br>(look ahead=(1+multiplier)*routing lag):</html>");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rtwPanel.add((Component)jLabel, gridBagConstraints);
        this._rtwMultiplier = new RmaJDecimalField();
        this._rtwMultiplier.setMinValue(0.0);
        jLabel.setLabelFor((Component)this._rtwMultiplier);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._rtwPanel.add((Component)this._rtwMultiplier, gridBagConstraints);
        this._resetDefaultsButton = new RmaJButton("Reset Parameters");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.getContentPane().add((Component)this._resetDefaultsButton, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
    }

    private void addListeners() {
        this._considerROCCheckbox.addActionListener((ActionListener)new DefaultDownstreamOptionsEditor$1(this));
        this._considerRTWCheckbox.addActionListener((ActionListener)new DefaultDownstreamOptionsEditor$2(this));
        this._resetDefaultsButton.addActionListener((ActionListener)new DefaultDownstreamOptionsEditor$3(this));
        DefaultDownstreamOptionsEditor$4 defaultDownstreamOptionsEditor$4 = new DefaultDownstreamOptionsEditor$4(this);
        this._option1Radio.addActionListener(defaultDownstreamOptionsEditor$4);
        this._option2Radio.addActionListener(defaultDownstreamOptionsEditor$4);
        this._option4Radio.addActionListener(defaultDownstreamOptionsEditor$4);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new DefaultDownstreamOptionsEditor$5(this));
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private void considerROCCheckAction() {
        if (this._considerROCCheckbox.isSelected()) {
            this._rocMaxLookahead.setEnabled(true);
            return;
        }
        this._rocMaxLookahead.setEnabled(false);
    }

    private void considerRTWCheckAction() {
        if (this._considerRTWCheckbox.isSelected()) {
            this._rtwMultiplier.setEnabled(true);
            return;
        }
        this._rtwMultiplier.setEnabled(false);
    }

    private void radioOptionAction() {
        if (this._option1Radio.isSelected()) {
            this._lagSpaceAbsFlowTol.setEnabled(true);
            this._lagSpaceFractionLimit.setEnabled(true);
            this._lagSpaceMaxIterations.setEnabled(true);
            this._predictionCorrectionFactor.setEnabled(false);
            this._predictorMaxIterations.setEnabled(false);
            return;
        }
        if (this._option2Radio.isSelected()) {
            this._lagSpaceAbsFlowTol.setEnabled(false);
            this._lagSpaceFractionLimit.setEnabled(false);
            this._lagSpaceMaxIterations.setEnabled(false);
            this._predictionCorrectionFactor.setEnabled(true);
            this._predictorMaxIterations.setEnabled(true);
            return;
        }
        this._lagSpaceAbsFlowTol.setEnabled(false);
        this._lagSpaceFractionLimit.setEnabled(false);
        this._lagSpaceMaxIterations.setEnabled(false);
        this._predictionCorrectionFactor.setEnabled(false);
        this._predictorMaxIterations.setEnabled(false);
    }

    protected void resetStaticDefaultsAction() {
        this._defaultOps.resetDefaults();
        this.fill();
    }

    private void saveForm() {
        this._defaultOps.setWeightLim(this._weightLimField.getValue());
        this._defaultOps.setWeightModel(this._weightModelField.getValue());
        this._defaultOps.setWeightReg(this._weightRegField.getValue());
        this._defaultOps.setWeightZeroIn(this._weightZeroInField.getValue());
        this._defaultOps.setLagFlowTolerance(this._lagSpaceAbsFlowTol.getParamValue().convertToUnitSystem(AppDaddy.getApp().getClientUnitSystem()));
        if (this._lagSpaceFractionLimit.getValue() > 0.0) {
            this._defaultOps.setLagFractionLimit(this._lagSpaceFractionLimit.getValue() / 100.0);
        } else {
            this._defaultOps.setLagFractionLimit(this._lagSpaceFractionLimit.getValue());
        }
        this._defaultOps.setLagMaxIterations(this._lagSpaceMaxIterations.getValue());
        this._defaultOps.setPredictorCorrectionFactor(this._predictionCorrectionFactor.getValue());
        this._defaultOps.setPredictorMaxIterations(this._predictorMaxIterations.getValue());
        this._defaultOps.setMaxLookaheadROC(this._rocMaxLookahead.getValue());
        this._defaultOps.setMultiplierRTW(this._rtwMultiplier.getValue());
        if (this._option1Radio.isSelected()) {
            this._defaultOps.setSpaceAdjType(1);
        } else if (this._option2Radio.isSelected()) {
            this._defaultOps.setSpaceAdjType(2);
        } else if (this._option4Radio.isSelected()) {
            this._defaultOps.setSpaceAdjType(3);
        } else {
            this._defaultOps.setSpaceAdjType(0);
        }
        if (this._considerROCCheckbox.isSelected()) {
            this._defaultOps.setUseConsiderROC(true);
        } else {
            this._defaultOps.setUseConsiderROC(false);
        }
        if (this._considerRTWCheckbox.isSelected()) {
            this._defaultOps.setUseConsiderRTW(true);
            return;
        }
        this._defaultOps.setUseConsiderRTW(false);
    }

    public void fill() {
        this._weightLimField.setValue(this._defaultOps.getWeightLim());
        this._weightModelField.setValue(this._defaultOps.getWeightModel());
        this._weightRegField.setValue(this._defaultOps.getWeightReg());
        this._weightZeroInField.setValue(this._defaultOps.getWeightZeroIn());
        double d = this._defaultOps.getLagFlowTolerance();
        ClientApp.app();
        this._lagSpaceAbsFlowTol.setValue(new ParamDouble(d, Parameter.PARAMID_FLOW, ClientApp.Workspace().getUnitSystem()));
        this._lagSpaceFractionLimit.setValue(this._defaultOps.getLagFractionLimit() * 100.0);
        this._lagSpaceMaxIterations.setValue(this._defaultOps.getLagMaxIterations());
        this._predictionCorrectionFactor.setValue(this._defaultOps.getPredictorCorrectionFactor());
        this._predictorMaxIterations.setValue(this._defaultOps.getPredictorMaxIterations());
        this._rocMaxLookahead.setValue(this._defaultOps.getMaxLookaheadROC());
        this._rtwMultiplier.setValue(this._defaultOps.getMultiplierRTW());
        if (this._defaultOps.getUseLaggedSpaceAdj()) {
            this._option1Radio.setSelected(true);
        } else if (this._defaultOps.getUsePredictor()) {
            this._option2Radio.setSelected(true);
        } else if (this._defaultOps.getUsePESTAdj()) {
            this._option4Radio.setSelected(true);
        }
        if (this._defaultOps.getUseConsiderROC()) {
            this._considerROCCheckbox.setSelected(true);
        } else {
            this._considerROCCheckbox.setSelected(false);
        }
        if (this._defaultOps.getUseConsiderRTW()) {
            this._considerRTWCheckbox.setSelected(true);
        } else {
            this._considerRTWCheckbox.setSelected(false);
        }
        this.radioOptionAction();
        this.considerROCCheckAction();
        this.considerRTWCheckAction();
    }
}

