/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.lang.NamedType;
import hec.rss.client.DeleteSelectedElementsDialog$1;
import hec.rss.model.Element;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class DeleteSelectedElementsDialog
extends RmaJDialog {
    private RmaJTable _elementTable;
    private ButtonCmdPanel _cmdPanel;
    private JLabel _cntLabel;
    private boolean _canceled;
    private String[] _tableTooltips;

    public DeleteSelectedElementsDialog(Frame frame, boolean bl) {
        super(frame, "Delete Network Elements", bl);
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setSize(400, 400);
        this.setLocationRelativeTo(frame);
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        Object object = new String[]{"Delete", "Element Name", "Element Type"};
        DeleteSelectedElementsDialog deleteSelectedElementsDialog = this;
        this._elementTable = new DeleteSelectedElementsDialog$1(deleteSelectedElementsDialog, (Component)((Object)deleteSelectedElementsDialog), (Object[])object);
        this._elementTable.setCheckBoxCellEditor(0);
        this._elementTable.setColumnWidths(new int[]{60, 160, 160});
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.INSETS5505;
        DeleteSelectedElementsDialog deleteSelectedElementsDialog2 = this;
        deleteSelectedElementsDialog2.add(deleteSelectedElementsDialog2._elementTable.getScrollPane(), object);
        JLabel jLabel = new JLabel("<html><b>Confirm deletion of selected Network Elements</b></html>");
        object.gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 10;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5505;
        this.add(jLabel, object);
        this._cntLabel = new JLabel();
        object.gridx = -1;
        object.gridy = -1;
        object.gridwidth = 1;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5555;
        DeleteSelectedElementsDialog deleteSelectedElementsDialog3 = this;
        deleteSelectedElementsDialog3.add(deleteSelectedElementsDialog3._cntLabel, object);
        this._cmdPanel = new ButtonCmdPanel(12);
        object.gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5555;
        DeleteSelectedElementsDialog deleteSelectedElementsDialog4 = this;
        deleteSelectedElementsDialog4.add((Component)deleteSelectedElementsDialog4._cmdPanel, object);
    }

    private void addListeners() {
        this._cmdPanel.addCmdPanelListener(actionEvent -> this.handleButtonCmdActions(actionEvent));
        this._elementTable.addTableModelListener(tableModelEvent -> this.tableModelChanged());
    }

    private void tableModelChanged() {
        this.updateCntLabel();
    }

    private void updateCntLabel() {
        List<Element> list = this.getSelectedElements();
        this._cntLabel.setText(String.valueOf(list.size() + " elements selected"));
    }

    private void handleButtonCmdActions(ActionEvent actionEvent) {
        switch (actionEvent.getID()) {
            case 8: {
                this._canceled = false;
                this.setVisible(false);
                return;
            }
            case 4: {
                this._canceled = true;
                this.setVisible(false);
            }
        }
    }

    public void fillForm(NamedType[] namedTypeArray, String[] stringArray) {
        this._elementTable.deleteCells();
        if (namedTypeArray == null) {
            return;
        }
        for (int i = 0; i < namedTypeArray.length; ++i) {
            NamedType namedType = namedTypeArray[i];
            if (!(namedType instanceof Element)) continue;
            namedType = (Element)namedType;
            Vector<Object> vector = new Vector<Object>(3);
            boolean bl = this.isRowEnabled(i, stringArray);
            vector.add(bl);
            vector.add(namedType);
            vector.add(namedType.getElementType());
            this._elementTable.appendRow(vector);
            this._elementTable.setCellEnabled(bl, i, 0);
        }
        this._tableTooltips = stringArray;
    }

    private boolean isRowEnabled(int n, String[] stringArray) {
        if (stringArray == null || stringArray.length <= n) {
            return true;
        }
        return stringArray[n] == null;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public List<Element> getSelectedElements() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = this._elementTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = this._elementTable.getValueAt(i, 0);
            if (object == null || !RMAIO.parseBoolean((String)object.toString(), (boolean)false)) continue;
            arrayList.add((Element)this._elementTable.getValueAt(i, 1));
        }
        return arrayList;
    }
}

