/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.event.ModifiableListener;
import hec.rss.model.RssSystem;
import hec.rss.model.dependencies.Dependency;
import hec.rss.model.dependencies.Dependency$DependencyType;
import hec.rss.model.dependencies.LaggedValRef;
import hec.rss.model.dependencies.PerAveRef;
import hec.rss.model.dependencies.TimeRef;
import hec.rss.model.dependencies.TimeRefUtil;
import hec.rss.model.dependencies.TsValRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import rma.lang.Modifiable;
import rma.swing.table.AbstractRmaTableModel;

public class DependencyTableModel
extends AbstractRmaTableModel
implements Modifiable {
    private static final Logger b = Logger.getLogger(DependencyTableModel.class.getName());
    public static final String TYPE = "Type";
    public static final String NAME = "Name/Location";
    public static final String PARAMETER = "Parameter";
    public static final String ACTIVE = "Active";
    public static final String OUTPUT = "I/O";
    public static final String FUNCTION = "Function";
    public static final String OFFSET = "Offset";
    public static final String PERIOD = "Period";
    public static final String TIME = "Time Option";
    private static final String[] c = new String[]{"Type", "Name/Location", "Parameter", "Active", "I/O", "Function", "Offset", "Period"};
    public static final String TYPE_TT = "Type tooltip";
    public static final String NAME_TT = "Name/Location tooltip";
    public static final String PARAMETER_TT = "Parameter tooltip";
    public static final String ACTIVE_TT = "Active tooltip";
    public static final String OUTPUT_TT = "I/O tooltip";
    public static final String FUNCTION_TT = "";
    public static final String OFFSET_TT = "Number of hours forward (+) or back (-) from the current timestep (0)";
    public static final String PERIOD_TT = "Number of hours back from the Offset";
    private static final String[] d = new String[]{"Type tooltip", "Name/Location tooltip", "Parameter tooltip", "Active tooltip", "I/O tooltip", "", "Number of hours forward (+) or back (-) from the current timestep (0)", "Number of hours back from the Offset"};
    private RssSystem _system;
    private final boolean _isUser;
    private boolean _modified = false;
    protected transient boolean a = false;
    private transient List<ModifiableListener> e = new ArrayList<ModifiableListener>();
    private final List<Dependency> _dependencies = new ArrayList<Dependency>();
    private final Map<String, Map<String, Set<Dependency>>> _typeNameDepMap = new LinkedHashMap<String, Map<String, Set<Dependency>>>();

    public DependencyTableModel(RssSystem rssSystem) {
        this(rssSystem, false);
    }

    public DependencyTableModel(RssSystem rssSystem, boolean bl) {
        this.m_columnNames = c;
        this._system = rssSystem;
        this._isUser = bl;
    }

    public static String[] a() {
        return (String[])d.clone();
    }

    public void setDependencies(Collection<Dependency> collection) {
        this._dependencies.clear();
        if (collection != null) {
            this._dependencies.addAll(collection);
        }
        this.setModified(true);
        this.fireTableDataChanged();
    }

    public Collection<Dependency> getDependencies() {
        return this._dependencies;
    }

    public void addChoices(Collection<Dependency> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Dependency dependency = (Dependency)object.next();
            Object object2 = this.getType(dependency);
            object2 = this._typeNameDepMap.computeIfAbsent((String)object2, string -> new LinkedHashMap());
            String string2 = this.getName(dependency);
            object2 = object2.computeIfAbsent(string2, string -> new LinkedHashSet());
            object2.add(dependency);
        }
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n < this._dependencies.size()) {
            String string;
            Object object2 = this._dependencies.get(n);
            switch (string = this.getColumnName(n2)) {
                case "Type": {
                    object = this.getType((Dependency)object2);
                    break;
                }
                case "Name/Location": {
                    object = this.getName((Dependency)object2);
                    break;
                }
                case "Parameter": {
                    object = this.getParameter((Dependency)object2);
                    break;
                }
                case "Active": {
                    object = ((Dependency)object2).f();
                    break;
                }
                case "I/O": {
                    object = ((Dependency)object2).b();
                    break;
                }
                case "Function": {
                    object2 = this.getTimeRef((Dependency)object2);
                    if (object2 == null) break;
                    object = object2.getName();
                    break;
                }
                case "Offset": {
                    object2 = this.getTimeRef((Dependency)object2);
                    boolean bl = this.shouldShowOffset((TimeRef)object2);
                    if (!bl) break;
                    object = object2.getOffset();
                    break;
                }
                case "Period": {
                    object2 = this.getTimeRef((Dependency)object2);
                    boolean bl = this.shouldShowPeriod((TimeRef)object2);
                    if (!bl) break;
                    object = object2.getPeriod();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + string);
                }
            }
        }
        return object;
    }

    private String getParameter(Dependency cloneable) {
        String string = FUNCTION_TT;
        if ((cloneable = ((Dependency)cloneable).c()) != null) {
            string = ((TsValRef)cloneable).a(this._system);
        }
        return string;
    }

    private String getName(Dependency object) {
        String string = FUNCTION_TT;
        if ((object = ((Dependency)object).c()) != null && (object = ((TsValRef)object).c()) != null) {
            string = object.getName();
        }
        return string;
    }

    private String getType(Dependency object) {
        String string = null;
        if ((object = ((Dependency)object).c()) != null) {
            object = ((TsValRef)object).c();
            string = object.getType();
        }
        return string;
    }

    private boolean shouldShowPeriod(TimeRef timeRef) {
        boolean bl = false;
        if (timeRef instanceof PerAveRef) {
            bl = true;
        }
        return bl;
    }

    private boolean shouldShowOffset(TimeRef timeRef) {
        boolean bl = false;
        if (timeRef != null) {
            if (timeRef instanceof LaggedValRef) {
                bl = true;
            } else if (timeRef instanceof PerAveRef) {
                bl = true;
            }
        }
        return bl;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= 0 && n < this._dependencies.size()) {
            String string;
            Dependency dependency = this._dependencies.get(n);
            switch (string = this.getColumnName(n2)) {
                case "Type": {
                    this.setType(dependency, DependencyTableModel.b(object));
                    int n3 = n;
                    this.fireTableRowsUpdated(n3, n3);
                    return;
                }
                case "Name/Location": {
                    this.setName(dependency, DependencyTableModel.b(object));
                    int n4 = n;
                    this.fireTableRowsUpdated(n4, n4);
                    return;
                }
                case "Active": {
                    this.setActive(dependency, object);
                    this.fireTableCellUpdated(n, n2);
                    return;
                }
                case "I/O": {
                    object = DependencyTableModel.a(object);
                    this.setOutput(dependency, (Dependency$DependencyType)((Object)object));
                    int n5 = n;
                    this.fireTableRowsUpdated(n5, n5);
                    return;
                }
                case "Function": {
                    this.setFunction(dependency, object);
                    int n6 = n;
                    this.fireTableRowsUpdated(n6, n6);
                    return;
                }
                case "Offset": {
                    try {
                        object = this.getInteger(object);
                        this.setOffset(dependency, (Integer)object);
                        this.fireTableCellUpdated(n, n2);
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                case "Period": {
                    try {
                        object = this.getInteger(object);
                        this.setPeriod(dependency, (Integer)object);
                        this.fireTableCellUpdated(n, n2);
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
            }
            b.fine("setValueAt:Unexpected col: " + string);
        }
    }

    private void setType(Dependency dependency, String object) {
        if (dependency != null && object != null && !((String)object).isEmpty()) {
            Object object2 = dependency.c();
            object2 = ((TsValRef)object2).b();
            String string = this.getName(dependency);
            String string2 = null;
            List<String> list = this.getNameChoices((String)object);
            if (list != null && !list.isEmpty()) {
                string2 = list.contains(string) ? string : list.get(0);
            }
            object = this._typeNameDepMap.get(object);
            if ((object = object.get(string2)) != null && !object.isEmpty()) {
                object = object.iterator().next();
                try {
                    object = ((Dependency)object).c().a();
                    ((TsValRef)object).a((TimeRef)object2);
                    dependency.a((TsValRef)object);
                    return;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    object = cloneNotSupportedException;
                    cloneNotSupportedException.printStackTrace();
                }
            }
        }
    }

    private void setName(Dependency dependency, String object) {
        if (dependency != null && object != null && !((String)object).isEmpty()) {
            Object object2 = dependency.c();
            object2 = ((TsValRef)object2).b();
            String string = this.getType(dependency);
            Map<String, Set<Dependency>> map = this._typeNameDepMap.get(string);
            if (map.containsKey(object)) {
                b.log(Level.FINE, "Name:{0} does not appear to be a valid selection for type:{1} valid choices are:{2}", new Object[]{object, string, map.keySet()});
            }
            if ((object = map.get(object)) != null && !object.isEmpty()) {
                object = (Dependency)object.iterator().next();
                try {
                    object = ((Dependency)object).c().a();
                    ((TsValRef)object).a((TimeRef)object2);
                    dependency.a((TsValRef)object);
                    return;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    object = cloneNotSupportedException;
                    cloneNotSupportedException.printStackTrace();
                }
            }
        }
    }

    private void setOutput(Dependency dependency, Dependency$DependencyType dependency$DependencyType) {
        Dependency$DependencyType dependency$DependencyType2;
        if (dependency != null && (dependency$DependencyType2 = dependency.b()) != dependency$DependencyType) {
            if (dependency$DependencyType == Dependency$DependencyType.OUTPUT) {
                this.setFunction(dependency, "current");
            }
            dependency.a(dependency$DependencyType);
            this.setModified(true);
        }
    }

    public static Dependency$DependencyType a(Object object) {
        Dependency$DependencyType dependency$DependencyType = Dependency$DependencyType.INPUT;
        if (object instanceof Dependency$DependencyType) {
            dependency$DependencyType = (Dependency$DependencyType)((Object)object);
        } else if (object != null) {
            try {
                dependency$DependencyType = Dependency$DependencyType.valueOf(object.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                b.info("Could not parse:" + String.valueOf(object) + " as DependencyType.");
            }
        }
        return dependency$DependencyType;
    }

    private TsValRef getTsValRef(Dependency dependency) {
        TsValRef tsValRef = null;
        if (dependency != null) {
            tsValRef = dependency.c();
        }
        return tsValRef;
    }

    private TimeRef getTimeRef(Dependency cloneable) {
        TimeRef timeRef = null;
        if ((cloneable = this.getTsValRef((Dependency)cloneable)) != null) {
            timeRef = ((TsValRef)cloneable).b();
        }
        return timeRef;
    }

    private void setPeriod(Dependency object, Integer n) {
        if ((object = this.getTimeRef((Dependency)object)) instanceof PerAveRef) {
            object = (PerAveRef)object;
            ((PerAveRef)object).a(n);
            this.setModified(true);
        }
    }

    private void setOffset(Dependency object, Integer n) {
        if ((object = this.getTimeRef((Dependency)object)) != null) {
            if (object instanceof PerAveRef) {
                object = (PerAveRef)object;
                ((PerAveRef)object).b(n);
                this.setModified(true);
                return;
            }
            if (object instanceof LaggedValRef) {
                object = (LaggedValRef)object;
                ((LaggedValRef)object).a(n);
                this.setModified(true);
            }
        }
    }

    private void setFunction(Dependency cloneable, Object object) {
        cloneable = this.getTsValRef((Dependency)cloneable);
        if (object != null && cloneable != null) {
            object = (String)object;
            object = TimeRefUtil.a((String)object);
            ((TsValRef)cloneable).a((TimeRef)object);
            this.setModified(true);
        }
    }

    private Integer getInteger(Object object) throws NumberFormatException {
        object = object instanceof Integer ? (Integer)object : Integer.valueOf(Integer.parseInt(object.toString().trim()));
        return object;
    }

    private void setActive(Dependency dependency, Object object) {
        if (object instanceof Boolean) {
            object = (Boolean)object;
            dependency.a((Boolean)object);
            this.setModified(true);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = super.isCellEditable(n, n2);
        if (n >= 0 && n < this._dependencies.size()) {
            String string;
            Dependency dependency = this._dependencies.get(n);
            bl = this._isUser;
            switch (string = this.getColumnName(n2)) {
                case "Type": {
                    break;
                }
                case "Name/Location": {
                    break;
                }
                case "Parameter": {
                    bl = false;
                    break;
                }
                case "Active": {
                    bl = true;
                    break;
                }
                case "I/O": {
                    break;
                }
                case "Function": {
                    if (!Dependency$DependencyType.OUTPUT.equals((Object)dependency.b())) break;
                    bl = false;
                    break;
                }
                case "Offset": {
                    bl = this._isUser && TimeRefUtil.a(this.getTimeRef(dependency));
                    break;
                }
                case "Period": {
                    bl = this._isUser && TimeRefUtil.b(this.getTimeRef(dependency));
                    break;
                }
                default: {
                    b.fine("isCellEditable: Unexpected col: " + string);
                }
            }
        }
        return bl;
    }

    public int getColumnCount() {
        return c.length;
    }

    public int getRowCount() {
        int n = 0;
        if (this._dependencies != null) {
            n = this._dependencies.size();
        }
        return n;
    }

    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
        this.fireTableDataChanged();
    }

    public void addDependencies(Collection<Dependency> collection) {
        if (collection != null && !collection.isEmpty()) {
            LinkedHashSet<Dependency> linkedHashSet = new LinkedHashSet<Dependency>(this._dependencies);
            linkedHashSet.addAll(collection);
            this._dependencies.clear();
            this._dependencies.addAll(linkedHashSet);
            this.setModified(true);
            this.fireTableDataChanged();
        }
    }

    public void deleteRow(int n) {
        if (n >= 0 && n < this._dependencies.size()) {
            Dependency dependency = this._dependencies.get(n);
            this._dependencies.remove(dependency);
            this.setModified(true);
            this.fireTableDataChanged();
        }
    }

    public List<String> getComboOptions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            if (TYPE.equals(string)) {
                arrayList.add("State Variable");
                arrayList.add("Reach");
                arrayList.add("Reservoir");
                arrayList.add("Junction");
                arrayList.add("Diversion");
                arrayList.add("External TimeSeries Junction");
            } else if (OUTPUT.equals(string)) {
                arrayList.add(Dependency$DependencyType.INPUT.toString());
                arrayList.add(Dependency$DependencyType.OUTPUT.toString());
                arrayList.add(Dependency$DependencyType.IO.toString());
            } else if (FUNCTION.equals(string)) {
                arrayList.add("current");
                arrayList.add("previous");
                arrayList.add("lagged");
                arrayList.add("period ave");
            }
        }
        return arrayList;
    }

    public List<String> getComboOptions(int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n >= 0 && n < this._dependencies.size() && NAME.equals(string)) {
            Object object = DependencyTableModel.b(this.getValueAt(n, this.getColumnNum(TYPE)));
            if ((object = this.getNameChoices((String)object)) != null) {
                arrayList.addAll((Collection<String>)object);
            }
        }
        return arrayList;
    }

    private List<String> getNameChoices(String object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ((object = this._typeNameDepMap.get(object)) != null) {
            arrayList.addAll(Collections.unmodifiableSet(object.keySet()));
        }
        return arrayList;
    }

    public static String b(Object object) {
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object != null) {
            string = object.toString();
        }
        return string;
    }

    private int getColumnNum(String string) {
        int n = 0;
        for (int i = 0; i < this.m_columnNames.length; ++i) {
            String string2 = this.m_columnNames[i];
            if (!string2.equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void setModified(boolean bl) {
        if (this.a) {
            return;
        }
        this._modified = bl;
        this.fireModifiedStateChanged();
    }

    public void addModifiableListener(ModifiableListener modifiableListener) {
        if (modifiableListener == null) {
            return;
        }
        this.e.add(modifiableListener);
    }

    public void removeModifiableListener(ModifiableListener modifiableListener) {
        this.e.remove(modifiableListener);
    }

    protected void fireModifiedStateChanged() {
        for (int i = this.e.size() - 1; i >= 0; --i) {
            ModifiableListener modifiableListener = this.e.get(i);
            if (modifiableListener == null) continue;
            DependencyTableModel dependencyTableModel = this;
            modifiableListener.modifiedStateChanged((Modifiable)dependencyTableModel, dependencyTableModel.isModified());
        }
    }

    public void setIgnoreModifiedEvents(boolean bl) {
        this.a = bl;
    }

    public boolean getIgnoreModifiedEvents() {
        return this.a;
    }
}

