/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.DependencyTable;
import hec.rss.client.DependencyTableModel;
import hec.rss.client.DependencyTablePanel$1;
import hec.rss.client.DependencyTablePanel$2;
import hec.rss.client.DependencyTablePanel$3;
import hec.rss.client.DependencyTablePanel$DepTransferHandler;
import hec.rss.model.RssSystem;
import hec.rss.model.dependencies.Dependency;
import hec.rss.model.dependencies.DependencyException;
import hec.rss.model.dependencies.DependencyFinder;
import hec.rss.model.dependencies.DependencySet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import rma.swing.RmaInsets;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJPopupMenu;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.MleHeadRenderer;
import rma.util.SoftHashMap;

public class DependencyTablePanel
extends RmaJPanel {
    private static final Logger a = Logger.getLogger(DependencyTablePanel.class.getName());
    private final transient DependencyFinder b;
    private DependencyTableModel _autoModel;
    private DependencyTableModel _userModel;
    private DependencyTable _autoTable;
    private DependencyTable _userTable;
    private final transient DependencyTablePanel$1 c = new DependencyTablePanel$1(this);
    private final transient Map<String, SoftReference<Collection<Dependency>>> d = new SoftHashMap();

    public DependencyTablePanel(RssSystem rssSystem, DependencyFinder dependencyFinder) {
        this.b = dependencyFinder;
        this._autoModel = new DependencyTableModel(rssSystem);
        this._autoModel.addModifiableListener(this.c);
        this._userModel = new DependencyTableModel(rssSystem, true);
        this._userModel.addModifiableListener(this.c);
        this.initComponents();
    }

    public void setSystem(RssSystem rssSystem) {
        this._autoModel.setSystem(rssSystem);
        this._userModel.setSystem(rssSystem);
    }

    public void fillPanel(DependencySet object, TreeModel treeModel) {
        Collection<Dependency> collection;
        LinkedHashSet<Dependency> linkedHashSet = new LinkedHashSet<Dependency>();
        if (object != null && (collection = ((DependencySet)object).b()) != null && !collection.isEmpty()) {
            linkedHashSet.addAll(collection);
        }
        this._autoModel.setIgnoreModifiedEvents(true);
        this._autoModel.setDependencies(linkedHashSet);
        this._autoModel.setIgnoreModifiedEvents(false);
        this._autoModel.setModified(false);
        collection = new LinkedHashSet<Dependency>();
        if (object != null && (object = ((DependencySet)object).a()) != null && !object.isEmpty()) {
            collection.addAll((Collection<Dependency>)object);
        }
        this._userModel.setIgnoreModifiedEvents(true);
        this._userModel.setDependencies(collection);
        this._userModel.setIgnoreModifiedEvents(false);
        this._userModel.setModified(false);
        object = new DependencyTablePanel$2(this, treeModel);
        ((SwingWorker)object).execute();
        this.setModified(false);
    }

    private List<TreeNode> getLeaves(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (treeNode != null) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                TreeNode treeNode2 = treeNode.getChildAt(i);
                if (treeNode2.isLeaf()) {
                    arrayList.add(treeNode2);
                    continue;
                }
                arrayList.addAll(this.getLeaves(treeNode2));
            }
        }
        return arrayList;
    }

    public DependencySet savePanel() {
        Collection<Dependency> collection = this._autoModel.getDependencies();
        Collection<Dependency> collection2 = this._userModel.getDependencies();
        return new DependencySet(collection, collection2);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.gridwidth = 0;
        RmaJPanel rmaJPanel = this.buildAutoPanel();
        this.add((Component)rmaJPanel, gridBagConstraints);
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel = this.buildUserPanel();
        this.add((Component)rmaJPanel, gridBagConstraints);
    }

    private RmaJPanel buildAutoPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel();
        rmaJPanel.setLayout((LayoutManager)new GridBagLayout());
        RmaJLabel rmaJLabel = new RmaJLabel("Auto Discovered");
        this._autoTable = new DependencyTable(this._autoModel);
        int n = this._autoModel.findColumn("Offset");
        int n2 = this._autoModel.findColumn("Period");
        this._autoTable.setIntegerCellEditor(n);
        this._autoTable.setIntegerCellEditor(n2);
        TableColumnModel tableColumnModel = this._autoTable.getColumnModel();
        ColumnGroup columnGroup = new ColumnGroup((TableCellRenderer)new MleHeadRenderer(), "Time Option");
        columnGroup.add((Object)tableColumnModel.getColumn(this._autoModel.findColumn("Function")));
        columnGroup.add((Object)tableColumnModel.getColumn(n));
        columnGroup.add((Object)tableColumnModel.getColumn(n2));
        GroupableTableHeader groupableTableHeader = new GroupableTableHeader(tableColumnModel);
        groupableTableHeader.addColumnGroup(columnGroup);
        groupableTableHeader.setToolTipStrings(DependencyTableModel.a());
        this._autoTable.setTableHeader((JTableHeader)groupableTableHeader);
        this._autoTable.setMlHeaderRenderer();
        int n3 = this._autoModel.findColumn("Active");
        this._autoTable.setCheckBoxCellEditor(this._autoTable.convertColumnIndexToView(n3));
        rmaJLabel.setLabelFor((Component)((Object)this._autoTable));
        this._autoTable.setAutoCreateRowSorter(true);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._autoTable));
        Cloneable cloneable = jScrollPane.getPreferredSize();
        cloneable.setSize(cloneable.getWidth(), 150.0);
        jScrollPane.setPreferredSize((Dimension)cloneable);
        cloneable = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)cloneable).anchor = 18;
        rmaJPanel.add((Component)rmaJLabel, (Object)cloneable);
        ((GridBagConstraints)cloneable).gridwidth = 0;
        ((GridBagConstraints)cloneable).fill = 1;
        ((GridBagConstraints)cloneable).weighty = 1.0;
        ((GridBagConstraints)cloneable).weightx = 1.0;
        rmaJPanel.add((Component)jScrollPane, (Object)cloneable);
        return rmaJPanel;
    }

    private RmaJPanel buildUserPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel();
        rmaJPanel.setLayout((LayoutManager)new GridBagLayout());
        this._userTable = new DependencyTable(this._userModel);
        int n = this._userModel.findColumn("Offset");
        int n2 = this._userModel.findColumn("Period");
        this._userTable.setIntegerCellEditor(n);
        this._userTable.setIntegerCellEditor(n2);
        Object object = this._userTable.getColumnModel();
        ColumnGroup columnGroup = new ColumnGroup((TableCellRenderer)new MleHeadRenderer(), "Time Option");
        columnGroup.add((Object)object.getColumn(this._userModel.findColumn("Function")));
        columnGroup.add((Object)object.getColumn(n));
        columnGroup.add((Object)object.getColumn(n2));
        GroupableTableHeader groupableTableHeader = new GroupableTableHeader((TableColumnModel)object);
        groupableTableHeader.setToolTipStrings(DependencyTableModel.a());
        groupableTableHeader.addColumnGroup(columnGroup);
        this._userTable.setTableHeader((JTableHeader)groupableTableHeader);
        this._userTable.setMlHeaderRenderer();
        this._userTable.setRowSelectionAllowed(true);
        this._userTable.setRowHeight(this._userTable.getRowHeight() + 5);
        int n3 = this._userModel.findColumn("Type");
        this._userTable.setComboBoxEditor(n3, this._userModel.getComboOptions("Type").toArray(new String[0]));
        this._userTable.setAutoCreateRowSorter(true);
        TableColumn tableColumn = object.getColumn(this._userModel.findColumn("Name/Location"));
        tableColumn.setCellEditor(this._userTable.buildColumnEditor("Name/Location"));
        int n4 = this._userModel.findColumn("Active");
        this._userTable.setCheckBoxCellEditor(this._userTable.convertColumnIndexToView(n4));
        n4 = this._userModel.findColumn("I/O");
        Object object2 = this._userModel.getComboOptions("I/O");
        this._userTable.setComboBoxEditor(this._userTable.convertColumnIndexToView(n4), object2.toArray(new String[0]));
        n4 = this._userModel.findColumn("Function");
        object2 = this._userModel.getComboOptions("Function");
        this._userTable.setComboBoxEditor(this._userTable.convertColumnIndexToView(n4), object2.toArray(new String[0]));
        this._userTable.setEnabled(true);
        this._userTable.setEditable(true);
        this._userTable.setPopupMenuEnabled(true);
        Object object3 = new RmaJPopupMenu();
        object2 = new JMenuItem("Delete Row(s)");
        ((AbstractButton)object2).setActionCommand("deleterow");
        ((AbstractButton)object2).addActionListener(actionEvent -> this._userTable.deleteRow());
        ((JPopupMenu)object3).add((JMenuItem)object2);
        this._userTable.setPopupMenu((JPopupMenu)object3);
        object3 = new RmaJLabel("User Specified");
        object3.setLabelFor((Component)((Object)this._userTable));
        object2 = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 0;
        ((GridBagConstraints)object2).anchor = 18;
        rmaJPanel.add((Component)object3, object2);
        object3 = new JScrollPane((Component)((Object)this._userTable));
        object = ((JComponent)object3).getPreferredSize();
        ((Dimension)object).setSize(((Dimension)object).getWidth(), 150.0);
        ((JComponent)object3).setPreferredSize((Dimension)object);
        object = new DependencyTablePanel$3(this);
        object = new DropTarget((Component)object3, (DropTargetListener)object);
        ((Component)object3).setDropTarget((DropTarget)object);
        ((GridBagConstraints)object2).gridwidth = 0;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).weightx = 1.0;
        rmaJPanel.add((Component)object3, object2);
        return rmaJPanel;
    }

    public static int a(String object) {
        object = Pattern.compile("\r\n|\r|\n").matcher((CharSequence)object);
        int n = 1;
        while (((Matcher)object).find()) {
            ++n;
        }
        return n;
    }

    private boolean isEditable() {
        return true;
    }

    public void paste() {
        if (this.isEditable() && this.isEnabled()) {
            this.invokeAction("paste", TransferHandler.getPasteAction());
        }
    }

    private int getCurrentEventModifiers() {
        int n = 0;
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof InputEvent) {
            n = ((InputEvent)aWTEvent).getModifiers();
        } else if (aWTEvent instanceof ActionEvent) {
            n = ((ActionEvent)aWTEvent).getModifiers();
        }
        return n;
    }

    private void invokeAction(String string, Action action) {
        ActionMap actionMap = this.getActionMap();
        Action action2 = null;
        if (actionMap != null) {
            action2 = actionMap.get(string);
        }
        if (action2 == null) {
            this.installDefaultTransferHandlerIfNecessary();
            action2 = action;
        }
        action2.actionPerformed(new ActionEvent((Object)this, 1001, (String)action2.getValue("Name"), EventQueue.getMostRecentEventTime(), this.getCurrentEventModifiers()));
    }

    private void installDefaultTransferHandlerIfNecessary() {
        if (this.getTransferHandler() == null) {
            this.setTransferHandler(new DependencyTablePanel$DepTransferHandler(this));
        }
    }

    public void insertDependenciesFromString(String object) {
        if ((object = this.getDependenciesFromFunction((String)object)) != null && !object.isEmpty()) {
            this.addDependencies((Collection<Dependency>)object);
        }
    }

    private Collection<Dependency> getDependenciesFromFunction(String object) {
        Collection<Dependency> collection = null;
        if (object != null) {
            SoftReference<Collection<Dependency>> softReference = this.d.get(object);
            if (softReference != null) {
                collection = softReference.get();
            }
            if (collection == null) {
                if (DependencyTablePanel.a((String)(object = ((String)object).trim())) == 1 && !((String)object).endsWith("Value(currentRuntimestep)")) {
                    object = (String)object + ".getPreviousValue(currentRuntimestep)";
                }
                try {
                    collection = this.b.a((String)object);
                    this.d.put((String)object, new SoftReference<Collection<Dependency>>(collection));
                }
                catch (DependencyException dependencyException) {
                    a.log(Level.WARNING, null, dependencyException);
                }
            }
        }
        return collection;
    }

    private void addDependencies(Collection<Dependency> collection) {
        this._userModel.addDependencies(collection);
    }

    public boolean isModified() {
        return super.isModified() || this._userModel.isModified() || this._autoModel.isModified();
    }
}

