/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.appInterface.AppDaddy;
import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.DefaultDownstreamOptionsEditor;
import hec.rss.client.DownstreamOptionsDlg$1;
import hec.rss.client.DownstreamOptionsDlg$2;
import hec.rss.client.DownstreamOptionsDlg$3;
import hec.rss.client.DownstreamOptionsDlg$4;
import hec.rss.client.DownstreamOptionsDlg$5;
import hec.rss.client.DownstreamOptionsDlg$6;
import hec.rss.client.DownstreamOptionsDlg$7;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.DownstreamOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJLabel;

public class DownstreamOptionsDlg
extends RmaJDialog {
    private DownstreamOpRule _rule;
    private ButtonCmdPanel _cmdPanel;
    protected boolean _canceled;
    private JRadioButton _useDefaultOptionsRadio;
    private RmaJButton _editDefaultsButton;
    private JRadioButton _useRuleSpecificOptionsRadio;
    private JPanel _attenuationPanel;
    private JRadioButton _option1Radio;
    private RmaJIntegerField _lagSpaceMaxIterations;
    private RmaJDecimalField _lagSpaceAbsFlowTol;
    private RmaJDecimalField _lagSpaceFractionLimit;
    private JRadioButton _option2Radio;
    private RmaJIntegerField _predictorMaxIterations;
    private RmaJDecimalField _predictionCorrectionFactor;
    private JRadioButton _option3Radio;
    private JRadioButton _option4Radio;
    private JPanel _rocPanel;
    private JPanel _rtwPanel;
    private RmaJCheckBox _considerROCCheckbox;
    private RmaJIntegerField _rocMaxLookahead;
    private RmaJCheckBox _considerRTWCheckbox;
    private RmaJDecimalField _rtwMultiplier;
    private RmaJButton _resetDefaultsButton;
    private DownstreamOptions _defaultOps;
    private DownstreamOptions _ruleSpecificOps;

    public DownstreamOptionsDlg(Dialog dialog, DownstreamOpRule downstreamOpRule) {
        super(dialog, true);
        this._rule = downstreamOpRule;
        this._defaultOps = this._rule.getDefaultDownstreamOptions();
        this._ruleSpecificOps = this._rule.getDownStreamOptions();
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        DownstreamOptionsDlg downstreamOptionsDlg = this;
        downstreamOptionsDlg.setLocationRelativeTo(downstreamOptionsDlg.getParent());
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Advanced Options");
        Serializable serializable = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)serializable, gridBagConstraints);
        this._useDefaultOptionsRadio = new JRadioButton("Use Global Options");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ((Container)serializable).add(this._useDefaultOptionsRadio, gridBagConstraints);
        this._editDefaultsButton = new RmaJButton("Edit...");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ((Container)serializable).add((Component)this._editDefaultsButton, gridBagConstraints);
        this._useRuleSpecificOptionsRadio = new JRadioButton("Use Rule Specific Options");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._useRuleSpecificOptionsRadio, gridBagConstraints);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._useDefaultOptionsRadio);
        ((ButtonGroup)serializable).add(this._useRuleSpecificOptionsRadio);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(new JSeparator(0), gridBagConstraints);
        this._attenuationPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        this._attenuationPanel.setBorder(new TitledBorder("Correct for Attenuation"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._attenuationPanel, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._attenuationPanel.add((Component)serializable, gridBagConstraints);
        this._option3Radio = new JRadioButton("No Correction");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._option3Radio, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._attenuationPanel.add((Component)serializable, gridBagConstraints);
        this._option1Radio = new JRadioButton("Option 1 (Lagged Space Adjustment)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        ((Container)serializable).add(this._option1Radio, gridBagConstraints);
        JLabel jLabel = new JLabel("   Max Iterations:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._lagSpaceMaxIterations = new RmaJIntegerField();
        jLabel.setLabelFor((Component)this._lagSpaceMaxIterations);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        gridBagConstraints.ipadx = 100;
        ((Container)serializable).add((Component)this._lagSpaceMaxIterations, gridBagConstraints);
        jLabel = new RmaJLabel("   Absolute Flow Tolerance (%S):");
        jLabel.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._lagSpaceAbsFlowTol = new RmaJDecimalField();
        this._lagSpaceAbsFlowTol.setDisplayUnitsSystem(AppDaddy.getApp().getClientUnitSystem());
        jLabel.setLabelFor((Component)this._lagSpaceAbsFlowTol);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._lagSpaceAbsFlowTol, gridBagConstraints);
        jLabel = new JLabel("   Tolerance Fraction of Limit (%):");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._lagSpaceFractionLimit = new RmaJDecimalField();
        this._lagSpaceFractionLimit.setMinValue(0.0);
        this._lagSpaceFractionLimit.setMaxValue(100.0);
        jLabel.setLabelFor((Component)this._lagSpaceFractionLimit);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._lagSpaceFractionLimit, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._attenuationPanel.add((Component)serializable, gridBagConstraints);
        this._option2Radio = new JRadioButton("Option 2 (Predictor Corrector)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(this._option2Radio, gridBagConstraints);
        jLabel = new JLabel("   Max Iterations");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._predictorMaxIterations = new RmaJIntegerField();
        jLabel.setLabelFor((Component)this._predictorMaxIterations);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._predictorMaxIterations, gridBagConstraints);
        jLabel = new JLabel("   Correction Factor (0.0-1.0):");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add(jLabel, gridBagConstraints);
        this._predictionCorrectionFactor = new RmaJDecimalField();
        this._predictionCorrectionFactor.setMaxValue(1.0);
        this._predictionCorrectionFactor.setMinValue(0.0);
        jLabel.setLabelFor((Component)this._predictionCorrectionFactor);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        ((Container)serializable).add((Component)this._predictionCorrectionFactor, gridBagConstraints);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._attenuationPanel.add((Component)serializable, gridBagConstraints);
        this._option4Radio = new JRadioButton("Option 3 (PEST Correction)");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        if (Boolean.getBoolean("ResSim.HasDSPestOption")) {
            ((Container)serializable).add(this._option4Radio, gridBagConstraints);
        }
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._option1Radio);
        ((ButtonGroup)serializable).add(this._option2Radio);
        ((ButtonGroup)serializable).add(this._option3Radio);
        ((ButtonGroup)serializable).add(this._option4Radio);
        this._rocPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        this._rocPanel.setBorder(new TitledBorder("Rate of Change Constraints"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        DownstreamOptionsDlg downstreamOptionsDlg = this;
        downstreamOptionsDlg.add(downstreamOptionsDlg._rocPanel, gridBagConstraints);
        this._considerROCCheckbox = new RmaJCheckBox("Consider ROC Constraints");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rocPanel.add((Component)this._considerROCCheckbox, gridBagConstraints);
        jLabel = new JLabel("Max Lookahead for ROC (Number of Time Steps):");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rocPanel.add((Component)jLabel, gridBagConstraints);
        this._rocMaxLookahead = new RmaJIntegerField();
        jLabel.setLabelFor((Component)this._rocMaxLookahead);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._rocPanel.add((Component)this._rocMaxLookahead, gridBagConstraints);
        this._rtwPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        this._rtwPanel.setBorder(new TitledBorder("Routing Time Window"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        DownstreamOptionsDlg downstreamOptionsDlg2 = this;
        downstreamOptionsDlg2.add(downstreamOptionsDlg2._rtwPanel, gridBagConstraints);
        this._considerRTWCheckbox = new RmaJCheckBox("Limit look ahead time window for downstream control");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rtwPanel.add((Component)this._considerRTWCheckbox, gridBagConstraints);
        jLabel = new JLabel("<html>Multiplier on estimated routing lag:<br>(look ahead=(1+multiplier)*routing lag):</html>");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rtwPanel.add((Component)jLabel, gridBagConstraints);
        this._rtwMultiplier = new RmaJDecimalField();
        this._rtwMultiplier.setMinValue(0.0);
        jLabel.setLabelFor((Component)this._rtwMultiplier);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._rtwPanel.add((Component)this._rtwMultiplier, gridBagConstraints);
        this._resetDefaultsButton = new RmaJButton("Reset Parameters");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        this.getContentPane().add((Component)this._resetDefaultsButton, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
    }

    private void addListeners() {
        this._editDefaultsButton.addActionListener((ActionListener)new DownstreamOptionsDlg$1(this));
        this._considerROCCheckbox.addActionListener((ActionListener)new DownstreamOptionsDlg$2(this));
        this._considerRTWCheckbox.addActionListener((ActionListener)new DownstreamOptionsDlg$3(this));
        this._resetDefaultsButton.addActionListener((ActionListener)new DownstreamOptionsDlg$4(this));
        ActionListener actionListener = new DownstreamOptionsDlg$5(this);
        this._option1Radio.addActionListener(actionListener);
        this._option2Radio.addActionListener(actionListener);
        this._option3Radio.addActionListener(actionListener);
        actionListener = new DownstreamOptionsDlg$6(this);
        this._useDefaultOptionsRadio.addActionListener(actionListener);
        this._useRuleSpecificOptionsRadio.addActionListener(actionListener);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new DownstreamOptionsDlg$7(this));
    }

    private void editDefaultOptionAction() {
        DownstreamOptionsDlg downstreamOptionsDlg = this;
        DefaultDownstreamOptionsEditor defaultDownstreamOptionsEditor = new DefaultDownstreamOptionsEditor(downstreamOptionsDlg, downstreamOptionsDlg._defaultOps, true);
        defaultDownstreamOptionsEditor.setLocationRelativeTo((Component)((Object)this));
        defaultDownstreamOptionsEditor.setVisible(true);
        if (!defaultDownstreamOptionsEditor.isCanceled() && this._useDefaultOptionsRadio.isSelected()) {
            this.useOptionAction();
        }
        defaultDownstreamOptionsEditor.dispose();
    }

    private void considerROCCheckAction() {
        if (this._considerROCCheckbox.isSelected()) {
            this._rocMaxLookahead.setEnabled(true);
            return;
        }
        this._rocMaxLookahead.setEnabled(false);
    }

    private void considerRTWCheckAction() {
        if (this._considerRTWCheckbox.isSelected()) {
            this._rtwMultiplier.setEnabled(true);
            return;
        }
        this._rtwMultiplier.setEnabled(false);
    }

    private void radioOptionAction() {
        if (this._option1Radio.isSelected()) {
            this._lagSpaceAbsFlowTol.setEnabled(true);
            this._lagSpaceFractionLimit.setEnabled(true);
            this._lagSpaceMaxIterations.setEnabled(true);
            this._predictionCorrectionFactor.setEnabled(false);
            this._predictorMaxIterations.setEnabled(false);
            return;
        }
        if (this._option2Radio.isSelected()) {
            this._lagSpaceAbsFlowTol.setEnabled(false);
            this._lagSpaceFractionLimit.setEnabled(false);
            this._lagSpaceMaxIterations.setEnabled(false);
            this._predictionCorrectionFactor.setEnabled(true);
            this._predictorMaxIterations.setEnabled(true);
            return;
        }
        this._lagSpaceAbsFlowTol.setEnabled(false);
        this._lagSpaceFractionLimit.setEnabled(false);
        this._lagSpaceMaxIterations.setEnabled(false);
        this._predictionCorrectionFactor.setEnabled(false);
        this._predictorMaxIterations.setEnabled(false);
    }

    protected void resetStaticDefaultsAction() {
        this._ruleSpecificOps.resetDefaults();
        this.useOptionAction();
    }

    protected void useOptionAction() {
        if (this._useDefaultOptionsRadio.isSelected()) {
            this.fillWithDefaults();
            this._attenuationPanel.setEnabled(false);
            this._rocPanel.setEnabled(false);
            this._rtwPanel.setEnabled(false);
            return;
        }
        this._attenuationPanel.setEnabled(true);
        this._rocPanel.setEnabled(true);
        this._rtwPanel.setEnabled(true);
        this.fillWithRuleSpecific();
        this.radioOptionAction();
        this.considerROCCheckAction();
        this.considerRTWCheckAction();
    }

    public void fillWithDefaults() {
        double d = this._defaultOps.getLagFlowTolerance();
        ClientApp.app();
        this._lagSpaceAbsFlowTol.setValue(new ParamDouble(d, Parameter.PARAMID_FLOW, ClientApp.Workspace().getUnitSystem()));
        this._lagSpaceFractionLimit.setValue(this._defaultOps.getLagFractionLimit() * 100.0);
        this._lagSpaceMaxIterations.setValue(this._defaultOps.getLagMaxIterations());
        this._predictionCorrectionFactor.setValue(this._defaultOps.getPredictorCorrectionFactor());
        this._predictorMaxIterations.setValue(this._defaultOps.getPredictorMaxIterations());
        this._rocMaxLookahead.setValue(this._defaultOps.getMaxLookaheadROC());
        this._rtwMultiplier.setValue(this._defaultOps.getMultiplierRTW());
        if (this._defaultOps.getUseLaggedSpaceAdj()) {
            this._option1Radio.setSelected(true);
        } else if (this._defaultOps.getUsePredictor()) {
            this._option2Radio.setSelected(true);
        } else if (this._defaultOps.getUsePESTAdj()) {
            this._option4Radio.setSelected(true);
        } else {
            this._option3Radio.setSelected(true);
        }
        if (this._defaultOps.getUseConsiderROC()) {
            this._considerROCCheckbox.setSelected(true);
        } else {
            this._considerROCCheckbox.setSelected(false);
        }
        if (this._defaultOps.getUseConsiderRTW()) {
            this._considerRTWCheckbox.setSelected(true);
            return;
        }
        this._considerRTWCheckbox.setSelected(false);
    }

    public void fillWithRuleSpecific() {
        double d = this._ruleSpecificOps.getLagFlowTolerance();
        ClientApp.app();
        this._lagSpaceAbsFlowTol.setValue(new ParamDouble(d, Parameter.PARAMID_FLOW, ClientApp.Workspace().getUnitSystem()));
        this._lagSpaceFractionLimit.setValue(this._ruleSpecificOps.getLagFractionLimit() * 100.0);
        this._lagSpaceMaxIterations.setValue(this._ruleSpecificOps.getLagMaxIterations());
        this._predictionCorrectionFactor.setValue(this._ruleSpecificOps.getPredictorCorrectionFactor());
        this._predictorMaxIterations.setValue(this._ruleSpecificOps.getPredictorMaxIterations());
        this._rocMaxLookahead.setValue(this._ruleSpecificOps.getMaxLookaheadROC());
        this._rtwMultiplier.setValue(this._ruleSpecificOps.getMultiplierRTW());
        if (this._ruleSpecificOps.getUseLaggedSpaceAdj()) {
            this._option1Radio.setSelected(true);
        } else if (this._ruleSpecificOps.getUsePredictor()) {
            this._option2Radio.setSelected(true);
        } else if (this._ruleSpecificOps.getUsePESTAdj()) {
            this._option4Radio.setSelected(true);
        } else {
            this._option3Radio.setSelected(true);
        }
        if (this._ruleSpecificOps.getUseConsiderROC()) {
            this._considerROCCheckbox.setSelected(true);
        } else {
            this._considerROCCheckbox.setSelected(false);
        }
        if (this._ruleSpecificOps.getUseConsiderRTW()) {
            this._considerRTWCheckbox.setSelected(true);
            return;
        }
        this._considerRTWCheckbox.setSelected(false);
    }

    protected void saveForm() {
        this._ruleSpecificOps.setLagFlowTolerance(this._lagSpaceAbsFlowTol.getParamValue().convertToUnitSystem(AppDaddy.getApp().getClientUnitSystem()));
        if (this._lagSpaceFractionLimit.getValue() > 0.0) {
            this._ruleSpecificOps.setLagFractionLimit(this._lagSpaceFractionLimit.getValue() / 100.0);
        } else {
            this._ruleSpecificOps.setLagFractionLimit(this._lagSpaceFractionLimit.getValue());
        }
        this._ruleSpecificOps.setLagMaxIterations(this._lagSpaceMaxIterations.getValue());
        this._ruleSpecificOps.setPredictorCorrectionFactor(this._predictionCorrectionFactor.getValue());
        this._ruleSpecificOps.setPredictorMaxIterations(this._predictorMaxIterations.getValue());
        this._ruleSpecificOps.setMaxLookaheadROC(this._rocMaxLookahead.getValue());
        this._ruleSpecificOps.setMultiplierRTW(this._rtwMultiplier.getValue());
        if (this._option1Radio.isSelected()) {
            this._ruleSpecificOps.setSpaceAdjType(1);
        } else if (this._option2Radio.isSelected()) {
            this._ruleSpecificOps.setSpaceAdjType(2);
        } else if (this._option4Radio.isSelected()) {
            this._ruleSpecificOps.setSpaceAdjType(3);
        } else {
            this._ruleSpecificOps.setSpaceAdjType(0);
        }
        if (this._considerROCCheckbox.isSelected()) {
            this._ruleSpecificOps.setUseConsiderROC(true);
        } else {
            this._ruleSpecificOps.setUseConsiderROC(false);
        }
        if (this._considerRTWCheckbox.isSelected()) {
            this._ruleSpecificOps.setUseConsiderRTW(true);
        } else {
            this._ruleSpecificOps.setUseConsiderRTW(false);
        }
        this._rule.setUseDefaultDSOptions(this._useDefaultOptionsRadio.isSelected());
        this._rule.setDownStreamOptions(this._ruleSpecificOps);
        this._rule.setDefaultDownstreamOptions(this._defaultOps);
    }

    private void fillForm() {
        if (this._rule.useDefaultDSOptions()) {
            this._useDefaultOptionsRadio.setSelected(true);
            this.useOptionAction();
            return;
        }
        this._useRuleSpecificOptionsRadio.setSelected(true);
        this.useOptionAction();
    }

    public boolean wasCanceled() {
        return this._canceled;
    }
}

