/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.Parameter;
import hec.rss.client.DownstreamOptionsDlg;
import hec.rss.client.DownstreamRulePanel$1;
import hec.rss.client.DownstreamRulePanel$2;
import hec.rss.client.RulePanel;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamCntrlOpRule$OperationType;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.RssNode;
import hec.rss.model.StorageZone;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class DownstreamRulePanel
extends RulePanel {
    public static final String[] DNSTRM_LIMIT_TYPES = new String[]{"Minimum", "Maximum"};
    protected RmaJTextField _locationField;
    ItemListener _locationComboListener;
    protected RmaJComboBox _parameterCombo;
    ItemListener _parameterComboListener;
    protected List _downStreamList = new ArrayList();
    protected JPanel _rocPanel;
    private JButton _advancedOptionsBtn;
    private JCheckBox _passThruCheckboxBUSTED;
    RmaJLabel _operationComboLabel;
    RmaJLabel _upperLimitZoneLabel;
    RmaJLabel _lowerLimitZoneLabel;
    RmaJLabel _averagePeriodLabel;
    private RmaJComboBox<DownstreamCntrlOpRule$OperationType> _operationCombo;
    private RmaJComboBox<String> _upperLimitZoneCombo;
    private RmaJComboBox<String> _lowerLimitZoneCombo;
    private RmaJDecimalField _averagePeriodField;
    private Vector<StorageZone> _storageZones;

    @Override
    protected void buildControls() {
        this._limitTypes = DNSTRM_LIMIT_TYPES;
        super.buildControls();
        JPanel jPanel = new JPanel(new GridBagLayout());
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 4;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add(jPanel, object);
        JLabel jLabel = new JLabel("Downstream Location:");
        jLabel.setDisplayedMnemonic('o');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 1;
        object.anchor = 18;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, object);
        this._locationField = new RmaJTextField();
        this._locationField.setEditable(false);
        jLabel.setLabelFor((Component)this._locationField);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 0;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._locationField, object);
        jLabel = new JLabel("Parameter:");
        jLabel.setDisplayedMnemonic('P');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.gridwidth = 1;
        object.anchor = 18;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, object);
        object = new String[]{"Flow", "Stage"};
        this._parameterCombo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, object));
        jLabel.setLabelFor((Component)this._parameterCombo);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 1;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._parameterCombo, object);
        this._rocPanel = new JPanel(new CardLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._rightPanel.add((Component)this._rocPanel, object);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("ROCPANEL");
        this._rocPanel.add(jPanel.getName(), jPanel);
        jLabel = new JLabel("   ");
        jLabel.setName("EMPTYPANEL");
        this._rocPanel.add(jLabel.getName(), jLabel);
        jPanel = this.buildParticipationPanel();
        if (Boolean.getBoolean("ResSim.HasDownstreamRuleOptions")) {
            new RmaGridBagConstraints();
            object = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            object.gridy = 6;
            object.gridwidth = 1;
            object.gridheight = 1;
            object.weighty = 0.0;
            object.weightx = 1.0;
            object.anchor = 18;
            object.fill = 2;
            object.insets = RmaInsets.insets((int)0, (int)0, (int)5, (int)0);
            this.add(jPanel, object);
        }
        this._risingFallingConditionCB.setSelected(false);
        this._risingFallingConditionCB.setEnabled(false);
        this._risingFallingConditionCB.hide();
        this._periodAverageLimitCB.setSelected(false);
        this._periodAverageLimitCB.setEnabled(false);
        this._parameterComboListener = new DownstreamRulePanel$1(this);
        this._advancedOptionsBtn = new JButton("Advanced Options");
        object.gridx = 0;
        object.gridy = 2;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5555;
        this._rightPanel.add((Component)this._advancedOptionsBtn, object);
        this._advancedOptionsBtn.addActionListener(new DownstreamRulePanel$2(this));
        this.initMinimumSize();
    }

    private void initMinimumSize() {
        this.setMinimumSize(new Dimension(500, 400));
    }

    @Override
    protected void buildRightPanel() {
        this._rightPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        DownstreamRulePanel downstreamRulePanel = this;
        downstreamRulePanel.add(downstreamRulePanel._rightPanel, gridBagConstraints);
    }

    private void usePassThruCheckboxAction() {
        this.setModified(true);
    }

    private RmaJPanel buildParticipationPanel() {
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this.initResOpFields();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)this._operationComboLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add(this._operationCombo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)15, (int)0, (int)5);
        rmaJPanel.add((Component)this._upperLimitZoneLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add(this._upperLimitZoneCombo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)15, (int)0, (int)5);
        rmaJPanel.add((Component)this._lowerLimitZoneLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add(this._lowerLimitZoneCombo, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)15, (int)0, (int)5);
        rmaJPanel.add((Component)this._averagePeriodLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)this._averagePeriodField, (Object)gridBagConstraints);
        this.setReRegOptionsEnabled(false);
        return rmaJPanel;
    }

    private void initResOpFields() {
        this._operationComboLabel = new RmaJLabel("Reservoir Participation:");
        this._upperLimitZoneLabel = new RmaJLabel("  Upper Limit Zone:");
        this._lowerLimitZoneLabel = new RmaJLabel("  Lower Limit Zone:");
        this._averagePeriodLabel = new RmaJLabel("  Average Period (Days):");
        this._operationCombo = new RmaJComboBox((Object[])DownstreamCntrlOpRule$OperationType.values());
        this._operationCombo.addActionListener(actionEvent -> this.operationComboAction());
        this._upperLimitZoneCombo = new RmaJComboBox();
        this._upperLimitZoneCombo.addActionListener(actionEvent -> this.setModified(true));
        this._lowerLimitZoneCombo = new RmaJComboBox();
        this._lowerLimitZoneCombo.addActionListener(actionEvent -> this.setModified(true));
        this._averagePeriodField = new RmaJDecimalField();
        this._averagePeriodField.addActionListener(actionEvent -> this.setModified(true));
    }

    private void operationComboAction() {
        boolean bl = this._operationCombo.getSelectedItem() == DownstreamCntrlOpRule$OperationType.RE_REG;
        this.setReRegOptionsEnabled(bl);
        this.setModified(true);
    }

    public void setReRegOptionsEnabled(boolean bl) {
        this._upperLimitZoneLabel.setEnabled(bl);
        this._lowerLimitZoneLabel.setEnabled(bl);
        this._averagePeriodLabel.setEnabled(bl);
        this._upperLimitZoneCombo.setEnabled(bl);
        this._lowerLimitZoneCombo.setEnabled(bl);
        this._averagePeriodField.setEnabled(bl);
    }

    protected void advancedOptionsAction() {
        Object object = (DownstreamCntrlOpRule)this._currentRuleRef.getRule();
        object = new DownstreamOptionsDlg((Dialog)SwingUtilities.windowForComponent((Component)((Object)this)), (DownstreamOpRule)object);
        object.setVisible(true);
        if (object.isModified()) {
            this.setModified(true);
        }
    }

    protected void setROCFieldState() {
        this.controlParameterChanged();
    }

    public void setDownstreamLocationComboModel(Vector vector) {
        Object e;
        if (vector != null && vector.size() > 0 && (e = (vector = (Vector)vector.clone()).elementAt(0)) instanceof String && ((String)e).equals("Release")) {
            vector.removeElementAt(0);
        }
        this._downStreamList.clear();
        this._downStreamList.addAll(vector);
    }

    public void fillZones(Vector<StorageZone> vector) {
        this._storageZones = vector;
        this._upperLimitZoneCombo.setModel(new DefaultComboBoxModel<StorageZone>(vector));
        this._lowerLimitZoneCombo.setModel(new DefaultComboBoxModel<StorageZone>(vector));
    }

    @Override
    public void fillPanel() {
        super.fillPanel();
        DownstreamCntrlOpRule downstreamCntrlOpRule = (DownstreamCntrlOpRule)this._currentRuleRef.getRule();
        this._parameterCombo.removeItemListener(this._parameterComboListener);
        int n = downstreamCntrlOpRule.getDownstreamControlParameter();
        if (n == DownstreamCntrlOpRule.b) {
            this._parameterCombo.setSelectedIndex(1);
        } else {
            this._parameterCombo.setSelectedIndex(0);
        }
        this._parameterCombo.addItemListener(this._parameterComboListener);
        n = downstreamCntrlOpRule.getDownstreamControlLocationID();
        if (n < 0) {
            this._locationField.setText(this._downStreamList.get(0).toString());
        } else {
            int n2;
            int n3 = this._downStreamList.size();
            for (n2 = 1; n2 < n3; ++n2) {
                RssNode rssNode = (RssNode)this._downStreamList.get(n2);
                if (rssNode.getIndex() != n) continue;
                this._locationField.setText(rssNode.toString());
                break;
            }
            if (n2 == n3) {
                this._locationField.setText(this._downStreamList.get(0).toString());
            }
        }
        this._yParamString = this._parameterCombo.getSelectedItem().toString();
        this._yParamId = this._parameterCombo.getSelectedIndex() == 1 ? Parameter.PARAMID_STAGE : Parameter.PARAMID_FLOW;
        if (this._currentPanel != null) {
            this._currentPanel.rebuildTableColumnLabels();
        }
        this.plotTable();
        this._locationField.setEditable(false);
        this.setROCFieldState();
        this._risingFallingConditionCB.setSelected(false);
        this._risingFallingConditionCB.setEnabled(false);
        this._periodAverageLimitCB.setSelected(false);
        this._periodAverageLimitCB.setEnabled(false);
        this.fillOperationSettings(downstreamCntrlOpRule);
    }

    private void fillOperationSettings(DownstreamCntrlOpRule downstreamCntrlOpRule) {
        this._operationCombo.setSelectedItem((Object)downstreamCntrlOpRule.getOperationType());
        this.selectUpperZone(downstreamCntrlOpRule.getUpperLimitZone());
        this.selectLowerZone(downstreamCntrlOpRule.getLowerLimitZone());
        Double d = downstreamCntrlOpRule.getReRegAvgPeriod();
        if (d != null) {
            this._averagePeriodField.setValue(downstreamCntrlOpRule.getReRegAvgPeriod().doubleValue());
        }
    }

    private void selectUpperZone(String object) {
        if (object != null) {
            object = this.getZoneByName((String)object);
            this._upperLimitZoneCombo.setSelectedItem(object);
        }
    }

    private void selectLowerZone(String object) {
        if (object != null) {
            object = this.getZoneByName((String)object);
            this._lowerLimitZoneCombo.setSelectedItem(object);
        }
    }

    private StorageZone getZoneByName(String string) {
        for (StorageZone storageZone : this._storageZones) {
            if (!string.equalsIgnoreCase(storageZone.getName())) continue;
            return storageZone;
        }
        return null;
    }

    @Override
    public boolean savePanel() {
        if (this._currentRuleRef == null) {
            return true;
        }
        DownstreamCntrlOpRule downstreamCntrlOpRule = (DownstreamCntrlOpRule)this._currentRuleRef.getRule();
        if (downstreamCntrlOpRule == null) {
            return false;
        }
        if (!super.savePanel()) {
            return false;
        }
        this.saveOperationSettings(downstreamCntrlOpRule);
        int n = DownstreamCntrlOpRule.a;
        if (this._parameterCombo.getSelectedIndex() == 1) {
            n = DownstreamCntrlOpRule.b;
        }
        downstreamCntrlOpRule.setDownstreamControlParameter(n);
        return true;
    }

    private void saveOperationSettings(DownstreamCntrlOpRule downstreamCntrlOpRule) {
        downstreamCntrlOpRule.setOperationType((DownstreamCntrlOpRule$OperationType)((Object)this._operationCombo.getSelectedItem()));
        Object object = this._upperLimitZoneCombo.getSelectedItem();
        if (object != null && object instanceof StorageZone) {
            downstreamCntrlOpRule.setUpperLimitZone(((StorageZone)object).getName());
        }
        if ((object = this._lowerLimitZoneCombo.getSelectedItem()) != null && object instanceof StorageZone) {
            downstreamCntrlOpRule.setLowerLimitZone(((StorageZone)object).getName());
        }
        downstreamCntrlOpRule.setReRegAvgPeriod(this._averagePeriodField.getValue());
    }

    public void controlParameterChanged() {
        this._yParamString = this._parameterCombo.getSelectedItem().toString();
        this._yParamId = this._parameterCombo.getSelectedIndex() == 1 ? Parameter.PARAMID_STAGE : Parameter.PARAMID_FLOW;
        this._currentPanel.rebuildTableColumnLabels();
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof RmaJDialog) {
            ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
        } else if (window instanceof RmaJFrame) {
            ((RmaJFrame)window).updateUnitSystem((Container)((Object)this));
        }
        this.plotTable();
    }

    protected boolean isROCType() {
        return false;
    }

    @Override
    protected String getAdditionalYParamString() {
        if (this.isROCType()) {
            return " ROC";
        }
        return super.getAdditionalYParamString();
    }

    @Override
    protected String getAdditionalYUnitsString() {
        return super.getAdditionalYUnitsString();
    }

    @Override
    protected void limitTypeComboChanged() {
        if (this.isROCType()) {
            ((CardLayout)this._rocPanel.getLayout()).show(this._rocPanel, "ROCPANEL");
        } else {
            ((CardLayout)this._rocPanel.getLayout()).show(this._rocPanel, "EMPTYPANEL");
        }
        this.controlParameterChanged();
    }
}

