/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PairedValuesExtData;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValuesExt;
import hec.model.PairedValuesExtTableModel;
import hec.rss.client.ESRDCurvesPanel$1;
import hec.rss.client.ESRDCurvesPanel$2;
import hec.rss.client.ESRDCurvesPanel$3;
import hec.rss.client.ESRDCurvesPanel$4;
import hec.rss.client.ESRDCurvesPanel$5;
import hec.rss.client.ESRDCurvesPanel$6;
import hec.rss.client.ESRDCurvesPanel$7;
import hec.rss.client.ESRDCurvesPanel$MyG2dPanel;
import hec.rss.client.ESRDPlotDialog;
import hec.rss.client.ISFallingPoolDialog;
import hec.rss.client.InducedSurchargeInflowsDialog;
import hec.rss.client.InflowTimeSeriesVariableOptionsDialog;
import hec.rss.client.JOperationsPanel;
import hec.rss.client.OutletUsageOptionsDialog;
import hec.rss.client.ReservoirJFrame;
import hec.rss.model.InducedSurchargeOpRule;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.ReservoirOp;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.print.PageText;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class ESRDCurvesPanel
extends DefaultJPanel {
    private RmaJTable _esrdTable;
    private ESRDCurvesPanel$MyG2dPanel _plotPanel;
    private JButton _editFallingPoolButton;
    private JButton _editEsrdInflowsButton;
    private JButton _inflowTSOptionsButton;
    private JButton _outletUsageOptionsButton;
    private RmaJRadioButton _inflowRadio;
    private RmaJRadioButton _rateOfRiseRadio;
    private GroupableTableHeader _tableHeader;
    private String[] _headers;
    private OpRuleRef _currentRuleRef = null;
    private InflowTimeSeriesVariableOptionsDialog _inflowTimeSeriesVariableOptionDialog;
    private OutletUsageOptionsDialog _outletUsageDialog;
    private JOperationsPanel _parent;
    private PairedValuesExtTableModel _tableModel;
    private PairedValuesExtData _elevReleaseData;
    private ColumnGroup _columnGroup;
    private PairedValuesExtTableModel _rateofRiseModel;
    private PairedValuesExtTableModel _inflowModel;
    private double[] _rateOfRiseForCurves;
    private double[] _reservoirInflowsForCurves;
    private boolean _fillingForm;

    public ESRDCurvesPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this._elevReleaseData = this.getElevReleaseData();
        this._headers = new String[]{"Elevation\n(%S)", "Envelope"};
        Object object = new boolean[]{true, true};
        this._inflowModel = this._tableModel = new PairedValuesExtTableModel(this._headers, (boolean[])object);
        this._rateofRiseModel = new PairedValuesExtTableModel(this._headers, (boolean[])object);
        ESRDCurvesPanel eSRDCurvesPanel = this;
        this._esrdTable = new RmaJTable((Component)((Object)eSRDCurvesPanel), (Object[])eSRDCurvesPanel._headers);
        this._esrdTable.setModel((TableModel)this._tableModel);
        this._esrdTable.setMlHeaderRenderer();
        this._esrdTable.setUnitsHeaderRenderer();
        object = new int[]{Parameter.PARAMID_ELEV, Parameter.PARAMID_FLOW};
        this._inflowModel.setColumnParameters((int[])object);
        this._rateofRiseModel.setColumnParameters((int[])object);
        this._esrdTable.setColumnParameters((int[])object);
        this._esrdTable.setDoubleCellEditor();
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        ESRDCurvesPanel eSRDCurvesPanel2 = this;
        eSRDCurvesPanel2.add(eSRDCurvesPanel2._esrdTable.getScrollPane(), object);
        Object object2 = this._esrdTable.getColumnModel();
        this._tableHeader = new GroupableTableHeader((TableColumnModel)object2);
        this._esrdTable.setTableHeader((JTableHeader)this._tableHeader);
        this._columnGroup = new ColumnGroup("Min Release per Inflow");
        this._columnGroup.add((Object)object2.getColumn(1));
        this._tableHeader.addColumnGroup(this._columnGroup);
        this._esrdTable.appendRows(5);
        object2 = new JPanel(new GridBagLayout());
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        this.add((Component)object2, object);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Specify Releases with Respect to:"));
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS0000;
        ((Container)object2).add((Component)jPanel, object);
        this._inflowRadio = new RmaJRadioButton("Reservoir Inflow", true);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._inflowRadio, object);
        this._rateOfRiseRadio = new RmaJRadioButton("Rate of Rise");
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._rateOfRiseRadio, object);
        this._editFallingPoolButton = new JButton("Edit Falling Pool Options...");
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 10;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS0555;
        ((Container)object2).add((Component)this._editFallingPoolButton, object);
        object2 = new JPanel(new GridBagLayout());
        ((GridBagConstraints)object).gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 0.5;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).gridheight = 2;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        this.add((Component)object2, object);
        this._plotPanel = new ESRDCurvesPanel$MyG2dPanel(this);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        ((Container)object2).add((Component)((Object)this._plotPanel), object);
        this._editEsrdInflowsButton = new JButton("Edit Inflows for ESRD Curves...");
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        ((Container)object2).add((Component)this._editEsrdInflowsButton, object);
        this._inflowTSOptionsButton = new JButton("Inflow Time Series Options...");
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        ((Container)object2).add((Component)this._inflowTSOptionsButton, object);
        this._outletUsageOptionsButton = new JButton("Outlet Usage Options...");
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS5505;
        this.setName("SpecifyEsrdCurves");
        ESRDCurvesPanel eSRDCurvesPanel3 = this;
        eSRDCurvesPanel3.configureFlowPlot(eSRDCurvesPanel3._plotPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        object = buttonGroup;
        buttonGroup.add((AbstractButton)this._inflowRadio);
        ((ButtonGroup)object).add((AbstractButton)this._rateOfRiseRadio);
    }

    private void addListeners() {
        this._editFallingPoolButton.addActionListener(new ESRDCurvesPanel$1(this));
        this._editEsrdInflowsButton.addActionListener(new ESRDCurvesPanel$2(this));
        this._inflowTSOptionsButton.addActionListener(new ESRDCurvesPanel$3(this));
        this._outletUsageOptionsButton.addActionListener(new ESRDCurvesPanel$4(this));
        this._esrdTable.addCellEditorListener((CellEditorListener)new ESRDCurvesPanel$5(this));
        this._inflowRadio.addActionListener((ActionListener)new ESRDCurvesPanel$6(this));
        this._rateOfRiseRadio.addActionListener((ActionListener)new ESRDCurvesPanel$7(this));
    }

    private void tableParameterTypeAction() {
        ColumnGroup columnGroup;
        this._tableHeader.removeAllColumnGroups();
        if (this._inflowRadio.isSelected()) {
            columnGroup = new ColumnGroup("Min Release per Inflow");
            this._esrdTable.setModel((TableModel)this._inflowModel);
            this._tableModel = this._inflowModel;
        } else {
            columnGroup = new ColumnGroup("Min Release per Rate of Rise");
            this._esrdTable.setModel((TableModel)this._rateofRiseModel);
            this._tableModel = this._rateofRiseModel;
        }
        TableColumnModel tableColumnModel = this._esrdTable.getColumnModel();
        for (int i = 1; i < tableColumnModel.getColumnCount(); ++i) {
            columnGroup.add((Object)tableColumnModel.getColumn(i));
        }
        this._tableHeader.addColumnGroup(columnGroup);
        this._esrdTable.setUnitsHeaderRenderer();
        this._esrdTable.setAutoResizeMode(tableColumnModel.getColumnCount() > 3 ? 0 : 4);
        if (!this._fillingForm) {
            this.elevReleaseReplot();
        }
    }

    private PairedValuesExtData getElevReleaseData() {
        PairedValuesExtData pairedValuesExtData = new PairedValuesExtData();
        new PairedValuesExtData().xunits = "Release (%S)";
        pairedValuesExtData.yunits = "Elevation (%S)";
        PairedValuesExt pairedValuesExt = new PairedValuesExt();
        pairedValuesExt.setInterpolationType(0);
        pairedValuesExtData.setPlotXvsY(true);
        pairedValuesExtData.resetData();
        return pairedValuesExtData;
    }

    private void elevReleaseReplot() {
        Vector<PairedValuesExtData> vector = new Vector<PairedValuesExtData>();
        PairedValuesExt pairedValuesExt = new PairedValuesExt();
        RmaTableModel rmaTableModel = (RmaTableModel)this._esrdTable.getModel();
        if (!(rmaTableModel instanceof PairedValuesExtTableModel)) {
            return;
        }
        rmaTableModel = (PairedValuesExtTableModel)rmaTableModel;
        rmaTableModel.setSaveEmptyYAsUndefined(true);
        rmaTableModel.storeData(pairedValuesExt);
        this._elevReleaseData.setPlotXvsY(true);
        this._elevReleaseData.setData(pairedValuesExt);
        this._elevReleaseData.calcPlotArrays();
        this._elevReleaseData.name = "Induced Surcharge Envelope";
        vector.addElement(this._elevReleaseData);
        this._plotPanel.setPlotObjects(vector);
        this._plotPanel.paintGfx();
    }

    public void fallingPoolOptionsButtonAction() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        object = new ISFallingPoolDialog((Dialog)object, true);
        ((ISFallingPoolDialog)object).setData((InducedSurchargeOpRule)this._currentRuleRef.getRule());
        ((ISFallingPoolDialog)object).setVisible(true);
        if (!((ISFallingPoolDialog)object).isOk()) {
            return;
        }
        this.setModified(true);
    }

    private void inflowTimeSeriesOptionAction() {
        Serializable serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(serializable instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        this._inflowTimeSeriesVariableOptionDialog = new InflowTimeSeriesVariableOptionsDialog((Dialog)serializable, true, 4);
        serializable = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        this._inflowTimeSeriesVariableOptionDialog.fillForm((InducedSurchargeOpRule)serializable);
        this._inflowTimeSeriesVariableOptionDialog.setVisible(true);
        if (this._inflowTimeSeriesVariableOptionDialog.isModified()) {
            this.setModified(true);
        }
    }

    private void outletUsageOptionsAction() {
        Serializable serializable = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(serializable instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null) {
            return;
        }
        this._outletUsageDialog = new OutletUsageOptionsDialog((Dialog)serializable, true);
        this._outletUsageDialog.setReservoirOp((ReservoirOp)this._currentRuleRef.getRule().getOperationsElement().getElementOp());
        serializable = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        this._outletUsageDialog.fillForm((InducedSurchargeOpRule)serializable);
        this._outletUsageDialog.setVisible(true);
    }

    protected void editEsrdInflowAction() {
        boolean bl;
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(window instanceof ReservoirJFrame)) {
            return;
        }
        TableColumnModel tableColumnModel = this._esrdTable.getColumnModel();
        double[] dArray = new double[]{};
        if (tableColumnModel.getColumnCount() > 2) {
            dArray = new double[tableColumnModel.getColumnCount() - 2];
            for (int i = 2; i < tableColumnModel.getColumnCount(); ++i) {
                dArray[i - 2] = RMAIO.parseDouble((Object)tableColumnModel.getColumn(i).getHeaderValue());
            }
        }
        this._esrdTable.commitEdit(true);
        InducedSurchargeInflowsDialog inducedSurchargeInflowsDialog = new InducedSurchargeInflowsDialog((Dialog)((Object)((ReservoirJFrame)((Object)window))), true);
        if (this._rateOfRiseRadio.isSelected()) {
            inducedSurchargeInflowsDialog.setTitle("Specify Rate of Rise for ESRD Curves");
            bl = true;
        } else {
            inducedSurchargeInflowsDialog.setTitle("Specify Inflows for ESRD Curves");
            bl = false;
        }
        inducedSurchargeInflowsDialog.fillForm(dArray, this._currentRuleRef.getRule().getUnitSystem(), bl, 0.0, 0.0);
        inducedSurchargeInflowsDialog.pack();
        inducedSurchargeInflowsDialog.setVisible(true);
        if (inducedSurchargeInflowsDialog.isOk()) {
            dArray = inducedSurchargeInflowsDialog.getTableValues();
            this.rebuildTable(dArray);
        }
    }

    private void rebuildTable(double[] dArray) {
        int n;
        PairedValuesExtTableModel pairedValuesExtTableModel = new String[dArray.length + 2];
        PairedValuesExtTableModel pairedValuesExtTableModel2 = pairedValuesExtTableModel;
        pairedValuesExtTableModel[0] = this._headers[0];
        pairedValuesExtTableModel2[1] = this._headers[1];
        for (int i = 0; i < dArray.length; ++i) {
            pairedValuesExtTableModel2[i + 2] = String.valueOf(dArray[i]);
        }
        Object object = new boolean[((String[])pairedValuesExtTableModel2).length];
        Arrays.fill(object, true);
        pairedValuesExtTableModel2 = new PairedValuesExtTableModel((String[])pairedValuesExtTableModel2, object);
        PairedValuesExt pairedValuesExt = new PairedValuesExt();
        object = pairedValuesExt;
        pairedValuesExt.setUnitSystem(this._currentRuleRef.getRule().getUnitSystem());
        object.setParamXId(Parameter.PARAMID_ELEV);
        object.setParamYId(Parameter.PARAMID_FLOW);
        object.setNumY(dArray.length + 1);
        pairedValuesExtTableModel2.setPairedValues((PairedValuesExt)object);
        for (n = 0; n < this._tableModel.getRowCount(); ++n) {
            pairedValuesExtTableModel2.setValueAt(this._tableModel.getValueAt(n, 0), n, 0);
            pairedValuesExtTableModel2.setValueAt(this._tableModel.getValueAt(n, 1), n, 1);
        }
        if (pairedValuesExtTableModel2.getColumnCount() > 2 && this._tableModel.getColumnCount() > 2) {
            block2: for (n = 2; n < pairedValuesExtTableModel2.getColumnCount(); ++n) {
                String string = pairedValuesExtTableModel2.getColumnName(n);
                for (int i = 2; i < this._tableModel.getColumnCount(); ++i) {
                    String string2 = this._tableModel.getColumnName(i);
                    if (!string.equalsIgnoreCase(string2)) continue;
                    for (int j = 0; j < this._tableModel.getRowCount(); ++j) {
                        pairedValuesExtTableModel2.setValueAt(this._tableModel.getValueAt(j, i), j, n);
                    }
                    continue block2;
                }
            }
        }
        this._esrdTable.setModel((TableModel)pairedValuesExtTableModel2);
        Object object2 = new int[pairedValuesExtTableModel2.getColumnCount()];
        Arrays.fill((int[])object2, Parameter.PARAMID_FLOW);
        object2[0] = Parameter.PARAMID_ELEV;
        this._esrdTable.setColumnParameters((int[])object2);
        object2 = this._esrdTable.getColumnModel();
        this._tableHeader.removeAllColumnGroups();
        if (this._inflowRadio.isSelected()) {
            this._columnGroup = new ColumnGroup("Min Release per Inflow");
            this._inflowModel = pairedValuesExtTableModel2;
        } else {
            this._columnGroup = new ColumnGroup("Min Release Rate of Rise");
            this._rateofRiseModel = pairedValuesExtTableModel2;
        }
        for (int i = 1; i < object2.getColumnCount(); ++i) {
            this._columnGroup.add((Object)object2.getColumn(i));
        }
        this._tableHeader.addColumnGroup(this._columnGroup);
        this._esrdTable.setDoubleCellEditor();
        this._esrdTable.appendRows(5);
        this._esrdTable.setMlHeaderRenderer();
        this._esrdTable.setUnitsHeaderRenderer();
        if (object2.getColumnCount() > 3) {
            this._esrdTable.setAutoResizeMode(0);
        } else {
            this._esrdTable.setAutoResizeMode(4);
        }
        this._tableModel = pairedValuesExtTableModel2;
    }

    private PairedValuesExtTableModel rebuildTableModel(PairedValuesExt pairedValuesExt, double[] object) {
        String[] stringArray = new String[((double[])object).length + 2];
        String[] stringArray2 = stringArray;
        stringArray[0] = this._headers[0];
        stringArray2[1] = this._headers[1];
        for (int i = 0; i < ((double[])object).length; ++i) {
            stringArray2[i + 2] = String.valueOf(object[i]);
        }
        boolean[] blArray = new boolean[stringArray2.length];
        Arrays.fill(blArray, true);
        PairedValuesExtTableModel pairedValuesExtTableModel = new PairedValuesExtTableModel(stringArray2, blArray);
        object = pairedValuesExtTableModel;
        pairedValuesExtTableModel.setPairedValues(pairedValuesExt);
        return object;
    }

    private double[] getInflows() {
        int n = this._esrdTable.getColumnCount();
        if (n == 2) {
            return new double[0];
        }
        double[] dArray = new double[n - 2];
        TableColumnModel tableColumnModel = this._esrdTable.getColumnModel();
        for (int i = 2; i < n; ++i) {
            Object object = tableColumnModel.getColumn(i).getHeaderValue();
            dArray[i - 2] = RMAIO.parseDouble((Object)object);
        }
        return dArray;
    }

    public void setRuleRef(OpRuleRef opRuleRef) {
        this._currentRuleRef = opRuleRef;
    }

    public void setParent(JPanel jPanel) {
        this._parent = (JOperationsPanel)((Object)jPanel);
    }

    private void configureFlowPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Release (%S)";
        g2dPlotProp.y1AxisProp.name = "Elevation (%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    public void fillPanel() {
        if (this._currentRuleRef == null) {
            return;
        }
        this._fillingForm = true;
        try {
            InducedSurchargeOpRule inducedSurchargeOpRule = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
            if (inducedSurchargeOpRule.getUserCurvesAreRateOfRise()) {
                this._rateOfRiseRadio.doClick(0);
            } else {
                this._inflowRadio.doClick(0);
            }
            Object object = inducedSurchargeOpRule.getUserDefinedIsCurves();
            object.setUnitSystem(this._currentRuleRef.getRule().getUnitSystem());
            object.setParamXId(Parameter.PARAMID_ELEV);
            object.setParamYId(Parameter.PARAMID_FLOW);
            double[] dArray = inducedSurchargeOpRule.getUserDefinedIsInflows();
            if (dArray != null && dArray.length > 0) {
                this.rebuildTable(dArray);
            } else {
                this.rebuildTable(new double[0]);
            }
            this._tableModel.setPairedValues(object);
            object = new PairedValuesExt();
            object.setUnitSystem(this._currentRuleRef.getRule().getUnitSystem());
            object.setParamXId(Parameter.PARAMID_ELEV);
            object.setParamYId(Parameter.PARAMID_FLOW);
            if (this._tableModel == this._inflowModel) {
                this._rateofRiseModel.setPairedValues(object);
            } else {
                this._inflowModel.setPairedValues(object);
            }
            object = new String("Workspace: " + ClientApp.Workspace().getTitleName());
            object = (String)object + "\n ResSim System: " + this._parent._reservoir.getSystem().getName();
            object = (String)object + "\n Reservoir: " + this._parent._reservoir.getName();
            object = (String)object + "\n Operation Set: " + this._parent._currentOpSet.getName();
            object = (String)object + "\n Induced Surcharge Rule: " + this._currentRuleRef.getName() + " \n ";
            object = new PageText((String)object, 0);
            this._esrdTable.setPrintTitle((PageText)object);
            if (inducedSurchargeOpRule.getUserCurvesAreRateOfRise()) {
                object = inducedSurchargeOpRule.getUserDefinedIsCurvesForFunctionOfInflow();
                if (object != null && object.size() > 0) {
                    this._reservoirInflowsForCurves = inducedSurchargeOpRule.getUserDefinedIsReservoirInflow();
                    if (this._reservoirInflowsForCurves != null) {
                        this._inflowModel = this.rebuildTableModel((PairedValuesExt)object, this._reservoirInflowsForCurves);
                    }
                }
            } else {
                object = inducedSurchargeOpRule.getUserDefinedIsCurvesForRateOfRise();
                if (object != null && object.size() > 0) {
                    this._rateOfRiseForCurves = inducedSurchargeOpRule.getUserDefinedRateOfRise();
                    if (this._rateOfRiseForCurves != null) {
                        this._rateofRiseModel = this.rebuildTableModel((PairedValuesExt)object, this._rateOfRiseForCurves);
                    }
                }
            }
        }
        finally {
            this._fillingForm = false;
        }
        this.elevReleaseReplot();
    }

    public boolean savePanel() {
        String string;
        int n;
        double[] dArray;
        PairedValuesExt pairedValuesExt;
        if (this._currentRuleRef == null) {
            return true;
        }
        this._esrdTable.commitEdit(true);
        InducedSurchargeOpRule inducedSurchargeOpRule = (InducedSurchargeOpRule)this._currentRuleRef.getRule();
        if (this._rateOfRiseRadio.isSelected()) {
            inducedSurchargeOpRule.setUserCurvesAreRateOfRise(true);
        } else {
            inducedSurchargeOpRule.setUserCurvesAreRateOfRise(false);
        }
        RmaTableModel rmaTableModel = (RmaTableModel)this._esrdTable.getModel();
        if (rmaTableModel instanceof PairedValuesExtTableModel) {
            pairedValuesExt = new PairedValuesExt();
            rmaTableModel = (PairedValuesExtTableModel)rmaTableModel;
            rmaTableModel.setSaveEmptyYAsUndefined(true);
            rmaTableModel.storeData(pairedValuesExt);
            dArray = this.getInflows();
            inducedSurchargeOpRule.setUserDefinedIsCurves(pairedValuesExt, dArray);
            if (this.isVisible() && pairedValuesExt.size() > 1 && !pairedValuesExt.canInterpX()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The ESRD Elevation values of your function must be a continuously increasing sequence.", "Error", 0);
                return false;
            }
        }
        if (this._rateofRiseModel != null) {
            pairedValuesExt = new PairedValuesExt();
            this._rateofRiseModel.storeData(pairedValuesExt);
            int n2 = this._rateofRiseModel.getColumnCount();
            if (n2 > 2) {
                dArray = new double[n2 - 2];
                for (n = 2; n < n2; ++n) {
                    string = this._rateofRiseModel.getColumnName(n);
                    dArray[n - 2] = RMAIO.parseDouble((String)string);
                }
                inducedSurchargeOpRule.setUserDefinedIsCurvesForRateOfRise(pairedValuesExt, dArray);
            }
        }
        if (this._inflowModel != null) {
            pairedValuesExt = new PairedValuesExt();
            this._inflowModel.storeData(pairedValuesExt);
            int n3 = this._inflowModel.getColumnCount();
            if (n3 > 2) {
                dArray = new double[n3 - 2];
                for (n = 2; n < n3; ++n) {
                    string = this._inflowModel.getColumnName(n);
                    dArray[n - 2] = RMAIO.parseDouble((String)string);
                }
                inducedSurchargeOpRule.setUserDefinedIsCurvesForFunctionOfInflow(pairedValuesExt, dArray);
            }
        }
        if (!inducedSurchargeOpRule.fallingPoolOptionsValid() && this.isShowing()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Induced Surcharge rule, " + inducedSurchargeOpRule.getName() + "'s Falling Pool Options are not defined.", "Error", 0);
            return false;
        }
        return true;
    }

    private PairedValuesExt saveTableModelData(RmaTableModel rmaTableModel) {
        if (rmaTableModel instanceof PairedValuesExtTableModel) {
            PairedValuesExt pairedValuesExt = new PairedValuesExt();
            rmaTableModel = (PairedValuesExtTableModel)rmaTableModel;
            rmaTableModel.storeData(pairedValuesExt);
            this.getInflows();
            if (this.isVisible() && pairedValuesExt.size() > 1 && !pairedValuesExt.canInterpX()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The ESRD Elevation values of your function must be a continuously increasing sequence.", "Error", 0);
                return null;
            }
        }
        return null;
    }

    private void plotSurchargeButton_ActionPerformed() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(object instanceof ReservoirJFrame)) {
            return;
        }
        if (this._currentRuleRef == null || this._currentRuleRef.getRule() == null) {
            return;
        }
        PairedValuesExt pairedValuesExt = new PairedValuesExt();
        Object object2 = (String[])this._esrdTable.getModel();
        if (!(object2 instanceof PairedValuesExtTableModel)) {
            return;
        }
        object2 = (PairedValuesExtTableModel)object2;
        object2.storeData(pairedValuesExt);
        object2 = this.getInflowLabels();
        pairedValuesExt.setCurveLabels((String[])object2);
        object2 = this._currentRuleRef.getRule();
        String string = ((OpRule)object2).getOperationsElement().getSystem().getNameForKeyString(((OpRule)object2).getController().getName());
        object2 = "ESRD Curves for: " + string + "   " + object2.getName();
        object = new ESRDPlotDialog((Frame)((Component)object).getParent(), this, (String)object2, true);
        ((ESRDPlotDialog)((Object)object)).setESRDCurves(pairedValuesExt, this._rateOfRiseRadio.isSelected());
        ((ESRDPlotDialog)((Object)object)).setVisible(true);
    }

    String[] getInflowLabels() {
        int n = this._currentRuleRef.getRule().getUnitSystem();
        double[] dArray = this.getInflows();
        int n2 = dArray.length + 1;
        String[] stringArray = new String[n2];
        String[] stringArray2 = stringArray;
        stringArray[0] = "Surcharge Envelope";
        boolean bl = this._rateOfRiseRadio.isSelected();
        Object object = "";
        try {
            if (bl) {
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_ELEV, (int)n);
                object = (String)object + "/hr";
            } else {
                object = Parameter.getUnitsStringForSystem((int)Parameter.PARAMID_FLOW, (int)n);
            }
        }
        catch (Exception exception) {}
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (bl) {
            numberFormat.setMaximumFractionDigits(3);
        } else {
            numberFormat.setMaximumFractionDigits(0);
            if (n == 2) {
                numberFormat.setMaximumFractionDigits(1);
            }
        }
        for (n = 1; n < n2; ++n) {
            String string = String.valueOf(dArray[n - 1]);
            stringArray2[n] = string + " " + (String)object;
        }
        return stringArray2;
    }
}

