/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.dataTable.HecDataTableFrame;
import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.io.PairedDataContainer;
import hec.model.PairedValuesExt;
import hec.rss.client.ESRDPlotDialog$MyPairedDataSet;
import hec.rss.model.InducedSurchargeOpRule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JMenuBar;
import rma.swing.DefaultJPanel;

public class ESRDPlotDialog
extends G2dDialog {
    InducedSurchargeOpRule _rule;
    boolean _plotRateOfRise = false;
    boolean _showDischargeCapacity = true;
    PairedValuesExt _pvExt;
    DefaultJPanel _parentPanel;
    private Vector _colorVec = null;
    boolean _doPlot = false;
    private static Color[] a = new Color[]{Color.blue, Color.red};

    public ESRDPlotDialog(Frame frame, DefaultJPanel defaultJPanel, String string, boolean bl) {
        super(frame, string, bl);
        this.setFrame(frame);
        this._parentPanel = defaultJPanel;
    }

    public HecDataTableFrame tabulate(boolean bl) {
        HecDataTableFrame hecDataTableFrame = super.tabulate(bl);
        hecDataTableFrame.setTitle(this.getTitle());
        return hecDataTableFrame;
    }

    void addMenuComponents() {
        JMenuBar jMenuBar = this.getJMenuBar();
        this.setJMenuBar(jMenuBar);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.fillForm();
        }
        super.setVisible(bl);
    }

    public void fillForm() {
        if (this._pvExt == null) {
            return;
        }
        this.plotSurchargeCurves();
    }

    private void configurePlot0() {
        G2dPanel g2dPanel = this.getPlotpanel();
        G2dPanelProp g2dPanelProp = g2dPanel.getProperties();
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().x1AxisProp.name = "Release";
        g2dPlotProp.y1AxisProp.name = "Elevation";
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
    }

    private void configurePlot() {
        G2dPanel g2dPanel = this.getPlotpanel();
        g2dPanel.clearPanel();
        G2dPanelProp g2dPanelProp = g2dPanel.getProperties();
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().x1AxisProp.name = "Release (%S)";
        g2dPlotProp.y1AxisProp.name = "Elevation (%S)";
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
    }

    protected void plotSurchargeCurves() {
        if (this._pvExt == null) {
            return;
        }
        G2dPanel g2dPanel = this.getPlotpanel();
        g2dPanel.clearPanel();
        Vector<PairedDataContainer> vector = new Vector<PairedDataContainer>();
        int n = this._pvExt.getNumberCurves();
        String[] stringArray = this._pvExt.getCurveLabels();
        for (int i = 0; i < n; ++i) {
            Object object = new PairedDataContainer();
            new PairedDataContainer().numberCurves = 1;
            object.xOrdinates = (double[])this._pvExt.getYArray(i).clone();
            object.numberOrdinates = object.xOrdinates.length;
            object.yOrdinates = new double[1][];
            object.yOrdinates[0] = this._pvExt.getXArray();
            object.labels = new String[1];
            if (stringArray != null && stringArray.length > i) {
                object.labels[0] = i > 0 ? (this._plotRateOfRise ? "Rate of Rise=" + stringArray[i] : "Inflow=" + stringArray[i]) : stringArray[i];
                object.labelsUsed = true;
            } else {
                object.labels[0] = "";
                object.labelsUsed = false;
            }
            object.switchXyAxis = false;
            object.xparameter = this._pvExt.getParamYString();
            object.yparameter = this._pvExt.getParamXString();
            object.xunits = this._pvExt.getParamYUnitsString();
            object.yunits = this._pvExt.getParamXUnitsString();
            object.xtype = "UNT";
            object.ytype = "UNT";
            object = new ESRDPlotDialog$MyPairedDataSet(this, (PairedDataContainer)object);
            vector.add((PairedDataContainer)object);
        }
        Vector<Color> vector2 = new Vector<Color>();
        vector2.add(a[0]);
        g2dPanel.buildComponents(vector, vector2);
        this.getContentPane().add((Component)g2dPanel, "Center");
        ESRDPlotDialog.setUnitSystem((int)this.getUnitDisplaySystem());
    }

    public void setInducedSurchargeOpRule(InducedSurchargeOpRule inducedSurchargeOpRule) {
        this._rule = inducedSurchargeOpRule;
    }

    public void setESRDCurves(PairedValuesExt pairedValuesExt, boolean bl) {
        this._pvExt = pairedValuesExt;
        this._plotRateOfRise = bl;
    }
}

