/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.Parameter;
import hec.model.PairedValuesExt;
import hec.model.PairedValuesExtTableModel;
import hec.rss.client.EfficiencyHillCurvePanel$1;
import hec.rss.client.EfficiencyHillCurvePanel$OutletTableHeaderRender;
import hec.rss.client.HillCurveFlowsDialog;
import hec.rss.client.ReservoirJFrame;
import hec.rss.model.PowerPlant;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaTableModel;
import rma.util.RMAIO;

public class EfficiencyHillCurvePanel
extends DefaultJPanel {
    private String[] _header;
    private RmaJTable _hillCurveTable;
    private PairedValuesExtTableModel _tableModel;
    private GroupableTableHeader _tableHeader;
    private ColumnGroup _columnGroup;
    private JButton _editFlowSettingsButton;

    public EfficiencyHillCurvePanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    private void buildControls() {
        this._header = new String[]{"Net Head\n(%S)", "Filling"};
        Object object = new boolean[]{true, true};
        this._tableModel = new PairedValuesExtTableModel(this._header, object);
        EfficiencyHillCurvePanel efficiencyHillCurvePanel = this;
        this._hillCurveTable = new RmaJTable((Component)((Object)efficiencyHillCurvePanel), (Object[])efficiencyHillCurvePanel._header);
        this._hillCurveTable.setModel((TableModel)this._tableModel);
        this._hillCurveTable.setMlHeaderRenderer();
        this._hillCurveTable.setUnitsHeaderRenderer();
        object = new int[]{Parameter.PARAMID_ELEV, Parameter.PARAMID_FLOW};
        this._hillCurveTable.setColumnParameters((int[])object);
        this._hillCurveTable.setDoubleCellEditor();
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.INSETS5505;
        EfficiencyHillCurvePanel efficiencyHillCurvePanel2 = this;
        efficiencyHillCurvePanel2.add(efficiencyHillCurvePanel2._hillCurveTable.getScrollPane(), object);
        TableColumnModel tableColumnModel = this._hillCurveTable.getColumnModel();
        this._tableHeader = new GroupableTableHeader(tableColumnModel);
        this._hillCurveTable.setTableHeader((JTableHeader)this._tableHeader);
        this._columnGroup = new ColumnGroup("Flow(%S)");
        this._columnGroup.add((Object)tableColumnModel.getColumn(1));
        this._tableHeader.addColumnGroup(this._columnGroup);
        this._hillCurveTable.appendRows(5);
        this._editFlowSettingsButton = new JButton("Edit Flow Settings...");
        object.gridx = 0;
        object.gridy = 1;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 0;
        object.insets = RmaInsets.INSETS5555;
        EfficiencyHillCurvePanel efficiencyHillCurvePanel3 = this;
        efficiencyHillCurvePanel3.add(efficiencyHillCurvePanel3._editFlowSettingsButton, object);
        this.setName("SpecifyHillCurves");
        this.rebuildTable(new double[]{Double.NaN});
    }

    private void addListeners() {
        this._editFlowSettingsButton.addActionListener(new EfficiencyHillCurvePanel$1(this));
    }

    private void editFlowSettingsAction() {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (!(window instanceof ReservoirJFrame)) {
            return;
        }
        TableColumnModel tableColumnModel = this._hillCurveTable.getColumnModel();
        double[] dArray = new double[]{};
        if (tableColumnModel.getColumnCount() >= 2) {
            dArray = new double[tableColumnModel.getColumnCount() - 1];
            for (int i = 1; i < tableColumnModel.getColumnCount(); ++i) {
                dArray[i - 1] = RMAIO.parseDouble((Object)tableColumnModel.getColumn(i).getHeaderValue());
            }
        }
        this._hillCurveTable.commitEdit(true);
        HillCurveFlowsDialog hillCurveFlowsDialog = new HillCurveFlowsDialog((Dialog)((Object)((ReservoirJFrame)((Object)window))), true);
        hillCurveFlowsDialog.fillForm(dArray, 0, false, 0.0, 0.0);
        hillCurveFlowsDialog.pack();
        hillCurveFlowsDialog.setVisible(true);
        if (hillCurveFlowsDialog.isOk()) {
            dArray = hillCurveFlowsDialog.getTableValues();
            this.rebuildTable(dArray);
        }
    }

    private void rebuildTable(double[] dArray) {
        int n;
        int n2;
        PairedValuesExtTableModel pairedValuesExtTableModel = new String[dArray.length + 1];
        PairedValuesExtTableModel pairedValuesExtTableModel2 = pairedValuesExtTableModel;
        pairedValuesExtTableModel[0] = this._header[0];
        for (int i = 0; i < dArray.length; ++i) {
            pairedValuesExtTableModel2[i + 1] = String.valueOf(dArray[i]);
        }
        Object object = new boolean[((String[])pairedValuesExtTableModel2).length];
        Arrays.fill(object, true);
        pairedValuesExtTableModel2 = new PairedValuesExtTableModel((String[])pairedValuesExtTableModel2, object);
        PairedValuesExt pairedValuesExt = new PairedValuesExt();
        object = pairedValuesExt;
        pairedValuesExt.setUnitSystem(ClientApp.app().getClientUnitSystem());
        object.setParamXId(Parameter.PARAMID_ELEV);
        object.setParamYId(Parameter.PARAMID_FLOW);
        object.setNumY(dArray.length + 1);
        pairedValuesExtTableModel2.setPairedValues((PairedValuesExt)object);
        for (n2 = 0; n2 < this._tableModel.getRowCount(); ++n2) {
            pairedValuesExtTableModel2.setValueAt(this._tableModel.getValueAt(n2, 0), n2, 0);
            pairedValuesExtTableModel2.setValueAt(this._tableModel.getValueAt(n2, 1), n2, 1);
        }
        if (pairedValuesExtTableModel2.getColumnCount() >= 2 && this._tableModel.getColumnCount() >= 2) {
            block2: for (n2 = 2; n2 < pairedValuesExtTableModel2.getColumnCount(); ++n2) {
                String string = pairedValuesExtTableModel2.getColumnName(n2);
                for (n = 2; n < this._tableModel.getColumnCount(); ++n) {
                    String string2 = this._tableModel.getColumnName(n);
                    if (!string.equalsIgnoreCase(string2)) continue;
                    for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
                        pairedValuesExtTableModel2.setValueAt(this._tableModel.getValueAt(i, n), i, n2);
                    }
                    continue block2;
                }
            }
        }
        this._hillCurveTable.setModel((TableModel)pairedValuesExtTableModel2);
        int[] nArray = new int[pairedValuesExtTableModel2.getColumnCount()];
        Arrays.fill(nArray, Parameter.PARAMID_FLOW);
        nArray[0] = Parameter.PARAMID_ELEV;
        this._hillCurveTable.setColumnParameters(nArray);
        TableColumnModel tableColumnModel = this._hillCurveTable.getColumnModel();
        this._tableHeader.removeAllColumnGroups();
        this._columnGroup = new ColumnGroup((TableCellRenderer)((Object)new EfficiencyHillCurvePanel$OutletTableHeaderRender(this)), "Flow (%S)");
        for (n = 1; n < tableColumnModel.getColumnCount(); ++n) {
            this._columnGroup.add((Object)tableColumnModel.getColumn(n));
        }
        this._tableHeader.addColumnGroup(this._columnGroup);
        this._hillCurveTable.setDoubleCellEditor();
        this._hillCurveTable.appendRows(5);
        this._hillCurveTable.setMlHeaderRenderer();
        this._hillCurveTable.setUnitsHeaderRenderer();
        if (tableColumnModel.getColumnCount() > 3) {
            this._hillCurveTable.setAutoResizeMode(0);
        } else {
            this._hillCurveTable.setAutoResizeMode(4);
        }
        this._tableModel = pairedValuesExtTableModel2;
    }

    public void fillPanel(PowerPlant powerPlant) {
        double[] dArray = powerPlant.getEfficiencyHillCurveTurbineInflows();
        if (dArray != null && dArray.length > 0) {
            this.rebuildTable(dArray);
        } else {
            this.rebuildTable(new double[]{Double.NaN});
        }
        powerPlant = powerPlant.getEfficientByHillCurve();
        this._tableModel.setPairedValues((PairedValuesExt)powerPlant);
    }

    public boolean savePanel(PowerPlant powerPlant) {
        if (powerPlant == null) {
            return true;
        }
        this._hillCurveTable.commitEdit(true);
        Object object = this.getFlows();
        powerPlant.setEfficiencyHillCurveTurbineInflows((double[])object);
        RmaTableModel rmaTableModel = (RmaTableModel)this._hillCurveTable.getModel();
        object = rmaTableModel;
        if (rmaTableModel instanceof PairedValuesExtTableModel) {
            PairedValuesExt pairedValuesExt = new PairedValuesExt();
            PairedValuesExtTableModel pairedValuesExtTableModel = (PairedValuesExtTableModel)object;
            object = pairedValuesExtTableModel;
            pairedValuesExtTableModel.setSaveEmptyYAsUndefined(true);
            object.storeData(pairedValuesExt);
            powerPlant.setEfficientByHillCurve(pairedValuesExt);
        }
        return true;
    }

    private double[] getFlows() {
        int n = this._hillCurveTable.getColumnCount();
        if (n == 1) {
            return new double[0];
        }
        double[] dArray = new double[n - 1];
        TableColumnModel tableColumnModel = this._hillCurveTable.getColumnModel();
        for (int i = 1; i < n; ++i) {
            Object object = tableColumnModel.getColumn(i).getHeaderValue();
            dArray[i - 1] = RMAIO.parseDouble((Object)object);
        }
        return dArray;
    }
}

