/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.StreamAlignment;
import hec.map.MapGlyph;
import hec.rss.client.ElementListReport$1;
import hec.rss.client.ElementListReport$2;
import hec.rss.client.ResSimElementMapSelector;
import hec.rss.client.RssReportsTableListener;
import hec.rss.client.reports.PrintableReport;
import hec.rss.model.Controller;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.JunctionElement;
import hec.rss.model.OpSet;
import hec.rss.model.ReachElement;
import hec.rss.model.ReservoirElement;
import hec.rss.model.Routing;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.Rule;
import hec.rss.model.TimeStepRoutingElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.RmaTableModel;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAConst;
import rma.util.RMASort;

public class ElementListReport
extends RmaJFrame
implements PrintableReport {
    public static final int RESERVOIR_LIST = 0;
    public static final int REACH_LIST = 1;
    public static final int JUNCTION_LIST = 2;
    public static final int DIVERSION_LIST = 3;
    public static final int MAX_ELEMENT_TYPE = 3;
    private static final String[] a = new String[]{ReservoirElement.class.getName(), ReachElement.class.getName(), JunctionElement.class.getName(), DiversionElement.class.getName()};
    private static final String[] b = new String[]{"Reservoir", "Reach", "Junction", "Diversion"};
    private RmaJTable cpTable;
    private JMenuItem _deleteMenuItem;
    private JMenuItem _editMenuItem;
    private Vector _streamList = new Vector();
    private StreamAlignment _alignment;
    private RssSystem _system;
    private List<RssReportsTableListener> _listenerList = new ArrayList<RssReportsTableListener>();
    private int _type = -1;
    private ReflectMultiListener _listener = new ReflectMultiListener();
    private JLabel _elementCntLbl;
    private boolean _columnsAdded;

    public ElementListReport() {
        this.buildControls();
        this.pack();
        this.setSize(350, 150);
        this.setLocation();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.buildMenus();
        this.setTitle("Reservoir List");
        this.cpTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{" \nID", " \nName", " \nDescription"});
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        this.getContentPane().add((Component)this.cpTable.getScrollPane(), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        this._elementCntLbl = new JLabel("");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)this._elementCntLbl, gridBagConstraints);
        this.cpTable.addMouseListener((MouseListener)new ElementListReport$1(this));
        this.cpTable.getSelectionModel().addListSelectionListener(new ElementListReport$2(this));
        this.pack();
    }

    private void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Export", 69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "exportReport"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Print", 80);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "printReport"));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Print Preview", 118);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "printPreviewReport"));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Close", 67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "closeDialog"));
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic('E');
        this._editMenuItem = new JMenuItem("Edit", 105);
        ElementListReport elementListReport = this;
        this._editMenuItem.addActionListener((ActionListener)this._listener.add((Object)elementListReport, (Object)elementListReport._editMenuItem, "editElement"));
        this._editMenuItem.setEnabled(false);
        jMenu.add(this._editMenuItem);
        this._deleteMenuItem = new JMenuItem("Delete", 100);
        ElementListReport elementListReport2 = this;
        this._deleteMenuItem.addActionListener((ActionListener)this._listener.add((Object)elementListReport2, (Object)elementListReport2._deleteMenuItem, "deleteElement"));
        this._deleteMenuItem.setEnabled(false);
        jMenu.add(this._deleteMenuItem);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    public void setAlignment(StreamAlignment streamAlignment) {
        this._alignment = streamAlignment;
        this._streamList.removeAllElements();
        if (this._alignment != null) {
            this._streamList.addAll(this._alignment.getElementVector());
        }
    }

    protected void editElement() {
        int n = this.cpTable.getSelectedRow();
        ElementListReport elementListReport = this;
        elementListReport.fireTableDoubleClicked(((Element)elementListReport.cpTable.getCell(n, 0)).toString());
    }

    protected void deleteElement() {
        switch (this._type) {
            case 2: {
                this._editMenuItem.setEnabled(false);
                this.deleteJunctions();
                return;
            }
            case 1: {
                this._editMenuItem.setEnabled(false);
                this.deleteReaches();
                return;
            }
            case 0: {
                this._editMenuItem.setEnabled(false);
                this.deleteReservoirs();
            }
        }
    }

    private void deleteReservoirs() {
        int n;
        Vector vector = this.cpTable.getSelectedRowsVector();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (n = 0; n < vector.size(); ++n) {
            Object object = (List)vector.get(n);
            if (!((object = object.get(0)) instanceof ReservoirElement)) continue;
            object = (ReservoirElement)object;
            arrayList.add((Element)object);
        }
        if (!this.confirmDelete(arrayList, "Reservoirs")) {
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this._system.deleteReservoir(((Element)arrayList.get(n)).getName());
        }
        ClientApp.frame().getMapPanel().paintMap();
        ElementListReport elementListReport = this;
        elementListReport.fillForm(elementListReport._system, 0);
    }

    protected void deleteReaches() {
        int n;
        Vector vector = this.cpTable.getSelectedRowsVector();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (n = 0; n < vector.size(); ++n) {
            Object object = (List)vector.get(n);
            if (!((object = object.get(0)) instanceof ReachElement)) continue;
            object = (ReachElement)object;
            arrayList.add((Element)object);
        }
        if (!this.confirmDelete(arrayList, "Reaches")) {
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this._system.deleteReach(((Element)arrayList.get(n)).getName());
        }
        ClientApp.frame().getMapPanel().paintMap();
        ElementListReport elementListReport = this;
        elementListReport.fillForm(elementListReport._system, 1);
    }

    private boolean confirmDelete(List<Element> object, String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < object.size(); ++n) {
            stringBuilder.append(object.get(n).getName() + "\n");
        }
        object = "The following " + string + " will be deleted: \n\n" + stringBuilder.toString() + "\nWould you like to delete the selected " + string + "?";
        n = JOptionPane.showConfirmDialog((Component)((Object)this), object, "Confirm Delete", 0, 3);
        return n == 0;
    }

    protected void deleteJunctions() {
        String string;
        Vector vector = this.cpTable.getSelectedRowsVector();
        new Vector();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<Object> vector3 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            Object object = (Vector)vector.get(i);
            if (!((object = ((Vector)object).get(0)) instanceof JunctionElement)) continue;
            if (((JunctionElement)(object = (JunctionElement)object)).hasConnectedElements()) {
                vector2.add(object);
                continue;
            }
            vector3.add(object);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < vector3.size(); ++i) {
            stringBuilder.append(((JunctionElement)vector3.get(i)).getName() + "\n");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < vector2.size(); ++i) {
            stringBuilder.append(((JunctionElement)vector2.get(i)).getName() + "\n");
        }
        if (vector2.isEmpty()) {
            string = "The Following Junctions will be deleted: \n" + stringBuilder.toString() + "\nWould you still like to delete the selected junctions?";
        } else {
            if (vector3.isEmpty()) {
                String string2 = "There are no eligible junctions selected that may be deleted.";
                JOptionPane.showMessageDialog((Component)((Object)this), string2);
                return;
            }
            string = "The Following junctions will NOT be deleted\nbecause of connectivity with other elements:\n" + stringBuilder2.toString() + "\nThe Following junctions will be deleted:\n" + stringBuilder.toString() + "\nWould you still like to delete the selected junctions?";
        }
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), string, "Confirm Delete", 0, 3);
        if (n == 0) {
            for (n = 0; n < vector3.size(); ++n) {
                this._system.deleteJunction(((JunctionElement)vector3.get(n)).getName());
            }
            ClientApp.frame().getMapPanel().paintMap();
            ElementListReport elementListReport = this;
            elementListReport.fillForm(elementListReport._system, 2);
        }
    }

    public void addReportsTableListener(RssReportsTableListener rssReportsTableListener) {
        if (rssReportsTableListener == null) {
            return;
        }
        this._listenerList.add(rssReportsTableListener);
    }

    public void removeReportsTableListener(RssReportsTableListener rssReportsTableListener) {
        if (rssReportsTableListener == null) {
            return;
        }
        this._listenerList.remove(rssReportsTableListener);
    }

    public void fillForm(RssSystem object, int n) {
        Object object2;
        if (object == null) {
            return;
        }
        this._system = object;
        if (n < 0 || n > 3) {
            return;
        }
        this._type = n;
        this._deleteMenuItem.setEnabled(false);
        this.setTitle(b[n] + " List");
        this.cpTable.deleteCells();
        object = ((RssSystem)object).getElementVectorByClass(a[n]);
        if (object == null) {
            return;
        }
        int n2 = ((Vector)object).size();
        if (n == 0 && this._system.getAlternative() != null) {
            var5_5 = this.cpTable.getModel();
            object2 = var5_5 instanceof RmaJTableSorter ? (RmaTableModel)((RmaJTableSorter)var5_5).getModel() : (RmaTableModel)var5_5;
            object2.addColumn(" \nOperations");
            if (var5_5 instanceof RmaJTableSorter) {
                ((RmaJTableSorter)var5_5).reallocateIndexes();
            }
        } else if (n == 1) {
            var5_5 = this.cpTable.getModel();
            object2 = var5_5 instanceof RmaJTableSorter ? (RmaTableModel)((RmaJTableSorter)var5_5).getModel() : (RmaTableModel)var5_5;
            if (!this._columnsAdded) {
                object2.addColumn(" \nRouting");
                object2.addColumn(" \nLosses");
                this._columnsAdded = true;
            }
            if (var5_5 instanceof RmaJTableSorter) {
                ((RmaJTableSorter)var5_5).reallocateIndexes();
            }
        } else if (n == 3) {
            var5_5 = this.cpTable.getModel();
            object2 = var5_5 instanceof RmaJTableSorter ? (RmaTableModel)((RmaJTableSorter)var5_5).getModel() : (RmaTableModel)var5_5;
            object2.addColumn(" \nMethod");
            if (var5_5 instanceof RmaJTableSorter) {
                ((RmaJTableSorter)var5_5).reallocateIndexes();
            }
        }
        for (int i = 0; i < n2; ++i) {
            object2 = (Element)((Vector)object).elementAt(i);
            if (object2 == null) continue;
            object2 = this.buildRow((Element)object2);
            this.cpTable.appendRow((Vector)object2);
        }
        Vector vector = ((RmaTableModelInterface)this.cpTable.getModel()).getDataVector();
        int[] nArray = new int[1];
        object2 = nArray;
        nArray[0] = 0;
        RMASort.multipleColumnSort((int[])object2, (List)vector, (boolean)true);
        this.setSize(400, 300);
        int n3 = vector.size();
        if (n3 == 0) {
            this._elementCntLbl.setText("No " + b[n] + "s");
        } else if (b[n].equals("Reach")) {
            this._elementCntLbl.setText(String.valueOf(n3) + " " + b[n] + (n3 > 1 ? "es" : ""));
        } else {
            this._elementCntLbl.setText(String.valueOf(n3) + " " + b[n] + (n3 > 1 ? "s" : ""));
        }
        this.configureTable();
    }

    protected void configureTable() {
        RmaJTableSorter rmaJTableSorter = new RmaJTableSorter((RmaTableModelInterface)this.cpTable.getModel());
        this.cpTable.setModel((TableModel)rmaJTableSorter);
        rmaJTableSorter.addMouseListenerToHeaderInTable((JTable)this.cpTable);
        this.cpTable.setMlHeaderRenderer();
        this.cpTable.setEnabled(false);
        this.cpTable.setColumnEnabled(false, 0);
        this.cpTable.setColumnVisible(0, false, 0);
        this.cpTable.setCellSelectionEnabled(false);
        this.cpTable.setColumnSelectionAllowed(false);
        this.cpTable.setRowSelectionAllowed(true);
        this.cpTable.setAddRemoveEnabled(false);
        this.cpTable.getSelectionModel().setSelectionMode(2);
    }

    private Vector<Object> buildRow(Element object) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object.getName());
        vector.addElement(object.getDescription());
        if (object instanceof ReservoirElement) {
            ReservoirElement reservoirElement = (ReservoirElement)object;
            object = this._system.getAlternative();
            if (object != null) {
                int n = ((RssAlt)object).getResOpSetSelection(reservoirElement.getIndex());
                OpSet opSet = reservoirElement.getReservoirOp().getOperationSet(n);
                if (opSet != null) {
                    vector.add(opSet.getName());
                }
            }
        } else if (object instanceof ReachElement) {
            object = (ReachElement)object;
            Duration[] durationArray = ((TimeStepRoutingElement)object).getDefinedTimeStepDurations();
            Routing routing = null;
            boolean bl = false;
            Duration[] durationArray2 = durationArray;
            int n = durationArray.length;
            for (int i = 0; i < n; ++i) {
                Duration duration = durationArray2[i];
                Function function = ((TimeStepRoutingElement)object).getFunction(duration, null);
                if (!(function instanceof Routing)) continue;
                routing = (Routing)function;
                bl = true;
                break;
            }
            if (!bl) {
                routing = (Routing)((Element)object).getFunction();
            }
            int n2 = ((ReachElement)object).getSeepageType();
            Object object2 = "None";
            if (n2 == 0) {
                double d = ((ReachElement)object).getConstSeepage();
                if (RMAConst.isValidValue((double)d)) {
                    object2 = "Constant-" + d;
                }
            } else if (n2 == 1) {
                object2 = "Function of Flow";
            }
            vector.add(routing.toString());
            vector.add(object2);
        } else if (object instanceof DiversionElement) {
            Rule rule;
            Vector vector2;
            object = (DiversionElement)object;
            Object object3 = "";
            Controller controller = ((DiversionElement)object).getController();
            if (controller != null && (vector2 = controller.getRuleVector()).size() > 0 && (rule = (Rule)vector2.get(0)) != null) {
                object3 = (String)object3 + rule.getName();
            }
            vector.add(object3);
        }
        return vector;
    }

    private void updateMap(MapGlyph mapGlyph) {
        int[] nArray = this.cpTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0) continue;
            Element element = (Element)this.cpTable.getCell(n, 0);
            ResSimElementMapSelector.a(element, mapGlyph);
        }
    }

    private void fireTableDoubleClicked(String string) {
        for (int i = this._listenerList.size() - 1; i >= 0; --i) {
            this._listenerList.get(i).reportDoubleClicked(this._type, string);
        }
    }

    @Override
    public void exportReport() {
        this.cpTable.exportData();
    }

    public void printReport() {
        this.cpTable.printData();
    }

    @Override
    public void printPreviewReport() {
        this.cpTable.printPreview();
    }

    protected void closeDialog() {
        this.setVisible(false);
    }
}

