/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import com.google.common.flogger.FluentLogger;
import hec.rss.client.ExceptionDialog$1;
import hec.rss.client.ExceptionDialog$2;
import hec.rss.client.ExceptionDialog$3;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseWheelEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextArea;
import rma.util.RMAIO;

public class ExceptionDialog
extends RmaJDialog {
    private static FluentLogger a = FluentLogger.forEnclosingClass();
    private Thread _thread;
    private Throwable _throwable;
    private JLabel _msgLabel;
    private JButton _okButton;
    private JButton _detailsButton;
    private JButton _copyToClipBoardButton;
    private RmaJTextArea _detailsTxt;
    private JScrollPane _detailsScrollPane;

    public ExceptionDialog(Frame frame, Thread thread, Throwable throwable) {
        super(frame, true);
        this._thread = thread;
        this._throwable = throwable;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public ExceptionDialog(Dialog dialog, Thread thread, Throwable throwable) {
        super(dialog, true);
        this._thread = thread;
        this._throwable = throwable;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    protected void buildControls() {
        this.setTitle("Uncaught Exception Occurred");
        this.getContentPane().setLayout(new GridBagLayout());
        this._msgLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._msgLabel, gridBagConstraints);
        Accessible accessible = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)((Object)accessible), gridBagConstraints);
        this._okButton = new JButton("OK");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        accessible.add(this._okButton, gridBagConstraints);
        this._detailsButton = new JButton("Details >>");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        accessible.add(this._detailsButton, gridBagConstraints);
        this._detailsTxt = new RmaJTextArea();
        this._detailsTxt.setEditable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._detailsScrollPane = new JScrollPane((Component)this._detailsTxt);
        this.getContentPane().add((Component)this._detailsScrollPane, gridBagConstraints);
        this._detailsScrollPane.setVisible(false);
        accessible = RmaImage.getImageIcon((String)"Images/Copy.gif");
        this._copyToClipBoardButton = new JButton((Icon)((Object)accessible));
        this._copyToClipBoardButton.setToolTipText("Copy to Clipboard");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._copyToClipBoardButton, gridBagConstraints);
        this._copyToClipBoardButton.setVisible(false);
    }

    private void addListeners() {
        this._okButton.addActionListener(new ExceptionDialog$1(this));
        this._detailsButton.addActionListener(new ExceptionDialog$2(this));
        this._copyToClipBoardButton.addActionListener(new ExceptionDialog$3(this));
        this._detailsTxt.addMouseWheelListener(mouseWheelEvent -> this.mouseWheelAction(mouseWheelEvent));
    }

    protected void mouseWheelAction(MouseWheelEvent mouseWheelEvent) {
        if ((mouseWheelEvent.getModifiers() & 2) == 2) {
            int n = mouseWheelEvent.getWheelRotation();
            this.changeFontSize(-n);
        }
    }

    protected void changeFontSize(int n) {
        Font font = this._detailsTxt.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() + n);
        this._detailsTxt.setFont(font2);
        this.revalidate();
    }

    protected void copyToClipboardAction() {
        Object object = this._detailsTxt.getText();
        object = new StringSelection((String)object);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            clipboard.setContents((Transferable)object, null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void showDetailsAction() {
        if (this._detailsScrollPane.isVisible()) {
            this._detailsScrollPane.setVisible(false);
            this._detailsButton.setText("Details >>");
            this._copyToClipBoardButton.setVisible(false);
            this.pack();
            return;
        }
        this._detailsScrollPane.setVisible(true);
        this._detailsButton.setText("<< Details");
        this._copyToClipBoardButton.setVisible(true);
        this.pack();
    }

    protected void closeDialogAction() {
        this.setVisible(true);
        this.dispose();
    }

    protected void fillForm() {
        Object object = UIManager.getIcon("OptionPane.errorIcon");
        this._msgLabel.setIcon((Icon)object);
        object = "<html>Uncaught Exception in Thread " + String.valueOf(this._thread) + "<br>Error:";
        object = ((String)object).concat(RMAIO.toHtmlString((String)this._throwable.toString()));
        object = ((String)object).concat("</html>");
        try {
            this._msgLabel.setText((String)object);
        }
        catch (Exception exception) {
            ((FluentLogger.Api)a.atInfo()).log("fillForm:exception setting text with exception info %s", (Object)exception);
        }
        if (this._throwable != null) {
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object, true);
            this._throwable.printStackTrace(printWriter);
            this._detailsTxt.setText(((StringWriter)object).toString());
            return;
        }
        this._detailsTxt.setText("No Exception Provided");
    }
}

