/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.model.TSLocation;
import hec.rss.client.ExistingRuleDlg$1;
import hec.rss.client.ExistingRuleDlg$2;
import hec.rss.client.ExistingRuleDlg$SymWindow;
import hec.rss.client.ExistingRuleDlg$TableModel;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleFactory;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.WaterQualityOpRule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class ExistingRuleDlg
extends RmaJDialog
implements ListSelectionListener,
ButtonCmdPanelListener {
    static String[] a = new String[]{"Rule Name", "Operates\nRelease From", "Rule Type", "Downstream\nLocation"};
    private boolean _canceled = false;
    private Object[] _names = null;
    private List _unusedList = null;
    private List _usedList = null;
    OpController _defaultController;
    private boolean _isRuleParentConditionalNode = false;
    private ButtonCmdPanel _cmdPanel = new ButtonCmdPanel(12);
    private RmaJTextField _selectNameTxt = new RmaJTextField();
    private JList _selectNameList = new JList();
    private JCheckBox _addRuleToAllZonesCheckBox = new JCheckBox("Add Rule To All Zones");
    private RmaJTable _ruleTable;
    private ExistingRuleDlg$TableModel _tableModel;
    private ExistingRuleDlg$TableModel _currentTableModel;

    public ExistingRuleDlg() {
        this((Frame)null, false);
    }

    public ExistingRuleDlg(String string) {
        this();
        this.setTitle(string);
    }

    public ExistingRuleDlg(Frame frame, boolean bl) {
        super(frame, bl);
        this.createControls();
    }

    public ExistingRuleDlg(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.createControls();
    }

    public ExistingRuleDlg(Dialog dialog, boolean bl, boolean bl2) {
        super(dialog, bl);
        this._isRuleParentConditionalNode = bl2;
        this.createControls();
    }

    private void createControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(640, 270);
        this.setTitle("Select Existing Rule");
        this._selectNameList.setSelectionMode(0);
        Object object = new JScrollPane(this._selectNameList);
        ((JScrollPane)object).setHorizontalScrollBarPolicy(30);
        ((JScrollPane)object).setVerticalScrollBarPolicy(22);
        ExistingRuleDlg existingRuleDlg = this;
        this._ruleTable = new ExistingRuleDlg$1(existingRuleDlg, (Component)((Object)existingRuleDlg));
        this._tableModel = new ExistingRuleDlg$TableModel(this);
        this._tableModel.getDataVector().clear();
        this._currentTableModel = this._tableModel;
        this._ruleTable.setModel((TableModel)((Object)this._tableModel));
        this._ruleTable.setEditable(false);
        this._ruleTable.setAddRemoveEnabled(false);
        this._ruleTable.setSelectionMode(0);
        this._ruleTable.setColumnSelectionAllowed(false);
        this._ruleTable.setCellSelectionEnabled(false);
        this._ruleTable.setRowSelectionAllowed(true);
        this._ruleTable.setMlHeaderRenderer();
        this._ruleTable.setProcessKeyEvents(false);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).fill = 1;
        ((GridBagConstraints)object).insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._ruleTable.getScrollPane(), object);
        this._selectNameTxt.setEnabled(false);
        this.getContentPane().add((Component)this._selectNameTxt, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this._addRuleToAllZonesCheckBox, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (this._isRuleParentConditionalNode) {
            this._addRuleToAllZonesCheckBox.setVisible(false);
        }
        this.getContentPane().add((Component)this._cmdPanel, new RmaGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        object = new ExistingRuleDlg$SymWindow(this);
        this.addWindowListener((WindowListener)object);
        this._ruleTable.getSelectionModel().addListSelectionListener(new ExistingRuleDlg$2(this));
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.setLocation();
        object = KeyStroke.getKeyStroke(10, 0);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this._ruleTable.getInputMap(1).put((KeyStroke)object, "none");
        this._ruleTable.getInputMap(1).put((KeyStroke)object, "none");
        this._ruleTable.getInputMap(1).put((KeyStroke)object, "none");
        this._ruleTable.getInputMap(1).put(keyStroke, "none");
        this._ruleTable.getInputMap(1).put(keyStroke, "none");
        this._ruleTable.getInputMap(1).put(keyStroke, "none");
    }

    public void setAddRuleToAllZonesChckbx(boolean bl) {
        this._addRuleToAllZonesCheckBox.setVisible(bl);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.fillForm();
        }
        super.setVisible(bl);
    }

    void ExistingRuleDlg_WindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
        this._canceled = true;
    }

    public boolean addToAllZones() {
        return this._addRuleToAllZonesCheckBox.isSelected();
    }

    @Override
    public void valueChanged(ListSelectionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._ruleTable) {
            this.mNameSelectionChanged();
        }
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.cmdOk_Action();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    private void mNameSelectionChanged() {
        OpRule opRule;
        int n = this._ruleTable.getSelectedRow();
        if (n >= 0 && (opRule = (OpRule)this._ruleTable.getValueAt(n, 0)) != null) {
            this._selectNameTxt.setText(opRule.getName());
            return;
        }
        this._selectNameTxt.setText("");
    }

    private void cmdOk_Action() {
        if (this._ruleTable.getSelectedRow() < 0) {
            RMAIO.postError((Component)((Object)this), (String)"Please make a selection");
            return;
        }
        this._canceled = false;
        this.setVisible(false);
    }

    private void cmdCancel_Action() {
        this._canceled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setRules(List list, List list2) {
        this._unusedList = list;
        this._usedList = list2;
    }

    public void setMultipleDelete() {
        this._ruleTable.setSelectionMode(2);
        this._selectNameList.setSelectionMode(2);
    }

    public void setDefaultController(OpController opController) {
        this._defaultController = opController;
    }

    public void fillForm() {
        this._tableModel.clearAll();
        if (this._unusedList != null && this._unusedList.size() > 0) {
            ExistingRuleDlg existingRuleDlg = this;
            existingRuleDlg.fillTable(existingRuleDlg._unusedList, null);
        }
        if (this._usedList != null) {
            ExistingRuleDlg existingRuleDlg = this;
            existingRuleDlg.fillTable(existingRuleDlg._usedList, UIManager.getColor("TextField.disabledBackground"));
        }
    }

    private void fillTable(List list, Color color) {
        int n = list.size();
        RssSystem rssSystem = ((RssTSLocationObject)this._defaultController).getSystem();
        boolean bl = this._defaultController.getElementOp().getOperationsElement() instanceof ReservoirElement;
        for (int i = 0; i < n; ++i) {
            TSLocation tSLocation = (OpRule)list.get(i);
            Vector<Object> vector = new Vector<Object>(4);
            vector.add(tSLocation);
            vector.add(tSLocation.getController());
            vector.add(OpRuleFactory.getRuleString(tSLocation, bl));
            if (tSLocation instanceof DownstreamOpRule) {
                if ((tSLocation = rssSystem.getNode(((DownstreamOpRule)tSLocation).getDownstreamControlLocationID())) != null) {
                    vector.add(((RssTSLocationObject)this._defaultController).getSystem().getNameForKeyString(tSLocation.getName()));
                }
            } else if (tSLocation instanceof WaterQualityOpRule && (tSLocation = rssSystem.getNode(((WaterQualityOpRule)tSLocation).getDownstreamControlLocationID())) != null) {
                vector.add(((RssTSLocationObject)this._defaultController).getSystem().getNameForKeyString(tSLocation.getName()));
            }
            this._ruleTable.appendRow(vector);
            if (color == null) continue;
            this._ruleTable.setRowBackground(this._ruleTable.getRowCount() - 1, color);
        }
    }

    public OpRule getSelectedRule() {
        int n = this._ruleTable.getSelectedRow();
        OpRule opRule = null;
        if (n >= 0) {
            opRule = (OpRule)this._ruleTable.getValueAt(n, 0);
        }
        return opRule;
    }

    public ArrayList<OpRule> getSelectedRules() {
        int[] nArray = this._ruleTable.getSelectedRows();
        ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) continue;
            OpRule opRule = (OpRule)this._ruleTable.getValueAt(nArray[i], 0);
            arrayList.add(opRule);
        }
        return arrayList;
    }
}

