/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.geometry.Scale;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPolygonProperties;
import hec.gfx2d.NoLegend;
import hec.gfx2d.Viewport;
import hec.rss.client.FloatingWaterAccountCurveData;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class FloatingWaterAccountBucketGlyph
extends G2dGlyph
implements NoLegend {
    private static final long serialVersionUID = -1535662973784526080L;
    private final FloatingWaterAccountCurveData _data;

    public FloatingWaterAccountBucketGlyph(Viewport viewport, FloatingWaterAccountCurveData floatingWaterAccountCurveData, Scale scale) {
        super(viewport, (G2dObject)floatingWaterAccountCurveData, scale);
        this._data = floatingWaterAccountCurveData;
        viewport = this._line.getProperties();
        this._line.getProperties()._drawPoints = true;
        viewport._symbolSize = 10.0f;
        viewport._lineColor = Color.BLUE;
        viewport._lineWidth = 10.0f;
        this._line.setProperties((G2dLineProperties)viewport);
    }

    public void draw(Graphics graphics) {
        double d = this._data.getWaterDepth();
        double d2 = this._data.getBucketWidth();
        double d3 = this._data.getBucketHeight();
        double d4 = this._data.getLeftX();
        double d5 = this._data.getLowerY();
        double d6 = d5 + d3;
        double d7 = d4 + d2;
        Rectangle rectangle = this.getVisibleRect();
        double d8 = d5;
        this.drawTheFill(graphics, d4, d8, d8 + d, d7, rectangle);
        double[] dArray = new double[]{d4, d4, d7, d7};
        double[] dArray2 = new double[]{d6, d5, d5, d6};
        this._line.setLineData(dArray, dArray2, 4);
        this._line.setLineWidth(3.0f);
        this._line.setLineColor(this._data.getDrawingProperties().a());
        this._line.drawLine(graphics, rectangle);
    }

    private void drawTheFill(Graphics graphics, double d, double d2, double d3, double d4, Rectangle rectangle) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = this._scale.e2x(d);
        nArray2[0] = this._scale.n2y(d2);
        nArray[1] = this._scale.e2x(d4);
        nArray2[1] = this._scale.n2y(d2);
        nArray[2] = this._scale.e2x(d4);
        nArray2[2] = this._scale.n2y(d3);
        nArray[3] = this._scale.e2x(d);
        nArray2[3] = this._scale.n2y(d3);
        G2dPolygonProperties g2dPolygonProperties = this._drawProp.polygonProperties;
        this._drawProp.polygonProperties.drawBackground = true;
        g2dPolygonProperties.fillColor = this._data.getDrawingProperties().b();
        this._polygon.setProperties(g2dPolygonProperties);
        this._polygon.setPolygonData(nArray, nArray2, 4);
        this._polygon.drawPolygon(graphics, rectangle);
    }
}

